/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.migration;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.general.dict.dto.DictMigrationDumpDto;
import com.jxdinfo.hussar.general.dict.migration.DictMigrationPluginMetadata;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DictMigrationDumpVo;
import com.jxdinfo.hussar.general.dict.vo.DictMigrationLoadVo;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DictMigrationPlugin
implements MigrationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(DictMigrationPlugin.class);
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private ISysDicService sysDicService;

    public MigrationPluginMetadata metadata() {
        return new DictMigrationPluginMetadata();
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        DictMigrationDumpDto dictMigrationDumpDto = (DictMigrationDumpDto)IdempotentJsonUtils.convert(parameters, DictMigrationDumpDto.class);
        List idList = dictMigrationDumpDto.getIds();
        if (HussarUtils.isEmpty((Object)idList)) {
            return MigrationDumpItemVo.success((Long)0L, Collections.emptyList());
        }
        List dicTypes = this.dicTypeService.selectDicTypeByTypeIds(idList);
        Set groupIdList = dicTypes.stream().map(DicType::getParentId).collect(Collectors.toSet());
        ArrayList<DicGroup> dicGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIdList)) {
            dicGroups = this.dicGroupService.getDicGroupByGroupIds(new ArrayList(groupIdList));
        }
        List dicSingles = this.dicSingleService.getDicSingleByTypeIds(idList, 2);
        context.setPayloadOfJson("dictTypeFile.json", (Object)dicTypes);
        context.setPayloadOfJson("dictSingleFile.json", (Object)dicSingles);
        context.setPayloadOfJson("dictGroupFile.json", dicGroups);
        List<DictMigrationDumpVo> dictDumpVoList = this.getDictDumpVoList(dicGroups, dicTypes, dicSingles);
        List dictTree = HussarTreeParser.getTreeList(dictDumpVoList);
        this.sysDicService.fillDictHasChildren((DictMigrationDumpVo)dictTree.get(0));
        return MigrationDumpItemVo.success((Long)((long)dictDumpVoList.size() - 1L), (Object)dictTree);
    }

    private List<DictMigrationDumpVo> getDictDumpVoList(List<DicGroup> dicGroups, List<DicType> dicTypes, List<DicSingle> dicSingles) {
        DictMigrationDumpVo dictDumpVo;
        ArrayList<DictMigrationDumpVo> dictDumpVoList = new ArrayList<DictMigrationDumpVo>();
        DictMigrationDumpVo root = new DictMigrationDumpVo();
        root.setId(Constants.ROOT_NODE_ID);
        root.setType(0);
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setLabel("\u6570\u636e\u5b57\u5178");
        root.setIcon("tree-com");
        dictDumpVoList.add(root);
        if (HussarUtils.isNotEmpty(dicGroups)) {
            for (DicGroup dicGroup : dicGroups) {
                dictDumpVo = new DictMigrationDumpVo();
                dictDumpVo.setId(dicGroup.getId());
                dictDumpVo.setParentId(dicGroup.getParentId());
                dictDumpVo.setType(1);
                dictDumpVo.setLabel(dicGroup.getGroupDescription());
                dictDumpVo.setIcon("tree-folder");
                dictDumpVoList.add(dictDumpVo);
            }
        }
        if (HussarUtils.isNotEmpty(dicTypes)) {
            for (DicType dicType : dicTypes) {
                dictDumpVo = new DictMigrationDumpVo();
                dictDumpVo.setId(dicType.getId());
                dictDumpVo.setParentId(dicType.getParentId());
                dictDumpVo.setType(2);
                dictDumpVo.setValue(dicType.getTypeName());
                dictDumpVo.setLabel(dicType.getTypeDescription());
                dictDumpVo.setIcon("zidian");
                dictDumpVoList.add(dictDumpVo);
            }
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                dictDumpVo = new DictMigrationDumpVo();
                dictDumpVo.setId(dicSingle.getId());
                dictDumpVo.setType(3);
                dictDumpVo.setParentId(dicSingle.getParentId() != null ? dicSingle.getParentId() : dicSingle.getTypeId());
                dictDumpVo.setValue(dicSingle.getValue());
                dictDumpVo.setLabel(dicSingle.getLabel());
                dictDumpVo.setIcon("dict");
                dictDumpVoList.add(dictDumpVo);
            }
        }
        return dictDumpVoList;
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List dicGroups = (List)context.getPayloadAsJson("dictGroupFile.json", (TypeReference)new TypeReference<List<DicGroup>>(){});
        List dicTypes = (List)context.getPayloadAsJson("dictTypeFile.json", (TypeReference)new TypeReference<List<DicType>>(){});
        List dicSingles = (List)context.getPayloadAsJson("dictSingleFile.json", (TypeReference)new TypeReference<List<DicSingle>>(){});
        List<DictMigrationLoadVo> dictLoadVoList = this.getDictLoadVoList(dicGroups, dicTypes, dicSingles);
        List dictTree = HussarTreeParser.getTreeList(dictLoadVoList);
        this.initializeChildrenChanges((DictMigrationLoadVo)dictTree.get(0));
        return MigrationPreloadItemVo.success((Object)dictTree);
    }

    private int initializeChildrenChanges(DictMigrationLoadVo dictVo) {
        if (HussarUtils.isNotEmpty((Object)dictVo.getChildren())) {
            dictVo.setHasChildren(Boolean.valueOf(true));
            List children = dictVo.getChildren();
            int childrenChanges = 0;
            for (DictMigrationLoadVo child : children) {
                int childChildrenChanges = this.initializeChildrenChanges(child);
                int childSelfChanges = child.getSelfChanges();
                int tempChildrenChanges = Math.max(childChildrenChanges, childSelfChanges);
                childrenChanges = Math.max(tempChildrenChanges, childrenChanges);
            }
            dictVo.setChildrenChanges(childrenChanges);
            return childrenChanges;
        }
        dictVo.setHasChildren(Boolean.valueOf(false));
        dictVo.setChildrenChanges(dictVo.getSelfChanges());
        return dictVo.getSelfChanges();
    }

    @HussarTransactional
    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        List dicGroups = (List)context.getPayloadAsJson("dictGroupFile.json", (TypeReference)new TypeReference<List<DicGroup>>(){});
        List dicTypes = (List)context.getPayloadAsJson("dictTypeFile.json", (TypeReference)new TypeReference<List<DicType>>(){});
        List dicSingles = (List)context.getPayloadAsJson("dictSingleFile.json", (TypeReference)new TypeReference<List<DicSingle>>(){});
        List<DictMigrationLoadVo> dictLoadVoList = this.getDictLoadVoList(dicGroups, dicTypes, dicSingles);
        List dictTree = HussarTreeParser.getTreeList(dictLoadVoList);
        this.initializeChildrenChanges((DictMigrationLoadVo)dictTree.get(0));
        Map<Long, Long> typeIdMap = this.preprocessDicTypes(dicTypes);
        Map<Long, Long> singleIdMap = this.preprocessDicSingles(dicSingles, typeIdMap);
        this.handleParentId(dicSingles, singleIdMap);
        this.dicTypeService.insertOrUpdateList(dicGroups);
        this.dicTypeService.insertOrUpdateList(dicTypes);
        this.dicSingleService.insertOrUpdateList(dicSingles);
        return MigrationLoadItemVo.success((Long)((long)dictLoadVoList.size() - 1L), (Object)dictTree);
    }

    private List<DictMigrationLoadVo> getDictLoadVoList(List<DicGroup> dicGroups, List<DicType> dicTypes, List<DicSingle> dicSingles) {
        ArrayList<DictMigrationLoadVo> dictLoadVoList = new ArrayList<DictMigrationLoadVo>();
        DictMigrationLoadVo root = new DictMigrationLoadVo();
        root.setId(Constants.ROOT_NODE_ID);
        root.setType(0);
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setLabel("\u6570\u636e\u5b57\u5178");
        root.setIcon("tree-com");
        dictLoadVoList.add(root);
        if (HussarUtils.isNotEmpty(dicGroups)) {
            List groupIds = dicGroups.stream().map(DicGroup::getId).collect(Collectors.toList());
            List groups = this.dicGroupService.getDicGroupByGroupIds(groupIds);
            Map<Long, DicGroup> groupMap = groups.stream().collect(Collectors.toMap(DicGroup::getId, item -> item));
            for (DicGroup dicGroup : dicGroups) {
                DictMigrationLoadVo dictVo = new DictMigrationLoadVo();
                dictVo.setId(dicGroup.getId());
                dictVo.setType(1);
                dictVo.setLabel(dicGroup.getGroupDescription());
                dictVo.setParentId(dicGroup.getParentId());
                dictVo.setSelfChanges(1);
                dictVo.setIcon("tree-folder");
                if (HussarUtils.isNotEmpty(groupMap) && HussarUtils.isNotEmpty((Object)groupMap.get(dicGroup.getId()))) {
                    DicGroup group = groupMap.get(dicGroup.getId());
                    boolean labelChange = !HussarUtils.equals((Object)dicGroup.getGroupDescription(), (Object)group.getGroupDescription());
                    dictVo.setSelfOldLabel(labelChange ? group.getGroupDescription() : null);
                    dictVo.setSelfChanges(labelChange ? 2 : 0);
                }
                dictLoadVoList.add(dictVo);
            }
        }
        if (HussarUtils.isNotEmpty(dicTypes)) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (DicType type : dicTypes) {
                typeNames.add(type.getTypeName());
            }
            List types = this.dicTypeService.selectDicTypeByTypeNames(typeNames);
            ArrayList<DicSingle> existedSingles = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)types)) {
                List typeIds = types.stream().map(DicType::getId).collect(Collectors.toList());
                existedSingles = this.dicSingleService.getDicSingleByTypeIds(typeIds, 2);
            }
            Map<String, DicType> typeMap = types.stream().collect(Collectors.toMap(DicType::getTypeName, item -> item));
            for (DicType dicType : dicTypes) {
                DictMigrationLoadVo dictVo = new DictMigrationLoadVo();
                dictVo.setParentId(dicType.getParentId());
                dictVo.setType(2);
                dictVo.setValue(dicType.getTypeName());
                dictVo.setLabel(dicType.getTypeDescription());
                dictVo.setSelfChanges(1);
                dictVo.setIcon("zidian");
                if (HussarUtils.isNotEmpty(typeMap) && HussarUtils.isNotEmpty((Object)typeMap.get(dicType.getTypeName()))) {
                    DicType localType = typeMap.get(dicType.getTypeName());
                    dictVo.setSaveExisted(this.getIsSaveExisted(localType.getId(), dicType.getId(), existedSingles, dicSingles));
                    boolean labelChange = !HussarUtils.equals((Object)dicType.getTypeDescription(), (Object)localType.getTypeDescription());
                    dictVo.setSelfOldLabel(labelChange ? localType.getTypeDescription() : null);
                    dictVo.setSelfChanges(labelChange ? 2 : 0);
                }
                dictVo.setId(dicType.getId());
                dictLoadVoList.add(dictVo);
            }
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            List repeatSingles = this.dicSingleService.getDicSingleByTypeAndField(dicSingles, "value");
            List labelRepeatSingles = this.dicSingleService.getDicSingleByTypeAndField(dicSingles, "label");
            for (DicSingle dicSingle : dicSingles) {
                DictMigrationLoadVo dictVo = new DictMigrationLoadVo();
                dictVo.setType(3);
                dictVo.setValue(dicSingle.getValue());
                dictVo.setLabel(dicSingle.getLabel());
                dictVo.setSelfChanges(1);
                dictVo.setIcon("dict");
                dictVo.setParentId(HussarUtils.isEmpty((Object)dicSingle.getParentId()) ? dicSingle.getTypeId() : dicSingle.getParentId());
                if (HussarUtils.isNotEmpty((Object)repeatSingles)) {
                    for (DicSingle single : repeatSingles) {
                        if (!HussarUtils.equals((Object)single.getValue(), (Object)dicSingle.getValue()) || !HussarUtils.equals((Object)single.getTypeId(), (Object)dicSingle.getTypeId())) continue;
                        boolean labelChange = !HussarUtils.equals((Object)dicSingle.getLabel(), (Object)single.getLabel());
                        dictVo.setSelfOldLabel(labelChange ? single.getLabel() : null);
                        dictVo.setSelfChanges(labelChange ? 2 : 0);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)labelRepeatSingles)) {
                    for (DicSingle single : labelRepeatSingles) {
                        boolean labelDuplicated = HussarUtils.equals((Object)single.getLabel(), (Object)dicSingle.getLabel()) && HussarUtils.equals((Object)single.getTypeId(), (Object)dicSingle.getTypeId()) && !HussarUtils.equals((Object)single.getValue(), (Object)dicSingle.getValue());
                        if (!labelDuplicated) continue;
                        dictVo.setLabelDuplicated(true);
                        break;
                    }
                }
                dictVo.setId(dicSingle.getId());
                dictLoadVoList.add(dictVo);
            }
        }
        return dictLoadVoList;
    }

    private boolean getIsSaveExisted(Long newTypeId, Long oldTypeId, List<DicSingle> singles, List<DicSingle> dicSingles) {
        List existedSingles = singles.stream().filter(dicSingle -> HussarUtils.equals((Object)newTypeId, (Object)dicSingle.getTypeId())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(existedSingles)) {
            return false;
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            for (DicSingle existedSingle : existedSingles) {
                long count = dicSingles.stream().filter(loadSingle -> HussarUtils.equals((Object)oldTypeId, (Object)loadSingle.getTypeId()) && HussarUtils.equals((Object)existedSingle.getValue(), (Object)loadSingle.getValue())).count();
                if (count != 0L) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private long getNewId(int type) {
        if (type == 1) {
            return IdWorker.getId((Object)new DicType());
        }
        return IdWorker.getId((Object)new DicSingle());
    }

    private Map<Long, Long> preprocessDicTypes(List<DicType> dicTypes) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        if (HussarUtils.isEmpty(dicTypes)) {
            return map;
        }
        List typeNames = dicTypes.stream().map(DicType::getTypeName).collect(Collectors.toList());
        List repeatTypes = this.dicTypeService.selectDicTypeByTypeNames(typeNames);
        List typeIds = dicTypes.stream().map(DicType::getId).collect(Collectors.toList());
        List idRepeatTypes = this.dicTypeService.selectDicTypeByTypeIds(typeIds);
        block0: for (DicType dicType : dicTypes) {
            if (HussarUtils.isNotEmpty((Object)repeatTypes)) {
                for (DicType type : repeatTypes) {
                    if (!HussarUtils.equals((Object)dicType.getTypeName(), (Object)type.getTypeName()) || HussarUtils.equals((Object)dicType.getId(), (Object)type.getId())) continue;
                    map.put(dicType.getId(), type.getId());
                    dicType.setId(type.getId());
                    break;
                }
            }
            if (!HussarUtils.isNotEmpty((Object)idRepeatTypes)) continue;
            for (DicType type : idRepeatTypes) {
                if (!HussarUtils.equals((Object)dicType.getId(), (Object)type.getId()) || HussarUtils.equals((Object)dicType.getTypeName(), (Object)type.getTypeName())) continue;
                long newId = this.getNewId(1);
                map.put(dicType.getId(), newId);
                dicType.setId(Long.valueOf(newId));
                continue block0;
            }
        }
        return map;
    }

    private Map<Long, Long> preprocessDicSingles(List<DicSingle> dicSingles, Map<Long, Long> idMap) {
        HashMap<Long, Long> singleIdMap = new HashMap<Long, Long>();
        if (HussarUtils.isEmpty(dicSingles)) {
            return singleIdMap;
        }
        for (DicSingle dicSingle : dicSingles) {
            if (!HussarUtils.isNotEmpty((Object)idMap.get(dicSingle.getTypeId()))) continue;
            Long typeId = idMap.get(dicSingle.getTypeId());
            dicSingle.setTypeId(typeId);
        }
        List repeatSingles = this.dicSingleService.getDicSingleByTypeAndField(dicSingles, "value");
        List singleIds = dicSingles.stream().map(DicSingle::getId).collect(Collectors.toList());
        List idRepeatSingles = this.dicSingleService.listByIds(singleIds);
        block1: for (DicSingle dicSingle : dicSingles) {
            if (HussarUtils.isNotEmpty((Object)repeatSingles)) {
                for (DicSingle single : repeatSingles) {
                    boolean isRepeat = HussarUtils.equals((Object)dicSingle.getValue(), (Object)single.getValue()) && HussarUtils.equals((Object)dicSingle.getTypeId(), (Object)single.getTypeId());
                    if (!isRepeat || HussarUtils.equals((Object)dicSingle.getId(), (Object)single.getId())) continue;
                    singleIdMap.put(dicSingle.getId(), single.getId());
                    dicSingle.setId(single.getId());
                    break;
                }
            }
            if (!HussarUtils.isNotEmpty((Object)idRepeatSingles)) continue;
            for (DicSingle single : idRepeatSingles) {
                boolean idRepeat = HussarUtils.equals((Object)dicSingle.getId(), (Object)single.getId());
                if (!idRepeat || HussarUtils.equals((Object)dicSingle.getValue(), (Object)single.getValue()) && HussarUtils.equals((Object)dicSingle.getTypeId(), (Object)single.getTypeId())) continue;
                long newId = this.getNewId(2);
                singleIdMap.put(dicSingle.getId(), newId);
                dicSingle.setId(Long.valueOf(newId));
                continue block1;
            }
        }
        return singleIdMap;
    }

    private void handleParentId(List<DicSingle> dicSingles, Map<Long, Long> singleIdMap) {
        if (HussarUtils.isNotEmpty(dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                if (!HussarUtils.isNotEmpty((Object)singleIdMap.get(dicSingle.getParentId()))) continue;
                long parentId = singleIdMap.get(dicSingle.getParentId());
                dicSingle.setParentId(Long.valueOf(parentId));
            }
        }
    }
}

