/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.general.enums.GeneralServicesTipsEnum;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysDicFrontServiceImpl
implements SysDicFrontService {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;

    public List<JSTreeModel> queryDicTypeTreeData() {
        List dicChilds;
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText(TranslateUtil.getTranslateName((String)GeneralServicesTipsEnum.DICT_DATA_DIRECTORY.getMessage()));
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setImgUrl("tree-com");
        mapList.add(root);
        List groups = this.dicGroupService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setParentId(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setTextLangKey(group.getDescriptionLangKey());
                tempObject.setType("dict");
                tempObject.setRangeType(group.getRangeType());
                tempObject.setImgUrl("tree-folder");
                tempObject.setDictGroupId(group.getId());
                mapList.add(tempObject);
            }
        }
        List types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        Map<Long, Long> groupMap = types.stream().collect(Collectors.toMap(DicType::getId, DicType::getParentId));
        if (types != null && types.size() > 0) {
            List allDics = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().isNull(DicSingle::getParentId));
            Map<Long, List<DicSingle>> dicSingleMap = allDics.stream().collect(Collectors.groupingBy(DicSingle::getTypeId));
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(type.getId());
                tempObject.setParent(type.getParentId());
                tempObject.setParentId(type.getParentId());
                tempObject.setText(type.getTypeDescription());
                tempObject.setTextLangKey(type.getDescriptionLangKey());
                tempObject.setType("type");
                tempObject.setRangeType(rangeType);
                tempObject.setLabel(type.getTypeDescription());
                tempObject.setValue(type.getTypeName());
                tempObject.setTypeName(typeName);
                tempObject.setImgUrl("zidian");
                tempObject.setDictGroupId(type.getParentId());
                mapList.add(tempObject);
                if (!dicSingleMap.containsKey(type.getId())) continue;
                List<DicSingle> dicSingles = dicSingleMap.get(type.getId());
                for (DicSingle dic : dicSingles) {
                    tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setParentId(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setTextLangKey(dic.getLabelLangKey());
                    tempObject.setType("dic");
                    tempObject.setRangeType(String.valueOf(rangeType));
                    tempObject.setTypeName(typeName);
                    tempObject.setValue(dic.getValue());
                    tempObject.setLabel(dic.getLabel());
                    tempObject.setImgUrl("dict");
                    tempObject.setDictGroupId(groupMap.get(dic.getTypeId()));
                    tempObject.setIfUse(dic.getIfUse());
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(dicChild.getId());
                tempObject.setParent(dicChild.getParentId());
                tempObject.setParentId(dicChild.getParentId());
                tempObject.setText(dicChild.getLabel());
                tempObject.setTextLangKey(dicChild.getLabelLangKey());
                tempObject.setType("dic");
                tempObject.setRangeType("child");
                tempObject.setTypeName("child");
                tempObject.setLabel(dicChild.getLabel());
                tempObject.setValue(dicChild.getValue());
                tempObject.setImgUrl("dict");
                tempObject.setDictGroupId(groupMap.get(dicChild.getTypeId()));
                tempObject.setIfUse(dicChild.getIfUse());
                mapList.add(tempObject);
            }
        }
        TranslateUtil.translate(mapList, JSTreeModel::getTextLangKey, JSTreeModel::setText);
        return TreeModelUtils.merge(mapList);
    }

    public List<JSTreeModel> queryDicOrderTreeData(Long typeId) {
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (pDic != null) {
            JSTreeModel parent = new JSTreeModel();
            parent.setId(pDic.getId());
            parent.setParent(Constants.ROOT_NODE_PARENT);
            parent.setText(pDic.getTypeDescription());
            parent.setType("type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)finder).isNull(DicSingle::getParentId)).orderByAsc(DicSingle::getSort));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    JSTreeModel tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    mapList.add(tempObject);
                }
            }
        }
        return TreeModelUtils.merge(mapList);
    }
}

