/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysDicFrontServiceImpl
implements SysDicFrontService {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Resource
    private ISysAppDevelopTeamService sysAppDevelopTeamService;

    public List<JSTreeModel> queryDicTypeTreeData(Long appId) {
        List dicChilds;
        JSTreeModel tempObject;
        List types;
        List<Object> mapList = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        root.setImgUrl("tree-com");
        mapList.add(root);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            ((LambdaQueryWrapper)wrapper.eq(DicGroup::getRangeType, (Object)"sys")).or(wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper1.eq(DicGroup::getAppId, (Object)appId);
            });
        }
        wrapper.orderByAsc(DicGroup::getSort);
        List groups = this.dicGroupService.list((Wrapper)wrapper);
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject2 = new JSTreeModel();
                tempObject2.setId(group.getId());
                tempObject2.setParent(group.getParentId());
                tempObject2.setParentId(group.getParentId());
                tempObject2.setText(group.getGroupDescription());
                tempObject2.setType("dict");
                tempObject2.setRangeType(group.getRangeType());
                tempObject2.setImgUrl("tree-folder");
                tempObject2.setDictGroupId(group.getId());
                tempObject2.setApplicationId(group.getAppId());
                mapList.add(tempObject2);
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(DicType::getRangeType, (Object)"sys")).or(wrapper3 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper3.eq(DicType::getAppId, (Object)appId);
            })).orderByAsc(DicType::getSort);
        }
        if ((types = this.dicTypeService.list((Wrapper)wrapper2)) != null && types.size() > 0) {
            List allDics = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().isNull(DicSingle::getParentId));
            Map<Long, List<DicSingle>> dicSingleMap = allDics.stream().collect(Collectors.groupingBy(DicSingle::getTypeId));
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                tempObject = new JSTreeModel();
                tempObject.setId(type.getId());
                tempObject.setParent(type.getParentId());
                tempObject.setParentId(type.getParentId());
                tempObject.setText(type.getTypeDescription());
                tempObject.setType("type");
                tempObject.setRangeType(rangeType);
                tempObject.setLabel(type.getTypeDescription());
                tempObject.setValue(type.getTypeName());
                tempObject.setTypeName(typeName);
                tempObject.setImgUrl("zidian");
                tempObject.setDictGroupId(type.getParentId());
                tempObject.setApplicationId(type.getAppId());
                mapList.add(tempObject);
                if (allDics == null || allDics.size() <= 0) continue;
                ArrayList<DicSingle> dics = new ArrayList<DicSingle>();
                for (DicSingle dicSingle : allDics) {
                    if (!type.getId().equals(dicSingle.getTypeId())) continue;
                    dics.add(dicSingle);
                }
                if (dics.size() <= 0) continue;
                for (DicSingle dic : dics) {
                    tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setParentId(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    tempObject.setRangeType(String.valueOf(rangeType));
                    tempObject.setTypeName(typeName);
                    tempObject.setValue(dic.getValue());
                    tempObject.setLabel(dic.getLabel());
                    tempObject.setImgUrl("dict");
                    tempObject.setDictGroupId(type.getParentId());
                    tempObject.setApplicationId(dic.getAppId());
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                Long typeId = dicChild.getTypeId();
                Optional<DicType> dictType = types.stream().filter(dicType -> dicType.getId().equals(typeId)).findFirst();
                DicType parentDicType = dictType.get();
                tempObject = new JSTreeModel();
                tempObject.setId(dicChild.getId());
                tempObject.setParent(dicChild.getParentId());
                tempObject.setText(dicChild.getLabel());
                tempObject.setType("dic");
                tempObject.setRangeType("child");
                tempObject.setTypeName("child");
                tempObject.setLabel(dicChild.getLabel());
                tempObject.setValue(dicChild.getValue());
                tempObject.setImgUrl("dict");
                tempObject.setDictGroupId(parentDicType.getParentId());
                tempObject.setApplicationId(dicChild.getAppId());
                mapList.add(tempObject);
            }
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUserRole sysUserRole = (SysUserRole)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUserRoleService.lambdaQuery().eq(SysUserRole::getUserId, (Object)shiroUser.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.TENANT_ADMIN_ROLE)).one();
        if (HussarUtils.isEmpty((Object)sysUserRole)) {
            List currentTeamIds = ((LambdaQueryChainWrapper)this.sysAppDevelopTeamMemberService.lambdaQuery().eq(SysAppDevelopTeamMember::getUserId, (Object)shiroUser.getUserId())).list().stream().map(SysAppDevelopTeamMember::getTeamId).collect(Collectors.toList());
            List<Object> currentAppIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(currentTeamIds)) {
                currentAppIds = ((LambdaQueryChainWrapper)this.sysAppDevelopTeamService.lambdaQuery().in(SysAppDevelopTeam::getId, currentTeamIds)).list().stream().map(SysAppDevelopTeam::getAppId).distinct().collect(Collectors.toList());
            }
            ArrayList finalCurrentAppIds = currentAppIds;
            mapList = mapList.stream().filter(jsTreeModel -> finalCurrentAppIds.contains(jsTreeModel.getApplicationId()) || null == jsTreeModel.getApplicationId()).collect(Collectors.toList());
        }
        return TreeModelUtils.merge(mapList);
    }

    public List<JSTreeModel> queryDicOrderTreeData(Long typeId) {
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (pDic != null) {
            JSTreeModel parent = new JSTreeModel();
            parent.setId(pDic.getId());
            parent.setParent(Constants.ROOT_NODE_PARENT);
            parent.setText(pDic.getTypeDescription());
            parent.setType("type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)finder).isNull(DicSingle::getParentId)).orderByAsc(DicSingle::getSort));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    JSTreeModel tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    mapList.add(tempObject);
                }
            }
        }
        return TreeModelUtils.merge(mapList);
    }
}

