/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.controller;

import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u65b0\u7248\u7cfb\u7edf\u5b57\u5178\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.general.dict.controller.hussarBaseDictFrontController")
@RequestMapping(value={"/hussarBase/general/dict/dictFront"})
public class HussarBaseDictFrontController {
    @Resource
    private ISysDicTypeService dicTypeService;

    @GetMapping(value={"/exportDictExcel"})
    @CheckPermission(value={"hussarBase:general:dict:dictFront:exportDictExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u5b57\u5178Excel\u6587\u4ef6", notes="\u5bfc\u51fa\u5b57\u5178Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178Excel\u6587\u4ef6\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportDictExcel(@ApiParam(value="\u5b57\u5178ids") @RequestParam String ids, @ApiParam(value="\u4efb\u52a1id") @RequestParam Long taskId) throws Exception {
        this.dicTypeService.exportDictExcel(ids, taskId);
    }

    @GetMapping(value={"/downloadDictExcelImpTpl"})
    @CheckPermission(value={"hussarBase:general:dict:dictFront:downloadDictExcelImpTpl"})
    @ApiOperation(value="\u5b57\u5178Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", notes="\u5b57\u5178Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178Excel\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void downloadDictExcelImpTpl(HttpServletResponse response) {
        this.dicTypeService.downloadDictExcelImpTpl(response);
    }

    @PostMapping(value={"/checkDictExcel"})
    @CheckPermission(value={"hussarBase:general:dict:dictFront:checkDictExcel"})
    @ApiOperation(value="\u6821\u9a8c\u5bfc\u5165\u5b57\u5178Excel\u6587\u4ef6", notes="\u6821\u9a8c\u5bfc\u5165\u5b57\u5178Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6821\u9a8c\u5b57\u5178Excel\u5bfc\u5165\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void checkDictExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId) {
        this.dicTypeService.checkDictExcel(file, scenario, taskId);
    }

    @PostMapping(value={"/importDictExcel"})
    @CheckPermission(value={"hussarBase:general:dict:dictFront:importDictExcel"})
    @ApiOperation(value="\u5bfc\u5165\u5b57\u5178Excel\u6587\u4ef6", notes="\u5bfc\u5165\u5b57\u5178Excel\u6587\u4ef6")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178Excel\u6587\u4ef6\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void importDictExcel(@RequestParam(value="scenario") String scenario, @RequestParam(value="taskId") Long taskId) throws Exception {
        this.dicTypeService.importDictExcel(scenario, taskId);
    }
}

