/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportErr;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.util.CustomMergeStrategy;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelUtils;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.constant.DictMigrationConstants;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.dto.DicExcelDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.model.DicExcel;
import com.jxdinfo.hussar.general.dict.model.DicExcelExportDesc;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.seq.impl.SnowflakeSequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.general.dict.service.impl.sysDicTypeServiceImpl")
public class SysDicTypeServiceImpl
extends HussarServiceImpl<SysDicTypeMapper, DicType>
implements ISysDicTypeService,
IHussarBaseCustomExcelService<DicExcel> {
    private Logger logger = LoggerFactory.getLogger(SysDicTypeServiceImpl.class);
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper singleMapper;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    private static int addGroupSort = 0;
    private static Long parentGroupId;
    private static int typeSort;
    private static Long parentTypeId;
    private static int singleSort;
    private static Map<String, Long> singleValeAndSingleID;
    private static Long snowId;

    public static Map<String, Long> getSingleValeAndSingleID() {
        return singleValeAndSingleID;
    }

    public static void setSingleValeAndSingleID(Map<String, Long> singleValeAndSingleID) {
        SysDicTypeServiceImpl.singleValeAndSingleID = singleValeAndSingleID;
    }

    public void evictTypeCacheById(Long id) {
        DicType type = (DicType)this.getById(id);
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName() + ":*"));
        }
    }

    public List<JSTreeModel> dicExportTreeData() {
        return this.sysDicTypeMapper.dicExportTreeData();
    }

    public void exportDict(List<String> idList, HttpServletResponse response) {
        List<Long> convertIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List group = this.dicGroupService.getGroupBytypeIds(convertIds);
        List type = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, convertIds));
        List<Long> singleIdList = this.getSingleIdByTypeId(convertIds, new ArrayList<Long>());
        List single = new ArrayList();
        if (singleIdList.size() > 0) {
            single = this.dicSingleService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicSingle::getId, singleIdList));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("group", group);
        data.put("export_type", "dictionary");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5e8f\u5217\u5316\u51fa\u9519");
        }
        String fileName = "dict_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<Long> getSingleIdByTypeId(List<Long> typeIdList, List<Long> resultList) {
        List splitIdList = LambdaQueryUtil.getSplitList(typeIdList);
        List<Long> singleIdList = this.singleMapper.getSingleIdByTypeId(splitIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    public JSONObject importDictData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"dictionary");
            return result;
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        Map<String, Integer> groupCount = this.insertOrUpdateList(group);
        Map<String, Integer> typeCount = this.insertOrUpdateList(type);
        Map<String, Integer> singleCount = this.insertOrUpdateList(single);
        result.put("success", (Object)"true");
        result.put("groupInsert", (Object)groupCount.get("insert"));
        result.put("groupUpdate", (Object)groupCount.get("update"));
        result.put("typeInsert", (Object)typeCount.get("insert"));
        result.put("typeUpdate", (Object)typeCount.get("update"));
        result.put("singleInsert", (Object)singleCount.get("insert"));
        result.put("singleUpdate", (Object)singleCount.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<?> list) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(list)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = list.get(i);
                if (obj instanceof DicGroup) {
                    DicGroup dicGroup = (DicGroup)obj;
                    if (this.dicGroupService.updateById((Object)dicGroup)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicGroupService.save((Object)dicGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicType) {
                    DicType dicType = (DicType)obj;
                    if (super.updateById((BaseEntity)dicType)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        super.save((BaseEntity)dicType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicSingle) {
                    DicSingle dicSingle = (DicSingle)obj;
                    if (this.dicSingleService.updateById((Object)dicSingle)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicSingleService.save((Object)dicSingle);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public IPage<DicType> queryList(Page page, String rangeType) {
        String rootRange = "root";
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        HashMap result = new HashMap(5);
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq(DicType::getRangeType, (Object)rangeType);
        }
        ew.orderByAsc(DicType::getSort);
        List list2 = ((Page)this.page((IPage)page, (Wrapper)ew)).getRecords();
        page.setRecords(list2);
        return page;
    }

    public List<DicType> selectListByParentId() {
        return this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(DicType::getSort));
    }

    public List<DicSingle> selectChildsById(String id) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(id != null, DicType::getId, (Object)id));
        List dicSingles = list.size() > 0 ? this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)id)).orderByAsc(DicSingle::getSort)) : this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id)).orderByAsc(DicSingle::getSort));
        return dicSingles;
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        Long typeId = dt.getId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)typeId)).orderByAsc(DicSingle::getSort));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    public List<DicType> selectDicTypeByDouble(List<DicType> dicTypeList) {
        ArrayList<DicType> returnList = new ArrayList<DicType>();
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < dicTypeList.size(); i += 699) {
            List<DicType> temp;
            if (i + 699 >= dicTypeList.size()) {
                temp = dicTypeList.subList(i, dicTypeList.size());
                dicTypeLambdaQueryWrapper.clear();
                for (DicType dicType : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
                }
                returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
                continue;
            }
            temp = dicTypeList.subList(i, i + 699);
            dicTypeLambdaQueryWrapper.clear();
            for (DicType dicType : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
            }
            returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
        }
        return returnList;
    }

    public List<DicType> selectDicTypeByTypeIds(List<Long> ids) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        for (Long id : ids) {
            ((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)id);
        }
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }

    public List<DicType> selectDicTypeByTypeNames(List<String> typeNames) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(typeNames)) {
            return Collections.emptyList();
        }
        for (String name : typeNames) {
            ((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getTypeName, (Object)name);
        }
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDictExcelTpl(HttpServletResponse response) {
        InputStream inputStream = null;
        try (ServletOutputStream out = response.getOutputStream();){
            String fileName = "";
            response.setContentType("multipart/form-data");
            fileName = URLEncoder.encode("\u5b57\u5178Excel\u5bfc\u5165\u6a21\u677f.xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            inputStream = SysDicTypeServiceImpl.class.getClassLoader().getResourceAsStream("static/dicTemplate.xlsx");
            Workbook workbook = HussarBaseExcelUtils.judegExcelEdition((String)fileName, (InputStream)inputStream);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.debug("inputStream close IOException:" + e.getMessage());
                }
            }
        }
    }

    public void exportDictExcel(DicExcelDto dicExcelDto) {
        DicExcel dicExcel;
        String ids = dicExcelDto.getIds();
        Long taskId = dicExcelDto.getTaskId();
        List<String> idList = Arrays.asList(ids.split(","));
        List<Long> convertIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List groups = this.dicGroupService.getGroupBytypeIds(convertIds);
        List types = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, convertIds));
        List<Long> singleIdList = this.getSingleIdByTypeId(convertIds, new ArrayList<Long>());
        List singles = new ArrayList();
        if (singleIdList.size() > 0) {
            singles = this.dicSingleService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicSingle::getId, singleIdList));
        }
        HashMap dictGroupMap = new HashMap();
        groups.forEach(group -> dictGroupMap.put(group.getId(), group));
        HashMap dictTypeMap = new HashMap();
        types.forEach(type -> dictTypeMap.put(type.getId(), type));
        HashMap dictSingleMap = new HashMap();
        singles.forEach(single -> dictSingleMap.put(single.getId(), single));
        ArrayList<DicExcel> dicExcelVos = new ArrayList<DicExcel>();
        HashSet<Long> rTypeIds = new HashSet<Long>();
        if (HussarUtils.isNotEmpty(singles)) {
            for (DicSingle single2 : singles) {
                dicExcel = new DicExcel();
                dicExcel.setSingleValue(single2.getValue());
                dicExcel.setSingleLabel(single2.getLabel());
                if (HussarUtils.notNull((Object)single2.getParentId())) {
                    dicExcel.setSingleParentId(single2.getParentId());
                    dicExcel.setSingleParentValue(((DicSingle)dictSingleMap.get(single2.getParentId())).getValue());
                }
                dicExcel.setTypeDesc(((DicType)dictTypeMap.get(single2.getTypeId())).getTypeDescription());
                dicExcel.setTypeName(((DicType)dictTypeMap.get(single2.getTypeId())).getTypeName());
                rTypeIds.add(single2.getTypeId());
                dicExcel.setGroup(((DicGroup)dictGroupMap.get(((DicType)dictTypeMap.get(single2.getTypeId())).getParentId())).getGroupDescription());
                dicExcelVos.add(dicExcel);
            }
            for (Long rTypeId : rTypeIds) {
                types.remove(dictTypeMap.get(rTypeId));
            }
        }
        if (HussarUtils.isNotEmpty(dictTypeMap)) {
            for (DicType type2 : types) {
                dicExcel = new DicExcel();
                dicExcel.setTypeDesc(type2.getTypeDescription());
                dicExcel.setTypeName(type2.getTypeName());
                dicExcel.setGroup(((DicGroup)dictGroupMap.get(type2.getParentId())).getGroupDescription());
                dicExcelVos.add(dicExcel);
            }
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        DicExcelExportDesc dicExcelExportDesc = new DicExcelExportDesc();
        dicExcelExportDesc.setExportOperator(securityUser.getUserName());
        dicExcelExportDesc.setExportTime(Java8DateUtils.getCurrentDateDTimeStr());
        ArrayList<DicExcelExportDesc> dicExcelExportDescs = new ArrayList<DicExcelExportDesc>();
        dicExcelExportDescs.add(dicExcelExportDesc);
        List mergeColDataList = Stream.of(dicExcelVos.stream().map(DicExcel::getGroup).collect(Collectors.toList()), dicExcelVos.stream().map(DicExcel::getTypeName).collect(Collectors.toList()), dicExcelVos.stream().map(DicExcel::getTypeDesc).collect(Collectors.toList())).collect(Collectors.toList());
        List mergeColIndexList = Stream.of(0, 1, 2).collect(Collectors.toList());
        this.hussarBaseExcelServiceImpl.exportExcel(dicExcelExportDescs, dicExcelVos, DicExcelExportDesc.class, DicExcel.class, "\u5b57\u5178", taskId, new CustomMergeStrategy(mergeColDataList, mergeColIndexList));
    }

    public List<DicExcel> handleDataBeforeImport(List<DicExcel> list) {
        String groupInMergeCell = null;
        String typeNameInMergeCell = null;
        String typeDescInMergeCell = null;
        for (DicExcel dicExcel : list) {
            String groupData = dicExcel.getGroup();
            String typeDesData = dicExcel.getTypeDesc();
            String typeNameData = dicExcel.getTypeName();
            if (HussarUtils.isNotBlank((CharSequence)groupData) && HussarUtils.isNotBlank((CharSequence)typeDesData) && HussarUtils.isNotBlank((CharSequence)typeNameData)) {
                groupInMergeCell = groupData;
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)groupData) && HussarUtils.isNotBlank((CharSequence)typeDesData) && !HussarUtils.isNotBlank((CharSequence)typeNameData)) {
                groupInMergeCell = groupData;
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)groupData) && !HussarUtils.isNotBlank((CharSequence)typeDesData) && HussarUtils.isNotBlank((CharSequence)typeNameData)) {
                groupInMergeCell = groupData;
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (HussarUtils.isBlank((CharSequence)groupData) && HussarUtils.isNotBlank((CharSequence)typeDesData) && HussarUtils.isNotBlank((CharSequence)typeNameData)) {
                dicExcel.setGroup(groupInMergeCell);
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (HussarUtils.isBlank((CharSequence)groupData) && HussarUtils.isBlank((CharSequence)typeDesData) && HussarUtils.isNotBlank((CharSequence)typeNameData)) {
                dicExcel.setGroup(groupInMergeCell);
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (HussarUtils.isBlank((CharSequence)groupData) && HussarUtils.isNotBlank((CharSequence)typeDesData) && HussarUtils.isBlank((CharSequence)typeNameData)) {
                dicExcel.setGroup(groupInMergeCell);
                typeDescInMergeCell = typeDesData;
                typeNameInMergeCell = typeNameData;
                continue;
            }
            if (!HussarUtils.isBlank((CharSequence)groupData) || !HussarUtils.isBlank((CharSequence)typeDesData) || !HussarUtils.isBlank((CharSequence)typeNameData)) continue;
            dicExcel.setGroup(groupInMergeCell);
            dicExcel.setTypeDesc(typeDescInMergeCell);
            dicExcel.setTypeName(typeNameInMergeCell);
        }
        return list;
    }

    public ExcelCheckResult check(List<DicExcel> datas, String dicStrategy) throws CloneNotSupportedException {
        ArrayList<DicExcel> successList = new ArrayList<DicExcel>();
        ArrayList updateList = new ArrayList();
        ArrayList<DicExcel> rootDatas = new ArrayList<DicExcel>();
        ArrayList<ExcelImportErr> errorList = new ArrayList<ExcelImportErr>();
        String anteriorGroupName = null;
        String anteriorTypeDesc = null;
        String anteriorTypeName = null;
        String anteriorSingleLabel = null;
        String anteriorSingleValue = null;
        ArrayList<String> groupNames = new ArrayList<String>();
        ArrayList<String> typeDescsInSameGroup = new ArrayList<String>();
        ArrayList<String> typeNames = new ArrayList<String>();
        ArrayList<String> singleLabelsInSameTypeName = new ArrayList<String>();
        ArrayList<String> singleValuesInSameTypeName = new ArrayList<String>();
        boolean groupNameIsRepeat = false;
        boolean typeDescIsRepeat = false;
        boolean typeNameIsRepeat = false;
        HashMap typeNameAndSingleValue = new HashMap();
        ArrayList<String> singleValues = new ArrayList<String>();
        String parentTypeName = null;
        for (int i = 0; i < datas.size(); ++i) {
            DicExcel temp = datas.get(i);
            DicExcel dicForCopy = (DicExcel)temp.clone();
            rootDatas.add(dicForCopy);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)temp, (Integer)i);
            if (HussarUtils.isBlank((CharSequence)temp.getGroup())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (!HussarUtils.isBlank((CharSequence)temp.getTypeName()) && HussarUtils.isBlank((CharSequence)temp.getTypeDesc())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (HussarUtils.isBlank((CharSequence)temp.getTypeName()) && !HussarUtils.isBlank((CharSequence)temp.getTypeDesc())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (HussarUtils.isBlank((CharSequence)temp.getTypeName()) && !HussarUtils.isBlank((CharSequence)temp.getSingleLabel())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (HussarUtils.isBlank((CharSequence)temp.getTypeName()) && HussarUtils.isBlank((CharSequence)temp.getTypeDesc()) && !HussarUtils.isBlank((CharSequence)temp.getSingleValue())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (HussarUtils.isBlank((CharSequence)temp.getSingleLabel()) && !HussarUtils.isBlank((CharSequence)temp.getSingleValue())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (!HussarUtils.isBlank((CharSequence)temp.getSingleLabel()) && HussarUtils.isBlank((CharSequence)temp.getSingleValue())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Map)cellErrColMap);
            }
            if (HussarUtils.isNotBlank((CharSequence)temp.getGroup())) {
                if (!temp.getGroup().equals(anteriorGroupName)) {
                    anteriorGroupName = temp.getGroup();
                    anteriorTypeDesc = temp.getTypeDesc();
                    if (groupNames.contains(temp.getGroup())) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u5206\u7ec4\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                        groupNameIsRepeat = true;
                    } else {
                        groupNames.add(temp.getGroup());
                        groupNameIsRepeat = false;
                    }
                    typeDescsInSameGroup = new ArrayList();
                } else {
                    if (groupNameIsRepeat) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u5206\u7ec4\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                    }
                    if (HussarUtils.isNotBlank((CharSequence)temp.getTypeDesc()) && !temp.getTypeDesc().equals(anteriorTypeDesc)) {
                        anteriorTypeDesc = temp.getTypeDesc();
                        if (typeDescsInSameGroup.contains(temp.getTypeDesc())) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u5206\u7ec4\u4e0b\uff0c\u5b57\u5178\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                            typeDescIsRepeat = true;
                        } else {
                            typeDescsInSameGroup.add(temp.getTypeDesc());
                            typeDescIsRepeat = false;
                        }
                    } else if (typeDescIsRepeat) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u5206\u7ec4\u4e0b\uff0c\u5b57\u5178\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                    }
                }
            }
            if (HussarUtils.isNotEmpty((Object)temp.getTypeName())) {
                if (!temp.getTypeName().equals(anteriorTypeName)) {
                    anteriorTypeName = temp.getTypeName();
                    anteriorSingleLabel = temp.getSingleLabel();
                    anteriorSingleValue = temp.getSingleValue();
                    if (typeNames.contains(temp.getTypeName())) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                        typeNameIsRepeat = true;
                    } else {
                        typeNames.add(temp.getTypeName());
                        typeNameIsRepeat = false;
                    }
                    singleLabelsInSameTypeName = new ArrayList();
                    singleValuesInSameTypeName = new ArrayList();
                } else {
                    if (typeNameIsRepeat) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                    }
                    if (HussarUtils.isNotBlank((CharSequence)temp.getSingleLabel()) && !temp.getSingleLabel().equals(anteriorSingleLabel)) {
                        anteriorSingleLabel = temp.getSingleLabel();
                        if (singleLabelsInSameTypeName.contains(temp.getSingleLabel())) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                        } else {
                            singleLabelsInSameTypeName.add(temp.getSingleLabel());
                        }
                    } else if (HussarUtils.isNotBlank((CharSequence)temp.getSingleLabel()) && temp.getSingleLabel().equals(anteriorSingleLabel)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u540d\u79f0\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                    }
                    if (HussarUtils.isNotBlank((CharSequence)temp.getSingleValue()) && !temp.getSingleValue().equals(anteriorSingleValue)) {
                        anteriorSingleValue = temp.getSingleValue();
                        if (singleValuesInSameTypeName.contains(temp.getSingleValue())) {
                            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u503c\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                        } else {
                            singleValuesInSameTypeName.add(temp.getSingleLabel());
                        }
                    } else if (HussarUtils.isNotBlank((CharSequence)temp.getSingleValue()) && temp.getSingleValue().equals(anteriorSingleValue)) {
                        HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u5f53\u524d\u5b57\u5178\u6807\u8bc6\u4e0b\uff0c\u5b57\u6bb5\u503c\u586b\u5199\u91cd\u590d", (Map)cellErrColMap);
                    }
                }
            }
            if (!HussarUtils.isNull((Object)temp.getSingleValue()) && !HussarUtils.isBlank((CharSequence)temp.getSingleParentValue()) && temp.getSingleValue().equals(temp.getSingleParentValue())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u503c\u4e0e\u5b57\u6bb5\u503c\u76f8\u540c\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e0a\u7ea7\u5b57\u6bb5\u503c", (Map)cellErrColMap);
            }
            if (!HussarUtils.isNull((Object)temp.getTypeName()) && !HussarUtils.isNull((Object)temp.getSingleValue())) {
                List values;
                if (!temp.getTypeName().equals(parentTypeName)) {
                    parentTypeName = temp.getTypeName();
                    singleValues = new ArrayList();
                }
                singleValues.add(temp.getSingleValue());
                typeNameAndSingleValue.put(temp.getTypeName(), singleValues);
                if (!HussarUtils.isNull((Object)temp.getSingleParentValue()) && !(values = (List)typeNameAndSingleValue.get(temp.getTypeName())).contains(temp.getSingleParentValue())) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)"\u4e0a\u7ea7\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e0a\u7ea7\u5b57\u6bb5\u503c", (Map)cellErrColMap);
                }
            }
            if ("4".equals(dicStrategy) && !HussarUtils.isNull((Object)this.haveSameNameGroup(temp))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)"\u5b57\u5178\u5206\u7ec4\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
                if (!HussarUtils.isNull((Object)this.haveSameNameTypeDesc(temp, this.haveSameNameGroup(temp)))) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)"\u5f53\u524d\u5b57\u5178\u5206\u7ec4\u4e0b\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
                }
                if (!HussarUtils.isNull((Object)this.haveSameNameSingleLabel(temp, this.haveSameNameType(temp, this.haveSameNameGroup(temp))))) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)"\u5f53\u524d\u5b57\u5178\u4e0b\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
                }
                if (!HussarUtils.isNull((Object)this.haveSameNameSingleValue(temp, this.haveSameNameType(temp, this.haveSameNameGroup(temp))))) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)"\u5f53\u524d\u5b57\u5178\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
                }
            }
            if ("4".equals(dicStrategy) && !HussarUtils.isNull((Object)this.haveSameTypeName(temp))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
            }
            if (!"4".equals(dicStrategy) && HussarUtils.isNull((Object)this.haveSameNameGroup(temp)) && !HussarUtils.isNull((Object)this.haveSameTypeName(temp))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)"\u5b57\u5178\u6807\u8bc6\u5df2\u5b58\u5728\uff01", (Map)cellErrColMap);
            }
            if (cellErrColMap.size() == 0) {
                successList.add(temp);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorList.add(new ExcelImportErr((Object)temp, cellErrColMap));
        }
        if (errorList.size() == 0) {
            rootDatas.clear();
        }
        return new ExcelCheckResult(successList, errorList, successList, rootDatas);
    }

    public void saveData(List<DicExcel> datas) {
        ArrayList<DicGroup> groups = new ArrayList<DicGroup>();
        ArrayList<DicType> types = new ArrayList<DicType>();
        ArrayList<DicSingle> singles = new ArrayList<DicSingle>();
        DicExcel anterior = new DicExcel();
        Long sameNameGroupId = null;
        Long sameNameTypeDescId = null;
        Long sameNameTypeId = null;
        Long sameNameSingleLabelId = null;
        Long sameNameSingleValueId = null;
        for (int i = 0; i < datas.size(); ++i) {
            DicExcel dicExcel = datas.get(i);
            if (!dicExcel.getGroup().equals(anterior.getGroup())) {
                anterior = dicExcel;
                parentGroupId = null;
                sameNameGroupId = this.haveSameNameGroup(dicExcel);
                if (sameNameGroupId == null) {
                    this.saveNoSameNameGroupData(dicExcel, groups, types, singles);
                    continue;
                }
                if (!HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName())) continue;
                sameNameTypeDescId = this.haveSameNameTypeDesc(dicExcel, sameNameGroupId);
                sameNameTypeId = this.haveSameNameType(dicExcel, sameNameGroupId);
                if (sameNameTypeDescId == null && sameNameTypeId == null) {
                    this.saveNoSameNameTypeData(dicExcel, sameNameGroupId, types, singles);
                    continue;
                }
                if (sameNameTypeDescId != null && sameNameTypeId == null) {
                    if (!HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) continue;
                    sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, sameNameTypeDescId);
                    sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, sameNameTypeDescId);
                    if (sameNameSingleLabelId != null || sameNameSingleValueId != null) continue;
                    this.saveNoSameNameSingleData(dicExcel, sameNameTypeDescId, singles);
                    continue;
                }
                if (sameNameTypeDescId != null || sameNameTypeId == null || !HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) continue;
                sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, sameNameTypeId);
                sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, sameNameTypeId);
                if (sameNameSingleLabelId != null || sameNameSingleValueId != null) continue;
                this.saveNoSameNameSingleData(dicExcel, sameNameTypeId, singles);
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName()) && !dicExcel.getTypeName().equals(anterior.getTypeName())) {
                anterior = dicExcel;
                parentTypeId = null;
                if (sameNameGroupId == null) {
                    sameNameTypeDescId = this.haveSameNameTypeDesc(dicExcel, ((DicGroup)groups.get(groups.size() - 1)).getId());
                    sameNameTypeId = this.haveSameNameType(dicExcel, ((DicGroup)groups.get(groups.size() - 1)).getId());
                } else {
                    sameNameTypeDescId = this.haveSameNameTypeDesc(dicExcel, sameNameGroupId);
                    sameNameTypeId = this.haveSameNameType(dicExcel, sameNameGroupId);
                }
                if (sameNameTypeDescId == null && sameNameTypeId == null) {
                    if (sameNameGroupId == null) {
                        Long parentGroupId = ((DicGroup)groups.get(groups.size() - 1)).getId();
                        this.saveNoSameNameTypeData(dicExcel, parentGroupId, types, singles);
                        continue;
                    }
                    this.saveNoSameNameTypeData(dicExcel, sameNameGroupId, types, singles);
                    continue;
                }
                if (sameNameTypeDescId != null && sameNameTypeId == null) {
                    if (!HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue()) || !((sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, sameNameTypeDescId)) == null & (sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, sameNameTypeDescId)) == null)) continue;
                    this.saveNoSameNameSingleData(dicExcel, sameNameTypeId, singles);
                    continue;
                }
                if (sameNameTypeDescId != null || sameNameTypeId == null || !HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue()) || !((sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, sameNameTypeId)) == null & (sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, sameNameTypeId)) == null)) continue;
                this.saveNoSameNameSingleData(dicExcel, sameNameTypeId, singles);
                continue;
            }
            if (!HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName()) || !dicExcel.getTypeName().equals(anterior.getTypeName()) || !HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue()) || dicExcel.getSingleValue().equals(anterior.getSingleValue())) continue;
            anterior = dicExcel;
            if (sameNameTypeId == null) {
                sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, ((DicType)types.get(types.size() - 1)).getId());
                sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, ((DicType)types.get(types.size() - 1)).getId());
            } else {
                sameNameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, sameNameTypeId);
                sameNameSingleValueId = this.haveSameNameSingleValue(dicExcel, sameNameTypeId);
            }
            if (sameNameSingleLabelId != null || sameNameSingleValueId != null) continue;
            if (sameNameTypeId == null) {
                this.saveNoSameNameSingleData(dicExcel, ((DicType)types.get(types.size() - 1)).getId(), singles);
                continue;
            }
            this.saveNoSameNameSingleData(dicExcel, sameNameTypeId, singles);
        }
        this.insertOrUpdateList(groups);
        this.insertOrUpdateList(types);
        this.insertOrUpdateList(singles);
    }

    public void updateData(List<DicExcel> datas) {
        ArrayList<DicGroup> groups = new ArrayList<DicGroup>();
        ArrayList<DicType> types = new ArrayList<DicType>();
        ArrayList<DicSingle> singles = new ArrayList<DicSingle>();
        DicExcel anterior = new DicExcel();
        for (int i = 0; i < datas.size(); ++i) {
            DicExcel dicExcel = datas.get(i);
            if (!dicExcel.getGroup().equals(anterior.getGroup())) {
                anterior = dicExcel;
                parentGroupId = null;
                Long sameNameGroupId = this.haveSameNameGroup(dicExcel);
                if (sameNameGroupId == null) {
                    this.saveNoSameNameGroupData(dicExcel, groups, types, singles);
                    continue;
                }
                DicGroup group = this.setGroup(dicExcel, sameNameGroupId);
                groups.add(group);
                this.dealType(dicExcel, sameNameGroupId, types, singles);
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeDesc()) && !dicExcel.getTypeDesc().equals(anterior.getTypeDesc())) {
                anterior = dicExcel;
                parentTypeId = null;
                Long parentGroupId = ((DicGroup)groups.get(groups.size() - 1)).getId();
                this.dealType(dicExcel, parentGroupId, types, singles);
                continue;
            }
            if (!HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName()) || !dicExcel.getTypeName().equals(anterior.getTypeName()) || !HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue()) || dicExcel.getSingleValue().equals(anterior.getSingleValue())) continue;
            Long typeId = ((DicType)types.get(types.size() - 1)).getId();
            this.updateSingle(dicExcel, typeId, singles);
        }
        this.insertOrUpdateList(groups);
        this.insertOrUpdateList(types);
        this.insertOrUpdateList(singles);
    }

    private void dealType(DicExcel dicExcel, Long groupId, List<DicType> types, List<DicSingle> singles) {
        if (HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName())) {
            Long sameNameTypeDescId = this.haveSameNameTypeDesc(dicExcel, groupId);
            Long sameNameTypeId = this.haveSameNameType(dicExcel, groupId);
            if (sameNameTypeDescId == null && sameNameTypeId == null) {
                this.saveNoSameNameTypeData(dicExcel, groupId, types, singles);
            } else if (sameNameTypeDescId != null && sameNameTypeId == null) {
                DicType type = this.setType(dicExcel, sameNameTypeDescId, groupId);
                types.add(type);
                if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                    this.updateSingle(dicExcel, sameNameTypeDescId, singles);
                }
            } else if (sameNameTypeDescId == null && sameNameTypeId != null) {
                DicType type = this.setType(dicExcel, sameNameTypeId, groupId);
                types.add(type);
                if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                    this.updateSingle(dicExcel, sameNameTypeId, singles);
                }
            } else if (sameNameTypeDescId != null && sameNameTypeId != null) {
                DicType type = this.setType(dicExcel, sameNameTypeId, groupId);
                types.add(type);
                if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                    this.updateSingle(dicExcel, sameNameTypeId, singles);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DicGroup setGroup(DicExcel dicExcel, Long groupId) {
        DicGroup group = new DicGroup();
        group.setParentId(DictMigrationConstants.ID_DICT_ROOT);
        group.setGroupDescription(dicExcel.getGroup());
        group.setId(groupId);
        if (dicExcel.getGroup().equals("\u7cfb\u7edf\u5b57\u5178")) {
            group.setSort(Integer.valueOf(1));
            group.setRangeType("sys");
            return group;
        }
        if (dicExcel.getGroup().equals("\u4e1a\u52a1\u5b57\u5178")) {
            group.setSort(Integer.valueOf(2));
            group.setRangeType("biz");
            return group;
        }
        DicGroup lastOne = (DicGroup)this.dicGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicGroup::getParentId, (Object)DictMigrationConstants.ID_DICT_ROOT)).orderByDesc(DicGroup::getSort), false);
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            if (ToolUtil.isEmpty((Object)lastOne)) {
                group.setSort(Integer.valueOf(3 + addGroupSort));
                ++addGroupSort;
            } else {
                group.setSort(Integer.valueOf(lastOne.getSort() + 1 + addGroupSort));
                ++addGroupSort;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            group.setRangeType("dict");
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicType setType(DicExcel dicExcel, Long typeId, Long groupId) {
        DicType type = new DicType();
        type.setTypeName(dicExcel.getTypeName());
        type.setTypeDescription(dicExcel.getTypeDesc());
        type.setParentId(groupId);
        type.setId(typeId);
        DicType lastOne = (DicType)this.dicTypeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicType::getParentId, (Object)groupId)).orderByDesc(DicType::getSort), false);
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            if (ToolUtil.isEmpty((Object)lastOne)) {
                if (groupId.equals(parentGroupId)) {
                    type.setSort(Integer.valueOf(++typeSort));
                } else {
                    typeSort = 0;
                    type.setSort(Integer.valueOf(++typeSort));
                    parentGroupId = groupId;
                }
            } else if (groupId.equals(parentGroupId)) {
                type.setSort(Integer.valueOf(++typeSort));
            } else {
                typeSort = lastOne.getSort();
                type.setSort(Integer.valueOf(++typeSort));
                parentGroupId = groupId;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            type.setRangeType(groupId.toString());
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicSingle setSingle(DicExcel dicExcel, Long singleId, Long typeId) {
        DicSingleDto single = new DicSingleDto();
        single.setValue(dicExcel.getSingleValue());
        single.setLabel(dicExcel.getSingleLabel());
        single.setId(singleId);
        single.setTypeId(typeId);
        DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)typeId)).orderByDesc(DicSingle::getSort), false);
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            if (HussarUtils.isEmpty((Object)lastOne)) {
                if (!typeId.equals(parentTypeId)) {
                    singleSort = 0;
                    single.setSort(Integer.valueOf(++singleSort));
                    parentTypeId = typeId;
                    SysDicTypeServiceImpl.setSingleValeAndSingleID(new HashMap<String, Long>());
                    if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                        SysDicTypeServiceImpl.getSingleValeAndSingleID().put(dicExcel.getSingleValue(), singleId);
                    }
                } else {
                    single.setSort(Integer.valueOf(++singleSort));
                    if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                        SysDicTypeServiceImpl.getSingleValeAndSingleID().put(dicExcel.getSingleValue(), singleId);
                    }
                    if (dicExcel.getSingleParentValue() != null) {
                        Long singleParentId = SysDicTypeServiceImpl.getSingleValeAndSingleID().get(dicExcel.getSingleParentValue());
                        single.setParentId(singleParentId);
                    } else {
                        single.setParentId(null);
                    }
                }
            } else if (!typeId.equals(parentTypeId)) {
                single.setSort(Integer.valueOf(++singleSort));
                if (dicExcel.getSingleValue() != null) {
                    SysDicTypeServiceImpl.setSingleValeAndSingleID(new HashMap<String, Long>());
                    SysDicTypeServiceImpl.getSingleValeAndSingleID().put(dicExcel.getSingleValue(), singleId);
                }
            } else {
                singleSort = lastOne.getSort();
                single.setSort(Integer.valueOf(++singleSort));
                parentTypeId = typeId;
                if (dicExcel.getSingleParentValue() != null) {
                    Long singleParentId = SysDicTypeServiceImpl.getSingleValeAndSingleID().get(dicExcel.getSingleParentValue());
                    single.setParentId(singleParentId);
                } else {
                    single.setParentId(null);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return single;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNoSameNameGroupData(DicExcel dicExcel, List<DicGroup> groups, List<DicType> types, List<DicSingle> singles) {
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            Long l = snowId;
            Long l2 = snowId = Long.valueOf(snowId + 1L);
            Long newGroupId = l;
            DicGroup group = this.setGroup(dicExcel, newGroupId);
            groups.add(group);
            if (HussarUtils.isNotBlank((CharSequence)dicExcel.getTypeName())) {
                this.saveNoSameNameTypeData(dicExcel, newGroupId, types, singles);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNoSameNameTypeData(DicExcel dicExcel, Long parentGroupId, List<DicType> types, List<DicSingle> singles) {
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            Long l = snowId;
            Long l2 = snowId = Long.valueOf(snowId + 1L);
            Long newTypeId = l;
            DicType type = this.setType(dicExcel, newTypeId, parentGroupId);
            types.add(type);
            if (HussarUtils.isNotBlank((CharSequence)dicExcel.getSingleValue())) {
                this.saveNoSameNameSingleData(dicExcel, newTypeId, singles);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNoSameNameSingleData(DicExcel dicExcel, Long parentTypeId, List<DicSingle> singles) {
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            Long l = snowId;
            Long l2 = snowId = Long.valueOf(snowId + 1L);
            Long newSingleId = l;
            DicSingle single = this.setSingle(dicExcel, newSingleId, parentTypeId);
            singles.add(single);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSingle(DicExcel dicExcel, Long parentTypeId, List<DicSingle> singles) {
        Long sameSingleLabelId = this.haveSameNameSingleLabel(dicExcel, parentTypeId);
        Long sameSingleValueId = this.haveSameNameSingleValue(dicExcel, parentTypeId);
        DicSingle single = null;
        Class<SysDicTypeServiceImpl> clazz = SysDicTypeServiceImpl.class;
        synchronized (SysDicTypeServiceImpl.class) {
            if (sameSingleLabelId == null && sameSingleValueId == null) {
                Long l = snowId;
                Long l2 = snowId = Long.valueOf(snowId + 1L);
                Long newSingleId = l;
                single = this.setSingle(dicExcel, newSingleId, parentTypeId);
            } else if (sameSingleLabelId != null) {
                single = this.setSingle(dicExcel, sameSingleLabelId, parentTypeId);
            } else if (sameSingleValueId != null) {
                single = this.setSingle(dicExcel, sameSingleValueId, parentTypeId);
            }
            singles.add(single);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public Long haveSameNameGroup(DicExcel dicExcel) {
        LambdaQueryWrapper wrapper = new QueryWrapper().lambda();
        wrapper.eq(DicGroup::getGroupDescription, (Object)dicExcel.getGroup());
        List sameNameGroup = this.dicGroupService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameGroup)) {
            return ((DicGroup)sameNameGroup.get(0)).getId();
        }
        return null;
    }

    public Long haveSameTypeName(DicExcel dicExcel) {
        LambdaQueryWrapper typeWrapper = new QueryWrapper().lambda();
        typeWrapper.eq(DicType::getTypeName, (Object)dicExcel.getTypeName());
        List sameNameType = this.dicTypeService.list((Wrapper)typeWrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameType)) {
            return ((DicType)sameNameType.get(0)).getId();
        }
        return null;
    }

    public Long haveSameNameType(DicExcel dicExcel, Long groupId) {
        LambdaQueryWrapper typeWrapper = new QueryWrapper().lambda();
        typeWrapper.eq(DicType::getTypeName, (Object)dicExcel.getTypeName());
        List sameNameType = this.dicTypeService.list((Wrapper)typeWrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameType)) {
            return ((DicType)sameNameType.get(0)).getId();
        }
        return null;
    }

    public Long haveSameNameTypeDesc(DicExcel dicExcel, Long groupId) {
        LambdaQueryWrapper typeWrapper = new QueryWrapper().lambda();
        ((LambdaQueryWrapper)typeWrapper.eq(DicType::getTypeDescription, (Object)dicExcel.getTypeDesc())).eq(DicType::getParentId, (Object)groupId);
        List sameNameType = this.dicTypeService.list((Wrapper)typeWrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameType)) {
            return ((DicType)sameNameType.get(0)).getId();
        }
        return null;
    }

    public Long haveSameNameSingleLabel(DicExcel dicExcel, Long typeId) {
        LambdaQueryWrapper singleWrapper = new QueryWrapper().lambda();
        ((LambdaQueryWrapper)singleWrapper.eq(DicSingle::getLabel, (Object)dicExcel.getSingleLabel())).eq(DicSingle::getTypeId, (Object)typeId);
        List sameNameSingle = this.dicSingleService.list((Wrapper)singleWrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameSingle)) {
            return ((DicSingle)sameNameSingle.get(0)).getId();
        }
        return null;
    }

    public Long haveSameNameSingleValue(DicExcel dicExcel, Long typeId) {
        LambdaQueryWrapper singleWrapper = new QueryWrapper().lambda();
        ((LambdaQueryWrapper)singleWrapper.eq(DicSingle::getValue, (Object)dicExcel.getSingleValue())).eq(DicSingle::getTypeId, (Object)typeId);
        List sameNameSingle = this.dicSingleService.list((Wrapper)singleWrapper);
        if (HussarUtils.isNotEmpty((Object)sameNameSingle)) {
            return ((DicSingle)sameNameSingle.get(0)).getId();
        }
        return null;
    }

    static {
        parentTypeId = null;
        singleValeAndSingleID = new HashMap<String, Long>();
        snowId = SnowflakeSequence.getSingleton().nextValue();
    }
}

