/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDicTypeServiceImpl
extends ServiceImpl<SysDicTypeMapper, DicType>
implements ISysDicTypeService {
    private Logger logger = LoggerFactory.getLogger(SysDicTypeServiceImpl.class);
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper singleMapper;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicGroupService dicGroupService;

    public void evictTypeCacheById(Long id) {
        DicType type = (DicType)this.getById(id);
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName() + ":*"));
        }
    }

    public List<JSTreeModel> dicExportTreeData() {
        return this.sysDicTypeMapper.dicExportTreeData();
    }

    public void exportDict(List<String> idList, HttpServletResponse response) {
        List<Long> convertIds = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List group = this.dicGroupService.getGroupBytypeIds(convertIds);
        List type = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicType::getId, convertIds));
        List<Long> singleIdList = this.getSingleIdByTypeId(convertIds, new ArrayList<Long>());
        List single = new ArrayList();
        if (singleIdList.size() > 0) {
            single = this.dicSingleService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(DicSingle::getId, singleIdList));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("group", group);
        data.put("export_type", "dictionary");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5e8f\u5217\u5316\u51fa\u9519");
        }
        String fileName = "dict_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<Long> getSingleIdByTypeId(List<Long> typeIdList, List<Long> resultList) {
        List splitIdList = LambdaQueryUtil.getSplitList(typeIdList);
        List<Long> singleIdList = this.singleMapper.getSingleIdByTypeId(splitIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    public JSONObject importDictData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"dictionary");
            return result;
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        Map<String, Integer> groupCount = this.insertOrUpdateList(group);
        Map<String, Integer> typeCount = this.insertOrUpdateList(type);
        Map<String, Integer> singleCount = this.insertOrUpdateList(single);
        result.put("success", (Object)"true");
        result.put("groupInsert", (Object)groupCount.get("insert"));
        result.put("groupUpdate", (Object)groupCount.get("update"));
        result.put("typeInsert", (Object)typeCount.get("insert"));
        result.put("typeUpdate", (Object)typeCount.get("update"));
        result.put("singleInsert", (Object)singleCount.get("insert"));
        result.put("singleUpdate", (Object)singleCount.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<?> list) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(list)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = list.get(i);
                if (obj instanceof DicGroup) {
                    DicGroup dicGroup = (DicGroup)obj;
                    if (this.dicGroupService.updateById((Object)dicGroup)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicGroupService.save((Object)dicGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicType) {
                    DicType dicType = (DicType)obj;
                    if (super.updateById((Object)dicType)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        super.save((Object)dicType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof DicSingle) {
                    DicSingle dicSingle = (DicSingle)obj;
                    if (this.dicSingleService.updateById((Object)dicSingle)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.dicSingleService.save((Object)dicSingle);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public IPage<DicType> queryList(Page page, String rangeType) {
        String rootRange = "root";
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        HashMap result = new HashMap(5);
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq(DicType::getRangeType, (Object)rangeType);
        }
        ew.orderByAsc(DicType::getSort);
        List list2 = ((Page)this.page((IPage)page, (Wrapper)ew)).getRecords();
        page.setRecords(list2);
        return page;
    }

    public List<DicType> selectListByParentId() {
        return this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(DicType::getSort));
    }

    public List<DicSingle> selectChildsById(String id) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(id != null, DicType::getId, (Object)id));
        List dicSingles = list.size() > 0 ? this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)id)).orderByAsc(DicSingle::getSort)) : this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id)).orderByAsc(DicSingle::getSort));
        return dicSingles;
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        Long typeId = dt.getId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)typeId)).orderByAsc(DicSingle::getSort));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    public List<DicType> selectDicTypeByDouble(List<DicType> dicTypeList) {
        ArrayList<DicType> returnList = new ArrayList<DicType>();
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        for (int i = 0; i < dicTypeList.size(); i += 699) {
            List<DicType> temp;
            if (i + 699 >= dicTypeList.size()) {
                temp = dicTypeList.subList(i, dicTypeList.size());
                dicTypeLambdaQueryWrapper.clear();
                for (DicType dicType : temp) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
                }
                returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
                continue;
            }
            temp = dicTypeList.subList(i, i + 699);
            dicTypeLambdaQueryWrapper.clear();
            for (DicType dicType : temp) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)dicType.getId())).ne(DicType::getTypeName, (Object)dicType.getTypeName());
            }
            returnList.addAll(this.sysDicTypeMapper.selectList((Wrapper)dicTypeLambdaQueryWrapper));
        }
        return returnList;
    }

    public List<DicType> selectDicTypeByTypeIds(List<Long> ids) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        for (Long id : ids) {
            ((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getId, (Object)id);
        }
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }

    public List<DicType> selectDicTypeByTypeNames(List<String> typeNames) {
        LambdaQueryWrapper dicTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty(typeNames)) {
            return Collections.emptyList();
        }
        for (String name : typeNames) {
            ((LambdaQueryWrapper)dicTypeLambdaQueryWrapper.or()).eq(DicType::getTypeName, (Object)name);
        }
        dicTypeLambdaQueryWrapper.orderByAsc(DicType::getSort);
        return this.list((Wrapper)dicTypeLambdaQueryWrapper);
    }
}

