/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.controller;

import com.jxdinfo.hussar.general.dict.feign.RemoteSysDicFrontService;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.dict.vo.DictLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.general.dict.vo.GroupDictVo;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Feign\u5b57\u5178\u7ba1\u7406"})
public class RemoteDicFrontController
implements RemoteSysDicFrontService {
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Autowired
    private ISysDicRefService sysDicRefService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicType> selectListByParentId() {
        return this.sysDicTypeService.selectListByParentId();
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178", notes="\u83b7\u53d6\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicVo> getDicListByCode(@RequestParam(value="code") String code) {
        return this.sysDicRefService.getDicListByType(code);
    }

    @ApiOperation(value="\u6839\u636e\u4f20\u5165\u7c7b\u578b\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", notes="\u6839\u636e\u4f20\u5165\u7c7b\u578b\u83b7\u53d6\u591a\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u4f20\u5165\u7c7b\u578b\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicType> getLevelDictType(String selectType) {
        return this.sysDicRefService.getLevelDictType(selectType);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578bid\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578bid\u83b7\u53d6\u591a\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578bid\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicLevelTreeVo> getLevelDictByType(Long typeId) {
        return this.sysDicRefService.getLevelDictByType(typeId);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u591a\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u591a\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicLevelTreeVo> getLevelDictByTypeName(String typeName) {
        return this.sysDicRefService.getLevelDictByTypeName(typeName);
    }

    @ApiOperation(value="\u83b7\u53d6\u4ec5\u6709\u4e00\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", notes="\u83b7\u53d6\u4ec5\u6709\u4e00\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4ec5\u6709\u4e00\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicType> getOneLevel() {
        return this.sysDicRefService.getOneLevel();
    }

    @ApiOperation(value="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", notes="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DicType> getMultilevel() {
        return this.sysDicRefService.getMultilevel();
    }

    @ApiOperation(value="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", notes="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u62e5\u6709\u591a\u7ea7\u5b57\u5178\u9879\u7684\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public List<DicLevelTreeVo> mergeDicLevelTree(List<DicLevelTreeVo> dicLevelTreeVoList) {
        return this.sysDicRefService.mergeDicLevelTree(dicLevelTreeVoList);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<GroupDictVo> getGroupDictByTypeName(String typeName) {
        return this.sysDicRefService.getGroupDictByTypeName(typeName);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DictVo> getDictVosByTypeNames(List<String> typeNames) {
        return this.sysDicRefService.getDictVosByTypeNames(typeNames);
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public List<DictLevelTreeVo> getDictLevelTreeVosByTypeNames(List<String> typeNames) {
        return this.sysDicRefService.getDictLevelTreeVosByTypeNames(typeNames);
    }
}

