/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.dto.DicGroupDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.dict.vo.DictLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DictMigrationDumpVo;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.general.dict.vo.GroupDictVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dicFront"})
@Api(tags={"\u7cfb\u7edf\u5b57\u5178\u7ba1\u7406"})
@HussarTokenDs
public class SysDicFrontController
extends HussarBaseController<DicSingle, ISysDicSingleService> {
    private String prefix = "/core/sys/dict/";
    private String flagOfEdit = "haveType";
    private String flagOfAdd = "0";
    @Resource
    private ISysDicService dictService;
    @Resource
    private SysDicFrontService sysDicFrontService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicRefService sysDicRefService;

    @GetMapping(value={"/getDictByCode"})
    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178", notes="\u83b7\u53d6\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicVo>> getDictByCode(@ApiParam(value="\u7c7b\u522b\u540d") @RequestParam(value="code") String code) {
        List list = this.sysDicRefService.getDicListByType(code);
        return ApiResponse.success((Object)list);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u65b0\u589e", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b57\u5178\u7c7b\u522b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse add(@ApiParam(value="\u6570\u636e\u5b57\u5178\u7c7b\u578b\u5b9e\u4f53") @RequestBody DicType dicType) {
        Long parentId = dicType.getParentId();
        String dictName = dicType.getTypeDescription();
        String dictTypeCode = dicType.getTypeName();
        String dictValues = null;
        return this.dictService.addDictType(parentId, dictName, dictTypeCode, dictValues);
    }

    @PostMapping(value={"/add_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u6dfb\u52a0", notes="\u65b0\u589e\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addSingle(@ApiParam(value="\u6570\u636e\u5b57\u5178Dto") @RequestBody DicSingleDto dicSingleDto) {
        Long dictId = dicSingleDto.getId();
        Long dictTypeId = dicSingleDto.getTypeId();
        String dictName = dicSingleDto.getLabel();
        String dictValue = dicSingleDto.getValue();
        String flag = dicSingleDto.getFlag();
        if (this.flagOfAdd.equals(flag)) {
            return this.dictService.saveDicSingle(dictId, dictTypeId, dictName, dictValue);
        }
        return this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue);
    }

    @PostMapping(value={"/addGroup"})
    @ApiOperation(value="\u5b57\u5178\u65b0\u589e", notes="\u65b0\u589e\u5b57\u5178\u5206\u7ec4")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b57\u5178\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addGroup(@ApiParam(value="\u5b57\u5178\u5206\u7ec4\u5b9e\u4f53") @RequestBody DicGroup dicGroup) {
        return this.dictService.saveDicGroup(dicGroup);
    }

    @PostMapping(value={"/editGroup"})
    @ApiOperation(value="\u5b57\u5178\u4fee\u6539", notes="\u4fee\u6539\u5b57\u5178\u5206\u7ec4")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u4fee\u6539\u5b57\u5178\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editGroup(@ApiParam(value="\u5b57\u5178\u5206\u7ec4\u5b9e\u4f53") @RequestBody DicGroup dicGroup) {
        return this.dictService.updateDictGroup(dicGroup);
    }

    @PostMapping(value={"/update_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u4fee\u6539", notes="\u4fee\u6539\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u4fee\u6539\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editSingle(@ApiParam(value="\u6570\u636e\u5b57\u5178\u5b9e\u4f53") @RequestBody DicSingle dicSingle) {
        Long dictId = dicSingle.getId();
        Long dictTypeId = dicSingle.getTypeId();
        String dictName = dicSingle.getLabel();
        String dictValue = dicSingle.getValue();
        return this.dictService.updateDicSingle(dictId, dictTypeId, dictName, dictValue);
    }

    @GetMapping(value={"/dicGroupList"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\uff1b\u52a8\u6001\u62fc\u63a5\u4e0a'\u7cfb\u7edf\u5b57\u5178'\u3001'\u4e1a\u52a1\u5b57\u5178'\u7ec4")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<DicGroup>> dicGroupList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u5b57\u5178\u5206\u7ec4dto") DicGroupDto dicGroupDto) {
        return ApiResponse.success((Object)this.dicGroupService.queryList(page, dicGroupDto));
    }

    @GetMapping(value={"/getList/{rangeType}"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\uff1b\u52a8\u6001\u62fc\u63a5\u4e0a'\u7cfb\u7edf\u5b57\u5178'\u3001'\u4e1a\u52a1\u5b57\u5178'\u7ec4")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<DicType>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u7f16\u8f91\u7c7b\u578b") @PathVariable(value="rangeType") String rangeType) {
        return ApiResponse.success((Object)this.dicTypeService.queryList(page, rangeType));
    }

    @GetMapping(value={"/list_single/{dictTypeId}"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", notes="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<DicSingle>> listSingle(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u7c7b\u578b(sys_dict_type\u5916\u952e)") @PathVariable(value="dictTypeId") Long dictTypeId) {
        return ApiResponse.success((Object)this.dictService.queryListSingle(page, dictTypeId));
    }

    @GetMapping(value={"/query_single"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", notes="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<DicSingle>> querySingle(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u7c7b\u578b(sys_dict_type\u5916\u952e)") @RequestParam(value="dictTypeId") String dictTypeId, @ApiParam(value="\u7236id") @RequestParam(value="parentId", required=false) String parentId) {
        return ApiResponse.success((Object)this.dictService.queryListSingle(page, dictTypeId, parentId));
    }

    @GetMapping(value={"/detail/{dictId}"})
    @ApiOperation(value="\u5b57\u5178\u8be6\u60c5", notes="\u5b57\u5178\u8be6\u60c5")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<DicSingle> openSingleDetail(@ApiParam(value="\u6570\u636e\u5b57\u5178id") @PathVariable(value="dictId") String dictId) {
        return this.dicSingleService.selectById(dictId);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u4fee\u6539", notes="\u5b57\u5178\u7c7b\u522b\u4fee\u6539")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u7c7b\u522b\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse update(@ApiParam(value="\u4fee\u6539\u5b57\u5178Dto") @RequestBody DicDto dicDto) {
        return this.dictService.updateNewDict(dicDto);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u5220\u9664", notes="\u5b57\u5178\u7c7b\u522b\u5220\u9664")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u7c7b\u522b\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delete(@ApiParam(value="\u5220\u9664\u4e3b\u952e") @RequestBody String dictId) {
        String[] strArr = dictId.split(",");
        return this.dictService.deleteCascadeDict(strArr);
    }

    @PostMapping(value={"/delete_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u5220\u9664", notes="\u5b57\u5178\u5b57\u6bb5\u5220\u9664")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u5b57\u6bb5\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse deleteSingle(@ApiParam(value="\u5220\u9664\u4e3b\u952e") @RequestBody String dictId) {
        String[] strarr = dictId.split(",");
        List<String> list = Arrays.asList(strarr);
        return this.dicSingleService.deleteSingle(list);
    }

    @GetMapping(value={"/dicTypeTree"})
    @ApiOperation(value="\u521d\u59cb\u5316\u5b57\u5178\u6811", notes="\u521d\u59cb\u5316\u5b57\u5178\u6811")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u521d\u59cb\u5316\u5b57\u5178\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicTypeTreeData() {
        return ApiResponse.success((Object)this.sysDicFrontService.queryDicTypeTreeData());
    }

    @GetMapping(value={"/dicOrderTree"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5", notes="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5\u8fdb\u884c\u6392\u5e8f")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicOrderTreeData(@ApiParam(value="\u6570\u636e\u5b57\u5178\u7c7b\u578b\u5b9e\u4f53") DicType dicType) {
        Long typeId = dicType.getId();
        if (ToolUtil.isEmpty((Object)typeId)) {
            return ApiResponse.success(new ArrayList());
        }
        return ApiResponse.success((Object)this.sysDicFrontService.queryDicOrderTreeData(typeId));
    }

    @PostMapping(value={"/saveDicOrder"})
    @ApiOperation(value="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f", notes="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f\u4fdd\u5b58")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveDicOrder(@ApiParam(value="\u6392\u5e8f\u4e3b\u952e") @RequestBody String orderInfo) {
        return this.dictService.updateDicOrder(orderInfo);
    }

    @PostMapping(value={"/singleMove"})
    @ApiOperation(value="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb", notes="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNode(@ApiParam(value="\u6570\u636e\u5b57\u5178Dto") @RequestBody DicSingleDto dicSingleDto) {
        return this.dictService.updateMoveNode(dicSingleDto);
    }

    @GetMapping(value={"/selectListByParentId"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicType>> selectListByParentId() {
        return ApiResponse.success((Object)this.dicTypeService.selectListByParentId());
    }

    @GetMapping(value={"/selectListByTypeName"})
    @ApiOperation(value="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", notes="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicSingle>> selectListByTypeName(@ApiParam(value="\u6570\u636e\u5b57\u5178\u7c7b\u578b\u5b9e\u4f53") DicType dicType) {
        return ApiResponse.success((Object)this.sysDicRefService.getDictByType(dicType.getTypeName()));
    }

    @GetMapping(value={"/selectChildsById"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55", notes="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicSingle>> selectChildsById(@ApiParam(value="\u5b57\u5178\u4e3b\u952e") @RequestParam(value="id") String id) {
        return ApiResponse.success((Object)this.dicTypeService.selectChildsById(id));
    }

    @GetMapping(value={"/dicExportTree"})
    @ApiOperation(value="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811", notes="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicExportTreeData() {
        return this.dictService.queryExportTreeData();
    }

    @PostMapping(value={"/exportDict"})
    @ApiOperation(value="\u5b57\u5178\u5bfc\u51fa", notes="\u5bfc\u51fa\u5b57\u5178\u6587\u4ef6")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(HttpServletResponse response, @ApiParam(value="\u6570\u636e\u5b57\u5178\u7c7b\u578bid") @RequestBody String typeIds) {
        List<String> typeIdList = Arrays.asList(typeIds.split(","));
        this.dicTypeService.exportDict(typeIdList, response);
    }

    @PostMapping(path={"/importData"})
    @ApiOperation(value="\u5b57\u5178\u5bfc\u5165", notes="\u5bfc\u5165\u5b57\u5178\u6570\u636e")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<JSONObject> importData(@ApiParam(value="\u5bfc\u5165\u6570\u636e\u5b57\u5178\u6570\u636e\u6587\u4ef6") @RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        JSONObject result = this.dicTypeService.importDictData(content);
        return ApiResponse.success((Object)result);
    }

    @RequestMapping(value={"/changeToPinyinLow"})
    @ApiOperation(value="\u5c06\u6c49\u5b57\u8f6c\u4e3a\u62fc\u97f3\uff0c\u5168\u90e8\u5c0f\u5199", notes="\u5c06\u6c49\u5b57\u8f6c\u4e3a\u62fc\u97f3\uff0c\u5168\u90e8\u5c0f\u5199")
    @ResponseBody
    public ApiResponse<String> changeToPinyinLow(@RequestBody Map<String, String> map) {
        String beforeChangeStr = map.get("chineseName");
        String afterChangeStr = this.dicSingleService.changeToPinyin(beforeChangeStr, HanyuPinyinCaseType.LOWERCASE);
        return ApiResponse.success((String)afterChangeStr);
    }

    @GetMapping(value={"/getLevelDictByType"})
    @ApiOperation(value="\u901a\u8fc7typeId\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879", notes="\u901a\u8fc7typeId\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u901a\u8fc7typeId\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicLevelTreeVo>> getLevelDict(@ApiParam(value="\u5b57\u5178\u7c7b\u578bid") @RequestParam(value="typeId") Long typeId) {
        return ApiResponse.success((Object)this.sysDicRefService.getLevelDictByType(typeId));
    }

    @GetMapping(value={"/getLevelDictByTypeName"})
    @ApiOperation(value="\u901a\u8fc7typeName\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879", notes="\u901a\u8fc7typeName\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u901a\u8fc7typeName\u67e5\u8be2\u591a\u7ea7\u5b57\u5178\u7684\u5b57\u5178\u9879", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicLevelTreeVo>> getLevelDictByTypeName(@ApiParam(value="\u5b57\u5178\u7c7b\u578b\u540d\u79f0") @RequestParam(value="typeName") String typeName) {
        return ApiResponse.success((Object)this.sysDicRefService.getLevelDictByTypeName(typeName));
    }

    @GetMapping(value={"/getLevelDictType"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u591a\u7ea7\u5b57\u5178", notes="\u67e5\u8be2\u6240\u6709\u591a\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6240\u6709\u591a\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicType>> getLevelDictType(@ApiParam(value="\u67e5\u8be2\u7c7b\u578b") @RequestParam(value="selectType") String selectType) {
        return ApiResponse.success((Object)this.sysDicRefService.getLevelDictType(selectType));
    }

    @GetMapping(value={"/getGroupDictByTypeName"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u83b7\u53d6\u6240\u6709\u4e8c\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<GroupDictVo>> getGroupDictByTypeName(@ApiParam(value="\u5b57\u5178\u7c7b\u578b\u540d\u79f0") @RequestParam(value="typeName") String typeName) {
        return ApiResponse.success((Object)this.sysDicRefService.getGroupDictByTypeName(typeName));
    }

    @GetMapping(value={"/getDictNoSys"})
    @ApiOperation(value="\u83b7\u53d6\u9664\u7cfb\u7edf\u5b57\u5178\u4e4b\u5916\u7684\u591a\u7ea7\u5b57\u5178", notes="\u83b7\u53d6\u9664\u7cfb\u7edf\u5b57\u5178\u4e4b\u5916\u7684\u591a\u7ea7\u5b57\u5178")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u9664\u7cfb\u7edf\u5b57\u5178\u4e4b\u5916\u7684\u591a\u7ea7\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DictMigrationDumpVo>> getDictNoSys() {
        return ApiResponse.success((Object)this.dictService.getDictOutSys());
    }

    @GetMapping(value={"/getDictVosByTypeNames"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868\u6279\u91cf\u83b7\u53d6\u4e0b\u5c5e\u6761\u76ee", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DictVo>> getDictVosByTypeNames(@ApiParam(value="\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868") @RequestParam(value="typeNames") List<String> typeNames) {
        return ApiResponse.success((Object)this.sysDicRefService.getDictVosByTypeNames(typeNames));
    }

    @GetMapping(value={"/getDictLevelTreeVosByTypeNames"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u6279\u91cf\u83b7\u53d6\u591a\u7ea7\u5b57\u5178\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DictLevelTreeVo>> getDictLevelTreeVosByTypeNames(@ApiParam(value="\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u5217\u8868") @RequestParam(value="typeNames") List<String> typeNames) {
        return ApiResponse.success((Object)this.sysDicRefService.getDictLevelTreeVosByTypeNames(typeNames));
    }
}

