/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.calendar.dao.SysCalendarMapper;
import com.jxdinfo.hussar.general.calendar.model.SysCalendar;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysCalendarRefServiceImpl
implements ISysCalendarRefService {
    @Resource
    private SysCalendarMapper sysCalendarMapper;

    public LocalDateTime getEndDateDefult(LocalDateTime startTime, String timeFrame, boolean isWorkCalendar) {
        int month = Integer.parseInt(timeFrame.substring(timeFrame.indexOf("P") + 1, timeFrame.indexOf("M")));
        int days = Integer.parseInt(timeFrame.substring(timeFrame.indexOf("M") + 1, timeFrame.indexOf("D")));
        int hours = Integer.parseInt(timeFrame.substring(timeFrame.indexOf("T") + 1, timeFrame.indexOf("H")));
        int mins = Integer.parseInt(timeFrame.substring(timeFrame.indexOf("H") + 1, timeFrame.lastIndexOf("M")));
        LocalDateTime endTime = startTime.plusMonths(month).plusDays(days).plusHours(hours).plusMinutes(mins);
        if (isWorkCalendar) {
            LocalDateTime startWorkDay = startTime.with(LocalTime.MIN);
            int workDatesTotal = (int)Duration.between(startWorkDay, endTime).toDays();
            List<SysCalendar> allSysCalendar = this.sysCalendarMapper.getEventsBetweenDate(Date.from(startWorkDay.atZone(ZoneId.systemDefault()).toInstant()), null);
            HashMap<Integer, SysCalendar> daysAndEvent = new HashMap<Integer, SysCalendar>();
            for (SysCalendar item : allSysCalendar) {
                int time = (int)Duration.between(startWorkDay, item.getStartTime()).toDays();
                daysAndEvent.put(time, item);
            }
            int weekDay = startWorkDay.getDayOfWeek().getValue();
            int workDates = 0;
            int naturalDays = 0;
            while (workDates < workDatesTotal) {
                int n = weekDay = ++weekDay > 7 ? 1 : weekDay;
                if (ToolUtil.isNotEmpty(daysAndEvent.get(++naturalDays))) {
                    if (!"\u73ed".equals(((SysCalendar)daysAndEvent.get(naturalDays)).getTitle())) continue;
                    ++workDates;
                    continue;
                }
                if (weekDay == 6 || weekDay == 7) continue;
                ++workDates;
            }
            int finalHours = endTime.getHour();
            int finalMins = endTime.getMinute();
            endTime = startWorkDay.plusDays(naturalDays).plusHours(finalHours).plusMinutes(finalMins);
        }
        return endTime;
    }

    public Integer getWorkDays(LocalDateTime startTime, LocalDateTime endTime) {
        startTime = LocalDateTime.of(startTime.toLocalDate(), LocalTime.MIN);
        endTime = LocalDateTime.of(endTime.toLocalDate(), LocalTime.MIN);
        int naturalDays = (int)Duration.between(startTime, endTime).toDays() + 1;
        List<SysCalendar> sysCalendarList = this.sysCalendarMapper.getEventsBetweenDate(Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant()), Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()));
        HashMap<Integer, SysCalendar> daysAndEvent = new HashMap<Integer, SysCalendar>();
        for (SysCalendar item : sysCalendarList) {
            int time = (int)Duration.between(startTime, item.getStartTime()).toDays();
            daysAndEvent.put(time, item);
        }
        int workDays = 0;
        int weekDays = startTime.getDayOfWeek().getValue();
        for (int i = 0; i < naturalDays; ++i) {
            if (ToolUtil.isNotEmpty(daysAndEvent.get(i))) {
                if ("\u73ed".equals(((SysCalendar)daysAndEvent.get(i)).getTitle())) {
                    ++workDays;
                }
                ++weekDays;
                continue;
            }
            if (weekDays != 6 && weekDays != 7) {
                ++workDays;
            }
            weekDays = ++weekDays > 7 ? 1 : weekDays;
        }
        return workDays;
    }

    public Integer getWorkDaysByMonth(String selectMonth) {
        String year = selectMonth.substring(0, 4);
        String month = selectMonth.substring(5, 7);
        selectMonth = year + "-" + month + "-01 00:00:00";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = LocalDateTime.parse(selectMonth, formatter);
        LocalDateTime endTime = LocalDateTime.of(LocalDate.from(startTime.with(TemporalAdjusters.lastDayOfMonth())), LocalTime.MAX);
        return this.getWorkDays(startTime, endTime);
    }

    public Boolean isWorkDay(LocalDateTime selectDay) {
        boolean result = false;
        LocalDateTime selectDate = LocalDateTime.of(selectDay.toLocalDate(), LocalTime.MIN);
        LambdaQueryWrapper queryCalendar = new LambdaQueryWrapper();
        queryCalendar.eq(SysCalendar::getStartTime, (Object)selectDate);
        SysCalendar sysCalendar = (SysCalendar)this.sysCalendarMapper.selectOne((Wrapper)queryCalendar);
        if (ToolUtil.isNotEmpty((Object)sysCalendar)) {
            if ("\u73ed".equals(sysCalendar.getTitle())) {
                result = true;
            }
        } else {
            int weekDay = selectDate.getDayOfWeek().getValue();
            if (weekDay != 7 && weekDay != 6) {
                result = true;
            }
        }
        return result;
    }
}

