/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.controller;

import com.jxdinfo.hussar.general.calendar.model.SysCalendar;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendarFront"})
@Api(tags={"\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406"})
@HussarTokenDs
public class WorkCalendarFrontController
extends HussarBaseController<SysCalendar, ISysCalendarService> {
    private static final String SAVE_FAIL = "saveFail";
    private static final String SAVE_FAIL1 = "saveFail1";
    @Resource
    private ISysCalendarService sysCalendarService;
    @Resource
    private ISysCalendarRefService sysCalendarRefService;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6", notes="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysCalendar>> eventsList(@ApiParam(value="\u5f00\u59cb\u65f6\u95f4") @RequestParam(value="startTime") String startTime, @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") @RequestParam(value="endTime") String endTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date start = simpleDateFormat.parse(startTime);
        Date end = simpleDateFormat.parse(endTime);
        return ApiResponse.success((Object)this.sysCalendarService.queryEventsBetweenDate(start, end));
    }

    @PostMapping(value={"/addEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u65b0\u589e", notes="\u53ef\u540c\u65f6\u65b0\u589e\u591a\u4e2a\u4e8b\u4ef6")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addEvent(@ApiParam(value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53") @RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.saveEvent(sysCalendar);
    }

    @PostMapping(value={"/addOneEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u65b0\u589e", notes="\u65b0\u589e\u5355\u4e2a\u65e5\u5386\u4e8b\u4ef6")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65b0\u589e\u5355\u65e5\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addOneEvent(@ApiParam(value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53") @RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.saveOneEvent(sysCalendar);
    }

    @PostMapping(value={"/editEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539", notes="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<SysCalendar> editEvent(@ApiParam(value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53") @RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.updateEvent(sysCalendar);
    }

    @GetMapping(value={"/dayEvent"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u5929\u7684\u4e8b\u4ef6", notes="\u67e5\u8be2\u70b9\u51fb\u5f53\u5929\u7684\u4e8b\u4ef6")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5f53\u5929\u7684\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysCalendar> dayEvent(@ApiParam(value="\u5f00\u59cb\u65f6\u95f4") @RequestParam(value="startTime") String startTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date start = simpleDateFormat.parse(startTime);
        return this.sysCalendarService.queryOneEvent(start);
    }

    @PostMapping(value={"/delEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664", notes="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delEvent(@ApiParam(value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53") @RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.deleteEvent(sysCalendar);
    }

    @PostMapping(value={"/delOneEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664", notes="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u5220\u9664\u5355\u4e2a\u65e5\u5386\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delOneEvent(@ApiParam(value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53") @RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.deleteOneEvent(sysCalendar);
    }

    @GetMapping(value={"/getEndDateDefult"})
    @ApiOperation(value="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", notes="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u5f00\u59cb\u65f6\u95f4\u548c\u65f6\u95f4\u957f\u5ea6\u83b7\u53d6\u7ed3\u675f\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<LocalDateTime> getEndDateDefult(@ApiParam(value="\u5f00\u59cb\u65f6\u95f4") @RequestParam(value="startTime") LocalDateTime startTime, @RequestParam(value="timeFrame") String timeFrame, @RequestParam(value="isWorkCalendar") boolean isWorkCalendar) {
        return ApiResponse.success((Object)this.sysCalendarRefService.getEndDateDefult(startTime, timeFrame, isWorkCalendar));
    }

    @GetMapping(value={"/getWorkDays"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570", notes="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u83b7\u53d6\u5de5\u4f5c\u65e5\u5929\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> getWorkDays(@RequestParam(value="startTime") LocalDateTime startTime, @RequestParam(value="endTime") LocalDateTime endTime) {
        return ApiResponse.success((Object)this.sysCalendarRefService.getWorkDays(startTime, endTime));
    }

    @GetMapping(value={"/getWorkDaysByMonth"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570", notes="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6307\u5b9a\u6708\u4efd\u7684\u5de5\u4f5c\u65e5\u5929\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> getWorkDaysByMonth(@ApiParam(value="\u6307\u5b9a\u6708\u4efd") @RequestParam(value="selectMonth") String selectMonth) {
        return ApiResponse.success((Object)this.sysCalendarRefService.getWorkDaysByMonth(selectMonth));
    }

    @GetMapping(value={"/isWorkDay"})
    @ApiOperation(value="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5", notes="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5")
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u5224\u65ad\u6307\u5b9a\u65e5\u671f\u662f\u5426\u662f\u5de5\u4f5c\u65e5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> isWorkDay(@ApiParam(value="\u6307\u5b9a\u65e5\u671f") @RequestParam(value="selectDay") LocalDateTime selectDay) {
        return ApiResponse.success((Object)this.sysCalendarRefService.isWorkDay(selectDay));
    }
}

