/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.migration.DictMigrationPlugin;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DictMigrationDumpVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysDicServiceImpl
implements ISysDicService {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private DictMigrationPlugin dictMigrationPlugin;
    @Resource
    private ISysDicTypeService dicTypeService;
    private String pseudoRootSys = "sys";
    private String pseudoRootBiz = "biz";
    private String pseudoRootDic = "dict";
    private String flagOfExecuteType = "haveType";

    public ApiResponse saveDicGroup(DicGroup dicGroup) {
        Long groupParentId = dicGroup.getParentId();
        String groupName = dicGroup.getGroupDescription();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupParentId, groupName})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (this.checkDicGroupDuplicated(groupParentId, groupName)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicGroup lastOne = (DicGroup)this.dicGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicGroup::getParentId, (Object)groupParentId)).orderByDesc(DicGroup::getSort), false);
        dicGroup.setRangeType(this.pseudoRootDic);
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dicGroup.setSort(Integer.valueOf(3));
        } else {
            dicGroup.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        if (this.dicGroupService.save((Object)dicGroup)) {
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    public ApiResponse updateDictGroup(DicGroup dicGroup) {
        Long groupId = dicGroup.getId();
        String groupName = dicGroup.getGroupDescription();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupId, groupName})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        if (this.checkDicGroupDuplicated(groupId, groupName)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (!this.dicGroupService.saveOrUpdate((Object)dicGroup)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<List<JSTreeModel>> queryExportTreeData() {
        ArrayList<Object> result = new ArrayList<Object>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        result.add(root);
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        List groups = this.dicGroupService.list((Wrapper)new LambdaQueryWrapper().orderByAsc(DicGroup::getSort));
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setType("zidian");
                tempObject.setSeq(group.getSort().toString());
                tempObject.setRangeType(group.getRangeType());
                mapList.add(tempObject);
            }
        }
        result.addAll(mapList);
        result.addAll(this.dicTypeService.dicExportTreeData());
        return ApiResponse.success((Object)TreeModelUtils.merge(result));
    }

    public IPage<DicSingle> queryListSingle(Page page, Long dictTypeId) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)dictTypeId)).orderByAsc(DicSingle::getSort);
        IPage dicSingleIPage = this.sysDicSingleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return dicSingleIPage;
    }

    public IPage<DicSingle> queryListSingle(Page page, String dictTypeId) {
        return this.queryListSingle(page, Long.parseLong(dictTypeId));
    }

    @HussarTransactional
    public ApiResponse updateMoveNode(DicSingleDto singleDto) {
        boolean isUp;
        Long dictId = singleDto.getId();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictId, isUp = singleDto.getIsUp()})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u6392\u5e8f");
        }
        this.dicSingleService.evictTypeCacheBySingleId(dictId);
        DicSingle thisDic = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)thisDic.getTypeId());
        if (null == thisDic.getParentId()) {
            ew.isNull(DicSingle::getParentId);
        } else {
            ew.eq(DicSingle::getParentId, (Object)thisDic.getParentId());
        }
        if (isUp) {
            ((LambdaQueryWrapper)ew.lt(DicSingle::getSort, (Object)thisDic.getSort())).orderByDesc(DicSingle::getSort);
        } else {
            ((LambdaQueryWrapper)ew.gt(DicSingle::getSort, (Object)thisDic.getSort())).orderByAsc(DicSingle::getSort);
        }
        DicSingle thatDic = (DicSingle)this.dicSingleService.getOne((Wrapper)ew, false);
        if (thatDic == null) {
            throw new BaseException("\u6b64\u6761\u76ee\u5df2\u7ecf\u4e3a" + (isUp ? "\u7b2c\u4e00\u6761\uff01" : "\u6700\u540e\u4e00\u6761\uff01"));
        }
        int temp = thisDic.getSort();
        thisDic.setSort(thatDic.getSort());
        thatDic.setSort(Integer.valueOf(temp));
        if (!this.dicSingleService.updateById((Object)thisDic) || !this.dicSingleService.updateById((Object)thatDic)) {
            throw new BaseException("\u4fdd\u5b58\u5b57\u5178\u987a\u5e8f\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(thisDic.getTypeId());
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public IPage<DicSingle> queryListSingle(Page page, String dictTypeId, String parentId) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            queryWrapper.eq(DicSingle::getParentId, (Object)Long.parseLong(parentId));
        } else {
            queryWrapper.isNull(DicSingle::getParentId);
        }
        Long tmpId = 0L;
        if ("child".equalsIgnoreCase(dictTypeId)) {
            tmpId = this.getTypeId(Long.parseLong(parentId));
            ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)tmpId)).orderByAsc(DicSingle::getSort);
        } else {
            ((LambdaQueryWrapper)queryWrapper.eq(DicSingle::getTypeId, (Object)Long.parseLong(dictTypeId))).orderByAsc(DicSingle::getSort);
        }
        IPage dicSingleIPage = this.sysDicSingleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        DicType typeEntity = null;
        typeEntity = "child".equalsIgnoreCase(dictTypeId) ? (DicType)this.dicTypeService.getById((Serializable)tmpId) : (DicType)this.dicTypeService.getById((Serializable)Long.valueOf(Long.parseLong(dictTypeId)));
        if (CollectionUtils.isNotEmpty((Collection)dicSingleIPage.getRecords())) {
            for (DicSingle ds : dicSingleIPage.getRecords()) {
                ds.setTypeName(typeEntity.getTypeName());
                ds.setTypeDesc(typeEntity.getTypeDescription());
            }
        }
        return dicSingleIPage;
    }

    public List<DictMigrationDumpVo> getDictOutSys() {
        ArrayList<DictMigrationDumpVo> dictMigrationDumpVos = new ArrayList<DictMigrationDumpVo>();
        DictMigrationDumpVo root = new DictMigrationDumpVo();
        root.setId(Constants.ROOT_NODE_ID);
        root.setLabel("\u6570\u636e\u5b57\u5178");
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setType(0);
        root.setHasChildren(Boolean.valueOf(false));
        root.setIcon("tree-com");
        dictMigrationDumpVos.add(root);
        List dicGroups = this.dicGroupService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(DicGroup::getRangeType, (Object)"sys")).orderByAsc(DicGroup::getSort));
        if (HussarUtils.isEmpty((Object)dicGroups)) {
            return dictMigrationDumpVos;
        }
        for (DicGroup dicGroup : dicGroups) {
            DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
            dictVo.setId(dicGroup.getId());
            dictVo.setParentId(dicGroup.getParentId());
            dictVo.setType(1);
            dictVo.setLabel(dicGroup.getGroupDescription());
            dictVo.setIcon("zidian");
            dictMigrationDumpVos.add(dictVo);
        }
        List dicTypes = this.dicTypeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(DicType::getRangeType, (Object)"sys")).orderByAsc(DicType::getSort));
        ArrayList<Long> typeIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)dicTypes)) {
            for (Object dicType : dicTypes) {
                DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
                dictVo.setId(dicType.getId());
                dictVo.setType(2);
                dictVo.setParentId(dicType.getParentId());
                dictVo.setLabel(dicType.getTypeDescription());
                dictVo.setValue(dicType.getTypeName());
                dictVo.setIcon("tree-folder");
                typeIds.add(dicType.getId());
                dictMigrationDumpVos.add(dictVo);
            }
        }
        List dicSingles = new ArrayList();
        if (HussarUtils.isNotEmpty(typeIds)) {
            dicSingles = this.dicSingleService.getDicSingleByTypeIds(typeIds, 2);
        }
        if (HussarUtils.isNotEmpty(dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                DictMigrationDumpVo dictVo = new DictMigrationDumpVo();
                dictVo.setId(dicSingle.getId());
                dictVo.setParentId(HussarUtils.isEmpty((Object)dicSingle.getParentId()) ? dicSingle.getTypeId() : dicSingle.getParentId());
                dictVo.setType(3);
                dictVo.setValue(dicSingle.getValue());
                dictVo.setLabel(dicSingle.getLabel());
                dictVo.setIcon("dict");
                dictMigrationDumpVos.add(dictVo);
            }
        }
        List dictTree = HussarTreeParser.getTreeList(dictMigrationDumpVos);
        this.fillDictHasChildren((DictMigrationDumpVo)dictTree.get(0));
        return dictTree;
    }

    public void fillDictHasChildren(DictMigrationDumpVo dictTree) {
        if (HussarUtils.isNotEmpty((Object)dictTree)) {
            List children = dictTree.getChildren();
            if (HussarUtils.isNotEmpty((Object)children)) {
                dictTree.setHasChildren(Boolean.valueOf(true));
                for (DictMigrationDumpVo dictDumpVo : children) {
                    this.fillDictHasChildren(dictDumpVo);
                }
            } else {
                dictTree.setHasChildren(Boolean.valueOf(false));
            }
        }
    }

    @HussarTransactional
    public ApiResponse addDictType(Long parentId, String dictName, String dictTypeCode, String dictValues) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{parentId, dictName, dictTypeCode})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (this.checkDicTypeDuplicated(parentId, dictName, dictTypeCode).equals("TypeNameRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicTypeDuplicated(parentId, dictName, dictTypeCode).equals("TypeDescriptionRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7c7b\u578b\u63cf\u8ff0\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicType lastOne = (DicType)this.dicTypeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicType::getParentId, (Object)parentId)).orderByDesc(DicType::getSort), false);
        DicType dict = new DicType();
        dict.setParentId(parentId);
        dict.setTypeName(dictTypeCode);
        dict.setTypeDescription(dictName);
        DicGroup parentGroup = (DicGroup)this.dicGroupService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getId, (Object)parentId));
        if (ToolUtil.isNotEmpty((Object)parentGroup)) {
            String parentRangeType = parentGroup.getRangeType();
            if (!this.pseudoRootBiz.equals(parentRangeType) && !this.pseudoRootSys.equals(parentRangeType)) {
                dict.setRangeType(String.valueOf(parentId));
            } else {
                dict.setRangeType(parentRangeType);
            }
        } else {
            dict.setRangeType(String.valueOf(parentId));
        }
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dict.setSort(Integer.valueOf(1));
        } else {
            dict.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        if (this.dicTypeService.save((Object)dict)) {
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
    }

    private boolean addDictTypeChildren(Long typeId, String dictValues) {
        if (ToolUtil.isNotEmpty((Object)dictValues)) {
            JSONArray jsonArray = JSON.parseArray((String)dictValues);
            ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                String value = (String)map.get("num");
                String label = (String)map.get("name");
                if (ToolUtil.isOneEmpty((Object[])new Object[]{value, label})) continue;
                DicSingle itemDict = new DicSingle();
                itemDict.setValue(value);
                itemDict.setLabel(label);
                itemDict.setTypeId(typeId);
                itemDict.setSort(Integer.valueOf(i + 1));
                addList.add(itemDict);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                return this.dicSingleService.saveBatch(addList);
            }
        }
        return false;
    }

    public void editDict(Long dictTypeId, String dictName, String dictTypeCode, String dictValues) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        if (this.checkDicTypeDuplicated(dictTypeId, dictName, dictTypeCode).equals("TypeNameRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicTypeDuplicated(dictTypeId, dictName, dictTypeCode).equals("TypeDescriptionRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u7c7b\u578b\u63cf\u8ff0\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicSingle finder = new DicSingle();
        finder.setTypeId(dictTypeId);
        this.dicSingleService.remove((Wrapper)new QueryWrapper((Object)finder));
        this.addDictTypeChildren(dictTypeId, dictValues);
        DicType type = (DicType)this.dicTypeService.getById((Serializable)dictTypeId);
        type.setTypeName(dictTypeCode);
        type.setTypeDescription(dictName);
        this.dicTypeService.updateById((Object)type);
    }

    @HussarTransactional
    public ApiResponse updateNewDict(DicDto dicDto) {
        String info = dicDto.getInfo();
        String dictValues = dicDto.getDictValues();
        String delIdString = dicDto.getDelIdString();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dicDto.getDictId(), dicDto.getDictName(), dicDto.getDictTypeCode()})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        Long dictId = dicDto.getDictId();
        String dictName = dicDto.getDictName();
        String dictTypeCode = dicDto.getDictTypeCode();
        String flag = dicDto.getFlag();
        List list = (List)JSON.parse((String)delIdString);
        if (ToolUtil.isNotEmpty((Object)list)) {
            this.dicSingleService.removeByIds((Collection)list);
        }
        if (this.flagOfExecuteType.equals(flag)) {
            DicType dicType = new DicType();
            dicType.setTypeName(dictTypeCode);
            dicType.setTypeDescription(dictName);
            DicType type = (DicType)this.dicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getId, (Object)dictId), false);
            Long id = type.getId();
            if (this.checkDicTypeDuplicated(id, dictName, dictTypeCode).equals("TypeNameRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728\uff01\uff09");
            }
            if (this.checkDicTypeDuplicated(id, dictName, dictTypeCode).equals("TypeDescriptionRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u7c7b\u578b\u63cf\u8ff0\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.dicTypeService.update((Object)dicType, (Wrapper)new LambdaQueryWrapper().eq(DicType::getId, (Object)dictId));
        } else {
            DicSingle dicSingle = new DicSingle();
            dicSingle.setValue(dictTypeCode);
            dicSingle.setLabel(dictName);
            DicSingle single = (DicSingle)this.dicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId), false);
            Long typeId = single.getTypeId();
            Long parentId = single.getParentId();
            if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictTypeCode, parentId).equals("LabelRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
            }
            if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictTypeCode, parentId).equals("ValueRepeat")) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.dicSingleService.update((Object)dicSingle, (Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId));
        }
        JSONArray jsonArray = JSON.parseArray((String)dictValues);
        ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
        ArrayList<DicSingle> updateList = new ArrayList<DicSingle>();
        if (ToolUtil.isNotEmpty((Object)jsonArray)) {
            int arr = 1;
            DicSingle lastOne = new DicSingle();
            lastOne = this.flagOfExecuteType.equals(flag) ? (DicSingle)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false) : (DicSingle)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false);
            if (ToolUtil.isNotEmpty((Object)lastOne)) {
                arr = lastOne.getSort() + 1;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                DicSingle dicSingle = new DicSingle();
                dicSingle.setValue((String)map.get("num"));
                dicSingle.setLabel((String)map.get("name"));
                dicSingle.setTypeId(dictId);
                if (!this.flagOfExecuteType.equals(flag)) {
                    dicSingle.setParentId(dictId);
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    dicSingle.setSort(Integer.valueOf(arr++));
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    addList.add(dicSingle);
                    continue;
                }
                dicSingle.setId(Long.valueOf((String)map.get("id")));
                updateList.add(dicSingle);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.dicSingleService.saveBatch(addList);
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                this.dicSingleService.updateBatchById(updateList);
            }
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public List<Map<String, Object>> dicTypeTreeData() {
        List dicChilds;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (types != null && types.size() > 0) {
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                tempObject.put("id", type.getId());
                tempObject.put("parent", type.getParentId());
                tempObject.put("text", type.getTypeDescription());
                tempObject.put("type", "type");
                tempObject.put("rangeType", rangeType);
                tempObject.put("typeName", typeName);
                mapList.add(tempObject);
                List dics = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)type.getId())).orderByAsc((Object)"SORT"));
                if (dics == null || dics.size() <= 0) continue;
                for (DicSingle dic : dics) {
                    tempObject = new HashMap(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    tempObject.put("rangeType", rangeType);
                    tempObject.put("typeName", typeName);
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                tempObject.put("id", dicChild.getId());
                tempObject.put("parent", dicChild.getParentId());
                tempObject.put("text", dicChild.getLabel());
                tempObject.put("type", "dic");
                tempObject.put("rangeType", "child");
                tempObject.put("typeName", "child");
                mapList.add(tempObject);
            }
        }
        return mapList;
    }

    public List<Map<String, Object>> dicOrderTreeData(Long typeId) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (pDic != null) {
            HashMap<String, Object> parent = new HashMap<String, Object>(10);
            parent.put("id", pDic.getId());
            parent.put("parent", Constants.ROOT_NODE_PARENT);
            parent.put("text", pDic.getTypeDescription());
            parent.put("type", "type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    HashMap<String, Object> tempObject = new HashMap<String, Object>(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    mapList.add(tempObject);
                }
            }
        }
        return mapList;
    }

    public ApiResponse updateDicOrder(String orderInfo) {
        DicSingle dicSingle;
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u6392\u5e8f\u5931\u8d25");
        }
        JSONArray arr = JSON.parseArray((String)orderInfo);
        List longList = arr.toJavaList(Long.class);
        Long[] orderInfoArr = longList.toArray(new Long[arr.size()]);
        DicSingle dic = null;
        ArrayList<DicSingle> listOfSingle = new ArrayList<DicSingle>();
        for (int i = 0; i < orderInfoArr.length; ++i) {
            Long id = orderInfoArr[i];
            dic = new DicSingle();
            dic.setId(id);
            dic.setSort(Integer.valueOf(i + 1));
            listOfSingle.add(dic);
        }
        if (ToolUtil.isNotEmpty(dic) && ToolUtil.isNotEmpty((Object)(dicSingle = (DicSingle)this.dicSingleService.getById((Serializable)dic.getId())))) {
            this.dicTypeService.evictTypeCacheById(dicSingle.getTypeId());
        }
        if (ToolUtil.isNotEmpty(listOfSingle)) {
            if (this.dicSingleService.updateBatchById(listOfSingle)) {
                return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
            }
            throw new BaseException("\u6392\u5e8f\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    public ApiResponse saveDicSingle(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, null).equals("LabelRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, null).equals("ValueRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        DicSingle dic = new DicSingle();
        DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).orderByDesc(DicSingle::getSort), false);
        dic.setTypeId(dictTypeId);
        dic.setLabel(dictName);
        dic.setValue(dictValue);
        dic.setIsEnabled(Integer.valueOf(1));
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dic.setSort(Integer.valueOf(1));
        } else {
            dic.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dic);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse updateDicSingle(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        DicSingle single = (DicSingle)this.dicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)dictId), false);
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)single)) {
            parentId = single.getParentId();
        }
        this.checkDicTypeRange(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, parentId).equals("LabelRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue, parentId).equals("ValueRepeat")) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539");
        }
        DicSingle dic = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
        dic.setLabel(dictName);
        dic.setValue(dictValue);
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dic);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public void deleteType(Long id) {
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (id != null && this.dicTypeService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0 && this.dicTypeService.removeById((Serializable)id)) {
            this.dicTypeService.evictTypeCacheById(id);
        }
        if (id != null && this.dicSingleService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0) {
            this.dicSingleService.removeById((Serializable)id);
        }
    }

    @HussarTransactional
    public ApiResponse deleteCascadeDict(String[] ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        ArrayList<Long> listOfGroup = new ArrayList<Long>();
        ArrayList<Long> listOfType = new ArrayList<Long>();
        ArrayList<Long> listOfSingle = new ArrayList<Long>();
        List<String> idList = Arrays.asList(ids);
        if (ToolUtil.isNotEmpty(idList)) {
            List idListL = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            List dicGroupList = this.dicGroupService.list((Wrapper)new LambdaQueryWrapper().in(DicGroup::getId, idListL));
            List dicTypeList = null;
            dicTypeList = com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dicGroupList) ? this.dicTypeService.list((Wrapper)new LambdaQueryWrapper().in(DicType::getParentId, (Collection)dicGroupList.stream().map(DicGroup::getId).collect(Collectors.toList()))) : this.dicTypeService.list((Wrapper)new LambdaQueryWrapper().in(DicType::getId, idListL));
            List dicSingleList = null;
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)dicTypeList)) {
                dicSingleList = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().in(DicSingle::getTypeId, (Collection)dicTypeList.stream().map(DicType::getId).collect(Collectors.toList())));
            } else {
                dicSingleList = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper().in(DicSingle::getId, idListL));
                if (CollectionUtils.isNotEmpty((Collection)dicSingleList)) {
                    this.putDictSingleChildren(dicSingleList, idList.stream().map(Long::parseLong).collect(Collectors.toList()));
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicGroupList)) {
                for (DicGroup dicGroup : dicGroupList) {
                    listOfGroup.add(dicGroup.getId());
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicTypeList)) {
                for (DicType dicType : dicTypeList) {
                    listOfType.add(dicType.getId());
                    this.dicTypeService.evictTypeCacheById(dicType.getId());
                }
            }
            if (ToolUtil.isNotEmpty((Object)dicSingleList)) {
                for (DicSingle dicSingle : dicSingleList) {
                    listOfSingle.add(dicSingle.getId());
                }
            }
        }
        boolean dicGroupFlag = false;
        boolean dictTypeFlag = false;
        boolean dictSingleFlag = false;
        if (ToolUtil.isNotEmpty(listOfGroup)) {
            dicGroupFlag = this.dicGroupService.removeByIds(listOfGroup);
        }
        if (ToolUtil.isNotEmpty(listOfType)) {
            dictTypeFlag = this.dicTypeService.removeByIds(listOfType);
        }
        if (ToolUtil.isNotEmpty(listOfSingle)) {
            dictSingleFlag = this.dicSingleService.removeByIds(listOfSingle);
        }
        if (dicGroupFlag || dictTypeFlag || dictSingleFlag) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    private void putDictSingleChildren(List<DicSingle> dicSingleList, List<Long> idList) {
        for (Long id : idList) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id);
            List list = this.dicSingleService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            dicSingleList.addAll(list);
            this.putDictSingleChildren(dicSingleList, list.stream().map(DicSingle::getId).collect(Collectors.toList()));
        }
    }

    private Long getTypeId(Long typeId) {
        DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getId, (Object)typeId)).orderByDesc(DicSingle::getSort), false);
        if (null == lastOne.getParentId()) {
            return lastOne.getTypeId();
        }
        return this.getTypeId(lastOne.getParentId());
    }

    public ApiResponse saveSingleChild(Long dictId, Long dictTypeId, String dictName, String dictValue) {
        DicSingle dicSingle;
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u65b0\u589e");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        Long typeId = this.getTypeId(dictTypeId);
        if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictValue, dictTypeId).equals("LabelRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (this.checkDicSingleDuplicated(dictId, typeId, dictName, dictValue, dictTypeId).equals("ValueRepeat")) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u7c7b\u578b\u4e0b\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\uff01\uff09");
        }
        if (ToolUtil.isEmpty((Object)dictId)) {
            DicSingle lastOne = (DicSingle)this.dicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)dictTypeId)).orderByDesc(DicSingle::getSort), false);
            dicSingle = new DicSingle();
            dicSingle.setTypeId(typeId);
            dicSingle.setParentId(dictTypeId);
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
            if (ToolUtil.isEmpty((Object)lastOne)) {
                dicSingle.setSort(Integer.valueOf(1));
            } else {
                dicSingle.setSort(Integer.valueOf(lastOne.getSort() + 1));
            }
        } else {
            dicSingle = (DicSingle)this.dicSingleService.getById((Serializable)dictId);
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dicSingle);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.dicTypeService.evictTypeCacheById(dicSingle.getTypeId());
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    private void checkDicTypeRange(Long typeId) {
        DicType parent = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (!ToolUtil.isNotEmpty((Object)parent)) {
            throw new BaseException("\u7c7b\u578b\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        this.checkRangeType(parent.getRangeType());
    }

    private void checkRangeType(String rangeType) {
        if (this.pseudoRootSys.equals(rangeType)) {
            throw new BaseException("\u5b57\u5178\u4e1a\u52a1\u7c7b\u578b\u4e3asys");
        }
    }

    private String checkDicTypeDuplicated(Long id, String dictName, String dictTypeCode) {
        Wrapper finderCode = (Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)dictTypeCode);
        List resCode = this.dicTypeService.list(finderCode);
        if (resCode.size() > 1 || resCode.size() == 1 && !((DicType)resCode.get(0)).getId().equals(id)) {
            return "TypeNameRepeat";
        }
        Wrapper finderDescription = (Wrapper)new QueryWrapper().eq((Object)"TYPE_DESCRIPTION", (Object)dictName);
        List resDescription = this.dicTypeService.list(finderDescription);
        if (resDescription.size() > 1 || resDescription.size() == 1 && !((DicType)resDescription.get(0)).getId().equals(id)) {
            return "TypeDescriptionRepeat";
        }
        return "";
    }

    private String checkDicSingleDuplicated(Long dictId, Long dictTypeId, String dictName, String dictValue, Long parentId) {
        LambdaQueryWrapper finderL = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).eq(DicSingle::getLabel, (Object)dictName);
        if (HussarUtils.isNotEmpty((Object)parentId)) {
            finderL.eq(DicSingle::getParentId, (Object)parentId);
        } else {
            finderL.isNull(DicSingle::getParentId);
        }
        List resL = this.dicSingleService.list((Wrapper)finderL);
        if (resL.size() > 1 || resL.size() == 1 && !((DicSingle)resL.get(0)).getId().equals(dictId)) {
            return "LabelRepeat";
        }
        LambdaQueryWrapper finderV = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dictTypeId)).eq(DicSingle::getValue, (Object)dictValue);
        List resV = this.dicSingleService.list((Wrapper)finderV);
        if (resV.size() > 1 || resV.size() == 1 && !HussarUtils.equals((Object)dictId, (Object)((DicSingle)resV.get(0)).getId())) {
            return "ValueRepeat";
        }
        return "";
    }

    private boolean checkDicGroupDuplicated(Long groupParentId, String groupName) {
        boolean flag = false;
        Wrapper finderL = (Wrapper)new LambdaQueryWrapper().eq(DicGroup::getGroupDescription, (Object)groupName);
        List resL = this.dicGroupService.list(finderL);
        if (resL.size() > 1 || resL.size() == 1 && !((DicGroup)resL.get(0)).getId().equals(groupParentId)) {
            flag = true;
        }
        return flag;
    }
}

