/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.general.attachment.dto.MobileAttachmentDto;
import com.jxdinfo.hussar.general.attachment.dto.SysFileInfoDto;
import com.jxdinfo.hussar.general.attachment.properties.AttachmentProperties;
import com.jxdinfo.hussar.general.attachment.service.ISysAttachmentService;
import com.jxdinfo.hussar.general.attachment.util.SysAttachmentUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.plugin.attachment.customize.model.AttachmentSizeModel;
import com.jxdinfo.hussar.support.oss.plugin.attachment.customize.service.ICustomizeAttachmentManagerService;
import com.jxdinfo.hussar.support.oss.plugin.attachment.customize.vo.AttachmentInfoVo;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class SysAttachmentServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements ISysAttachmentService {
    @Autowired
    private AttachmentProperties attachmentProperties;
    @Resource
    private ICustomizeAttachmentManagerService iCustomizeAttachmentManagerService;
    private static final Logger logger = LoggerFactory.getLogger(SysAttachmentServiceImpl.class);

    public boolean attachmentTypeVerify(MultipartHttpServletRequest multipartRequest, List<String> attachmentTypes) throws UnsupportedEncodingException {
        if (this.attachmentProperties.getUploadFileTypeCheck().booleanValue()) {
            if (HussarUtils.isNotEmpty((Object)this.attachmentProperties.getSupportFileTypes())) {
                AttachmentProperties newAttachmentProperties = new AttachmentProperties();
                newAttachmentProperties.setOssType(this.attachmentProperties.getOssType());
                newAttachmentProperties.setUploadFileTypeCheck(this.attachmentProperties.getUploadFileTypeCheck());
                HashSet<String> temp = new HashSet<String>();
                for (Iterator supportFileType : this.attachmentProperties.getSupportFileTypes()) {
                    temp.add((String)((Object)supportFileType));
                }
                ArrayList<String> removedTypes = new ArrayList<String>();
                if (HussarUtils.isNotEmpty(attachmentTypes)) {
                    for (String attachmentType : attachmentTypes) {
                        if (temp.contains(attachmentType)) continue;
                        removedTypes.add(attachmentType);
                    }
                    for (String removedType : removedTypes) {
                        attachmentTypes.remove(removedType);
                    }
                    newAttachmentProperties.setSupportFileTypes(attachmentTypes);
                } else {
                    newAttachmentProperties.setSupportFileTypes(this.attachmentProperties.getSupportFileTypes());
                }
                if (HussarUtils.isEmpty((Object)multipartRequest)) {
                    return false;
                }
                multipartRequest.setCharacterEncoding("UTF-8");
                MultipartFile multipartFile = null;
                Map map = multipartRequest.getFileMap();
                Iterator var6 = map.values().iterator();
                while (var6.hasNext()) {
                    MultipartFile value;
                    multipartFile = value = (MultipartFile)var6.next();
                }
                if (HussarUtils.isNotEmpty(multipartFile)) {
                    return SysAttachmentUtil.checkFileType(multipartFile, newAttachmentProperties);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public List<SysFileInfoDto> fileQuery(String businessId) {
        return null;
    }

    public List<AttachmentInfoVo> fileQuerys(List<String> fileIds) {
        List fileInfoDtos = this.iCustomizeAttachmentManagerService.fileQuerys(fileIds);
        return fileInfoDtos;
    }

    public List<SysFileInfoDto> fileQueryBySaveId(String saveId) {
        List attachmentSizeModels = this.iCustomizeAttachmentManagerService.listBySaveId(saveId);
        if (HussarUtils.isEmpty((Object)attachmentSizeModels)) {
            return new ArrayList<SysFileInfoDto>();
        }
        List fileIds = attachmentSizeModels.stream().filter(a -> !HussarUtils.isNull((Object)a.getFileId())).map(attachmentSizeModel -> String.valueOf(attachmentSizeModel.getFileId())).collect(Collectors.toList());
        if (HussarUtils.isEmpty(fileIds)) {
            return new ArrayList<SysFileInfoDto>();
        }
        List modelList = this.listByIds(fileIds);
        if (HussarUtils.isEmpty((Object)modelList)) {
            return new ArrayList<SysFileInfoDto>();
        }
        List<SysFileInfoDto> sysFileInfoDtos = modelList.stream().map(m -> {
            SysFileInfoDto dto = new SysFileInfoDto();
            BeanUtil.copyProperties((Object)m, (Object)dto);
            return dto;
        }).collect(Collectors.toList());
        for (SysFileInfoDto sysFileInfoDto : sysFileInfoDtos) {
            for (AttachmentSizeModel attachmentSizeModel2 : attachmentSizeModels) {
                if (!sysFileInfoDto.getId().equals(attachmentSizeModel2.getFileId())) continue;
                sysFileInfoDto.setFileSize(attachmentSizeModel2.getBytes());
                sysFileInfoDto.setUploadPerName(attachmentSizeModel2.getUploadPerName());
                sysFileInfoDto.setSaveId(attachmentSizeModel2.getSaveId());
            }
        }
        return sysFileInfoDtos;
    }

    public ApiResponse saveMobileUpload(MobileAttachmentDto mobileAttachmentDto) {
        ArrayList<AttachmentManagerModel> attachmentList = new ArrayList<AttachmentManagerModel>();
        List fileIds = mobileAttachmentDto.getFileIds();
        String businessId = mobileAttachmentDto.getBusinessId();
        for (String fileId : fileIds) {
            AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
            attachmentManagerModel.setId(Long.valueOf(fileId));
            attachmentManagerModel.setBusinessId(Long.valueOf(businessId));
            attachmentList.add(attachmentManagerModel);
        }
        this.updateBatchById(attachmentList);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.isNull(AttachmentManagerModel::getBusinessId);
        this.remove((Wrapper)wrapper);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public ApiResponse saveMobileUploadWithSaveId(String saveId, List<String> fileIds) {
        ArrayList<AttachmentSizeModel> attachmentList;
        logger.info("\u79fb\u52a8\u7aef\u4fdd\u5b58\u5f00\u59cb");
        List attachmentSizeModelList = this.iCustomizeAttachmentManagerService.listBySaveId(saveId);
        if (HussarUtils.isNotEmpty((Object)attachmentSizeModelList)) {
            logger.info("\u5220\u9664\u5df2\u6709\u6570\u636e");
            attachmentList = new ArrayList();
            if (HussarUtils.isEmpty(fileIds)) {
                for (Object attachmentSizeModel : attachmentSizeModelList) {
                    AttachmentSizeModel attachmentSize = new AttachmentSizeModel();
                    attachmentSize.setFileId(attachmentSizeModel.getFileId());
                    attachmentSize.setSaveId(null);
                    attachmentList.add(attachmentSize);
                }
                this.iCustomizeAttachmentManagerService.updateBatchBySaveId(attachmentList);
            } else {
                List deleteList = attachmentSizeModelList.stream().filter(a -> !fileIds.contains(String.valueOf(a.getFileId()))).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)deleteList)) {
                    for (AttachmentSizeModel attachmentSizeModel : deleteList) {
                        AttachmentSizeModel attachmentSize = new AttachmentSizeModel();
                        attachmentSize.setFileId(attachmentSizeModel.getFileId());
                        attachmentSize.setSaveId(null);
                        attachmentList.add(attachmentSize);
                    }
                    this.iCustomizeAttachmentManagerService.updateBatchBySaveId(attachmentList);
                }
            }
        }
        attachmentList = new ArrayList<AttachmentSizeModel>();
        for (String fileId : fileIds) {
            AttachmentSizeModel attachmentSizeModel;
            attachmentSizeModel = new AttachmentSizeModel();
            attachmentSizeModel.setFileId(Long.valueOf(fileId));
            attachmentSizeModel.setSaveId(saveId);
            attachmentList.add(attachmentSizeModel);
        }
        logger.info("\u66f4\u65b0FILE_SIZE\u8868\uff0c\u4fdd\u5b58SaveId");
        this.iCustomizeAttachmentManagerService.updateBatchBySaveId(attachmentList);
        List attachmentSizeModels = this.iCustomizeAttachmentManagerService.listNoSaveId();
        logger.info("\u79fb\u52a8\u7aef\u4e0a\u4f20\u7684\u9644\u4ef6\uff1a" + attachmentSizeModels.size());
        for (AttachmentSizeModel attachmentSizeModel : attachmentSizeModels) {
            AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
            attachmentManagerModel.setId(attachmentSizeModel.getFileId());
            this.iCustomizeAttachmentManagerService.removeBySaveId(attachmentSizeModel);
        }
        logger.info("\u79fb\u52a8\u7aef\u4fdd\u5b58\u7ed3\u675f");
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public ApiResponse fileDeleteByFileId(String fileId) {
        boolean resultSize = this.iCustomizeAttachmentManagerService.deleteByFileId(fileId);
        boolean resultFile = this.removeById((Serializable)((Object)fileId));
        return ApiResponse.success((Object)(resultFile && resultSize ? 1 : 0));
    }
}

