/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.IdGenerator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static Map<String, String> HUSSAR_TOKEN = null;

    public static String httpPostFileByClient(Map<String, String> urlMap, Map<String, MultipartFile> fileMap, Map<String, String> authParamMap, Map<String, String> authHeaderMap, Map<String, Object> paramMap) {
        String resultString;
        String hussarToken = HttpClientUtil.getHussarToken(authParamMap, authHeaderMap, urlMap.get("getTokenUrl"));
        if (HussarUtils.isEmpty((Object)hussarToken)) {
            throw new RuntimeException("\u8fde\u63a5\u5ba1\u6279\u4e2d\u5fc3\u5931\u8d25");
        }
        File tempFile = null;
        String tempDir = System.getProperty("java.io.tmpdir");
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(urlMap.get("approvalCenterUrl"));
        CloseableHttpResponse httpResponse = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Consts.UTF_8);
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            for (Map.Entry<String, MultipartFile> entry : fileMap.entrySet()) {
                MultipartFile multipartFile = entry.getValue();
                tempFile = new File(tempDir + (multipartFile.getOriginalFilename() != null ? multipartFile.getOriginalFilename() : IdGenerator.getId()));
                multipartFile.transferTo(tempFile);
                builder.addBinaryBody(HussarSecurityUtils.getLoginUserDetails().getUserName(), tempFile);
            }
            if (HussarUtils.isNotEmpty(paramMap)) {
                paramMap.forEach((k, v) -> builder.addTextBody(k, String.valueOf(v)));
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            httpPost.setHeader("Authorization", hussarToken);
            httpPost.setHeader("Client-Id", authHeaderMap.get("client-id"));
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = httpResponse.getEntity();
            resultString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = (JSONObject)JSONArray.parse((String)resultString);
            String msg = jsonObject.getString("msg");
            if (msg.contains("\u65e0\u6548")) {
                HttpClientUtil.requestHussarToken(authParamMap, authHeaderMap, urlMap.get("getTokenUrl"));
                HttpClientUtil.httpPostFileByClient(urlMap, fileMap, authParamMap, authHeaderMap, paramMap);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                tempFile.delete();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultString;
    }

    public static String httpGetFileByClient(Map<String, String> urlMap, Map<String, String> authParamMap, Map<String, String> authHeaderMap, HttpServletResponse response) {
        String resultString = "";
        String hussarToken = HttpClientUtil.getHussarToken(authParamMap, authHeaderMap, urlMap.get("getTokenUrl"));
        if (HussarUtils.isEmpty((Object)hussarToken)) {
            throw new RuntimeException("\u8fde\u63a5\u5ba1\u6279\u4e2d\u5fc3\u5931\u8d25");
        }
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(urlMap.get("approvalCenterUrl"));
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        try {
            httpGet.setHeader("Authorization", hussarToken);
            httpGet.setHeader("Client-Id", authHeaderMap.get("client-id"));
            CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (!HussarUtils.isNull((Object)response)) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(bytes);
                outputStream.close();
            } else {
                HttpEntity responseEntity = httpResponse.getEntity();
                resultString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultString;
    }

    public static String getHussarToken(Map<String, String> authParamMap, Map<String, String> authHeaderMap, String getTokenUrl) {
        if (HussarUtils.isNotEmpty(HUSSAR_TOKEN)) {
            logger.info("\u901a\u8fc7\u7f13\u5b58\u83b7\u53d6token");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            logger.info("\u5230\u671f\u65f6\u95f4timeInMillis" + timeInMillis);
            String validTime = HUSSAR_TOKEN.get("validTime");
            logger.info("\u6709\u6548\u65f6\u95f4validTime" + validTime);
            return validTime != null && timeInMillis < Long.parseLong(validTime) ? HUSSAR_TOKEN.get("client-token") : HttpClientUtil.requestHussarToken(authParamMap, authHeaderMap, getTokenUrl);
        }
        return HttpClientUtil.requestHussarToken(authParamMap, authHeaderMap, getTokenUrl);
    }

    public static String requestHussarToken(Map<String, String> authParamMap, Map<String, String> authHeaderMap, String getTokenUrl) {
        Map cacheToken = null;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(getTokenUrl);
            if (HussarUtils.isNotEmpty(authParamMap)) {
                for (Map.Entry<String, String> entry : authParamMap.entrySet()) {
                    builder.setParameter(entry.getKey(), entry.getValue());
                }
            }
            HttpGet httpGet = new HttpGet(builder.toString());
            if (HussarUtils.isNotEmpty(authHeaderMap)) {
                for (Map.Entry<String, String> entry : authHeaderMap.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = closeableHttpClient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode() == 200) {
                String resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                JSONObject jSONObject = (JSONObject)JSONArray.parse((String)resultString);
                logger.info("\u83b7\u53d6token\u7684\u8fd4\u56de\u503c\uff1a" + jSONObject);
                cacheToken = (Map)jSONObject.getJSONObject("data").toJavaObject(Map.class);
                Calendar calendar = Calendar.getInstance();
                logger.info("\u8fc7\u671f\u65f6\u95f4\u95f4\u9694\uff1a" + String.valueOf(cacheToken.get("expires-in")));
                String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(String.valueOf(cacheToken.get("expires-in"))));
                cacheToken.put("validTime", timeInMillis);
                logger.info("\u91cd\u65b0\u8bbe\u7f6e\u7684\u8d85\u671f\u65f6\u95f4\uff1a" + timeInMillis);
                HUSSAR_TOKEN = cacheToken;
            }
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237\u7aef\u8ba4\u8bc1\u83b7\u53d6token\u5931\u8d25");
            throw new RuntimeException(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return (String)cacheToken.get("client-token");
    }

    public static String httpPostDeleteFileByClient(Map<String, String> urlMap, Map<String, String> authParamMap, Map<String, String> authHeaderMap, Map<String, String> paramMap) {
        String resultString;
        String hussarToken = HttpClientUtil.getHussarToken(authParamMap, authHeaderMap, urlMap.get("getTokenUrl"));
        if (HussarUtils.isEmpty((Object)hussarToken)) {
            throw new RuntimeException("\u8fde\u63a5\u5ba1\u6279\u4e2d\u5fc3\u5931\u8d25");
        }
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(urlMap.get("approvalCenterUrl"));
        CloseableHttpResponse httpResponse = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        try {
            if (HussarUtils.isNotEmpty(paramMap)) {
                httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(paramMap), StandardCharsets.UTF_8));
            }
            httpPost.setHeader("Authorization", hussarToken);
            httpPost.setHeader("Client-Id", authHeaderMap.get("client-id"));
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = httpResponse.getEntity();
            resultString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return resultString;
    }
}

