/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.calendar.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.calendar.dao.SysCalendarMapper;
import com.jxdinfo.hussar.general.calendar.model.SysCalendar;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysCalendarServiceImpl
extends HussarServiceImpl<SysCalendarMapper, SysCalendar>
implements ISysCalendarService {
    @Resource
    private SysCalendarMapper sysCalendarMapper;

    public List<SysCalendar> getEventsList() {
        return this.sysCalendarMapper.getEventsList();
    }

    public List<SysCalendar> queryEventsBetweenDate(Date startTime, Date endTime) {
        return this.sysCalendarMapper.getEventsBetweenDate(startTime, endTime);
    }

    @HussarTransactional
    public ApiResponse saveEvent(SysCalendar sysCalendar) {
        List<SysCalendar> calendarList = this.queryEventsBetweenDate(Date.from(sysCalendar.getStartTime().atZone(ZoneId.systemDefault()).toInstant()), Date.from(sysCalendar.getEndTime().atZone(ZoneId.systemDefault()).toInstant()));
        if (ToolUtil.isNotEmpty(calendarList)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        List<Date> list = this.getBetweenDates(Date.from(sysCalendar.getStartTime().atZone(ZoneId.systemDefault()).toInstant()), Date.from(sysCalendar.getEndTime().atZone(ZoneId.systemDefault()).toInstant()));
        if (list.size() > 31) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u65b0\u589e\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708\uff09");
        }
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setStartTime(start.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isEmpty(sysCalendarList)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (!this.saveBatch(sysCalendarList, sysCalendarList.size())) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public ApiResponse saveOneEvent(SysCalendar sysCalendar) {
        if (this.checkHaveEventForAddOne(sysCalendar)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        if (!this.save((BaseEntity)sysCalendar)) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public boolean checkHaveEventForAddOne(SysCalendar sysCalendar) {
        boolean flag = false;
        QueryWrapper sysCalendarQueryWrapper = new QueryWrapper();
        List sysCalendarList = this.list((Wrapper)sysCalendarQueryWrapper);
        List SysCalendarForOne = sysCalendarList.stream().filter(o -> o.getStartTime().isEqual(sysCalendar.getStartTime()) && o.getEndTime() == null).collect(Collectors.toList());
        List SysCalendarForList = sysCalendarList.stream().filter(o -> ToolUtil.isNotEmpty((Object)o.getEndTime())).collect(Collectors.toList());
        SysCalendarForList = SysCalendarForList.stream().filter(o -> o.getStartTime().isBefore(sysCalendar.getStartTime()) && o.getEndTime().isAfter(sysCalendar.getStartTime()) || o.getStartTime().isEqual(sysCalendar.getStartTime()) || o.getEndTime().isEqual(sysCalendar.getStartTime())).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(SysCalendarForOne) || ToolUtil.isNotEmpty(SysCalendarForList)) {
            flag = true;
        }
        return flag;
    }

    public ApiResponse<SysCalendar> updateEvent(SysCalendar sysCalendar) {
        if (!this.updateById((BaseEntity)sysCalendar)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<SysCalendar> queryOneEvent(Date start) {
        SysCalendar sysCalendar = (SysCalendar)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysCalendar::getStartTime, (Object)start));
        return ApiResponse.success((Object)sysCalendar);
    }

    public ApiResponse deleteEvent(SysCalendar sysCalendar) {
        List sysCalendarList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(SysCalendar::getStartTime, (Object)sysCalendar.getStartTime())).le(SysCalendar::getStartTime, (Object)sysCalendar.getEndTime())).in(SysCalendar::getClassName, new Object[]{sysCalendar.getClassName()}));
        if (sysCalendarList.size() == 0) {
            throw new BaseException("\u8be5\u65f6\u95f4\u6bb5\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u4e8b\u4ef6\uff01");
        }
        boolean flag = this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(SysCalendar::getStartTime, (Object)sysCalendar.getStartTime())).le(SysCalendar::getStartTime, (Object)sysCalendar.getEndTime())).in(SysCalendar::getClassName, new Object[]{sysCalendar.getClassName()}));
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse deleteOneEvent(SysCalendar sysCalendar) {
        if (!this.removeById(sysCalendar.getId())) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        Date newStartDate = startDate;
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(newStartDate);
        while (newStartDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            newStartDate = tempStart.getTime();
        }
        return result;
    }
}

