/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.general.attachment.dto.AttachmentWithSaveIdDto;
import com.jxdinfo.hussar.general.attachment.dto.MobileAttachmentDto;
import com.jxdinfo.hussar.general.attachment.dto.SysFileInfoDto;
import com.jxdinfo.hussar.general.attachment.properties.SysAttachmentProperties;
import com.jxdinfo.hussar.general.attachment.service.ISysAttachmentService;
import com.jxdinfo.hussar.general.attachment.util.HttpClientUtil;
import com.jxdinfo.hussar.general.attachment.util.SysAttachmentUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.plugin.attachment.customize.service.ICustomizeAttachmentManagerService;
import com.jxdinfo.hussar.support.oss.plugin.attachment.customize.vo.AttachmentInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"\u9644\u4ef6\u4e0a\u4f20"})
@RequestMapping(value={"/file/attachment"})
public class SysAttachmentController {
    @Autowired
    private ICustomizeAttachmentManagerService iCustomizeAttachmentManagerService;
    @Autowired
    private ISysAttachmentService sysAttachmentService;
    @Resource
    private SysAttachmentProperties sysAttachmentProperties;

    @ApiOperation(value="\u591a\u6587\u4ef6\u4e0a\u4f20", notes="\u53ef\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartRequest", value="\u591a\u6587\u4ef6", required=true, paramType="body"), @ApiImplicitParam(name="attachmentType", value="\u8282\u70b9\u914d\u7f6e\u7684\u9644\u4ef6\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="isWeb", value="\u662f\u5426\u4e3aweb\u7aef\u4e0a\u4f20", required=false, paramType="query"), @ApiImplicitParam(name="businessId", value="\u4e1a\u52a1ID", required=false, paramType="query")})
    @PostMapping(value={"/uploadfilewithdrag"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u591a\u6587\u4ef6\u4e0a\u4f20", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest, String attachmentType, boolean isWeb, String businessId) throws Exception {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            List<Object> attachmentTypes = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)attachmentType)) {
                attachmentTypes = SysAttachmentUtil.paseString(attachmentType);
            }
            if (!this.sysAttachmentService.attachmentTypeVerify(multipartRequest, attachmentTypes)) {
                return ApiResponse.fail((String)"\u4e0d\u80fd\u4e0a\u4f20\u5f53\u524d\u7c7b\u578b\u7684\u9644\u4ef6");
            }
            if (HussarUtils.isNotEmpty((Object)isWeb) && HussarUtils.isNotEmpty((Object)businessId)) {
                return this.iCustomizeAttachmentManagerService.uploadFileWithDrag(multipartRequest, Long.valueOf(Long.parseLong(businessId)));
            }
            return this.iCustomizeAttachmentManagerService.uploadFileWithDrag(multipartRequest, null);
        }
        Map fileMap = multipartRequest.getFileMap();
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterUrl());
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        String responseString = HttpClientUtil.httpPostFileByClient(urlMap, fileMap, authParamMap, authHeaderMap, new HashMap<String, Object>());
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u591a\u6587\u4ef6\u4e0a\u4f20\uff08\u5e26\u552f\u4e00\u4fdd\u5b58\u6807\u8bc6\uff09", notes="\u53ef\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\uff08\u5e26\u552f\u4e00\u4fdd\u5b58\u6807\u8bc6\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartRequest", value="\u591a\u6587\u4ef6", required=true, paramType="body"), @ApiImplicitParam(name="attachmentType", value="\u8282\u70b9\u914d\u7f6e\u7684\u9644\u4ef6\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="isWeb", value="\u662f\u5426\u4e3aweb\u7aef\u4e0a\u4f20", required=false, paramType="query"), @ApiImplicitParam(name="saveId", value="\u552f\u4e00\u4fdd\u5b58\u6807\u8bc6", required=false, paramType="query")})
    @PostMapping(value={"/uploadfilewithsaveid"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u591a\u6587\u4ef6\u4e0a\u4f20\uff08\u5e26\u552f\u4e00\u4fdd\u5b58\u6807\u8bc6\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<AttachmentManagerModelVo> uploadfileWithSaveId(MultipartHttpServletRequest multipartRequest, String attachmentType, boolean isWeb, String saveId) throws Exception {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            List<Object> attachmentTypes = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)attachmentType)) {
                attachmentTypes = SysAttachmentUtil.paseString(attachmentType);
            }
            if (!this.sysAttachmentService.attachmentTypeVerify(multipartRequest, attachmentTypes)) {
                return ApiResponse.fail((String)"\u4e0d\u80fd\u4e0a\u4f20\u5f53\u524d\u7c7b\u578b\u7684\u9644\u4ef6");
            }
            if (HussarUtils.isNotEmpty((Object)isWeb) && HussarUtils.isNotEmpty((Object)saveId)) {
                return this.iCustomizeAttachmentManagerService.uploadFileWithSaveId(multipartRequest, saveId);
            }
            return this.iCustomizeAttachmentManagerService.uploadFileWithSaveId(multipartRequest, null);
        }
        Map fileMap = multipartRequest.getFileMap();
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        authHeaderMap.put("tcode", this.sysAttachmentProperties.getTcode());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterUrl());
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        paramMap.put("saveId", saveId);
        paramMap.put("isWeb", isWeb);
        String responseString = HttpClientUtil.httpPostFileByClient(urlMap, fileMap, authParamMap, authHeaderMap, paramMap);
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="response", value="\u54cd\u5e94\u7ed3\u679c", required=true, paramType="body"), @ApiImplicitParam(name="fileId", value="\u6587\u4ef6 ID", required=true, paramType="query")})
    @GetMapping(value={"/fileDownload"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0b\u8f7d\u7ba1\u7406", eventDesc="\u9644\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void fileDownload(HttpServletResponse response, String fileId) {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            this.iCustomizeAttachmentManagerService.fileDownload(response, Long.valueOf(fileId));
        } else {
            HashMap<String, String> authParamMap = new HashMap<String, String>();
            HashMap<String, String> authHeaderMap = new HashMap<String, String>();
            HashMap<String, String> urlMap = new HashMap<String, String>();
            authParamMap.put("grant_type", "client_credentials");
            authParamMap.put("scope", this.sysAttachmentProperties.getScope());
            authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
            authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
            urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterFileDownloadUrl() + "?fileId=" + fileId);
            urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
            HttpClientUtil.httpGetFileByClient(urlMap, authParamMap, authHeaderMap, response);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740", notes="\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6 ID", required=true, paramType="query")})
    @GetMapping(value={"/getFileDownloadUrl"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0b\u8f7d\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<String> getFileDownloadUrl(String fileId) {
        return this.iCustomizeAttachmentManagerService.getFileDownloadUrl(Long.valueOf(fileId));
    }

    @ApiOperation(value="\u9644\u4ef6\u67e5\u8be2", notes="\u9644\u4ef6\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1id", required=true, paramType="query")})
    @GetMapping(value={"/fileQuery"})
    @AuditLog(moduleName="\u9644\u4ef6\u67e5\u8be2", eventDesc="\u9644\u4ef6\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysFileInfoDto>> fileQuery(String businessId) {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            if (HussarUtils.isEmpty((Object)businessId)) {
                return ApiResponse.success(new ArrayList());
            }
            return ApiResponse.success((Object)this.sysAttachmentService.fileQuery(businessId));
        }
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterFileQueryUrl() + "?businessId=" + businessId);
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        String responseString = HttpClientUtil.httpGetFileByClient(urlMap, authParamMap, authHeaderMap, null);
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u9644\u4ef6\u67e5\u8be2", notes="\u9644\u4ef6\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1id", required=true, paramType="query")})
    @PostMapping(value={"/fileQuerys"})
    @AuditLog(moduleName="\u9644\u4ef6\u67e5\u8be2", eventDesc="\u9644\u4ef6\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AttachmentInfoVo>> fileQuerys(@RequestBody String fileIds) {
        if (fileIds == null || fileIds.equals("")) {
            return ApiResponse.success(new ArrayList());
        }
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            List<String> fileId = Arrays.asList(fileIds.split(","));
            return ApiResponse.success((Object)this.sysAttachmentService.fileQuerys(fileId));
        }
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterFileQuerysUrl());
        paramMap.put("fileIds", fileIds);
        String responseString = HttpClientUtil.httpPostDeleteFileByClient(urlMap, authParamMap, authHeaderMap, paramMap);
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u9644\u4ef6\u67e5\u8be2(\u968f\u673a\u6807\u8bc6)", notes="\u9644\u4ef6\u67e5\u8be2(\u968f\u673a\u6807\u8bc6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="saveId", value="\u968f\u673a\u6807\u8bc6", required=true, paramType="query")})
    @GetMapping(value={"/fileQueryBySaveId"})
    @AuditLog(moduleName="\u9644\u4ef6\u67e5\u8be2(\u968f\u673a\u6807\u8bc6)", eventDesc="\u9644\u4ef6\u67e5\u8be2(\u968f\u673a\u6807\u8bc6)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysFileInfoDto>> fileQueryBySaveId(String saveId) {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            if (HussarUtils.isEmpty((Object)saveId)) {
                return ApiResponse.success(new ArrayList());
            }
            return ApiResponse.success((Object)this.sysAttachmentService.fileQueryBySaveId(saveId));
        }
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterFileQueryBySaveIdUrl() + "?saveId=" + saveId);
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        String responseString = HttpClientUtil.httpGetFileByClient(urlMap, authParamMap, authHeaderMap, null);
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u9644\u4ef6\u5220\u9664", notes="\u9644\u4ef6\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u968f\u673a\u6807\u8bc6", required=true, paramType="delete")})
    @PostMapping(value={"/fileDeleteByFileId"})
    @AuditLog(moduleName="\u9644\u4ef6\u5220\u9664", eventDesc="\u9644\u4ef6\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> fileDeleteByFileId(@RequestBody AttachmentWithSaveIdDto attachmentWithSaveIdDto) {
        if (this.sysAttachmentProperties.isApprovalCenter()) {
            if (HussarUtils.isEmpty((Object)attachmentWithSaveIdDto.getFileId())) {
                return ApiResponse.success((Object)true);
            }
            return this.sysAttachmentService.fileDeleteByFileId(attachmentWithSaveIdDto.getFileId());
        }
        HashMap<String, String> authParamMap = new HashMap<String, String>();
        HashMap<String, String> authHeaderMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        authParamMap.put("grant_type", "client_credentials");
        authParamMap.put("scope", this.sysAttachmentProperties.getScope());
        authHeaderMap.put("client-id", this.sysAttachmentProperties.getClientId());
        authHeaderMap.put("client-secret", this.sysAttachmentProperties.getClientSecret());
        urlMap.put("approvalCenterUrl", this.sysAttachmentProperties.getApprovalCenterFileDeleteByFileIdUrl());
        urlMap.put("getTokenUrl", this.sysAttachmentProperties.getGetTokenUrl());
        paramMap.put("fileId", attachmentWithSaveIdDto.getFileId());
        String responseString = HttpClientUtil.httpPostDeleteFileByClient(urlMap, authParamMap, authHeaderMap, paramMap);
        return (ApiResponse)JSON.parseObject((String)responseString, ApiResponse.class);
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58", notes="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobileAttachmentDto", value="\u6587\u4ef6\u4fdd\u5b58\u4fe1\u606f", required=true, paramType="body")})
    @PostMapping(value={"/mobileUploadSave"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse saveMobileFile(@RequestBody MobileAttachmentDto mobileAttachmentDto) {
        return this.sysAttachmentService.saveMobileUpload(mobileAttachmentDto);
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58(\u5e26\u968f\u673a\u6807\u8bc6)", notes="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58(\u5e26\u968f\u673a\u6807\u8bc6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="attachmentWithSaveIdDto", value="\u6587\u4ef6\u4fdd\u5b58\u4fe1\u606f", required=true, paramType="body")})
    @PostMapping(value={"/mobileUploadSaveWithSaveId"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u79fb\u52a8\u7aef\u6587\u4ef6\u4fdd\u5b58(\u5e26\u968f\u673a\u6807\u8bc6)", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse saveMobileFileWithSaveTag(@RequestBody AttachmentWithSaveIdDto attachmentWithSaveIdDto) {
        return this.sysAttachmentService.saveMobileUploadWithSaveId(attachmentWithSaveIdDto.getSaveId(), attachmentWithSaveIdDto.getFileIds());
    }
}

