/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.util;

import com.jxdinfo.hussar.general.attachment.properties.AttachmentProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypes;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class SysAttachmentUtil {
    private static Detector detector = TikaConfig.getDefaultConfig().getDetector();
    private static MimeTypes mimeTypes = MimeTypes.getDefaultMimeTypes();

    public static List<String> paseString(String temp) {
        Object[] strs;
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)temp) && HussarUtils.isNotEmpty((Object[])(strs = temp.split(",")))) {
            for (Object str : strs) {
                list.add((String)str);
            }
        }
        return list;
    }

    public static boolean checkFileType(MultipartFile file, AttachmentProperties attachmentProperties) {
        if (attachmentProperties.getUploadFileTypeCheck().booleanValue()) {
            if (HussarUtils.isEmpty((Object)attachmentProperties.getSupportFileTypes())) {
                return false;
            }
            String fileName = file.getOriginalFilename();
            String extension = SysAttachmentUtil.getExtension(fileName);
            Boolean valid = attachmentProperties.getSupportFileTypes().stream().anyMatch(type -> type.equalsIgnoreCase(extension));
            if (valid.booleanValue()) {
                String message = "";
                String mimeType = SysAttachmentUtil.getMimeType(file);
                String fileMt = SysAttachmentUtil.getFileMimeTypeByExtension(fileName);
                MediaTypeRegistry registry = mimeTypes.getMediaTypeRegistry();
                MediaType mediaType = MediaType.parse((String)mimeType);
                MediaType superMediaType = MediaType.parse((String)fileMt);
                valid = superMediaType.equals((Object)MediaType.OCTET_STREAM) ? (mediaType.equals((Object)MediaType.OCTET_STREAM) ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(registry.isInstanceOf(mediaType, superMediaType) || registry.isInstanceOf(superMediaType, mediaType));
                if (!valid.booleanValue()) {
                    return false;
                }
            }
            if (!valid.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public static String getExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getMimeType(MultipartFile file) {
        try {
            TikaInputStream stream = TikaInputStream.get((InputStream)file.getInputStream());
            Metadata metadata = new Metadata();
            metadata.add("resourceName", file.getOriginalFilename());
            MediaType mediaType = detector.detect((InputStream)stream, metadata);
            return mediaType.toString();
        }
        catch (IOException var4) {
            throw new HussarException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u7c7b\u578b\u5931\u8d25", (Throwable)var4);
        }
    }

    public static String getFileMimeTypeByExtension(String fileName) {
        return new Tika().detect(fileName);
    }
}

