/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.common.controller;

import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.core.encrypt.AbstractCryptoProvider;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarTenantProperties;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.common.properties.HussarSecureProperties;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.EncryptSupportService;
import com.jxdinfo.hussar.platform.core.support.service.dto.EncryptDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.JobExecutionProperties;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/baseData"})
@Api(tags={"\u57fa\u7840\u4fe1\u606f\u7ba1\u7406"})
public class SystemBaseDataControler {
    private static int SM2 = 1;
    @Resource
    private IGlobalService globalService;
    @Resource
    private AbstractCryptoProvider crypto;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarSecureProperties hussarSecureProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;

    private static int convert(String encryptType) {
        if ("sm2".equalsIgnoreCase(encryptType)) {
            return SM2;
        }
        return 0;
    }

    @GetMapping(value={"/getBaseData"})
    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u57fa\u7840\u4fe1\u606f", notes="\u83b7\u53d6\u9875\u9762\u57fa\u7840\u4fe1\u606f")
    @Inner
    public ApiResponse<Map<String, Object>> getInitEncryptInfo() {
        JobExecutionProperties jobExecutionProperties;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Boolean enableEncrypt = this.hussarSecureProperties.getEnabled();
        map.put("enableEncrypt", enableEncrypt);
        map.put("h_version", this.hussarConfig.getStaticVersion());
        map.put("tabSwitchover", this.globalService.isTabSwitchover());
        map.put("kaptcha", this.hussarLoginConfigService.getKaptchaOpen());
        map.put("totp", this.hussarLoginConfigService.getTotpOpen());
        map.put("standAlone", this.sysBaseConfigService.isNotRedis());
        if (this.hussarTenantProperties.isTenantOpen()) {
            map.put("tenantOpen", this.hussarTenantProperties.isTenantOpen());
            map.put("tenantModel", this.hussarTenantProperties.getTenantModel());
        }
        if (enableEncrypt.booleanValue()) {
            EncryptSupportService encryptSupportService = (EncryptSupportService)SpringContextHolder.getBean(EncryptSupportService.class);
            EncryptDto initEncryptInfo = encryptSupportService.getInitEncryptInfo();
            map.put("enabledEncryptSign", initEncryptInfo.isEnabledEncryptSign());
            map.put("headerEncrypt", initEncryptInfo.getHeaderEncrypt());
            map.put("hussarFP", initEncryptInfo.getFrontPriKey());
            map.put("hussarBP", initEncryptInfo.getBackendPubKey());
            map.put("enableEncryptCbcMode", initEncryptInfo.getEnableEncryptCbcMode());
        }
        if (HussarUtils.isNotEmpty((Object)(jobExecutionProperties = (JobExecutionProperties)SpringContextHolder.getBean(JobExecutionProperties.class)))) {
            map.put("appName", jobExecutionProperties.getAppName());
        }
        PasswordEncryptDTO pwEncryptDTO = this.passwordEncryptService.getPasswordEncryptInfo();
        Boolean enablePwEncryption = pwEncryptDTO.getEnabled();
        map.put("enablePwEncryption", enablePwEncryption);
        if (enablePwEncryption.booleanValue()) {
            map.put("hussarET", SystemBaseDataControler.convert(pwEncryptDTO.getEncryptType()));
            map.put("hussarEK", pwEncryptDTO.getEncryptKey());
        }
        return ApiResponse.success(map);
    }
}

