/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.general.attachment.dto.AttachInfoDto;
import com.jxdinfo.hussar.general.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.general.attachment.service.AttachmentManagerService;
import com.jxdinfo.hussar.general.attachment.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/attachment"})
@Api(tags={"\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406"})
public class AttachmentManagerController
extends HussarBaseController<AttachmentManagerModel, AttachmentManagerService> {
    @Resource
    private AttachmentManagerService attachmentManagerService;

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6", required=true, paramType="body")})
    @CheckPermission(value={"attachment:upload"})
    @PostMapping(value={"/add"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u4e0a\u4f20\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<String> upload(@RequestPart(value="file") MultipartFile file) {
        return this.attachmentManagerService.upload(file);
    }

    @ApiOperation(value="\u591a\u6587\u4ef6\u4e0a\u4f20", notes="\u53ef\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartRequest", value="\u591a\u6587\u4ef6", required=true, paramType="body")})
    @CheckPermission(value={"attachment:uploadfilewithdrag"})
    @PostMapping(value={"/uploadfilewithdrag"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u591a\u6587\u4ef6\u4e0a\u4f20", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest) throws Exception {
        return this.attachmentManagerService.uploadfileWithDrag(multipartRequest);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="response", value="\u54cd\u5e94\u7ed3\u679c", required=true, paramType="body")})
    @CheckPermission(value={"attachment:fileDownload"})
    @GetMapping(value={"/fileDownload"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void fileDownload(HttpServletResponse response, String fileId) {
        this.attachmentManagerService.fileDownload(response, fileId);
    }

    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d", notes="\u6279\u91cf\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u6587\u4ef6id", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94\u7ed3\u679c", required=true, paramType="body")})
    @CheckPermission(value={"attachment:BatchDownload"})
    @GetMapping(value={"/BatchDownload"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u6279\u91cf\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void batchDownload(@RequestParam(value="fileId") String ids, HttpServletResponse response) throws ServletException, IOException {
        this.attachmentManagerService.batchDownload(ids, response);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u5220\u9664\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="query")})
    @CheckPermission(value={"attachment:delete"})
    @PostMapping(value={"/delete"})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u5220\u9664\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> fileDelete(@RequestParam String fileId) {
        return this.attachmentManagerService.deleteFile(fileId);
    }

    @CheckPermission(value={"attachment:getAttachmentList"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="body"), @ApiImplicitParam(name="info", value="\u9644\u4ef6\u67e5\u8be2\u4fe1\u606f", required=true, paramType="body")})
    @GetMapping(value={"/getAttachmentList"})
    @ApiOperation(value="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2", notes="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u9644\u4ef6\u4fe1\u606f\u5217\u8868\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<AttachmentManagerModel>> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        return ApiResponse.success((Object)this.attachmentManagerService.getAttachmentList(page, info));
    }

    @CheckPermission(value={"attachment:showPicture"})
    @GetMapping(value={"/showPicture"})
    @ApiOperation(value="\u663e\u793a\u56fe\u7247", notes="\u663e\u793a\u56fe\u7247")
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u663e\u793a\u56fe\u7247", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void showImage(HttpServletResponse response, String image) {
        this.attachmentManagerService.showImage(response, image);
    }

    @CheckPermission(value={"attachment:uploadFileQuery"})
    @GetMapping(value={"/uploadFileQuery"})
    @ResponseBody
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", notes="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id", required=true, paramType="query")})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<AttachmentManagerModelVo> uploadFileQuery(@RequestParam(value="fileId") String fileId) {
        return ApiResponse.success((Object)this.attachmentManagerService.getByFileId(fileId));
    }

    @GetMapping(value={"/uploadFilesQuery"})
    @ResponseBody
    @ApiOperation(value="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", notes="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileIds", value="\u6587\u4ef6ids", required=true, paramType="query")})
    @AuditLog(moduleName="\u9644\u4ef6\u4e0a\u4f20\u7ba1\u7406", eventDesc="\u591a\u4e2a\u6587\u4ef6\u4e0a\u4f20\u56de\u663e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AttachmentManagerModelVo>> uploadFilesQuery(@RequestParam(value="fileIds") String fileIds) {
        if (StringUtils.isNotBlank((CharSequence)fileIds)) {
            String[] relFileIds = fileIds.split(",");
            return ApiResponse.success((Object)this.attachmentManagerService.getByFileIds(relFileIds));
        }
        return ApiResponse.fail((String)"\u56de\u663e\u53c2\u6570\u4e3a\u7a7a");
    }
}

