/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.romoteMenu.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHttpUtil {
    private static Logger logger = LoggerFactory.getLogger(RequestHttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttp(String type, String url, String soap) {
        long startTimeValue = System.currentTimeMillis();
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        try {
            String line;
            logger.info("===url=" + url);
            logger.info("===soap=" + soap);
            URL wsUrl = new URL(url);
            httpURLConnection = (HttpURLConnection)wsUrl.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            if ("post".equals(type.toLowerCase())) {
                httpURLConnection.setRequestMethod("POST");
            } else {
                httpURLConnection.setRequestMethod("GET");
            }
            String token = JSON.parseObject((String)soap).getString("token");
            if (HussarUtils.isNotEmpty((Object)token)) {
                httpURLConnection.setRequestProperty("Authorization", token);
            }
            httpURLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            httpURLConnection.setConnectTimeout(6000);
            httpURLConnection.setReadTimeout(6000);
            OutputStream out = httpURLConnection.getOutputStream();
            out.write(soap.getBytes("UTF-8"));
            out.flush();
            out.close();
            inputStream = httpURLConnection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            System.out.println("===sendHttpPost===SUCCESS===COST=" + (System.currentTimeMillis() - startTimeValue) + "===HttpReturn===" + response.toString());
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("===sendHttpPost===ERROR=" + e.getMessage());
            String string = "REQUEST_ERROR";
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logger.info("===\u56de\u6536\u8d44\u6e90is\u62a5\u9519");
            }
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception e) {
                logger.info("===\u56de\u6536\u8d44\u6e90httpURLConnection\u62a5\u9519");
            }
        }
    }
}

