/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysDicRefServiceImpl
implements ISysDicRefService {
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public List<DicSingle> getDictByType(String typeName) {
        DicType type;
        List<Object> result = new ArrayList<DicSingle>();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":list";
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            LambdaQueryWrapper wp = Wrappers.lambdaQuery();
            wp.isNull(DicSingle::getParentId);
            ((LambdaQueryWrapper)wp.eq(DicSingle::getTypeId, (Object)type.getId())).orderByAsc(DicSingle::getSort);
            result = this.dicSingleService.list((Wrapper)wp);
        }
        return result;
    }

    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":map";
        LinkedHashMap<String, String> result = (LinkedHashMap<String, String>)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty((Object)result)) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            List<DicSingle> list = this.getDictByType(typeName);
            for (DicSingle dicSingle : list) {
                linkedHashMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
            result = linkedHashMap;
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, linkedHashMap);
        }
        return result;
    }

    public List<DicVo> getDicListByType(String typeName) {
        DicType type;
        List result = new ArrayList();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":allShow";
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getDicListByType(type.getId());
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        return result;
    }

    public List<DicVo> getCertainDictOptions(String typeName, String[] optionValues) {
        DicType type;
        List result = new ArrayList();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":onlyShow";
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getCertainDictOptions(type.getId(), optionValues);
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        return result;
    }

    public List<DicVo> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        DicType type;
        List result = new ArrayList();
        String key = "dict_of_type:" + this.dynamicDataSourceService.currentDsName() + ":" + typeName + ":notShow";
        result = (List)HussarCacheUtil.get((String)"hussar_dict_of_type_cache", (Object)key);
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getDictOptionsWithoutNotShows(type.getId(), notShows);
            HussarCacheUtil.put((String)"hussar_dict_of_type_cache", (Object)key, result);
        }
        return result;
    }

    public String getDictLabel(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabel(type.getId(), value);
        }
        return result;
    }

    public String getDictValue(String typeName, String label) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            result = this.dicSingleService.getDictValue(type.getId(), label);
        }
        return result;
    }

    public String getDictOptionsInJson(String typeName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getLabel(), dicSingle.getValue());
        }
        return JSON.toJSONString(linkedHashMap);
    }

    private DicType getTypeInfo(String typeName) {
        return (DicType)this.dicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getTypeName, (Object)typeName), false);
    }

    public DicVo getDictByTypeValue(String typeName, String value) {
        DicType type;
        DicVo result = null;
        if (ToolUtil.isEmpty(result) && ToolUtil.isNotEmpty((Object)(type = this.getTypeInfo(typeName)))) {
            result = this.dicSingleService.getPrentDict(type.getId(), value);
        }
        return result;
    }
}

