/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.attachment.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CheckUploadFileUtils;
import com.jxdinfo.hussar.common.utils.OssProperties;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.attachment.dao.BaseAttachmentManagerMapper;
import com.jxdinfo.hussar.general.attachment.dto.AttachInfoDto;
import com.jxdinfo.hussar.general.attachment.enums.OssExceptionEnum;
import com.jxdinfo.hussar.general.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.general.attachment.properties.OssFileProperties;
import com.jxdinfo.hussar.general.attachment.service.BaseAttachmentManagerService;
import com.jxdinfo.hussar.general.attachment.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseAttachmentManagerServiceImpl
extends HussarServiceImpl<BaseAttachmentManagerMapper, AttachmentManagerModel>
implements BaseAttachmentManagerService {
    private static Logger logger = LogManager.getLogger(BaseAttachmentManagerServiceImpl.class);
    @Resource
    private BaseAttachmentManagerMapper baseAttachmentManagerMapper;
    @Resource
    private BaseAttachmentManagerService baseAttachmentManagerService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private OssFileProperties ossFileProperties;
    @Resource
    private OssProperties ossProperties;
    private static Environment env = (Environment)SpringContextHolder.getBean(Environment.class);

    public BaseAttachmentManagerServiceImpl(OssFileProperties ossFileProperties) {
        this.ossFileProperties = ossFileProperties;
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.baseAttachmentManagerMapper.addAttachment(attachmentManagerModel);
        return attachmentManagerModel.getId();
    }

    public String finddirById(String id) {
        return this.baseAttachmentManagerMapper.finddirById(id);
    }

    public AttachmentManagerModelVo getByFileId(String fileId) {
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById((Serializable)((Object)fileId));
        Long id = attachmentModel.getId();
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + id + suffix;
        File file = new File(path);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        attachmentManagerModelVo.setId(id);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        return attachmentManagerModelVo;
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (ToolUtil.isEmpty((Object)fileIds)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        for (String fileId : fileIds) {
            AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById((Serializable)((Object)fileId));
            Long id = attachmentManagerModel.getId();
            String fileName = attachmentManagerModel.getAttachmentName();
            String suffix = this.getSuffix(fileName);
            String path = attachmentManagerModel.getAttachmentDir() + id + suffix;
            File file = new File(path);
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            attachmentManagerModelVo.setId(id);
            attachmentManagerModelVo.setFileName(fileName);
            attachmentManagerModelVo.setPath(path);
            attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
            attachmentManagerModelVos.add(attachmentManagerModelVo);
        }
        return attachmentManagerModelVos;
    }

    public AttachmentManagerModel saveFileManager(Long businessId, String fileName, String suffix, String fileSavePath) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileName);
        attachment.setAttachmentType(suffix.replace(".", ""));
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            boolean eomsTokenUser = Boolean.parseBoolean(env.getProperty("eomsTokenUser"));
            if (eomsTokenUser) {
                attachment.setUploadAcc(user.getAccount());
            } else {
                attachment.setUploadPer(user.getId());
            }
        }
        attachment.setAttachmentDir(fileSavePath);
        attachment.setUploadDate(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        this.save(attachment);
        return attachment;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (ToolUtil.isEmpty((Object)file)) {
            throw new BaseException("\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties, (String)"");
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            String fileSavePath = this.ossFileProperties.getFileUploadPath();
            file.transferTo(new File(fileSavePath + fName));
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.UPLOAD_ERROR.getMessage());
        }
        return ApiResponse.success((String)fName);
    }

    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(MultipartHttpServletRequest multipartRequest) throws Exception {
        if (ToolUtil.isEmpty((Object)multipartRequest)) {
            throw new BaseException("\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        HashMap result = new HashMap();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        Long businessId = 0L;
        if (ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("businessId"))) {
            businessId = Long.valueOf(multipartRequest.getParameter("businessId"));
        }
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (ToolUtil.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties, (String)"");
            String fileName = multipartFile.getOriginalFilename();
            String suffix = this.getSuffix(fileName);
            try {
                String fileSavePath = this.ossFileProperties.getFileUploadPath();
                if (this.hussarBaseProperties.isTenantOpen()) {
                    String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
                    File tenantFolder = new File(fileSavePath = fileSavePath + tenantCode + File.separator);
                    if (!tenantFolder.exists()) {
                        tenantFolder.mkdir();
                    }
                }
                AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(businessId, fileName, suffix, fileSavePath);
                multipartFile.transferTo(new File(fileSavePath + attachmentManagerModel.getId() + suffix));
                attachmentManagerModelVo.setId(attachmentManagerModel.getId());
                attachmentManagerModelVo.setFileName(fileName);
            }
            catch (IOException e) {
                logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
                throw new BaseException(BizExceptionEnum.UPLOAD_ERROR.getMessage());
            }
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    public void fileDownload(HttpServletResponse response, String fileId) {
        if (ToolUtil.isEmpty((Object)response) || ToolUtil.isEmpty((Object)fileId)) {
            throw new BaseException("\u4e0b\u8f7d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.baseAttachmentManagerService.getById((Serializable)((Object)fileId));
        Long id = attachmentModel.getId();
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + id + suffix;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(path)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)fileName.toString(), (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"\u7f16\u7801\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        catch (IOException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"IO\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (ToolUtil.isEmpty((Object)ids) || ToolUtil.isEmpty((Object)response)) {
            throw new BaseException("\u4e0b\u8f7d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ServletOutputStream os = response.getOutputStream();
        ZipOutputStream zos = new ZipOutputStream((OutputStream)os);
        BufferedInputStream bis = null;
        List<String> fileIdList = Arrays.asList(ids.split(","));
        List attachList = this.baseAttachmentManagerService.listByIds(fileIdList);
        try {
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                ++count;
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String path = attach.getAttachmentDir() + id + suffix;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
                byte[] buf = new byte[((InputStream)inputStream).available()];
                int len = 0;
                ZipEntry zipEntry = new ZipEntry(count + "-" + fileName);
                zos.putNextEntry(zipEntry);
                bis = new BufferedInputStream(inputStream, 10240);
                while ((len = bis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                    zos.flush();
                }
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            zos.close();
            if (null != bis) {
                bis.close();
            }
        }
    }

    public ApiResponse<Object> deleteFile(String fileId) {
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new BaseException("\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fId = fileId.replace("[\"", "").replace("\"]", "");
        Map<String, String> fileMap = this.baseAttachmentManagerMapper.findById(fId);
        String fileName = fileMap.get("name");
        String id = fileMap.get("id");
        String fileSavePath = this.baseAttachmentManagerService.finddirById(id);
        String suffix = this.getSuffix(fileName);
        File file = new File(fileSavePath.replace("\\", "/") + id + suffix);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        this.baseAttachmentManagerMapper.deleteFile(id);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void showImage(HttpServletResponse response, String id) {
        if (ToolUtil.isEmpty((Object)response) || ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u663e\u793a\u56fe\u7247\u53c2\u6570\u4e3a\u7a7a");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        AttachmentManagerModel image = (AttachmentManagerModel)this.baseAttachmentManagerService.getById((Serializable)((Object)id));
        String fileName = image.getAttachmentName();
        Long fileId = image.getId();
        String fileSavePath = image.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        String absolutePath = fileSavePath.replace("\\", "/") + fileId + suffix;
        try (FileInputStream fis = new FileInputStream(absolutePath);
             ServletOutputStream os = response.getOutputStream();){
            byte[] byt = new byte[fis.available()];
            fis.read(byt);
            os.write(byt);
            os.flush();
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public void fileDownloadByPath(HttpServletResponse response, String filePath) {
        if (ToolUtil.isEmpty((Object)response) || ToolUtil.isEmpty((Object)filePath)) {
            throw new BaseException("\u4e0b\u8f7d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tPath = filePath.replace("\\", "/");
        String fileName = tPath.substring(tPath.lastIndexOf("/") + 1);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(filePath)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)fileName.toString(), (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"\u7f16\u7801\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        catch (IOException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"IO\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public IPage<AttachmentManagerModel> getAttachmentList(Page page, AttachInfoDto info) {
        if (ToolUtil.isEmpty((Object)info)) {
            throw new BaseException("\u9644\u4ef6\u4fe1\u606f\u53c2\u6570\u4e3a\u7a7a");
        }
        String attachmentName = info.getAttachmentName();
        String startDate = info.getStartDate();
        String endDate = info.getEndDate();
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        page.setRecords(this.baseAttachmentManagerMapper.getAttachmentList(page, attachmentName, start, end));
        return page;
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    public ApiResponse<Boolean> isExist(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        File file = new File(absolutePath);
        if (!file.exists()) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        AttachmentManagerModel attachmentManagerModel = this.baseAttachmentManagerService.saveFileManager(null, fileName, suffix, fileSavePath);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        File upload = new File(path);
        try {
            file.transferTo(upload);
        }
        catch (IOException e) {
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        return ApiResponse.success((Object)id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<byte[]> backgroundDownload(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        try (FileInputStream fis = new FileInputStream(absolutePath);){
            ApiResponse apiResponse = ApiResponse.success((Object)IoUtil.readToByteArray((InputStream)fis));
            return apiResponse;
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    public ApiResponse<Object> deleteFile(Long id) {
        return this.deleteFile(String.valueOf(id));
    }

    private String getAbsolutePath(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String fileName = file.getAttachmentName();
        String fileSavePath = file.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        return fileSavePath + id + suffix;
    }
}

