/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.dict.dao.EomsDictSingleMapper;
import com.jxdinfo.hussar.dict.dao.EomsDictTypeMapper;
import com.jxdinfo.hussar.dict.po.TransDictType;
import com.jxdinfo.hussar.dict.service.EomsDictTypeService;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EomsDictTypeServiceImpl
extends HussarServiceImpl<EomsDictTypeMapper, TransDictType>
implements EomsDictTypeService {
    private static Logger log = LoggerFactory.getLogger(EomsDictTypeServiceImpl.class);
    @Resource
    private EomsDictTypeMapper eomsDictTypeMapper;
    @Resource
    private EomsDictSingleMapper eomsDictSingleMapper;
    @Resource
    private ISysDicGroupService sysDicGroupService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysDicService dictService;

    @Override
    public ApiResponse<?> insertDictType(TransDictType transDictType) {
        if (HussarUtils.isBlank((CharSequence)transDictType.getDictParentClass())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DicGroup::getRangeType, (Object)"biz");
            DicGroup dicGroup = (DicGroup)this.sysDicGroupService.getOne((Wrapper)queryWrapper);
            DicType lastOne = (DicType)this.sysDicTypeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicType::getParentId, (Object)dicGroup.getId())).orderByDesc(DicType::getSort), false);
            Integer sort = ToolUtil.isEmpty((Object)lastOne) ? Integer.valueOf(1) : Integer.valueOf(lastOne.getSort() + 1);
            boolean isSuccess = this.eomsDictTypeMapper.insertDictType(transDictType, dicGroup.getId(), sort);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
        } else {
            return ApiResponse.success((String)"\u542b\u6709\u7236\u7ea7\u5b57\u5178\uff0c\u65e0\u9700\u65b0\u589e\u5230\u7cfb\u7edf\u8868");
        }
        return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
    }

    @Override
    public ApiResponse<?> updateDictType(TransDictType transDictType) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"TYPE_NAME", (Object)transDictType.getDictClass());
        DicType dicType = (DicType)this.sysDicTypeService.getOne((Wrapper)qw, false);
        if (ToolUtil.isEmpty((Object)dicType)) {
            return ApiResponse.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        transDictType.setTypeId(dicType.getId());
        if (HussarUtils.isBlank((CharSequence)transDictType.getDictParentClass())) {
            boolean isSuccess = this.eomsDictTypeMapper.updateDictType(transDictType);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
        } else {
            return ApiResponse.success((String)"\u6709\u7236\u7ea7\u5b57\u5178\uff0c\u65e0\u9700\u4fee\u6539\u5230\u7cfb\u7edf\u8868");
        }
        return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public ApiResponse<?> deletDictType(String dictClass) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DicType::getTypeName, (Object)dictClass);
        DicType dicType = (DicType)this.sysDicTypeService.getOne((Wrapper)queryWrapper);
        if (!StringUtils.isEmpty((Object)dicType)) {
            Long typeId = dicType.getId();
            boolean flag1 = this.sysDicTypeService.removeById((Serializable)typeId);
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"TYPE_ID", (Object)typeId);
            this.sysDicSingleService.remove((Wrapper)ew);
            if (flag1) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        List<DicSingle> childrenList = this.eomsDictTypeMapper.childrenList(dictClass);
        if (childrenList.size() == 0) {
            return ApiResponse.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ArrayList<Long> childrenIds = new ArrayList<Long>();
        for (DicSingle child : childrenList) {
            this.removeChildrenList(child, childrenIds);
        }
        boolean isSuccess = this.sysDicSingleService.removeByIds(childrenIds);
        if (isSuccess) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    public ApiResponse<?> importDictType(MultipartFile multipartFile) {
        if (StringUtils.isEmpty((Object)multipartFile)) {
            throw new BaseException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        Map<String, Object> file = EomsDictTypeServiceImpl.MultipartFileToFile(multipartFile);
        File excelFile = (File)file.get("file");
        String prefix = (String)file.get("prefix");
        ArrayList<TransDictType> transDictTypeList = new ArrayList<TransDictType>();
        try {
            HSSFWorkbook workbook;
            FileInputStream fis = new FileInputStream(excelFile);
            if (prefix.equals(".xls")) {
                workbook = new HSSFWorkbook((InputStream)fis);
            } else if (prefix.equals(".xlsx")) {
                workbook = new XSSFWorkbook((InputStream)fis);
            } else {
                throw new BaseException("\u8bf7\u5bfc\u5165excel\u6587\u4ef6");
            }
            Sheet sheet = workbook.getSheetAt(0);
            int lastRow = sheet.getLastRowNum();
            Row titleRow = sheet.getRow(0);
            int lastCell = titleRow.getLastCellNum();
            if (!(lastCell >= 4 && "\u7c7b\u522b\u540d".equals(titleRow.getCell(1).getStringCellValue()) && "\u7c7b\u522b\u63cf\u8ff0".equals(titleRow.getCell(2).getStringCellValue()) && "\u7236\u7c7b\u522b\u540d".equals(titleRow.getCell(3).getStringCellValue()) && "\u5b57\u5178Id".equals(titleRow.getCell(4).getStringCellValue()))) {
                throw new BaseException("\u5bfc\u5165Excel\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 1; i <= lastRow; ++i) {
                Row row = sheet.getRow(i);
                ArrayList<String> cells = new ArrayList<String>();
                for (int j = 1; j < lastCell; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell != null) {
                        if (cell.getCellType() == CellType.NUMERIC) {
                            double numericCellValue = cell.getNumericCellValue();
                            DecimalFormat df = new DecimalFormat("0");
                            cells.add(df.format(numericCellValue));
                            continue;
                        }
                        cells.add(cell.getStringCellValue());
                        continue;
                    }
                    cells.add(null);
                }
                String tId = (String)cells.get(3);
                long typeId = IdWorker.getId((Object)new TransDictType());
                if (HussarUtils.isNotBlank((CharSequence)tId)) {
                    typeId = Long.parseLong(tId);
                }
                if (HussarUtils.isBlank((CharSequence)((CharSequence)cells.get(0)))) {
                    throw new BaseException("\u7c7b\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (HussarUtils.isBlank((CharSequence)((CharSequence)cells.get(1)))) {
                    throw new BaseException("\u7c7b\u522b\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                transDictTypeList.add(new TransDictType((String)cells.get(0), (String)cells.get(1), (String)cells.get(2), typeId));
            }
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new BaseException("\u627e\u4e0d\u5230\u6587\u4ef6");
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new BaseException("\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
        }
        this.saveDictType(transDictTypeList);
        return ApiResponse.success((Object)true);
    }

    @Override
    public ResponseEntity<byte[]> exportExcelModel() {
        org.springframework.core.io.Resource resource = new PathMatchingResourcePatternResolver().getResource("classpath:/model/dict-type-model.xlsx");
        try {
            InputStream input = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)input);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)bytes);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public DicType getNewDictType(TransDictType transDictType) {
        DicType dicType = new DicType();
        dicType.setId(transDictType.getTypeId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DicGroup::getRangeType, (Object)"biz");
        DicGroup dicGroup = (DicGroup)this.sysDicGroupService.getOne((Wrapper)queryWrapper);
        dicType.setParentId(dicGroup.getId());
        dicType.setTypeName(transDictType.getDictClass());
        dicType.setTypeDescription(transDictType.getTypeDescription());
        dicType.setRangeType("biz");
        return dicType;
    }

    public static Map<String, Object> MultipartFileToFile(MultipartFile multiFile) {
        String fileName = multiFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("prefix", prefix);
        try {
            File file = File.createTempFile(fileName.substring(0, fileName.lastIndexOf(46)), prefix);
            multiFile.transferTo(file);
            result.put("file", file);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BaseException("\u6587\u4ef6\u8f6c\u6362\u9519\u8bef");
        }
    }

    public List<Long> removeChildrenList(DicSingle dicSingle, List<Long> ids) {
        ids.add(dicSingle.getId());
        List<DicSingle> childrenSingleList = this.eomsDictSingleMapper.childrenList(dicSingle.getId());
        if (childrenSingleList.size() > 0) {
            for (DicSingle item : childrenSingleList) {
                this.removeChildrenList(item, ids);
            }
        }
        return ids;
    }

    @Override
    public void saveDictType(List<TransDictType> dictTypeList) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"RANGE_TYPE", (Object)"biz");
        DicGroup dicGroup = (DicGroup)this.sysDicGroupService.getOne((Wrapper)ew, false);
        Long groupId = dicGroup.getId();
        for (TransDictType tmp : dictTypeList) {
            boolean addFlag = true;
            Long typeId = tmp.getTypeId();
            String dictClass = tmp.getDictClass();
            String typeDescription = tmp.getTypeDescription();
            String dictParentClass = tmp.getDictParentClass();
            if (ToolUtil.isEmpty((Object)dictClass) || ToolUtil.isNotEmpty((Object)dictParentClass)) continue;
            DicDto dicDto = new DicDto();
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"TYPE_NAME", (Object)dictClass);
            DicType dicType = (DicType)this.sysDicTypeService.getOne((Wrapper)qw, false);
            if (ToolUtil.isNotEmpty((Object)dicType)) {
                addFlag = false;
                typeId = dicType.getId();
                dicDto.setDictId(typeId);
                dicDto.setDictName(typeDescription);
                dicDto.setDictTypeCode(dictClass);
                dicDto.setDelIdString("");
                dicDto.setDictValues("");
                dicDto.setFlag("haveType");
            }
            DicType dicTypeInfo = new DicType();
            dicTypeInfo.setId(typeId);
            dicTypeInfo.setDictParentClass(dictParentClass);
            DicSingle dicSingleInfo = new DicSingle();
            dicSingleInfo.setParentClass(dictParentClass);
            try {
                if (addFlag) {
                    this.dictService.addDictType(groupId, typeDescription, dictClass, null, dicTypeInfo);
                    continue;
                }
                this.dictService.updateNewDict(dicDto, dicSingleInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

