/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.dict.dao.EomsDictSingleMapper;
import com.jxdinfo.hussar.dict.po.TransDictSingle;
import com.jxdinfo.hussar.dict.service.EomsDictSingleService;
import com.jxdinfo.hussar.dict.service.impl.EomsDictTypeServiceImpl;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EomsDictSingleServiceImpl
extends HussarServiceImpl<EomsDictSingleMapper, TransDictSingle>
implements EomsDictSingleService {
    private static Logger log = LoggerFactory.getLogger(EomsDictTypeServiceImpl.class);
    @Resource
    private EomsDictSingleMapper eomsDictSingleMapper;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Resource
    private ISysDicService dictService;
    @Value(value="${importData.maxDictLevel:6}")
    private int maxDictLevel;

    @Override
    public ApiResponse<?> insertDictSingle(TransDictSingle transDictSingle) {
        if (HussarUtils.isNotBlank((CharSequence)transDictSingle.getParentClass())) {
            DicSingle dicSingle = this.eomsDictSingleMapper.getparentSingle(transDictSingle);
            if (ToolUtil.isEmpty((Object)dicSingle)) {
                return ApiResponse.fail((String)"\u7236\u7ea7\u4e0d\u5b58\u5728");
            }
            DicSingle lastOne = (DicSingle)this.sysDicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dicSingle.getTypeId())).orderByDesc(DicSingle::getSort), false);
            Integer sort = ToolUtil.isEmpty((Object)lastOne) ? Integer.valueOf(1) : Integer.valueOf(lastOne.getSort() + 1);
            boolean isSuccess = this.eomsDictSingleMapper.insertSingle(transDictSingle, dicSingle.getId(), dicSingle.getTypeId(), sort);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
        } else {
            LambdaQueryWrapper queryType = new LambdaQueryWrapper();
            queryType.eq(DicType::getTypeName, (Object)transDictSingle.getDictClass());
            DicType dicType = (DicType)this.sysDicTypeService.getOne((Wrapper)queryType);
            DicSingle lastOne = (DicSingle)this.sysDicSingleService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)dicType.getId())).orderByDesc(DicSingle::getSort), false);
            Integer sort = ToolUtil.isEmpty((Object)lastOne) ? Integer.valueOf(1) : Integer.valueOf(lastOne.getSort() + 1);
            boolean isSuccess = this.eomsDictSingleMapper.insertSingle(transDictSingle, null, dicType.getId(), sort);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
        }
        return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
    }

    @Override
    public ApiResponse<?> updateDictSingle(TransDictSingle transDictSingle) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"DICT_CLASS", (Object)transDictSingle.getDictClass());
        ew.eq((Object)"VALUE", (Object)transDictSingle.getValue());
        DicSingle dicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)ew, false);
        transDictSingle.setDictId(dicSingle.getId());
        if (ToolUtil.isNotEmpty((Object)dicSingle)) {
            boolean isSuccess = this.eomsDictSingleMapper.updateSingle(transDictSingle);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25");
        }
        return ApiResponse.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResponse<?> deleteDictSingle(String value, String dictClass) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"DICT_CLASS", (Object)dictClass);
        ew.eq((Object)"VALUE", (Object)value);
        DicSingle dicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)ew, false);
        if (ToolUtil.isNotEmpty((Object)dicSingle)) {
            List<Long> singleIds = this.removeChildrenList(dicSingle, new ArrayList<Long>());
            boolean isSuccess = this.sysDicSingleService.removeByIds(singleIds);
            if (isSuccess) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResponse<?> importDictSingle(MultipartFile multipartFile) {
        Map<String, Object> file = EomsDictSingleServiceImpl.MultipartFileToFile(multipartFile);
        File excelFile = (File)file.get("file");
        String prefix = (String)file.get("prefix");
        ArrayList<TransDictSingle> transDictSingleList = new ArrayList<TransDictSingle>();
        try {
            HSSFWorkbook workbook;
            FileInputStream fis = new FileInputStream(excelFile);
            if (prefix.equals(".xls")) {
                workbook = new HSSFWorkbook((InputStream)fis);
            } else if (prefix.equals(".xlsx")) {
                workbook = new XSSFWorkbook((InputStream)fis);
            } else {
                throw new BaseException("\u8bf7\u5bfc\u5165excel\u6587\u4ef6");
            }
            Sheet sheet = workbook.getSheetAt(0);
            int lastRow = sheet.getLastRowNum();
            Row titleRow = sheet.getRow(0);
            int lastCell = titleRow.getLastCellNum();
            if (!(lastCell >= 6 && "\u5b57\u6bb5\u503c".equals(titleRow.getCell(1).getStringCellValue()) && "\u6807\u7b7e\u540d".equals(titleRow.getCell(2).getStringCellValue()) && "\u5b57\u5178\u7c7b\u522b(dict_class)".equals(titleRow.getCell(3).getStringCellValue()) && "\u7236\u5b57\u5178\u7c7b\u522b(p_dict_class)".equals(titleRow.getCell(4).getStringCellValue()) && "\u7236\u5b57\u6bb5\u503c(parent_class)".equals(titleRow.getCell(5).getStringCellValue()) && "\u5b57\u6bb5Id".equals(titleRow.getCell(6).getStringCellValue()))) {
                throw new BaseException("\u5bfc\u5165Excel\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 1; i <= lastRow; ++i) {
                Row row = sheet.getRow(i);
                ArrayList<String> cells = new ArrayList<String>();
                boolean rowEmpty = true;
                for (int j = 0; j < lastCell; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell != null && cell.getCellType() != CellType.BLANK) {
                        rowEmpty = false;
                        if (cell.getCellType() == CellType.NUMERIC) {
                            double numericCellValue = cell.getNumericCellValue();
                            DecimalFormat df = new DecimalFormat("0");
                            cells.add(df.format(numericCellValue));
                            continue;
                        }
                        cells.add(cell.getStringCellValue());
                        continue;
                    }
                    cells.add(null);
                }
                if (rowEmpty) continue;
                String dId = (String)cells.get(6);
                long dictId = IdWorker.getId((Object)new TransDictSingle());
                if (HussarUtils.isNotBlank((CharSequence)dId)) {
                    dictId = Long.parseLong(dId);
                }
                if (HussarUtils.isBlank((CharSequence)((CharSequence)cells.get(1)))) {
                    throw new BaseException("\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (HussarUtils.isBlank((CharSequence)((CharSequence)cells.get(2)))) {
                    throw new BaseException("\u6807\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (HussarUtils.isBlank((CharSequence)((CharSequence)cells.get(3)))) {
                    throw new BaseException("\u5b57\u5178\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                transDictSingleList.add(new TransDictSingle((String)cells.get(1), (String)cells.get(2), (String)cells.get(3), (String)cells.get(4), (String)cells.get(5), dictId));
            }
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new BaseException("\u627e\u4e0d\u5230\u6587\u4ef6");
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new BaseException("\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
        }
        this.saveDictSingle(transDictSingleList);
        return ApiResponse.success((Object)true);
    }

    @Override
    public ResponseEntity<byte[]> exportExcelModel() {
        org.springframework.core.io.Resource resource = new PathMatchingResourcePatternResolver().getResource("classpath:/model/dict-single-model.xlsx");
        try {
            InputStream input = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)input);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)bytes);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public DicSingle getDictSingle(TransDictSingle transDictSingle, Long parentId, Long typeId) {
        DicSingle dicSingle = new DicSingle();
        dicSingle.setId(transDictSingle.getDictId());
        dicSingle.setValue(transDictSingle.getValue());
        dicSingle.setLabel(transDictSingle.getName());
        if (typeId != null) {
            dicSingle.setTypeId(typeId);
        }
        if (parentId != null) {
            dicSingle.setParentId(parentId);
        }
        return dicSingle;
    }

    public static Map<String, Object> MultipartFileToFile(MultipartFile multiFile) {
        String fileName = multiFile.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("prefix", prefix);
        try {
            File file = File.createTempFile(fileName.substring(0, fileName.lastIndexOf(46)), prefix);
            multiFile.transferTo(file);
            result.put("file", file);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BaseException("\u6587\u4ef6\u8f6c\u6362\u9519\u8bef");
        }
    }

    public List<DicSingle> getAllRemainSingles(List<DicSingle> allDicSingle, List<TransDictSingle> transDictSingleList, List<TransDictSingle> allTransSingle, TransDictSingle transDictSingle, List<DicSingle> remainSingle) {
        TransDictSingle grandparentTransDictSingle = this.getDicTypeId(allTransSingle, transDictSingle, transDictSingleList);
        if (ToolUtil.isNotEmpty((Object)grandparentTransDictSingle)) {
            DicSingle grandparentSingle = null;
            for (DicSingle item : allDicSingle) {
                if (!grandparentTransDictSingle.getDictId().equals(item.getId())) continue;
                grandparentSingle = item;
            }
            TransDictSingle parentTransSingle = null;
            for (TransDictSingle item : allTransSingle) {
                if (!transDictSingle.getpDictClass().equals(item.getDictClass()) || !transDictSingle.getParentClass().equals(item.getValue())) continue;
                parentTransSingle = item;
            }
            if (ToolUtil.isEmpty(parentTransSingle)) {
                for (TransDictSingle item : transDictSingleList) {
                    if (!transDictSingle.getpDictClass().equals(item.getDictClass()) || !transDictSingle.getParentClass().equals(item.getValue())) continue;
                    parentTransSingle = item;
                }
            }
            remainSingle.add(this.getDictSingle(transDictSingle, parentTransSingle.getDictId(), grandparentSingle.getTypeId()));
            return remainSingle;
        }
        throw new BaseException("\u5bfc\u5165\u6570\u636e\u5b58\u5728\u672a\u5173\u8054\u4e0a\u7ea7\u7684\u5b57\u6bb5");
    }

    public TransDictSingle getDicTypeId(List<TransDictSingle> allTransSingle, TransDictSingle transDictSingle, List<TransDictSingle> transDictSingleList) {
        TransDictSingle parentTransDictSingle = null;
        for (TransDictSingle item : allTransSingle) {
            if (!transDictSingle.getpDictClass().equals(item.getDictClass()) || !transDictSingle.getParentClass().equals(item.getValue())) continue;
            parentTransDictSingle = item;
        }
        if (ToolUtil.isNotEmpty(parentTransDictSingle)) {
            return parentTransDictSingle;
        }
        for (TransDictSingle item : transDictSingleList) {
            if (!transDictSingle.getpDictClass().equals(item.getDictClass()) || !transDictSingle.getParentClass().equals(item.getValue())) continue;
            return this.getDicTypeId(allTransSingle, item, transDictSingleList);
        }
        return null;
    }

    public List<Long> removeChildrenList(DicSingle dicSingle, List<Long> ids) {
        ids.add(dicSingle.getId());
        List<DicSingle> childrenSingleList = this.eomsDictSingleMapper.childrenList(dicSingle.getId());
        if (childrenSingleList.size() > 0) {
            for (DicSingle item : childrenSingleList) {
                this.removeChildrenList(item, ids);
            }
        }
        return ids;
    }

    @Override
    public void saveDictSingle(List<TransDictSingle> dictSingleList) {
        this.recursionDictSingle(dictSingleList, 0);
    }

    private void recursionDictSingle(List<TransDictSingle> dictSingleList, int num) {
        if (num <= this.maxDictLevel - 1 && dictSingleList.size() > 0) {
            List<TransDictSingle> errorList = this.addOrUpdateDictSingle(dictSingleList);
            this.recursionDictSingle(errorList, ++num);
        } else if (dictSingleList.size() > 0) {
            this.addOrUpdateDictSingle(dictSingleList);
        }
    }

    private List<TransDictSingle> addOrUpdateDictSingle(List<TransDictSingle> dictSingleList) {
        ArrayList<TransDictSingle> errorList = new ArrayList<TransDictSingle>();
        for (TransDictSingle tmp : dictSingleList) {
            QueryWrapper ew;
            Long dictId = tmp.getDictId();
            String value = tmp.getValue();
            String name = tmp.getName();
            String dictClass = tmp.getDictClass();
            String pDictClass = tmp.getpDictClass();
            String parentClass = tmp.getParentClass();
            if (ToolUtil.isEmpty((Object)dictClass) || ToolUtil.isEmpty((Object)value)) continue;
            boolean childFlag = true;
            Long typeId = 0L;
            if (ToolUtil.isEmpty((Object)pDictClass) || ToolUtil.isEmpty((Object)parentClass)) {
                ew = new QueryWrapper();
                ew.eq((Object)"TYPE_NAME", (Object)dictClass);
                DicType dicType = (DicType)this.sysDicTypeService.getOne((Wrapper)ew, false);
                if (!ToolUtil.isNotEmpty((Object)dicType)) continue;
                childFlag = false;
                typeId = dicType.getId();
            } else {
                ew = new QueryWrapper();
                ew.eq((Object)"BAK_1", (Object)pDictClass);
                ew.eq((Object)"VALUE", (Object)parentClass);
                DicSingle parentDicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)ew, false);
                if (ToolUtil.isNotEmpty((Object)parentDicSingle)) {
                    typeId = parentDicSingle.getId();
                } else {
                    errorList.add(tmp);
                    continue;
                }
            }
            DicDto dicDto = new DicDto();
            DicSingle dicSingle = new DicSingle();
            boolean addFlag = true;
            QueryWrapper ew2 = new QueryWrapper();
            ew2.eq((Object)"BAK_1", (Object)dictClass);
            ew2.eq((Object)"VALUE", (Object)value);
            DicSingle dicSingleInfo = (DicSingle)this.sysDicSingleService.getOne((Wrapper)ew2, false);
            if (ToolUtil.isNotEmpty((Object)dicSingleInfo)) {
                addFlag = false;
                dictId = dicSingleInfo.getId();
                dicDto.setDictId(dictId);
                dicDto.setDictName(name);
                dicDto.setDictTypeCode(value);
                dicDto.setDictTypeId(typeId);
                dicDto.setDelIdString("");
                dicDto.setDictValues("");
                dicDto.setFlag("justSingle");
            }
            dicSingle.setId(dictId);
            dicSingle.setBak1(dictClass);
            dicSingle.setDictClass(dictClass);
            dicSingle.setpDictClass(pDictClass);
            dicSingle.setParentClass(parentClass);
            try {
                if (addFlag) {
                    if (!childFlag) {
                        this.dictService.saveDicSingle(null, typeId, name, value, dicSingle);
                        continue;
                    }
                    this.dictService.saveSingleChild(null, typeId, name, value, dicSingle);
                    continue;
                }
                this.dictService.updateNewDict(dicDto, dicSingle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return errorList;
    }
}

