/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.idtable.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.dao.SysIdtableInfoMapper;
import com.jxdinfo.hussar.general.idtable.dao.SysSerialtableMapper;
import com.jxdinfo.hussar.general.idtable.model.SysIdtableInfo;
import com.jxdinfo.hussar.general.idtable.model.SysSerialtable;
import com.jxdinfo.hussar.general.idtable.service.ISysSerialtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysSerialtableServiceImpl
extends HussarServiceImpl<SysSerialtableMapper, SysSerialtable>
implements ISysSerialtableService {
    @Resource
    ISysSerialtableService sysSerialtableService;
    @Resource
    SysSerialtableMapper sysSerialtableMapper;
    @Resource
    SysIdtableInfoMapper sysIdtableInfoMapper;

    public IPage<SysSerialtable> queryList(Page page, SysSerialtable sysSerialtable) {
        if (ToolUtil.isEmpty((Object)sysSerialtable) || ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysSerialtable.getFieldName()), SysSerialtable::getFieldName, (Object)sysSerialtable.getFieldName())).like(!StringUtils.isEmpty((Object)sysSerialtable.getSerialDesc()), SysSerialtable::getSerialDesc, (Object)sysSerialtable.getSerialDesc());
        IPage sysSerialtableIPage = this.sysSerialtableMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return sysSerialtableIPage;
    }

    @DSTransactional
    public ApiResponse<Tip> deleteByIds(List<String> ids) {
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        if (!this.removeByIds(ids)) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
        this.sysIdtableInfoMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysIdtableInfo::getIdtableId, ids));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> updateSerialtable(SysSerialtable sysSerialtable) {
        String fieldName = sysSerialtable.getFieldName();
        SysSerialtable Serialtable = this.sysSerialtableMapper.getSerialtableByQuery(fieldName);
        if (ToolUtil.isNotEmpty((Object)Serialtable) && !Serialtable.getId().equals(sysSerialtable.getId())) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (!this.updateById((BaseEntity)sysSerialtable)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> saveSerialtable(SysSerialtable sysSerialtable) {
        if (ToolUtil.isEmpty((Object)sysSerialtable.getFieldName())) {
            throw new BaseException("\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysSerialtable.getSerialDesc())) {
            throw new BaseException("\u4e2d\u6587\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysSerialtable.getSerialValue())) {
            throw new BaseException("\u5f53\u524d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysSerialtable.getCacheSize())) {
            throw new BaseException("\u9012\u589e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fieldName = sysSerialtable.getFieldName();
        sysSerialtable.setFieldName(fieldName.toUpperCase());
        SysSerialtable serialtable = this.sysSerialtableMapper.getSerialtableByQuery(fieldName);
        if (ToolUtil.isNotEmpty((Object)serialtable)) {
            throw new BaseException("\u4e1a\u52a1\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (!this.save((BaseEntity)sysSerialtable)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public JSONArray queryList(String name) {
        JSONArray jsonArray = new JSONArray();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if ("".equals(name)) {
            queryWrapper.select(new SFunction[0]);
        } else {
            queryWrapper.like(SysSerialtable::getSerialDesc, (Object)name);
        }
        List list = this.sysSerialtableService.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            for (SysSerialtable sysSerialtable : list) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)sysSerialtable.getId());
                jsonObject.put("serialDesc", (Object)sysSerialtable.getSerialDesc());
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    public JSONArray querySerialData(String ids) {
        String[] idStr;
        JSONArray jsonArray = new JSONArray();
        if ("".equals(ids)) {
            return jsonArray;
        }
        for (String s : idStr = ids.split(",")) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            JSONObject jsonObject = new JSONObject();
            queryWrapper.eq(SysSerialtable::getId, (Object)s);
            if (!ToolUtil.isNotEmpty((Object)this.sysSerialtableService.list((Wrapper)queryWrapper))) continue;
            SysSerialtable sysSerialtable = (SysSerialtable)this.sysSerialtableService.list((Wrapper)queryWrapper).get(0);
            String rule = sysSerialtable.getEncodingRules();
            BigDecimal serialValue = sysSerialtable.getSerialValue();
            int isIncludeTime = sysSerialtable.getIsIncludeTime();
            String month = "";
            String day = "";
            Calendar now = Calendar.getInstance();
            int refreshRule = sysSerialtable.getRefreshRule();
            String year = String.valueOf(now.get(1));
            month = now.get(2) + 1 < 10 ? "0" + (now.get(2) + 1) : "" + (now.get(2) + 1);
            String string = day = now.get(5) < 10 ? "0" + now.get(5) : "" + now.get(5);
            if (isIncludeTime == 1) {
                rule = rule.replace("#yyyy#", year);
                rule = rule.replace("#yyyy-MM#", year + month);
                rule = rule.replace("#yyyy-MM-dd#", year + month + day);
            }
            StringBuilder realNum = new StringBuilder(serialValue.add(sysSerialtable.getCacheSize()).toString());
            LambdaQueryWrapper sysIdtableInfoLambdaQueryWrapper = new LambdaQueryWrapper();
            String temp = "";
            switch (refreshRule) {
                case 0: {
                    break;
                }
                case 1: {
                    temp = String.valueOf(now.get(1));
                    break;
                }
                case 2: {
                    temp = year + month;
                    break;
                }
                case 3: {
                    temp = year + month + day;
                    break;
                }
            }
            sysIdtableInfoLambdaQueryWrapper.eq(SysIdtableInfo::getIdtableId, (Object)s);
            BigDecimal value = serialValue;
            if (refreshRule != 0 && this.sysIdtableInfoMapper.selectList((Wrapper)sysIdtableInfoLambdaQueryWrapper).isEmpty()) {
                realNum = new StringBuilder(sysSerialtable.getSerialValue().add(sysSerialtable.getCacheSize()).toString());
                value = sysSerialtable.getSerialValue().add(sysSerialtable.getCacheSize());
            } else {
                ((LambdaQueryWrapper)sysIdtableInfoLambdaQueryWrapper.eq(SysIdtableInfo::getParentNumber, (Object)temp)).eq(SysIdtableInfo::getIdtableId, (Object)s);
                if (refreshRule != 0 && this.sysIdtableInfoMapper.selectList((Wrapper)sysIdtableInfoLambdaQueryWrapper).isEmpty()) {
                    realNum = new StringBuilder("1");
                    value = new BigDecimal(1);
                }
            }
            BigDecimal serialLength = sysSerialtable.getSerialLength();
            if (serialLength.compareTo(BigDecimal.valueOf(realNum.length())) >= 0) {
                while (serialLength.compareTo(BigDecimal.valueOf(realNum.length())) > 0) {
                    realNum.insert(0, "0");
                }
                jsonObject.put("tooLong", (Object)false);
            } else {
                jsonObject.put("tooLong", (Object)true);
            }
            rule = rule.replace("@#\uffe5", realNum.toString());
            jsonObject.put("serial", (Object)rule);
            jsonObject.put("serialId", (Object)s);
            jsonObject.put("value", (Object)value);
            jsonObject.put("date", (Object)temp);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public ApiResponse<Tip> checkSerial(String serialId, String value, String date) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper sysIdtableInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)sysIdtableInfoLambdaQueryWrapper.eq(SysIdtableInfo::getParentNumber, (Object)date)).eq(SysIdtableInfo::getIdtableId, (Object)serialId);
        lambdaQueryWrapper.eq(SysSerialtable::getId, (Object)Long.valueOf(serialId));
        SysSerialtable sysSerialtable = (SysSerialtable)this.sysSerialtableService.list((Wrapper)lambdaQueryWrapper).get(0);
        BigDecimal bigDecimal = new BigDecimal(value).add(sysSerialtable.getCacheSize());
        if (bigDecimal.compareTo(sysSerialtable.getSerialValue()) > 0 || this.sysIdtableInfoMapper.selectList((Wrapper)sysIdtableInfoLambdaQueryWrapper).isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(serialId);
            stringBuffer.append(",").append(date).append(",").append(value);
            return ApiResponse.success((String)stringBuffer.toString());
        }
        return ApiResponse.fail((String)"\u5931\u8d25\uff01");
    }

    public ApiResponse<Tip> updateOrSave(String serialId, String date, String value) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysSerialtable::getId, (Object)serialId);
        SysSerialtable sysSerialtable = (SysSerialtable)this.sysSerialtableService.list((Wrapper)lambdaQueryWrapper).get(0);
        if (sysSerialtable.getRefreshRule() != 0) {
            LambdaQueryWrapper sysIdtableInfoLambdaQueryWrapper = new LambdaQueryWrapper();
            SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
            sysIdtableInfoLambdaQueryWrapper.eq(SysIdtableInfo::getIdtableId, (Object)serialId);
            if (this.sysIdtableInfoMapper.selectList((Wrapper)sysIdtableInfoLambdaQueryWrapper).isEmpty()) {
                sysSerialtable.setSerialValue(new BigDecimal(value));
                sysIdtableInfo.setIdValue(value);
                sysIdtableInfo.setIdtableId(Long.valueOf(serialId));
                sysIdtableInfo.setParentNumber(date);
                this.sysIdtableInfoMapper.insert(sysIdtableInfo);
            } else {
                ((LambdaQueryWrapper)sysIdtableInfoLambdaQueryWrapper.eq(SysIdtableInfo::getParentNumber, (Object)date)).eq(SysIdtableInfo::getIdtableId, (Object)serialId);
                if (this.sysIdtableInfoMapper.selectList((Wrapper)sysIdtableInfoLambdaQueryWrapper).isEmpty()) {
                    sysSerialtable.setSerialValue(new BigDecimal("1"));
                    sysIdtableInfo.setIdValue("1");
                    sysIdtableInfo.setIdtableId(Long.valueOf(serialId));
                    sysIdtableInfo.setParentNumber(date);
                    this.sysIdtableInfoMapper.insert(sysIdtableInfo);
                } else {
                    sysSerialtable.setSerialValue(sysSerialtable.getSerialValue().add(sysSerialtable.getCacheSize()));
                    sysIdtableInfo.setIdValue(sysSerialtable.getSerialValue().toString());
                    this.sysIdtableInfoMapper.update(sysIdtableInfo, (Wrapper)sysIdtableInfoLambdaQueryWrapper);
                }
            }
        } else {
            sysSerialtable.setSerialValue(new BigDecimal(value).add(sysSerialtable.getCacheSize()));
        }
        this.saveOrUpdate((BaseEntity)sysSerialtable);
        return ApiResponse.success((String)"\u6210\u529f\uff01");
    }
}

