/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.stereotype.Service;

@Service
public class SysDicSingleServiceImpl
extends HussarServiceImpl<SysDicSingleMapper, DicSingle>
implements ISysDicSingleService {
    @Resource
    private SysDicTypeMapper dicTypeMapper;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;

    public void evictTypeCacheBySingleId(Long id) {
        DicSingle dic = (DicSingle)this.getById(id);
        DicType type = (DicType)this.dicTypeMapper.selectById(dic.getTypeId());
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName()));
        }
    }

    public List<DicVo> getDicListByType(Long typeId) {
        return this.sysDicSingleMapper.getDicListByType(typeId);
    }

    public List<DicVo> getCertainDictOptions(Long typeId, String[] optionValues) {
        return this.sysDicSingleMapper.getCertainDictOptions(typeId, optionValues);
    }

    public List<DicVo> getDictOptionsWithoutNotShows(Long typeId, String[] notShows) {
        return this.sysDicSingleMapper.getDictOptionsWithoutNotShows(typeId, notShows);
    }

    public String getDictLabel(Long typeId, String value) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setValue(value);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)this.sysDicSingleMapper.selectOne((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)dic)) {
            return dic.getLabel();
        }
        return "";
    }

    public String getDictValue(Long typeId, String label) {
        DicSingle t = new DicSingle();
        t.setTypeId(typeId);
        t.setLabel(label);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)t);
        DicSingle dic = (DicSingle)this.sysDicSingleMapper.selectOne((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty((Object)dic)) {
            return dic.getValue();
        }
        return "";
    }

    public ApiResponse deleteSingle(List<String> ids) {
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)"dict_of_type:");
        if (!this.removeByIds(ids)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<DicSingle> selectById(String dictId) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u67e5\u8be2");
        }
        return ApiResponse.success((Object)this.getById((Serializable)((Object)dictId)));
    }

    public String changeToPinyin(String chineseName, HanyuPinyinCaseType caseType) {
        char[] clChars = chineseName.trim().toCharArray();
        String hanyupinyin = "";
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (int i = 0; i < clChars.length; ++i) {
                hanyupinyin = String.valueOf(clChars[i]).matches("[\u4e00-\u9fa5]+") ? hanyupinyin + PinyinHelper.toHanyuPinyinStringArray((char)clChars[i], (HanyuPinyinOutputFormat)defaultFormat)[0] : hanyupinyin + clChars[i];
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return hanyupinyin;
    }
}

