/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.theme.dao.ThemeMapper;
import com.jxdinfo.hussar.theme.model.Theme;
import com.jxdinfo.hussar.theme.service.IThemeService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ThemeServiceImpl
extends HussarServiceImpl<ThemeMapper, Theme>
implements IThemeService {
    @Resource
    private ThemeMapper themeMapper;
    @Resource
    private GlobalProperties globalProperties;

    public String queryUserTheme() {
        SecurityUser shiroUser;
        Theme t;
        String result = this.globalProperties.getDefaultTheme();
        if (this.globalProperties.isChangeTheme() && ToolUtil.isNotEmpty((Object)(t = (Theme)this.themeMapper.selectById((shiroUser = BaseSecurityUtil.getUser()).getId())))) {
            result = t.getThemeType();
        }
        return result;
    }

    public String queryUserThemeWithUserId(Long userId) {
        Theme t;
        String result = this.globalProperties.getDefaultTheme();
        if (this.globalProperties.isChangeTheme() && ToolUtil.isNotEmpty((Object)(t = (Theme)this.themeMapper.selectById(userId)))) {
            result = t.getThemeType();
        }
        return result;
    }

    public ApiResponse<Tip> updateTheme(String theme) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Theme t = new Theme();
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            throw new BaseException("\u7528\u6237\u672a\u767b\u5f55");
        }
        t.setId(shiroUser.getId());
        t.setThemeType(theme);
        if (!super.saveOrUpdate((Object)t)) {
            return ApiResponse.success((String)"\u8bbe\u7f6e\u4e3b\u9898\u6210\u529f\uff01");
        }
        BaseSecurityUtil.setAttribute((String)"theme", (Object)this.queryUserTheme());
        throw new BaseException("\u8bbe\u7f6e\u4e3b\u9898\u6210\u529f\uff01");
    }
}

