/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.idtable.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.dao.SysIdtableInfoMapper;
import com.jxdinfo.hussar.general.idtable.dao.SysIdtableMapper;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.model.SysIdtableInfo;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SysIdtableServiceImpl
extends HussarServiceImpl<SysIdtableMapper, SysIdtable>
implements ISysIdtableService {
    @Resource
    SysIdtableMapper sysIdtableMapper;
    @Resource
    SysIdtableInfoMapper sysIdtableInfoMapper;

    public IPage<SysIdtable> queryList(Page page, SysIdtable sysIdtable) {
        if (ToolUtil.isEmpty((Object)sysIdtable) || ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.like(!StringUtils.isEmpty((Object)sysIdtable.getFieldName()), SysIdtable::getFieldName, (Object)sysIdtable.getFieldName())).like(!StringUtils.isEmpty((Object)sysIdtable.getTableName()), SysIdtable::getTableName, (Object)sysIdtable.getTableName());
        IPage sysIdtableIPage = this.sysIdtableMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return sysIdtableIPage;
    }

    public ApiResponse<Tip> saveIdtable(SysIdtable sysIdtable) {
        if (ToolUtil.isEmpty((Object)sysIdtable.getFieldName())) {
            throw new BaseException("\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sysIdtable.getFieldName().length() > 30) {
            throw new BaseException("\u4e1a\u52a1\u540d\u79f0\u6700\u957f\u4e0d\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getIdDesc())) {
            throw new BaseException("\u4e2d\u6587\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sysIdtable.getFieldName().length() > 30) {
            throw new BaseException("\u4e2d\u6587\u540d\u79f0\u6700\u957f\u4e0d\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getTableName())) {
            throw new BaseException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getIdLength())) {
            throw new BaseException("\u7f16\u53f7\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysIdtable.getCacheSize())) {
            throw new BaseException("\u9012\u589e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName();
        sysIdtable.setIsGlobal("0");
        sysIdtable.setTableName(tableName.toUpperCase());
        sysIdtable.setFieldName(fieldName.toUpperCase());
        SysIdtable idtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)idtable)) {
            throw new BaseException("\u4e1a\u52a1\u540d\u79f0\u548c\u4e1a\u52a1\u8868\u540d\u5df2\u5b58\u5728\uff01");
        }
        BigDecimal num = new BigDecimal(0);
        sysIdtable.setIdValue(num);
        if (!this.save(sysIdtable)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> updateIdtable(SysIdtable sysIdtable) {
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName();
        sysIdtable.setTableName(tableName.toUpperCase());
        SysIdtable idtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)idtable) && !idtable.getId().equals(sysIdtable.getId())) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (!this.updateById(sysIdtable)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse<Tip> deleteByIds(List<String> ids) {
        if (ToolUtil.isEmpty(ids)) {
            throw new BaseException("\u53c2\u6570\u4e3a\u7a7a\u65e0\u6cd5\u5220\u9664");
        }
        if (!this.removeByIds(ids)) {
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
        this.sysIdtableInfoMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysIdtableInfo::getIdtableId, ids));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @DSTransactional
    public synchronized String getCurrentCode(String fieldName, String tableName) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            String isPrefix = sysIdtable.getIsPrefix();
            String idPrefix = sysIdtable.getIdPrefix();
            String isSuffix = sysIdtable.getIsSuffix();
            String idSuffix = sysIdtable.getIdSuffix();
            StringBuilder currentCode = new StringBuilder();
            if ("1".equals(isPrefix)) {
                String lastDate;
                if (idPrefix.indexOf("[") == 0 && idPrefix.indexOf("]") == idPrefix.length() - 1) {
                    idPrefix = idPrefix.substring(1, idPrefix.length());
                    idPrefix = idPrefix.substring(0, idPrefix.length() - 1);
                    SimpleDateFormat sdf = new SimpleDateFormat(idPrefix);
                    idPrefix = sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                }
                if (!ToolUtil.equals((Object)(lastDate = sysIdtable.getLastDate()), (Object)idPrefix)) {
                    sysIdtable.setLastDate(idPrefix);
                    super.updateById((Object)sysIdtable);
                    sysIdtable.setIdValue(new BigDecimal(0));
                }
                currentCode.append(idPrefix);
            }
            BigDecimal result = sysIdtable.getIdValue().add(sysIdtable.getCacheSize());
            BigDecimal length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = result.toString();
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            currentCode.append(result);
            if ("1".equals(isSuffix)) {
                currentCode.append(idSuffix);
            }
            sysIdtable.setIdValue(result);
            this.sysIdtableMapper.updateById(sysIdtable);
            return currentCode.toString();
        }
        throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
    }

    @DSTransactional
    public synchronized String getCurrentCode(String fieldName, String tableName, String parentNumber) {
        SysIdtable sysIdtable = this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)sysIdtable)) {
            if (ToolUtil.equals((Object)sysIdtable.getIsLevel(), (Object)"0")) {
                throw new BaseException("\u7f16\u7801\u89c4\u5219\u4e0d\u662f\u5c42\u7ea7\u7801");
            }
            List<SysIdtableInfo> list = this.sysIdtableMapper.getIdTableByParentNumber(fieldName, tableName, parentNumber);
            if (list.size() == 0) {
                SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
                sysIdtableInfo.setId(null);
                sysIdtableInfo.setIdtableId(sysIdtable.getId());
                sysIdtableInfo.setIdValue("1");
                sysIdtableInfo.setParentNumber(parentNumber);
                this.sysIdtableInfoMapper.insert(sysIdtableInfo);
                BigDecimal length = sysIdtable.getIdLength();
                String idLength = length.toString();
                int zeroLength = Integer.valueOf(idLength) - sysIdtableInfo.getIdValue().length();
                StringBuffer currentCode = new StringBuffer();
                if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                    currentCode.append(parentNumber);
                }
                for (int i = 0; i < zeroLength; ++i) {
                    currentCode.append("0");
                }
                if (zeroLength < 0) {
                    throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
                }
                currentCode.append(sysIdtableInfo.getIdValue());
                return currentCode.toString();
            }
            int result = Integer.parseInt(list.get(0).getIdValue()) + sysIdtable.getCacheSize().intValue();
            BigDecimal length = sysIdtable.getIdLength();
            String idLength = length.toString();
            String resultCode = String.valueOf(result);
            int zeroLength = Integer.valueOf(idLength) - resultCode.length();
            StringBuilder currentCode = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)parentNumber)) {
                currentCode.append(parentNumber);
            }
            for (int i = 0; i < zeroLength; ++i) {
                currentCode.append("0");
            }
            if (zeroLength < 0) {
                throw new BaseException("\u7f16\u7801\u8d85\u51fa\u89c4\u5b9a\u7684\u957f\u5ea6");
            }
            currentCode.append(result);
            SysIdtableInfo sysIdtableInfo = new SysIdtableInfo();
            sysIdtableInfo.setId(list.get(0).getId());
            sysIdtableInfo.setIdValue(resultCode);
            this.sysIdtableInfoMapper.updateById(sysIdtableInfo);
            return currentCode.toString();
        }
        throw new BaseException("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219");
    }

    public SysIdtable getIdtableByQuery(String fieldName, String tableName) {
        return this.sysIdtableMapper.getIdtableByQuery(fieldName, tableName);
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        List idTable = this.sysIdtableMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idTable", idTable);
        data.put("export_type", "idTable");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "idtable_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    public ApiResponse importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"idTable".equals(export_type)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("idTable")));
        }
        List idtable = (List)data.get("idTable");
        Map<String, Integer> count = this.insertOrUpdateList(idtable);
        return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002"));
    }

    public JSONObject importIdTableData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"idTable".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"idTable");
            return result;
        }
        List idtable = (List)data.get("idTable");
        Map<String, Integer> count = this.insertOrUpdateList(idtable);
        result.put("success", (Object)"true");
        result.put("insertCount", (Object)count.get("insert"));
        result.put("updateCount", (Object)count.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<SysIdtable> idTableList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(idTableList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = idTableList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)idTableList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)idTableList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

