/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.general.dict.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dto.DicDto;
import com.jxdinfo.hussar.general.dict.dto.DicGroupDto;
import com.jxdinfo.hussar.general.dict.dto.DicSingleDto;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.general.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dicFront"})
@Api(tags={"\u7cfb\u7edf\u5b57\u5178\u7ba1\u7406"})
public class SysDicFrontController
extends HussarBaseController<DicSingle, ISysDicSingleService> {
    private String prefix = "/core/sys/dict/";
    private String flagOfEdit = "haveType";
    private String flagOfAdd = "0";
    @Resource
    private ISysDicService dictService;
    @Resource
    private SysDicFrontService sysDicFrontService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicRefService sysDicRefService;

    @GetMapping(value={"/getDictByCode"})
    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178", notes="\u83b7\u53d6\u5b57\u5178")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u7c7b\u522b\u540d", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5b57\u5178", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicVo>> getDictByCode(String code) {
        List list = this.sysDicRefService.getDicListByType(code);
        return ApiResponse.success((Object)list);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u65b0\u589e", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u522b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicType", value="\u6570\u636e\u5b57\u5178\u7c7b\u578b\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b57\u5178\u7c7b\u522b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse add(@RequestBody DicType dicType) {
        Long parentId = dicType.getParentId();
        String dictName = dicType.getTypeDescription();
        String dictTypeCode = dicType.getTypeName();
        String dictValues = null;
        return this.dictService.addDictType(parentId, dictName, dictTypeCode, dictValues);
    }

    @PostMapping(value={"/add_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u6dfb\u52a0", notes="\u65b0\u589e\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicSingleDto", value="\u6570\u636e\u5b57\u5178Dto", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addSingle(@RequestBody DicSingleDto dicSingleDto) {
        Long dictId = dicSingleDto.getId();
        Long dictTypeId = dicSingleDto.getTypeId();
        String dictName = dicSingleDto.getLabel();
        String dictValue = dicSingleDto.getValue();
        String flag = dicSingleDto.getFlag();
        if (this.flagOfAdd.equals(flag)) {
            return this.dictService.saveDicSingle(dictId, dictTypeId, dictName, dictValue);
        }
        return this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue);
    }

    @PostMapping(value={"/addGroup"})
    @ApiOperation(value="\u5b57\u5178\u65b0\u589e", notes="\u65b0\u589e\u5b57\u5178\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicGroup", value="\u5b57\u5178\u5206\u7ec4DTO", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u65b0\u589e\u5b57\u5178\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addGroup(@RequestBody DicGroup dicGroup) {
        return this.dictService.saveDicGroup(dicGroup);
    }

    @PostMapping(value={"/editGroup"})
    @ApiOperation(value="\u5b57\u5178\u4fee\u6539", notes="\u4fee\u6539\u5b57\u5178\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicGroup", value="\u5b57\u5178\u5206\u7ec4\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u4fee\u6539\u5b57\u5178\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editGroup(@RequestBody DicGroup dicGroup) {
        return this.dictService.updateDictGroup(dicGroup);
    }

    @PostMapping(value={"/update_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u4fee\u6539", notes="\u4fee\u6539\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicSingleDto", value="\u6570\u636e\u5b57\u5178\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u4fee\u6539\u67d0\u5b57\u5178\u6761\u76ee\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editSingle(@RequestBody DicSingle dicSingle) {
        Long dictId = dicSingle.getId();
        Long dictTypeId = dicSingle.getTypeId();
        String dictName = dicSingle.getLabel();
        String dictValue = dicSingle.getValue();
        return this.dictService.updateDicSingle(dictId, dictTypeId, dictName, dictValue);
    }

    @GetMapping(value={"/dicGroupList"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\uff1b\u52a8\u6001\u62fc\u63a5\u4e0a'\u7cfb\u7edf\u5b57\u5178'\u3001'\u4e1a\u52a1\u5b57\u5178'\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="dicGroupDto", value="\u5b57\u5178\u5206\u7ec4\u5b9e\u4f53", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<DicGroup>> dicGroupList(Page page, DicGroupDto dicGroupDto) {
        return ApiResponse.success((Object)this.dicGroupService.queryList(page, dicGroupDto));
    }

    @GetMapping(value={"/getList/{rangeType}"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5217\u8868", notes="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u7ec4\uff1b\u52a8\u6001\u62fc\u63a5\u4e0a'\u7cfb\u7edf\u5b57\u5178'\u3001'\u4e1a\u52a1\u5b57\u5178'\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="rangeType", value="\u7f16\u8f91\u7c7b\u578b", required=true, paramType="path")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<DicType>> list(Page page, @PathVariable(value="rangeType") String rangeType) {
        return ApiResponse.success((Object)this.dicTypeService.queryList(page, rangeType));
    }

    @GetMapping(value={"/list_single/{dictTypeId}"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", notes="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="dictTypeId", value="\u7c7b\u578b(sys_dict_type\u5916\u952e)", required=true, paramType="path")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<DicSingle>> listSingle(Page page, @PathVariable(value="dictTypeId") String dictTypeId) {
        return ApiResponse.success((Object)this.dictService.queryListSingle(page, dictTypeId));
    }

    @GetMapping(value={"/query_single"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", notes="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="dictTypeId", value="\u7c7b\u578b(sys_dict_type\u5916\u952e)", required=true, paramType="query"), @ApiImplicitParam(name="parentId", value="\u7236ID", required=true, paramType="path")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<DicSingle>> querySingle(Page page, @RequestParam(value="dictTypeId") String dictTypeId, @RequestParam(value="parentId", required=false) String parentId) {
        return ApiResponse.success((Object)this.dictService.queryListSingle(page, dictTypeId, parentId));
    }

    @GetMapping(value={"/detail/{dictId}"})
    @ApiOperation(value="\u5b57\u5178\u8be6\u60c5", notes="\u5b57\u5178\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictId", value="\u6570\u636e\u5b57\u5178\u4e3b\u952e", required=true, paramType="path")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<DicSingle> openSingleDetail(@PathVariable(value="dictId") String dictId) {
        return this.dicSingleService.selectById(dictId);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u4fee\u6539", notes="\u5b57\u5178\u7c7b\u522b\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicDto", value="\u4fee\u6539\u5b57\u5178Dto", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u7c7b\u522b\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse update(@RequestBody DicDto dicDto) {
        return this.dictService.updateNewDict(dicDto);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5b57\u5178\u7c7b\u522b\u5220\u9664", notes="\u5b57\u5178\u7c7b\u522b\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictId", value="\u5220\u9664\u4e3b\u952e", required=true, paramType="form")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u7c7b\u522b\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delete(@RequestBody String dictId) {
        String[] strArr = dictId.split(",");
        return this.dictService.deleteCascadeDict(strArr);
    }

    @PostMapping(value={"/delete_single"})
    @ApiOperation(value="\u5b57\u5178\u5b57\u6bb5\u5220\u9664", notes="\u5b57\u5178\u5b57\u6bb5\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictId", value="\u5220\u9664\u4e3b\u952e", required=true, paramType="form")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u5b57\u6bb5\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse deleteSingle(@RequestBody String dictId) {
        String[] strarr = dictId.split(",");
        List<String> list = Arrays.asList(strarr);
        return this.dicSingleService.deleteSingle(list);
    }

    @GetMapping(value={"/dicTypeTree"})
    @ApiOperation(value="\u521d\u59cb\u5316\u5b57\u5178\u6811", notes="\u521d\u59cb\u5316\u5b57\u5178\u6811")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u521d\u59cb\u5316\u5b57\u5178\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicTypeTreeData() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("root");
        result.add(root);
        result.addAll(this.sysDicFrontService.queryDicTypeTreeData());
        return ApiResponse.success((Object)ForestNodeMerger.merge(result));
    }

    @GetMapping(value={"/dicOrderTree"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5", notes="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5\u8fdb\u884c\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", value="\u6392\u5e8f\u4e3b\u952e", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4e0b\u7ea7\u5b57\u5178\u5b57\u6bb5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicOrderTreeData(DicType dicType) {
        Long typeId = dicType.getId();
        if (ToolUtil.isEmpty((Object)typeId)) {
            return ApiResponse.success(new ArrayList());
        }
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysDicFrontService.queryDicOrderTreeData(typeId)));
    }

    @PostMapping(value={"/saveDicOrder"})
    @ApiOperation(value="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f", notes="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictId", value="\u6392\u5e8f\u4e3b\u952e", required=true, paramType="form")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveDicOrder(@RequestBody String orderInfo) {
        return this.dictService.updateDicOrder(orderInfo);
    }

    @PostMapping(value={"/singleMove"})
    @ApiOperation(value="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb", notes="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicSingleDto", value="\u6570\u636e\u5b57\u5178Dto", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNode(@RequestBody DicSingleDto dicSingleDto) {
        return this.dictService.updateMoveNode(dicSingleDto);
    }

    @GetMapping(value={"/selectListByParentId"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicType>> selectListByParentId() {
        return ApiResponse.success((Object)this.dicTypeService.selectListByParentId());
    }

    @GetMapping(value={"/selectListByTypeName"})
    @ApiOperation(value="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", notes="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dicType", value="\u6570\u636e\u5b57\u5178\u7c7b\u578bDto", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicSingle>> selectListByTypeName(DicType dicType) {
        return ApiResponse.success((Object)this.sysDicRefService.getDictByType(dicType.getTypeName()));
    }

    @GetMapping(value={"/selectChildsById"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55", notes="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicSingle>> selectChildsById(String id) {
        return ApiResponse.success((Object)this.dicTypeService.selectChildsById(id));
    }

    @GetMapping(value={"/dicExportTree"})
    @ApiOperation(value="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811", notes="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u5b57\u5178\u5bfc\u51fa\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> dicExportTreeData() {
        return this.dictService.queryExportTreeData();
    }

    @PostMapping(value={"/exportDict"})
    @ApiOperation(value="\u5b57\u5178\u5bfc\u51fa", notes="\u5bfc\u51fa\u5b57\u5178\u6587\u4ef6")
    @AuditLog(moduleName="\u5b57\u5178\u7ba1\u7406", eventDesc="\u5b57\u5178\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(HttpServletResponse response, @RequestBody String typeIds) {
        List<String> typeIdList = Arrays.asList(typeIds.split(","));
        this.dicTypeService.exportDict(typeIdList, response);
    }

    @RequestMapping(value={"/changeToPinyinLow"})
    @ResponseBody
    public ApiResponse<String> changeToPinyinLow(@RequestBody Map<String, String> map) {
        String beforeChangeStr = map.get("chineseName");
        String afterChangeStr = this.dicSingleService.changeToPinyin(beforeChangeStr, HanyuPinyinCaseType.LOWERCASE);
        return ApiResponse.success((String)afterChangeStr);
    }
}

