/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.idtable.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.idtable.model.SysIdtable;
import com.jxdinfo.hussar.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.idtable.service.TableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/idtableFront"})
@Api(tags={"\u6700\u5927\u53f7\u8868\u7ba1\u7406"})
public class IdtableFrontController
extends HussarBaseController<SysIdtable, ISysIdtableService> {
    @Resource
    ISysIdtableService sysIdtableService;
    @Resource
    private TableService tableService;
    @Resource
    private DruidProperties druidProperties;

    @GetMapping(value={"/getAllTable"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u8868", notes="\u67e5\u8be2\u6240\u6709\u7684\u8868")
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6240\u6709\u7684\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Map<String, Object>>> getAllTable() throws SQLException {
        List list = this.tableService.getTables();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                Set se = ((Map)list.get(i)).keySet();
                for (String set : se) {
                    map.put(set.toUpperCase(), ((Map)list.get(i)).get(set).toString().toUpperCase());
                }
                newList.add(map);
            }
            return ApiResponse.success(newList);
        }
        return ApiResponse.success((Object)list);
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5217\u8868", notes="\u67e5\u8be2\u6700\u5927\u53f7\u8868\u5206\u9875\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868\u5b9e\u4f53", required=true, paramType="query")})
    @CheckPermission(value={"idtableFront:getList"})
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysIdtable>> list(Page page, SysIdtable sysIdtable) {
        return ApiResponse.success((Object)this.sysIdtableService.queryList(page, sysIdtable));
    }

    @ApiOperation(value="\u65b0\u589e\u6700\u5927\u53f7\u8868", notes="\u65b0\u589e\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868", required=true, paramType="body")})
    @PostMapping(value={"/addSave"})
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u65b0\u589e\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> addSave(@RequestBody SysIdtable sysIdtable) {
        return this.sysIdtableService.saveIdtable(sysIdtable);
    }

    @ApiOperation(value="\u4fee\u6539\u6700\u5927\u53f7\u8868", notes="\u4fee\u6539\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868", required=true, paramType="body")})
    @PostMapping(value={"/editSave"})
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u4fee\u6539\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> editSave(@RequestBody SysIdtable sysIdtable) {
        return this.sysIdtableService.updateIdtable(sysIdtable);
    }

    @ApiOperation(value="\u5220\u9664\u6700\u5927\u53f7\u8868", notes="\u5220\u9664\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u6700\u5927\u53f7\u8868\u4e3b\u952e", dataType="list", required=true, paramType="form")})
    @PostMapping(value={"/delByIds"})
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u5220\u9664\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delByIds(@RequestBody String ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u5220\u9664\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids1 = ids.split(",");
        return this.sysIdtableService.deleteByIds(Arrays.asList(ids1));
    }

    @PostMapping(value={"/exportData"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5bfc\u51fa", notes="\u6700\u5927\u53f7\u8868\u5bfc\u51fa")
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(HttpServletResponse response, @RequestBody JSONObject jsonObject) {
        if (ToolUtil.isEmpty((Object)jsonObject)) {
            throw new BaseException("\u5bfc\u51fa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ids = jsonObject.get((Object)"ids").toString();
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysIdtableService.exportData(idList, response);
    }

    @PostMapping(path={"/importData"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5bfc\u5165", notes="\u6700\u5927\u53f7\u8868\u5bfc\u5165")
    @AuditLog(moduleName="\u6700\u5927\u53f7\u8868\u7ba1\u7406", eventDesc="\u81ea\u5b9a\u4e49\u7f16\u7801\u89c4\u5219\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<JSONObject> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        if (ToolUtil.isEmpty((Object)hussarFile)) {
            throw new BaseException("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] content = hussarFile.getBytes();
        JSONObject result = this.sysIdtableService.importIdTableData(content);
        return ApiResponse.success((Object)result);
    }
}

