/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.calendar.controller;

import com.jxdinfo.hussar.calendar.model.SysCalendar;
import com.jxdinfo.hussar.calendar.service.ISysCalendarService;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendarFront"})
@Api(tags={"\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406"})
public class WorkCalendarFrontController
extends HussarBaseController<SysCalendar, ISysCalendarService> {
    private static final String SAVE_FAIL = "saveFail";
    private static final String SAVE_FAIL1 = "saveFail1";
    @Resource
    private ISysCalendarService sysCalendarService;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6", notes="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", dataType="string", required=true, paramType="query")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysCalendar>> eventsList(String startTime, String endTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date start = simpleDateFormat.parse(startTime);
        Date end = simpleDateFormat.parse(endTime);
        return ApiResponse.success((Object)this.sysCalendarService.queryEventsBetweenDate(start, end));
    }

    @PostMapping(value={"/addEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u65b0\u589e", notes="\u53ef\u540c\u65f6\u65b0\u589e\u591a\u4e2a\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> addEvent(@RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.saveEvent(sysCalendar);
    }

    @PostMapping(value={"/addOneEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u65b0\u589e", notes="\u65b0\u589e\u5355\u4e2a\u65e5\u5386\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65b0\u589e\u5355\u65e5\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> addOneEvent(@RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.saveOneEvent(sysCalendar);
    }

    @PostMapping(value={"/editEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539", notes="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<SysCalendar> editEvent(@RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.updateEvent(sysCalendar);
    }

    @GetMapping(value={"/dayEvent"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u5929\u7684\u4e8b\u4ef6", notes="\u67e5\u8be2\u70b9\u51fb\u5f53\u5929\u7684\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="query")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5f53\u5929\u7684\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysCalendar> dayEvent(String startTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date start = simpleDateFormat.parse(startTime);
        return this.sysCalendarService.queryOneEvent(start);
    }

    @PostMapping(value={"/delEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664", notes="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u65e5\u5386\u4e8b\u4ef6\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delEvent(@RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.deleteEvent(sysCalendar);
    }

    @PostMapping(value={"/delOneEvent"})
    @ApiOperation(value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664", notes="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysCalendar", value="\u5de5\u4f5c\u65e5\u5386\u5b9e\u4f53", required=true, paramType="body")})
    @AuditLog(moduleName="\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406", eventDesc="\u5220\u9664\u5355\u4e2a\u65e5\u5386\u4e8b\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delOneEvent(@RequestBody SysCalendar sysCalendar) {
        return this.sysCalendarService.deleteOneEvent(sysCalendar);
    }
}

