/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.calendar.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.calendar.dao.SysCalendarMapper;
import com.jxdinfo.hussar.calendar.model.SysCalendar;
import com.jxdinfo.hussar.calendar.service.ISysCalendarService;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysCalendarServiceImpl
extends HussarServiceImpl<SysCalendarMapper, SysCalendar>
implements ISysCalendarService {
    @Resource
    private SysCalendarMapper sysCalendarMapper;

    public List<SysCalendar> getEventsList() {
        return this.sysCalendarMapper.getEventsList();
    }

    public List<SysCalendar> queryEventsBetweenDate(Date startTime, Date endTime) {
        return this.sysCalendarMapper.getEventsBetweenDate(startTime, endTime);
    }

    @DSTransactional
    public ApiResponse<Tip> saveEvent(SysCalendar sysCalendar) {
        List<SysCalendar> calendarList = this.queryEventsBetweenDate(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (ToolUtil.isNotEmpty(calendarList)) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        List<Date> list = this.getBetweenDates(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (list.size() > 31) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u65b0\u589e\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708\uff09");
        }
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setStartTime(start);
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isEmpty(sysCalendarList)) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        if (!this.saveBatch(sysCalendarList, sysCalendarList.size())) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> saveOneEvent(SysCalendar sysCalendar) {
        if (!this.save(sysCalendar)) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<SysCalendar> updateEvent(SysCalendar sysCalendar) {
        if (!this.updateById(sysCalendar)) {
            throw new HussarException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<SysCalendar> queryOneEvent(Date start) {
        SysCalendar sysCalendar = (SysCalendar)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysCalendar::getRemark, (Object)start));
        return ApiResponse.success((Object)sysCalendar);
    }

    public ApiResponse<Tip> deleteEvent(SysCalendar sysCalendar) {
        boolean flag = this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(SysCalendar::getStartTime, (Object)sysCalendar.getStartTime())).le(SysCalendar::getStartTime, (Object)sysCalendar.getEndTime())).in(SysCalendar::getClassName, new Object[]{sysCalendar.getClassName()}));
        if (!flag) {
            throw new HussarException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> deleteOneEvent(SysCalendar sysCalendar) {
        if (!this.removeById(sysCalendar.getId())) {
            throw new HussarException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        Date newStartDate = startDate;
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(newStartDate);
        while (newStartDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            newStartDate = tempStart.getTime();
        }
        return result;
    }
}

