/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.idtable.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.idtable.model.SysIdtable;
import com.jxdinfo.hussar.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.idtable.service.TableService;
import com.jxdinfo.hussar.log.api.annotation.BussinessLog;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/idtableFront"})
@Api(tags={"\u6700\u5927\u53f7\u8868\u7ba1\u7406"})
public class IdtableFrontController
extends HussarBaseController<SysIdtable, ISysIdtableService> {
    @Resource
    ISysIdtableService sysIdtableService;
    @Resource
    private TableService tableService;
    @Resource
    private DruidProperties druidProperties;

    @GetMapping(value={"/getAllTable"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u8868", notes="\u67e5\u8be2\u6240\u6709\u7684\u8868")
    @BussinessLog(key="/idtableFront/getAllTable", type="04", value="\u67e5\u8be2\u6240\u6709\u7684\u8868")
    public ApiResponse<List<Map<String, Object>>> getAllTable() throws SQLException {
        List list = this.tableService.getTables();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                Set se = ((Map)list.get(i)).keySet();
                for (String set : se) {
                    map.put(set.toUpperCase(), ((Map)list.get(i)).get(set).toString().toUpperCase());
                }
                newList.add(map);
            }
            return ApiResponse.success(newList);
        }
        return ApiResponse.success((Object)list);
    }

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5217\u8868", notes="\u67e5\u8be2\u6700\u5927\u53f7\u8868\u5206\u9875\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868\u5b9e\u4f53", required=true, paramType="query")})
    @BussinessLog(key="/idtableFront/list", type="04", value="\u6700\u5927\u53f7\u8868\u5217\u8868")
    @CheckPermission(value={"idtable:list"})
    public ApiResponse<IPage<SysIdtable>> list(Page page, SysIdtable sysIdtable) {
        return ApiResponse.success((Object)this.sysIdtableService.queryList(page, sysIdtable));
    }

    @BussinessLog(key="/idtableFront/addSave", type="01", value="\u6700\u5927\u53f7\u8868\u65b0\u589e\u4fdd\u5b58")
    @ApiOperation(value="\u65b0\u589e\u6700\u5927\u53f7\u8868", notes="\u65b0\u589e\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868", required=true, paramType="body")})
    @PostMapping(value={"/addSave"})
    public ApiResponse<Tip> addSave(@RequestBody SysIdtable sysIdtable) {
        return this.sysIdtableService.saveIdtable(sysIdtable);
    }

    @BussinessLog(key="/idtableFront/editSave", type="03", value="\u6700\u5927\u53f7\u8868\u4fee\u6539\u4fdd\u5b58")
    @ApiOperation(value="\u4fee\u6539\u6700\u5927\u53f7\u8868", notes="\u4fee\u6539\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysIdtable", value="\u6700\u5927\u53f7\u8868", required=true, paramType="body")})
    @PostMapping(value={"/editSave"})
    public ApiResponse<Tip> editSave(@RequestBody SysIdtable sysIdtable) {
        return this.sysIdtableService.updateIdtable(sysIdtable);
    }

    @BussinessLog(key="/idtableFront/del", type="02", value="\u6700\u5927\u53f7\u8868\u5220\u9664")
    @ApiOperation(value="\u5220\u9664\u6700\u5927\u53f7\u8868", notes="\u5220\u9664\u6700\u5927\u53f7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u6700\u5927\u53f7\u8868\u4e3b\u952e", dataType="list", required=true, paramType="form")})
    @PostMapping(value={"/delByIds"})
    public ApiResponse<Tip> delByIds(@RequestBody String ids) {
        String[] ids1 = ids.split(",");
        return this.sysIdtableService.deleteByIds(Arrays.asList(ids1));
    }

    @PostMapping(value={"/exportData"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5bfc\u51fa", notes="\u6700\u5927\u53f7\u8868\u5bfc\u51fa")
    @BussinessLog(key="/idtableFront/exportData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u51fa")
    public void exportData(HttpServletResponse response, String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysIdtableService.exportData(idList, response);
    }

    @PostMapping(path={"/importData"})
    @ApiOperation(value="\u6700\u5927\u53f7\u8868\u5bfc\u5165", notes="\u6700\u5927\u53f7\u8868\u5bfc\u5165")
    @BussinessLog(key="/idtableFront/importData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u5165")
    public ApiResponse<JSONObject> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        JSONObject result = this.sysIdtableService.importIdTableData(content);
        return ApiResponse.success((Object)result);
    }
}

