/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dict.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.dict.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.dict.model.DicSingle;
import com.jxdinfo.hussar.dict.model.DicType;
import com.jxdinfo.hussar.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;

@Service
public class SysDicTypeServiceImpl
extends ServiceImpl<SysDicTypeMapper, DicType>
implements ISysDicTypeService {
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper singleMapper;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicGroupService dicGroupService;

    public void evictTypeCacheById(Long id) {
        DicType type = (DicType)this.getById(id);
        if (ToolUtil.isNotEmpty((Object)type)) {
            HussarCacheUtil.evictKeysLike((String)"hussar_dict_of_type_cache", (String)("dict_of_type:" + type.getTypeName() + ":*"));
        }
    }

    public List<JSTreeModel> dicExportTreeData() {
        return this.sysDicTypeMapper.dicExportTreeData();
    }

    public void exportDict(List<String> idList, HttpServletResponse response) {
        List group = this.dicGroupService.listByIds(idList);
        List type = this.listByIds(idList);
        List<String> singleIdList = this.getSingleIdByTypeId(idList, new ArrayList<String>());
        List single = new ArrayList();
        if (singleIdList.size() > 0) {
            single = this.dicSingleService.listByIds(singleIdList);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("group", group);
        data.put("export_type", "dictionary");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "dict_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<String> getSingleIdByTypeId(List<String> typeIdList, List<String> resultList) {
        List<String> singleIdList = this.singleMapper.getSingleIdByTypeId(typeIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    public ApiResponse importDict(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("dictionary")));
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        if (group.size() > 0) {
            this.dicGroupService.saveOrUpdateBatch((Collection)group, group.size());
        }
        Map<String, Integer> count = this.insertOrUpdateList(type);
        if (single.size() > 0) {
            this.dicSingleService.saveOrUpdateBatch((Collection)single, single.size());
        }
        return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002"));
    }

    public JSONObject importDictData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HussarException(BizExceptionEnum.FILE_READING_ERROR.getMessage());
        }
        if (ToolUtil.isEmpty((Object)data)) {
            result.put("success", (Object)"fileError");
            result.put("message", (Object)"\u5bfc\u5165\u6570\u636e\u6709\u8bef");
            result.put("trueType", (Object)"dictionary");
            return result;
        }
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"dictionary");
            return result;
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        if (group.size() > 0) {
            this.dicGroupService.saveOrUpdateBatch((Collection)group, group.size());
        }
        Map<String, Integer> count = this.insertOrUpdateList(type);
        if (single.size() > 0) {
            this.dicSingleService.saveOrUpdateBatch((Collection)single, single.size());
        }
        result.put("success", (Object)"true");
        result.put("insertCount", (Object)count.get("insert"));
        result.put("updateCount", (Object)count.get("update"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<DicType> dicTypeList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = dicTypeList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)dicTypeList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)dicTypeList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public IPage<DicType> queryList(Page page, String rangeType) {
        String rootRange = "root";
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        HashMap result = new HashMap(5);
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq(DicType::getRangeType, (Object)rangeType);
        }
        ew.orderByAsc(DicType::getSort);
        List list2 = ((Page)this.page((IPage)page, (Wrapper)ew)).getRecords();
        page.setRecords(list2);
        return page;
    }

    public List<DicType> selectListByParentId() {
        return this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(DicType::getSort));
    }

    public List<DicSingle> selectChildsById(String id) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(id != null, DicType::getId, (Object)id));
        List dicSingles = list.size() > 0 ? this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)id)).orderByAsc(DicSingle::getSort)) : this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getParentId, (Object)id)).orderByAsc(DicSingle::getSort));
        return dicSingles;
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        Long typeId = dt.getId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)typeId)).orderByAsc(DicSingle::getSort));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }
}

