/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.dict.model.DicGroup;
import com.jxdinfo.hussar.dict.model.DicSingle;
import com.jxdinfo.hussar.dict.model.DicType;
import com.jxdinfo.hussar.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.dict.service.SysDicFrontService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysDicFrontServiceImpl
implements SysDicFrontService {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;

    public List<JSTreeModel> queryDicTypeTreeData() {
        List dicChilds;
        List types;
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        List groups = this.dicGroupService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setParentId(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setType("dict");
                tempObject.setRangeType(group.getRangeType());
                mapList.add(tempObject);
            }
        }
        if ((types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"))) != null && types.size() > 0) {
            ArrayList<Long> typeIds = new ArrayList<Long>();
            for (Object type : types) {
                typeIds.add(type.getId());
            }
            List allDics = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"type_id", typeIds)).orderByAsc((Object)"sort"));
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(type.getId());
                tempObject.setParent(type.getParentId());
                tempObject.setParentId(type.getParentId());
                tempObject.setText(type.getTypeDescription());
                tempObject.setType("type");
                tempObject.setRangeType(rangeType);
                tempObject.setTypeName(typeName);
                mapList.add(tempObject);
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(dicChild.getId());
                tempObject.setParent(dicChild.getParentId());
                tempObject.setText(dicChild.getLabel());
                tempObject.setType("dic");
                tempObject.setRangeType("child");
                tempObject.setTypeName("child");
                mapList.add(tempObject);
            }
        }
        return mapList;
    }

    public List<JSTreeModel> queryDicOrderTreeData(Long typeId) {
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)typeId);
        if (pDic != null) {
            JSTreeModel parent = new JSTreeModel();
            parent.setId(pDic.getId());
            parent.setParent(Constants.ROOT_NODE_PARENT);
            parent.setText(pDic.getTypeDescription());
            parent.setType("type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)new LambdaQueryWrapper((Object)finder).orderByAsc(DicSingle::getSort));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    JSTreeModel tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    mapList.add(tempObject);
                }
            }
        }
        return mapList;
    }
}

