/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.dataset.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.EchartData;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.EchartDto;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.TableConfigDto;
import com.jxdinfo.hussar.formdesign.api.dataset.model.ChartApiParamModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.DataSetQueryModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.DataSetSortModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Dimension;
import com.jxdinfo.hussar.formdesign.api.dataset.model.JoinSubset;
import com.jxdinfo.hussar.formdesign.api.dataset.model.JoinTable;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Metrics;
import com.jxdinfo.hussar.formdesign.api.dataset.model.ProjectionField;
import com.jxdinfo.hussar.formdesign.api.dataset.model.QueryConditionModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.SortConditionFields;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Tables;
import com.jxdinfo.hussar.formdesign.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceDataService;
import com.jxdinfo.hussar.formdesign.api.tabledataset.model.SysTableDataSet;
import com.jxdinfo.hussar.formdesign.api.util.DataSetUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.DataCellInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.DataCellInfoService;
import com.jxdinfo.hussar.formdesign.server.tabledataset.service.impl.TableDataSetServiceImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetServiceImpl
implements DataSetService {
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceImpl.class);
    @Autowired
    private DataSourceDataService datasourceDataService;
    @Autowired
    private TableDataSetServiceImpl tableDataSetService;
    @Autowired
    private DataCellInfoService dataCellInfoService;

    public Map<String, Object> previewData(TableConfigDto tableConfigDto) throws LcdpException, IOException {
        String sql = this.generateSql(tableConfigDto).getData().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] decodedBytes = null;
        try {
            decodedBytes = Base64.getDecoder().decode(sql);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6sql\u89e3\u5bc6\u5931\u8d25");
            return map;
        }
        String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
        if (tableConfigDto.getTables() == null && !ToolUtil.isNotEmpty((Object)tableConfigDto.getTables()) && tableConfigDto.getTables().size() != 0) {
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6\u914d\u7f6e\u9519\u8bef");
            return map;
        }
        List tableList = new ArrayList();
        try {
            tableList = this.datasourceDataService.selectDataBySql(tableConfigDto.getDataSourceId(), decodedString);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", 10001);
            HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
            pageMap.put("pageSize", 10);
            pageMap.put("totalPages", 1);
            pageMap.put("total", 0);
            map.put("page", pageMap);
            map.put("msg", "\u6570\u636e\u96c6\u67e5\u8be2\u5931\u8d25");
            return map;
        }
        if (tableList == null || ToolUtil.isEmpty(tableList)) {
            map.put("msg", "\u6570\u636e\u96c6\u67e5\u8be2\u4e3a\u7a7a");
            HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
            pageMap.put("pageSize", 10);
            pageMap.put("totalPages", 1);
            pageMap.put("total", 0);
            map.put("page", pageMap);
            map.put("code", 200);
            return map;
        }
        int startIndex = (tableConfigDto.getPage() - 1) * tableConfigDto.getPageSize();
        int endIndex = Math.min(startIndex + tableConfigDto.getPageSize(), tableList.size());
        List pageTableList = tableList.subList(startIndex, endIndex);
        ArrayList pageColumns = new ArrayList();
        for (ProjectionField projectionField : tableConfigDto.getProjection()) {
            HashMap<String, String> map1 = new HashMap<String, String>();
            if ("calc".equals(projectionField.getType())) {
                projectionField.setField(projectionField.getRename());
                map1.put("field", projectionField.getField());
            } else {
                map1.put("field", projectionField.getFieldAlias());
            }
            if ("".equals(projectionField.getRename())) {
                projectionField.setRename(projectionField.getFieldAlias());
            }
            map1.put("title", projectionField.getRename());
            pageColumns.add(map1);
        }
        Integer total = tableList.size();
        int totalPages = 1;
        try {
            totalPages = (int)Math.ceil((double)total.intValue() / (double)tableConfigDto.getPageSize().intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", 10001);
            map.put("msg", "\u8868\u683c\u5c55\u793a\u6761\u6570\u4e0d\u80fd\u4e3a\u96f6");
            return map;
        }
        HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
        pageMap.put("pageSize", tableConfigDto.getPageSize());
        pageMap.put("totalPages", totalPages);
        pageMap.put("total", total);
        map.put("tableDatas", pageTableList);
        map.put("tableColumns", pageColumns);
        map.put("page", pageMap);
        map.put("code", 200);
        return map;
    }

    public FormDesignResponse generateSql(TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder;
        StringBuilder sql = new StringBuilder();
        FormDesignResponse response = new FormDesignResponse();
        if (tableConfigDto.getTables() == null || ToolUtil.isEmpty((Object)tableConfigDto.getTables()) || tableConfigDto.getTables().size() == 0) {
            response.setErrorCode(10001);
            response.setErrorMsg("\u6570\u636e\u96c6\u672a\u9009\u62e9\u8868");
            response.setData((Object)false);
            return response;
        }
        sql.append("SELECT ");
        if (tableConfigDto.getProjection() == null || !ToolUtil.isNotEmpty((Object)tableConfigDto.getProjection()) || tableConfigDto.getProjection().size() == 0) {
            response.setErrorCode(10001);
            response.setErrorMsg("\u6570\u636e\u96c6\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef");
            response.setData((Object)false);
            return response;
        }
        sql.append((CharSequence)this.combineField(tableConfigDto.getProjection()));
        if (tableConfigDto.getRelationship() == null || ToolUtil.isEmpty((Object)tableConfigDto.getRelationship()) && tableConfigDto.getTables().size() > 1) {
            response.setErrorCode(10001);
            response.setErrorMsg("\u6570\u636e\u96c6\u672a\u914d\u7f6e\u5173\u8054\u5173\u7cfb");
            response.setData((Object)false);
        }
        if (tableConfigDto.getTables().size() == 1) {
            sql.append("\n").append("FROM ");
            sql.append(((Tables)tableConfigDto.getTables().get(0)).getName()).append("\n");
        }
        if (tableConfigDto.getRelationship() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getRelationship()) && tableConfigDto.getRelationship().size() != 0) {
            sql.append("\n").append("FROM ");
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertJoin(tableConfigDto.getRelationship());
            if ("".equals(stringBuilder)) {
                response.setErrorCode(10001);
                response.setErrorMsg("\u6570\u636e\u96c6\u5173\u8054\u914d\u7f6e\u9519\u8bef");
                response.setData((Object)false);
                return response;
            }
            sql.append((CharSequence)stringBuilder);
        }
        if (tableConfigDto.getQuery() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getQuery()) && tableConfigDto.getQuery().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertquery(tableConfigDto.getQuery());
            if (!"".equals(stringBuilder.toString())) {
                sql.append("WHERE ").append((CharSequence)stringBuilder);
            }
        }
        if (tableConfigDto.getSort() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getSort()) && tableConfigDto.getSort().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertSort(tableConfigDto.getSort());
            if ("".equals(stringBuilder)) {
                response.setErrorCode(10001);
                response.setErrorMsg("\u6392\u5e8f\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
                response.setData((Object)false);
                return response;
            }
            sql.append((CharSequence)stringBuilder);
        }
        byte[] inputBytes = sql.toString().getBytes(StandardCharsets.UTF_8);
        byte[] encodedSql = Base64.getEncoder().encode(inputBytes);
        String encodedString = new String(encodedSql, StandardCharsets.UTF_8);
        response.setData((Object)encodedString);
        return response;
    }

    public StringBuilder convertJoin(List<JoinTable> joinTables) {
        StringBuilder sql = new StringBuilder();
        int joinTableNum = 1;
        for (JoinTable joinTable : joinTables) {
            int times = 1;
            if ("".equals(joinTable.getLeftTable()) || "".equals(joinTable.getRightTable())) {
                return new StringBuilder();
            }
            for (JoinSubset joinSubset : joinTable.getChildren()) {
                if (!DataSetUtil.isFieldNull((Object)joinSubset)) continue;
                return new StringBuilder();
            }
            String joinType = null;
            switch (joinTable.getJoinType()) {
                case "left": {
                    joinType = "LEFT JOIN";
                    break;
                }
                case "right": {
                    joinType = "RIGHT JOIN";
                    break;
                }
                case "inner": {
                    joinType = "INNER JOIN";
                }
            }
            if (joinTableNum == 1) {
                sql.append(joinTable.getLeftTable()).append(" ").append(joinType).append(" ").append(joinTable.getRightTable()).append(" ON ");
            } else {
                sql.append(joinType).append(" ").append(joinTable.getRightTable()).append(" ON ");
            }
            for (JoinSubset joinSubset : joinTable.getChildren()) {
                sql.append(joinTable.getLeftTable()).append(".").append(joinSubset.getLeftField()).append(" ").append(joinSubset.getCondition()).append(" ").append(joinTable.getRightTable()).append(".").append(joinSubset.getRightField()).append(" ").append("\n");
                if (times != joinTable.getChildren().size()) {
                    sql.append(joinSubset.getPreCondition()).append(" ");
                }
                ++times;
            }
            ++joinTableNum;
        }
        return sql;
    }

    public StringBuilder convertSort(List<DataSetSortModel> sortConditionList) {
        StringBuilder sql = new StringBuilder();
        sql.append("ORDER BY ");
        for (DataSetSortModel joinSort : sortConditionList) {
            if (DataSetUtil.isFieldNull((Object)joinSort)) {
                return new StringBuilder();
            }
            sql.append(joinSort.getField()).append(" ").append(joinSort.getDirection()).append(",").append("\n");
        }
        sql.deleteCharAt(sql.length() - 2);
        return sql;
    }

    public StringBuilder convertquery(List<DataSetQueryModel> filterList) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (DataSetQueryModel tableFilter : filterList) {
            tableFilter.setValue(this.fieldType(tableFilter.getFieldType(), tableFilter.getValue()));
            if ("row".equals(tableFilter.getType())) {
                if (!ToolUtil.isNotEmpty((Object)tableFilter.getTable()) || !ToolUtil.isNotEmpty((Object)tableFilter.getField()) || !ToolUtil.isNotEmpty((Object)tableFilter.getValue())) continue;
                sql.append(tableFilter.getTable()).append(".");
                sql.append((CharSequence)this.getQueryByType(tableFilter));
                if (++i != filterList.size()) continue;
                sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 1));
                continue;
            }
            if (!"child".equals(tableFilter.getType()) || tableFilter.getChildren().size() == 0) continue;
            sql.append("(");
            sql.append((CharSequence)this.convertquery(tableFilter.getChildren())).append(")");
        }
        return sql;
    }

    public StringBuilder queryCondition(List<DataSetQueryModel> filterList) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (DataSetQueryModel tableFilter : filterList) {
            tableFilter.setValue(this.fieldType(tableFilter.getFieldType(), tableFilter.getValue()));
            if ("row".equals(tableFilter.getType())) {
                if (!ToolUtil.isNotEmpty((Object)tableFilter.getFromModelField()) || !ToolUtil.isNotEmpty((Object)tableFilter.getValue())) continue;
                sql.append("T.");
                sql.append((CharSequence)this.getQueryByType(tableFilter));
                if (++i != filterList.size()) continue;
                sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 1));
                continue;
            }
            if (!"child".equals(tableFilter.getType()) || tableFilter.getChildren().size() == 0) continue;
            sql.append("(");
            sql.append((CharSequence)this.convertquery(tableFilter.getChildren())).append(")");
        }
        return sql;
    }

    public StringBuilder publishQueryCondition(List<QueryConditionModel> filterList) {
        StringBuilder sql = new StringBuilder();
        for (int j = 0; j < filterList.size(); ++j) {
            QueryConditionModel tableFilter = filterList.get(j);
            if (ToolUtil.isNotEmpty((Object)tableFilter.getValue())) {
                tableFilter.setValue(this.fieldType(tableFilter.getDataType(), tableFilter.getValue()));
            }
            if ("row".equals(tableFilter.getType())) {
                int length;
                if (ToolUtil.isNotEmpty((Object)tableFilter.getFromModelField()) && ToolUtil.isNotEmpty((Object)tableFilter.getValue())) {
                    sql.append((CharSequence)this.getQueryByType2(tableFilter));
                    if (j != filterList.size() - 1) continue;
                    sql.setLength(sql.length() - (tableFilter.getConnect().length() + 1));
                    continue;
                }
                if (j != filterList.size() - 1 || (length = sql.length() - (tableFilter.getConnect().length() + 1)) <= 0) continue;
                sql.setLength(sql.length() - (tableFilter.getConnect().length() + 1));
                continue;
            }
            if (!"child".equals(tableFilter.getType()) || tableFilter.getChildren().size() == 0) continue;
            sql.append("(");
            sql.append((CharSequence)this.publishQueryCondition(tableFilter.getChildren())).append(")");
        }
        if (sql.toString().indexOf("and ()") > 0) {
            sql = new StringBuilder(sql.toString().replace("and ()", ""));
        } else if (sql.toString().indexOf("or ()") > 0) {
            sql = new StringBuilder(sql.toString().replace("or ()", ""));
        }
        return sql;
    }

    public StringBuilder getQueryByType(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getCondition()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "regexp": {
                sql.append(tableFilter.getField()).append(" ").append("REGEXP ").append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
        }
        return sql;
    }

    public StringBuilder getQueryByType2(QueryConditionModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getSymbol()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getFromModelField()).append(" ").append(tableFilter.getSymbol()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getFromModelField()).append(" ").append(tableFilter.getSymbol()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getFromModelField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getFromModelField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().toString().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getFromModelField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().toString().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            case "regexp": {
                sql.append(tableFilter.getFromModelField()).append(" ").append("REGEXP ").append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
                break;
            }
            default: {
                sql.append(tableFilter.getFromModelField()).append(" ").append(tableFilter.getSymbol()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getConnect()).append(" ");
            }
        }
        return sql;
    }

    public Object fieldType(String fieldType, Object fieldValue) {
        switch (fieldType.toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": 
            case "TEXT": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": 
            case "ENUM": 
            case "STRING": {
                return "'" + fieldValue + "'";
            }
            case "DATE": 
            case "TIME": 
            case "YEAR": 
            case "DATETIME": 
            case "TIMESTAMP": {
                return "'" + fieldValue + "'";
            }
            case "INT": 
            case "NUM": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "INTEGER": 
            case "BIGINT": 
            case "LONG": {
                return fieldValue;
            }
            case "FLOAT": 
            case "DOUBLE": 
            case "DECIMAL": {
                return fieldValue;
            }
            case "BIT": 
            case "TINYINT": 
            case "BOOLEAN": {
                return fieldValue;
            }
        }
        return "'" + fieldValue + "'";
    }

    public StringBuilder combineField(List<ProjectionField> projectionFields) {
        StringBuilder sql = new StringBuilder();
        for (ProjectionField projectionField : projectionFields) {
            if ("default".equals(projectionField.getType())) {
                sql.append(projectionField.getTable()).append(".").append(projectionField.getField());
                if (ToolUtil.isNotEmpty((Object)projectionField.getFieldAlias())) {
                    sql.append(" AS ").append(projectionField.getFieldAlias());
                }
                sql.append(",").append("\n");
                continue;
            }
            if (!"calc".equals(projectionField.getType())) continue;
            sql.append(projectionField.getExpression());
            sql.append(" AS '").append(projectionField.getRename()).append("'").append(",").append("\n");
        }
        if (!sql.toString().isEmpty()) {
            sql.setLength(sql.length() - 2);
        }
        return sql;
    }

    private static boolean isBelongList(String str) {
        ArrayList<String> calcLists = new ArrayList<String>();
        calcLists.add("count");
        calcLists.add("sum");
        calcLists.add("max");
        calcLists.add("min");
        calcLists.add("avg");
        boolean bResult = false;
        for (String temp : calcLists) {
            if (!str.contains(temp)) continue;
            bResult = true;
        }
        return bResult;
    }

    public List<String[]> exportCsv(TableConfigDto tableConfigDto, String sql) throws LcdpException, IOException {
        List allTableList = this.datasourceDataService.selectDataBySql(tableConfigDto.getDataSourceId(), sql);
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        Map keyMap = (Map)allTableList.get(0);
        String[] keysArray = new String[keyMap.size()];
        int k = 0;
        for (String key : keyMap.keySet()) {
            keysArray[k++] = key;
        }
        dataList.add(keysArray);
        for (Map map : allTableList) {
            String[] keyValueArray = new String[map.size() * 2];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                keyValueArray[i++] = entry.getValue().toString();
            }
            dataList.add(keyValueArray);
        }
        return dataList;
    }

    public Map<String, Object> viewDataSet(TableConfigDto tableConfigDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SysTableDataSet sysTableDataSet = this.getSysTableDataSet(tableConfigDto.getDataModelId());
        byte[] decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        String decodedMessage = new String(decodedBytes);
        String finalSql = "";
        try {
            finalSql = this.combineDatasetSql(decodedMessage, tableConfigDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), finalSql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u67e5\u8be2\u5931\u8d25");
        }
        if (ToolUtil.isEmpty(allTableList)) {
            resultMap.put("code", 200);
            resultMap.put("msg", "\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return resultMap;
        }
        EchartDto echartDto = new EchartDto();
        ArrayList<String> xAxisData = new ArrayList<String>();
        ArrayList<EchartData> yAxisData = new ArrayList<EchartData>();
        ArrayList dataList = new ArrayList();
        if (tableConfigDto.getDim() != null && !tableConfigDto.getDim().isEmpty()) {
            for (Dimension dimension : tableConfigDto.getDim()) {
                for (Object map : allTableList) {
                    for (String mapKey : map.keySet()) {
                        if (!mapKey.equals(dimension.getFieldName())) continue;
                        xAxisData.addAll(Collections.singleton(map.get(mapKey).toString()));
                    }
                }
            }
            echartDto.setxAxisData(xAxisData);
        }
        if (!tableConfigDto.getMetric().isEmpty() && tableConfigDto.getMetric() != null) {
            EchartData datas = new EchartData();
            for (Metrics data : tableConfigDto.getMetric()) {
                if (ToolUtil.isNotEmpty((Object)data.getFieldAlias())) {
                    data.setFieldName(data.getFieldAlias());
                }
                datas.setName(data.getLegendName());
                for (Map map : allTableList) {
                    for (String mapKey : map.keySet()) {
                        if (data.getAggFunc() != null || !data.getAggFunc().isEmpty()) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("COUNT(").append("DISTINCT(").append(data.getFieldName()).append("))");
                            if (mapKey.equals(stringBuilder.toString())) {
                                dataList.add(map.get(mapKey));
                                continue;
                            }
                            if (!mapKey.equals(String.format("%s(%s)", data.getAggFunc(), data.getFieldName()))) continue;
                            dataList.add(map.get(mapKey));
                            continue;
                        }
                        if (!mapKey.equals(data.getFieldName())) continue;
                        dataList.add(map.get(mapKey));
                    }
                }
                ArrayList newList = new ArrayList(dataList);
                datas.setData(newList);
                yAxisData.add(datas);
                datas = new EchartData();
                dataList = new ArrayList();
            }
        }
        echartDto.setyAxisData(yAxisData);
        resultMap.put("xAxisData", xAxisData);
        resultMap.put("yAxisData", yAxisData);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    private String combineGaugeMapDatasetSql(String sql, TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        ArrayList targetField = new ArrayList(tableConfigDto.getMetric());
        if (targetField != null && !targetField.isEmpty()) {
            for (Metrics metrics : targetField) {
                if (ToolUtil.isNotEmpty((Object)metrics.getFieldAlias())) {
                    metrics.setFieldName(metrics.getFieldAlias());
                }
                if (!metrics.getFieldName().isEmpty() && !metrics.getAggFunc().isEmpty()) {
                    if ("DISTIN".equals(metrics.getAggFunc())) {
                        stringBuilder.append("COUNT(").append("DISTINCT(").append(metrics.getFieldName()).append(")),");
                        continue;
                    }
                    if ("STDEV".equals(metrics.getAggFunc())) {
                        metrics.setAggFunc("STDDEV");
                        stringBuilder.append(metrics.getAggFunc()).append("(").append(metrics.getFieldName()).append(")").append(",");
                        continue;
                    }
                    stringBuilder.append(metrics.getAggFunc()).append("(").append(metrics.getFieldName()).append(")").append(",");
                    continue;
                }
                stringBuilder.append(metrics.getFieldName()).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" FROM");
        stringBuilder.append("\n");
        stringBuilder.append("(").append(sql).append(") T\n");
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        if (tableConfigDto.getSort() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getSort()) && tableConfigDto.getSort().size() != 0) {
            stringBuilder = this.convertSort(tableConfigDto.getSort());
        }
        return stringBuilder.toString();
    }

    public Map<String, Object> viewGaugeDataSet(TableConfigDto tableConfigDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SysTableDataSet sysTableDataSet = this.getSysTableDataSet(tableConfigDto.getDataModelId());
        byte[] decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        String decodedMessage = new String(decodedBytes);
        String finalSql = "";
        try {
            finalSql = this.combineGaugeMapDatasetSql(decodedMessage, tableConfigDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), finalSql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u67e5\u8be2\u5931\u8d25");
        }
        if (ToolUtil.isEmpty(allTableList)) {
            resultMap.put("code", 200);
            resultMap.put("msg", "\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return resultMap;
        }
        ArrayList<EchartData> gaugeMap = new ArrayList<EchartData>();
        for (Metrics data : tableConfigDto.getMetric()) {
            EchartData datas = new EchartData();
            datas.setName(data.getLegendName());
            ArrayList fieldList = new ArrayList();
            for (Map map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (data.getAggFunc() != null || !data.getAggFunc().isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("COUNT(").append("DISTINCT(").append(data.getFieldName()).append("))");
                        if (mapKey.equals(stringBuilder.toString())) {
                            fieldList.add(map.get(mapKey));
                            continue;
                        }
                        if (!mapKey.equals(String.format("%s(%s)", data.getAggFunc(), data.getFieldName()))) continue;
                        fieldList.add(map.get(mapKey));
                        continue;
                    }
                    if (!mapKey.equals(data.getFieldName())) continue;
                    fieldList.add(map.get(mapKey));
                }
            }
            HashMap obj = new HashMap();
            obj.put("fieldList", fieldList);
            datas.setData(obj);
            gaugeMap.add(datas);
        }
        resultMap.put("datas", gaugeMap);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    public Map<String, Object> viewScatterMapDataSet(TableConfigDto tableConfigDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SysTableDataSet sysTableDataSet = this.getSysTableDataSet(tableConfigDto.getDataModelId());
        byte[] decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        String decodedMessage = new String(decodedBytes);
        String finalSql = "";
        try {
            finalSql = this.combineScatterMapDatasetSql(decodedMessage, tableConfigDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), finalSql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u67e5\u8be2\u5931\u8d25");
        }
        if (ToolUtil.isEmpty(allTableList)) {
            resultMap.put("code", 200);
            resultMap.put("msg", "\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return resultMap;
        }
        ArrayList<EchartData> scatterMap = new ArrayList<EchartData>();
        for (Metrics data : tableConfigDto.getMetric()) {
            EchartData datas = new EchartData();
            datas.setName(data.getLegendName());
            ArrayList fieldList = new ArrayList();
            ArrayList nameList = new ArrayList();
            ArrayList longitudeList = new ArrayList();
            ArrayList latitudeList = new ArrayList();
            for (Map map : allTableList) {
                HashMap oneData = new HashMap();
                for (String mapKey : map.keySet()) {
                    if (data.getAggFunc() != null || !data.getAggFunc().isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("COUNT(").append("DISTINCT(").append(data.getFieldName()).append("))");
                        if (mapKey.equals(stringBuilder.toString())) {
                            oneData.put("field", map.get(mapKey));
                        } else if (mapKey.equals(String.format("%s(%s)", data.getAggFunc(), data.getFieldName()))) {
                            oneData.put("field", map.get(mapKey));
                        }
                    } else if (mapKey.equals(data.getFieldName())) {
                        oneData.put("field", map.get(mapKey));
                    }
                    if (mapKey.equals(data.getName())) {
                        oneData.put("name", map.get(mapKey));
                    }
                    if (mapKey.equals(data.getLongitude())) {
                        oneData.put("Longitude", map.get(mapKey));
                    }
                    if (!mapKey.equals(data.getLatitude())) continue;
                    oneData.put("Latitude", map.get(mapKey));
                }
                if (!ToolUtil.isNotEmpty(oneData.get("field"))) continue;
                fieldList.add(oneData.get("field"));
                nameList.add(oneData.get("name"));
                longitudeList.add(oneData.get("Longitude"));
                latitudeList.add(oneData.get("Latitude"));
            }
            HashMap obj = new HashMap();
            obj.put("fieldList", fieldList);
            obj.put("nameList", nameList);
            obj.put("longitudeList", longitudeList);
            obj.put("latitudeList", latitudeList);
            datas.setData(obj);
            scatterMap.add(datas);
        }
        resultMap.put("datas", scatterMap);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    public List<QueryConditionModel> getQueryValue(String qureyName, Map<String, Object> queryDtoMap, List<QueryConditionModel> queryConditionModels) {
        for (QueryConditionModel queryConditionModel : queryConditionModels) {
            if (qureyName.equals(queryConditionModel.getQueryAttrName())) {
                queryConditionModel.setValue(queryDtoMap.get(qureyName));
                continue;
            }
            if (!"".equals(queryConditionModel.getQueryAttrName())) continue;
            this.getQueryValue(qureyName, queryDtoMap, queryConditionModel.getChildren());
        }
        return queryConditionModels;
    }

    public List<QueryConditionModel> getQueryValueType(String fieldName, Map<String, Object> queryDtoMap, List<QueryConditionModel> queryConditionModels) {
        for (QueryConditionModel queryConditionModel : queryConditionModels) {
            if (fieldName.equals(queryConditionModel.getQueryAttrName())) {
                queryConditionModel.setDataType(queryDtoMap.get(fieldName).toString());
                continue;
            }
            if (!"".equals(queryConditionModel.getQueryAttrName())) continue;
            this.getQueryValueType(fieldName, queryDtoMap, queryConditionModel.getChildren());
        }
        return queryConditionModels;
    }

    public FormDesignResponse publishViewData(ChartApiParamModel chartApiParamModel) {
        byte[] byArray;
        Object queryDtoMap;
        List<QueryConditionModel> queryCondition = this.getQueryCondition(chartApiParamModel.getDataModelId(), chartApiParamModel.getQueryArrName());
        if (ToolUtil.isNotEmpty(queryCondition)) {
            queryDtoMap = new HashMap();
            queryDtoMap = JSON.parseObject((String)chartApiParamModel.getQueryValue());
            for (String string : queryDtoMap.keySet()) {
                this.getQueryValue(string, (Map<String, Object>)queryDtoMap, queryCondition);
            }
            chartApiParamModel.setQuery(queryCondition);
        }
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getQueryVariableType())) {
            queryDtoMap = new HashMap();
            queryDtoMap = JSON.parseObject((String)chartApiParamModel.getQueryVariableType());
            for (Map.Entry entry : queryDtoMap.entrySet()) {
                this.getQueryValueType((String)entry.getKey(), (Map<String, Object>)queryDtoMap, queryCondition);
            }
        }
        SysTableDataSet sysTableDataSet = this.getSysTableDataSet(chartApiParamModel.getDataModelId());
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        Object var5_8 = null;
        try {
            byArray = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u89e3\u5bc6\u5931\u8d25");
        }
        String decodedMessage = new String(byArray);
        String sql = this.combinePublishedSql(decodedMessage, chartApiParamModel);
        ArrayList<Map<String, Object>> allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), sql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u914d\u7f6e");
        }
        if (ToolUtil.isEmpty(allTableList)) {
            formDesignResponse.setErrorCode(20000);
            formDesignResponse.setErrorMsg("\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a");
            return formDesignResponse;
        }
        Map<Object, Object> resultMap = new HashMap();
        resultMap = this.getResult(allTableList, chartApiParamModel);
        formDesignResponse.setData(resultMap);
        return formDesignResponse;
    }

    public StringBuilder publishSort(List<SortConditionFields> sortConditionFieldsList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nORDER BY ");
        for (SortConditionFields sortConditionFields : sortConditionFieldsList) {
            stringBuilder.append(sortConditionFields.getFromModelFieldSort()).append(" ").append(sortConditionFields.getSortCondition()).append(",").append("\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        return stringBuilder;
    }

    private String combineScatterMapDatasetSql(String sql, TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        ArrayList targetField = new ArrayList(tableConfigDto.getMetric());
        if (targetField != null && !targetField.isEmpty()) {
            for (Metrics metrics : targetField) {
                if (!metrics.getName().isEmpty()) {
                    stringBuilder.append(metrics.getName()).append(",");
                }
                if (!metrics.getLongitude().isEmpty()) {
                    stringBuilder.append(metrics.getLongitude()).append(",");
                }
                if (!metrics.getLatitude().isEmpty()) {
                    stringBuilder.append(metrics.getLatitude()).append(",");
                }
                if (!metrics.getFieldName().isEmpty() && !metrics.getAggFunc().isEmpty()) {
                    if ("DISTIN".equals(metrics.getAggFunc())) {
                        stringBuilder.append("COUNT(").append("DISTINCT(").append(metrics.getFieldName()).append(")),");
                        continue;
                    }
                    if ("STDEV".equals(metrics.getAggFunc())) {
                        metrics.setAggFunc("STDDEV");
                        stringBuilder.append(metrics.getAggFunc()).append("(").append(metrics.getFieldAlias()).append(")").append(",");
                        continue;
                    }
                    stringBuilder.append(metrics.getAggFunc()).append("(").append(metrics.getFieldName()).append(")").append(",");
                    continue;
                }
                stringBuilder.append(metrics.getFieldName()).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" FROM ");
        stringBuilder.append("\n");
        stringBuilder.append("(").append(sql).append(") T\n");
        if (ToolUtil.isNotEmpty(targetField)) {
            stringBuilder.append("GROUP BY ");
            for (Metrics metrics : targetField) {
                if (!metrics.getName().isEmpty()) {
                    stringBuilder.append(metrics.getName()).append(",");
                }
                if (!metrics.getLongitude().isEmpty()) {
                    stringBuilder.append(metrics.getLongitude()).append(",");
                }
                if (metrics.getLatitude().isEmpty()) continue;
                stringBuilder.append(metrics.getLatitude()).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        if (tableConfigDto.getSort() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getSort()) && tableConfigDto.getSort().size() != 0) {
            stringBuilder = this.convertSort(tableConfigDto.getSort());
        }
        return stringBuilder.toString();
    }

    public StringBuilder splitMetrics(List<Metrics> metrics) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Metrics metric : metrics) {
            if (ToolUtil.isNotEmpty((Object)metric.getFieldAlias())) {
                if (ToolUtil.isNotEmpty((Object)metric.getAggFunc())) {
                    if ("DISTIN".equals(metric.getAggFunc())) {
                        stringBuilder.append("COUNT(").append("DISTINCT(").append(metric.getFieldAlias()).append(")),");
                        continue;
                    }
                    if ("STDEV".equals(metric.getAggFunc())) {
                        metric.setAggFunc("STDDEV");
                        stringBuilder.append(metric.getAggFunc()).append("(").append(metric.getFieldAlias()).append(")").append(",");
                        continue;
                    }
                    stringBuilder.append(metric.getAggFunc()).append("(").append(metric.getFieldAlias()).append(")").append(",");
                    continue;
                }
                stringBuilder.append(metric.getFieldAlias()).append(",");
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)metric.getAggFunc())) {
                if ("DISTIN".equals(metric.getAggFunc())) {
                    stringBuilder.append("COUNT(").append("DISTINCT(").append(metric.getFieldName()).append(")),");
                    continue;
                }
                if ("STDEV".equals(metric.getAggFunc())) {
                    metric.setAggFunc("STDDEV");
                    stringBuilder.append(metric.getAggFunc()).append("(").append(metric.getFieldAlias()).append(")").append(",");
                    continue;
                }
                stringBuilder.append(metric.getAggFunc()).append("(").append(metric.getFieldName()).append(")").append(",");
                continue;
            }
            stringBuilder.append(metric.getFieldName()).append(",");
        }
        return stringBuilder;
    }

    private String combineDatasetSql(String sql, TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (!tableConfigDto.getDim().isEmpty()) {
            if (ToolUtil.isNotEmpty((Object)((Dimension)tableConfigDto.getDim().get(0)).getFieldAlias())) {
                stringBuilder.append(((Dimension)tableConfigDto.getDim().get(0)).getFieldAlias()).append(",");
            } else {
                stringBuilder.append(((Dimension)tableConfigDto.getDim().get(0)).getFieldName()).append(",");
            }
        }
        ArrayList<Metrics> targetField = new ArrayList<Metrics>(tableConfigDto.getMetric());
        ArrayList dimensions = new ArrayList(tableConfigDto.getDim());
        stringBuilder.append((CharSequence)this.splitMetrics(targetField));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" FROM");
        stringBuilder.append("\n");
        stringBuilder.append("(").append(sql).append(") T\n");
        if (dimensions != null && ToolUtil.isNotEmpty(dimensions)) {
            Boolean isGroupBy = false;
            for (Metrics metrics : tableConfigDto.getMetric()) {
                if (!ToolUtil.isNotEmpty((Object)metrics.getAggFunc())) continue;
                isGroupBy = true;
                break;
            }
            if (isGroupBy.booleanValue()) {
                stringBuilder.append("GROUP BY").append(" ");
                for (Dimension field : dimensions) {
                    if (ToolUtil.isNotEmpty((Object)field.getFieldAlias())) {
                        field.setFieldName(field.getFieldAlias());
                    }
                    stringBuilder.append(" ").append(field.getFieldName()).append(",");
                }
                for (Metrics metrics : tableConfigDto.getMetric()) {
                    if (ToolUtil.isNotEmpty((Object)metrics.getFieldAlias())) {
                        metrics.setFieldName(metrics.getFieldName());
                    }
                    if (!ToolUtil.isEmpty((Object)metrics.getAggFunc())) continue;
                    stringBuilder.append(metrics.getFieldName()).append(",");
                }
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String combinePublishedSql(String sql, ChartApiParamModel chartApiParamModel) {
        StringBuilder splitSql = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder queryBuilder1 = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getDim())) {
            for (String s : chartApiParamModel.getDim()) {
                stringBuilder.append(s).append(",");
            }
        }
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getMetrics())) {
            for (String s : chartApiParamModel.getMetrics()) {
                stringBuilder.append(s).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(" FROM \n");
        if (chartApiParamModel.getQuery() != null && ToolUtil.isNotEmpty((Object)chartApiParamModel.getQuery()) && chartApiParamModel.getQuery().size() != 0) {
            StringBuilder stringBuilder1 = new StringBuilder();
            stringBuilder1 = this.publishQueryCondition(chartApiParamModel.getQuery());
            if (ToolUtil.isNotEmpty((Object)stringBuilder1.toString()) && !"()".equals(stringBuilder1.toString()) && !" ".equals(stringBuilder1.toString())) {
                stringBuilder.append("(SELECT ").append((CharSequence)this.getSelectedField(chartApiParamModel.getDataModelId())).append(" FROM ").append("(").append(sql).append(") T\n").append("WHERE ").append((CharSequence)stringBuilder1).append(") TT ");
            } else {
                stringBuilder.append("(").append(sql).append(") T\n");
            }
        } else {
            stringBuilder.append("(").append(sql).append(") T\n");
        }
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getDim())) {
            stringBuilder.append("GROUP BY ");
            for (String s : chartApiParamModel.getDim()) {
                stringBuilder.append(s).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getSortName())) {
            chartApiParamModel.setSort(this.getSortAtrr(chartApiParamModel.getDataModelId(), chartApiParamModel.getSortName()));
            stringBuilder.append((CharSequence)this.publishSort(chartApiParamModel.getSort()));
        }
        splitSql.append((CharSequence)stringBuilder);
        return splitSql.toString();
    }

    public Map<String, Object> getResult(List<Map<String, Object>> allTableList, ChartApiParamModel tableConfig) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        EchartDto echartDto = new EchartDto();
        ArrayList<String> xAxisData = new ArrayList<String>();
        ArrayList<EchartData> yAxisData = new ArrayList<EchartData>();
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (String s : tableConfig.getDim()) {
            for (Map<String, Object> map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (!mapKey.equals(s)) continue;
                    xAxisData.addAll(Collections.singleton(map.get(mapKey).toString()));
                }
            }
        }
        echartDto.setxAxisData(xAxisData);
        EchartData datas = new EchartData();
        for (String data : tableConfig.getMetrics()) {
            datas.setName(data);
            for (Map<String, Object> map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (!mapKey.equals(data)) continue;
                    dataList.add(map.get(mapKey));
                }
            }
            ArrayList arrayList = new ArrayList(dataList);
            datas.setData(arrayList);
            yAxisData.add(datas);
            datas = new EchartData();
            dataList = new ArrayList();
        }
        echartDto.setyAxisData(yAxisData);
        resultMap.put("xAxisData", xAxisData);
        resultMap.put("yAxisData", yAxisData);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    public FormDesignResponse dataSetLoad(ChartApiParamModel chartApiParamModel) {
        SysTableDataSet sysTableDataSet = this.getSysTableDataSet(chartApiParamModel.getDataModelId());
        byte[] decodedBytes = null;
        try {
            decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u89e3\u5bc6\u5931\u8d25");
        }
        String decodedMessage = new String(decodedBytes);
        List allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), decodedMessage);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u914d\u7f6e");
        }
        return FormDesignResponse.success((int)200, allTableList, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public List<QueryConditionModel> getQueryCondition(String id, String queryName) {
        HashMap fileDatas = new HashMap();
        List<Object> queryModels = new ArrayList<QueryConditionModel>();
        String dataCellInfoData = null;
        try {
            dataCellInfoData = ((DataCellInfo)this.dataCellInfoService.get(id)).getData();
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSON.parseObject(dataCellInfoData);
        JSONArray queryObject = jsonObject.getJSONArray("queryConditions");
        for (int i = 0; i < queryObject.size(); ++i) {
            JSONObject object = JSON.parseObject((String)queryObject.get(i).toString());
            if (!queryName.equals(object.get((Object)"name").toString())) continue;
            queryModels = JSONArray.parseArray((String)object.get((Object)"fields").toString(), QueryConditionModel.class);
        }
        return queryModels;
    }

    public StringBuilder getSelectedField(String id) {
        ArrayList<String> fieldList = new ArrayList<String>();
        HashMap fileDatas = new HashMap();
        String dataCellInfoData = null;
        try {
            dataCellInfoData = ((DataCellInfo)this.dataCellInfoService.get(id)).getData();
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSON.parseObject(dataCellInfoData);
        JSONArray queryObject = jsonObject.getJSONArray("projection");
        List projectionField = JSONArray.parseArray((String)queryObject.toString(), ProjectionField.class);
        for (int i = 0; i < projectionField.size(); ++i) {
            if (ToolUtil.isNotEmpty((Object)((ProjectionField)projectionField.get(i)).getFieldAlias())) {
                ((ProjectionField)projectionField.get(i)).setField(((ProjectionField)projectionField.get(i)).getFieldAlias());
                fieldList.add(((ProjectionField)projectionField.get(i)).getField());
                continue;
            }
            fieldList.add(((ProjectionField)projectionField.get(i)).getField());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ToolUtil.isNotEmpty(fieldList)) {
            for (int i = 0; i < fieldList.size(); ++i) {
                stringBuilder.append((String)fieldList.get(i)).append(",");
                if (i != fieldList.size() - 1) continue;
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
            }
        }
        return stringBuilder;
    }

    public SysTableDataSet getSysTableDataSet(String id) {
        String dataCellInfoData = null;
        SysTableDataSet sysTableDataSet = new SysTableDataSet();
        try {
            dataCellInfoData = ((DataCellInfo)this.dataCellInfoService.get(id)).getData();
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSON.parseObject(dataCellInfoData);
        String sqlStateMent = jsonObject.getString("sqlStatement");
        String dataSourceId = jsonObject.getString("dataSourceId");
        sysTableDataSet.setDataSourceId(dataSourceId);
        sysTableDataSet.setSqlContent(sqlStateMent);
        return sysTableDataSet;
    }

    public List<SortConditionFields> getSortAtrr(String id, String name) {
        ArrayList fieldList = new ArrayList();
        HashMap fileDatas = new HashMap();
        List<Object> projectionField = new ArrayList<SortConditionFields>();
        String dataCellInfoData = null;
        try {
            dataCellInfoData = ((DataCellInfo)this.dataCellInfoService.get(id)).getData();
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = JSON.parseObject(dataCellInfoData);
        JSONArray queryObject = jsonObject.getJSONArray("sortCondition");
        for (int i = 0; i < queryObject.size(); ++i) {
            JSONObject jsonObject1 = JSON.parseObject((String)queryObject.get(i).toString());
            if (!name.equals(jsonObject1.get((Object)"name"))) continue;
            JSONArray jsonArray = JSONArray.parseArray((String)jsonObject1.get((Object)"fields").toString());
            projectionField = JSONArray.parseArray((String)jsonArray.toString(), SortConditionFields.class);
        }
        return projectionField;
    }
}

