/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.tabledataset.service.impl;

import com.jxdinfo.hussar.formdesign.api.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.TableConfigDto;
import com.jxdinfo.hussar.formdesign.api.tabledataset.model.SysTableDataSet;
import com.jxdinfo.hussar.formdesign.api.tabledataset.service.TableDataSetService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.server.dataset.service.impl.DataSetServiceImpl;
import com.jxdinfo.hussar.formdesign.server.tabledataset.dao.TableDataSetMapper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TableDataSetServiceImpl
extends HussarServiceImpl<TableDataSetMapper, SysTableDataSet>
implements TableDataSetService {
    @Autowired
    private DataSetServiceImpl dataSetService;

    public FormDesignResponse addDataSet(DataSetInfoDto dataSetInfoDto) {
        TableConfigDto tableConfigDto = new TableConfigDto();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        tableConfigDto.setTables(dataSetInfoDto.getTables());
        tableConfigDto.setProjection(dataSetInfoDto.getProjection());
        tableConfigDto.setQuery(dataSetInfoDto.getQuery());
        tableConfigDto.setSort(dataSetInfoDto.getSort());
        tableConfigDto.setRelationship(dataSetInfoDto.getRelationship());
        tableConfigDto.setDataSourceId(dataSetInfoDto.getDataSourceId());
        String sql = (String)this.dataSetService.generateSql(tableConfigDto).getData();
        byte[] inputBytes = sql.getBytes(StandardCharsets.UTF_8);
        byte[] encodedSql = null;
        try {
            encodedSql = Base64.getEncoder().encode(inputBytes);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            formDesignResponse.setErrorCode(10001);
            formDesignResponse.setErrorMsg("sql\u52a0\u5bc6\u5f02\u5e38");
        }
        String encodedString = new String(encodedSql, StandardCharsets.UTF_8);
        dataSetInfoDto.setSqlContent(sql);
        formDesignResponse.setData((Object)this.saveOrUpdate((BaseEntity)dataSetInfoDto));
        return formDesignResponse;
    }
}

