/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.dataset.service.impl;

import com.jxdinfo.hussar.formdesign.api.dataset.dto.EchartData;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.EchartDto;
import com.jxdinfo.hussar.formdesign.api.dataset.dto.TableConfigDto;
import com.jxdinfo.hussar.formdesign.api.dataset.model.ChartApiParamModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.DataSetQueryModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.DataSetSortModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.DatasetGroupModel;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Dimension;
import com.jxdinfo.hussar.formdesign.api.dataset.model.JoinSubset;
import com.jxdinfo.hussar.formdesign.api.dataset.model.JoinTable;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Metrics;
import com.jxdinfo.hussar.formdesign.api.dataset.model.ProjectionField;
import com.jxdinfo.hussar.formdesign.api.dataset.model.Tables;
import com.jxdinfo.hussar.formdesign.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.formdesign.api.datasource.config.rule.DbType;
import com.jxdinfo.hussar.formdesign.api.datasource.dto.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceDataService;
import com.jxdinfo.hussar.formdesign.api.tabledataset.model.SysTableDataSet;
import com.jxdinfo.hussar.formdesign.api.util.FieldUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.server.tabledataset.service.impl.TableDataSetServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetServiceImpl
implements DataSetService {
    private static final Logger logger = LoggerFactory.getLogger(DataSetServiceImpl.class);
    @Autowired
    private DataSourceDataService datasourceDataService;
    @Autowired
    private TableDataSetServiceImpl tableDataSetService;

    public Map<String, Object> previewData(TableConfigDto tableConfigDto) throws LcdpException, IOException {
        String sql = this.generateSql(tableConfigDto).getData().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] decodedBytes = null;
        try {
            decodedBytes = Base64.getDecoder().decode(sql);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6sql\u89e3\u5bc6\u5931\u8d25");
            return map;
        }
        String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
        if (tableConfigDto.getTables() == null && !ToolUtil.isNotEmpty((Object)tableConfigDto.getTables()) && tableConfigDto.getTables().size() != 0) {
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6\u914d\u7f6e\u9519\u8bef");
            return map;
        }
        List tableList = new ArrayList();
        try {
            tableList = this.datasourceDataService.selectDataBySql(tableConfigDto.getDataSourceId(), decodedString);
        }
        catch (Exception e) {
            HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6\u67e5\u8be2\u5931\u8d25");
            pageMap.put("pageSize", 10);
            pageMap.put("totalPages", 1);
            pageMap.put("total", 0);
            map.put("page", pageMap);
            e.printStackTrace();
            return map;
        }
        if (tableList == null || ToolUtil.isEmpty(tableList)) {
            HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
            map.put("code", 10001);
            map.put("msg", "\u6570\u636e\u96c6\u67e5\u8be2\u5931\u8d25");
            pageMap.put("pageSize", 10);
            pageMap.put("totalPages", 1);
            pageMap.put("total", 0);
            map.put("page", pageMap);
            return map;
        }
        int startIndex = (tableConfigDto.getPage() - 1) * tableConfigDto.getPageSize();
        int endIndex = Math.min(startIndex + tableConfigDto.getPageSize(), tableList.size());
        List pageTableList = tableList.subList(startIndex, endIndex);
        ArrayList pageColumns = new ArrayList();
        for (ProjectionField projectionField : tableConfigDto.getProjection()) {
            if ("calc".equals(projectionField.getType())) {
                projectionField.setField("calc_" + projectionField.getField());
            } else {
                projectionField.setField(projectionField.getTable() + "_" + projectionField.getField());
            }
            HashMap<String, String> map1 = new HashMap<String, String>();
            if ("calc".equals(projectionField.getType())) {
                projectionField.setField(projectionField.getRename());
            }
            map1.put("field", projectionField.getField());
            if ("".equals(projectionField.getRename())) {
                projectionField.setRename(projectionField.getField());
            }
            map1.put("title", projectionField.getRename());
            pageColumns.add(map1);
        }
        Integer total = tableList.size();
        int totalPages = 1;
        try {
            totalPages = (int)Math.ceil((double)total.intValue() / (double)tableConfigDto.getPageSize().intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", 10001);
            map.put("msg", "\u8868\u683c\u5c55\u793a\u6761\u6570\u4e0d\u80fd\u4e3a\u96f6");
            return map;
        }
        HashMap<String, Integer> pageMap = new HashMap<String, Integer>();
        pageMap.put("pageSize", tableConfigDto.getPageSize());
        pageMap.put("totalPages", totalPages);
        pageMap.put("total", total);
        map.put("tableDatas", pageTableList);
        map.put("tableColumns", pageColumns);
        map.put("page", pageMap);
        map.put("code", 200);
        return map;
    }

    public FormDesignResponse generateSql(TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder;
        String dbType;
        StringBuilder sql = new StringBuilder();
        FormDesignResponse response = new FormDesignResponse();
        try {
            DatasourceConfigDTO configDTO = this.datasourceDataService.getDatasourceNameById(Long.valueOf(tableConfigDto.getDataSourceId()));
            dbType = configDTO.getRealDbType();
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
            response.setErrorCode(10001);
            response.setErrorMsg("\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
            response.setData((Object)false);
            return response;
        }
        sql.append("SELECT ");
        if (tableConfigDto.getProjection() == null || !ToolUtil.isNotEmpty((Object)tableConfigDto.getProjection()) || tableConfigDto.getProjection().size() == 0) {
            response.setErrorCode(10001);
            response.setErrorMsg("\u6570\u636e\u96c6\u914d\u7f6e\u9519\u8bef");
            response.setData((Object)false);
            return response;
        }
        sql.append((CharSequence)this.combineField(tableConfigDto.getProjection()));
        sql.append("\n").append("FROM ");
        if (tableConfigDto.getTables().size() == 1) {
            sql.append(((Tables)tableConfigDto.getTables().get(0)).getName()).append("\n");
        }
        if (tableConfigDto.getTables() == null || !ToolUtil.isNotEmpty((Object)tableConfigDto.getTables()) || tableConfigDto.getTables().size() == 0) {
            response.setErrorCode(10001);
            response.setErrorMsg("\u6570\u636e\u96c6\u914d\u7f6e\u9519\u8bef");
            response.setData((Object)false);
            return response;
        }
        if (tableConfigDto.getRelationship() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getRelationship()) && tableConfigDto.getRelationship().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertJoin(tableConfigDto.getRelationship());
            if ("".equals(stringBuilder)) {
                response.setErrorCode(10001);
                response.setErrorMsg("\u6570\u636e\u96c6\u5173\u8054\u914d\u7f6e\u9519\u8bef");
                response.setData((Object)false);
                return response;
            }
            sql.append((CharSequence)stringBuilder);
        }
        if (tableConfigDto.getQuery() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getQuery()) && tableConfigDto.getQuery().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertquery(tableConfigDto.getQuery(), dbType);
            if (!"".equals(stringBuilder.toString())) {
                sql.append("WHERE ").append((CharSequence)stringBuilder);
            }
        }
        if (tableConfigDto.getSort() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getSort()) && tableConfigDto.getSort().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertSort(tableConfigDto.getSort());
            if ("".equals(stringBuilder)) {
                response.setErrorCode(10001);
                response.setErrorMsg("\u6392\u5e8f\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
                response.setData((Object)false);
                return response;
            }
            sql.append((CharSequence)stringBuilder);
        }
        if (tableConfigDto.getGroup() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getGroup()) && tableConfigDto.getGroup().size() != 0) {
            stringBuilder = new StringBuilder();
            stringBuilder = this.convertGroup(tableConfigDto.getGroup());
            if ("".equals(stringBuilder)) {
                response.setErrorCode(10001);
                response.setErrorMsg("\u5206\u7ec4\u6761\u4ef6\u914d\u7f6e\u9519\u8bef");
                response.setData((Object)false);
                return response;
            }
            sql.append((CharSequence)stringBuilder);
        }
        byte[] inputBytes = sql.toString().getBytes(StandardCharsets.UTF_8);
        byte[] encodedSql = Base64.getEncoder().encode(inputBytes);
        String encodedString = new String(encodedSql, StandardCharsets.UTF_8);
        response.setData((Object)encodedString);
        return response;
    }

    public StringBuilder getQueryByTypeMysql(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getCondition()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "regexp": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("REGEXP ").append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
        }
        return sql;
    }

    public StringBuilder getQueryByTypeDM(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getCondition()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "regexp": {
                sql.append("REGEXP_LIKE(").append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(",").append("'").append(tableFilter.getValue()).append("'").append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
        }
        return sql;
    }

    public StringBuilder getQueryByTypeOracle(DataSetQueryModel tableFilter) {
        StringBuilder sql = new StringBuilder();
        switch (tableFilter.getCondition()) {
            case ">": 
            case "<": 
            case "=": 
            case "!=": 
            case "<=": 
            case ">=": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" ").append(tableFilter.getValue()).append(" ").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "in": 
            case "not in": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append(tableFilter.getCondition()).append(" (").append(tableFilter.getValue()).append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "full_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "left_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '").append(tableFilter.getValue().replace("'", "")).append("%'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "right_like": {
                sql.append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(" ").append("LIKE").append(" '%").append(tableFilter.getValue().replace("'", "")).append("'").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
            case "regexp": {
                sql.append("REGEXP_LIKE(").append(tableFilter.getTable()).append(".").append(tableFilter.getField()).append(",").append("'").append(tableFilter.getValue()).append("'").append(")").append("\n");
                sql.append(tableFilter.getPreCondition()).append(" ");
                break;
            }
        }
        return sql;
    }

    public StringBuilder convertJoin(List<JoinTable> joinTables) {
        StringBuilder sql = new StringBuilder();
        for (JoinTable joinTable : joinTables) {
            if ("".equals(joinTable.getLeftTable()) || "".equals(joinTable.getRightTable())) {
                return new StringBuilder();
            }
            for (Object joinSubset : joinTable.getChildren()) {
                if (!FieldUtil.isFieldNull((Object)joinSubset)) continue;
                return new StringBuilder();
            }
            String joinType = null;
            switch (joinTable.getJoinType()) {
                case "left": {
                    joinType = "LEFT JOIN";
                    break;
                }
                case "right": {
                    joinType = "RIGHT JOIN";
                    break;
                }
                case "inner": {
                    joinType = "INNER JOIN";
                }
            }
            sql.append(joinTable.getLeftTable()).append(" ").append(joinType).append(" ").append(joinTable.getRightTable()).append(" ON ");
            int times = 1;
            for (JoinSubset joinSubset : joinTable.getChildren()) {
                sql.append(joinTable.getLeftTable()).append(".").append(joinSubset.getLeftField()).append(" ").append(joinSubset.getCondition()).append(" ").append(joinTable.getRightTable()).append(".").append(joinSubset.getRightField()).append(" ").append("\n");
                if (times != joinTable.getChildren().size()) {
                    sql.append(joinSubset.getPreCondition()).append(" ");
                }
                ++times;
            }
        }
        return sql;
    }

    public StringBuilder convertSort(List<DataSetSortModel> sortConditionList) {
        StringBuilder sql = new StringBuilder();
        sql.append("ORDER BY ");
        for (DataSetSortModel joinSort : sortConditionList) {
            if (FieldUtil.isFieldNull((Object)joinSort)) {
                return new StringBuilder();
            }
            sql.append(joinSort.getTable()).append(".").append(joinSort.getField()).append(" ").append(joinSort.getDirection()).append(",").append("\n");
        }
        sql.deleteCharAt(sql.length() - 2);
        return sql;
    }

    public StringBuilder convertGroup(List<DatasetGroupModel> groupFieldList) {
        StringBuilder sql = new StringBuilder();
        sql.append("GROUP BY ");
        for (DatasetGroupModel joinGroup : groupFieldList) {
            if (FieldUtil.isFieldNull((Object)joinGroup)) {
                return new StringBuilder();
            }
            sql.append(joinGroup.getTable()).append(".").append(joinGroup.getField()).append(", ");
        }
        sql.deleteCharAt(sql.length() - 2);
        return sql;
    }

    public StringBuilder convertquery(List<DataSetQueryModel> filterList, String dbType) {
        StringBuilder sql = new StringBuilder();
        int i = 0;
        for (DataSetQueryModel tableFilter : filterList) {
            tableFilter.setValue(this.fieldType(tableFilter.getFieldType(), tableFilter.getValue()));
            if ("row".equals(tableFilter.getType())) {
                if (!ToolUtil.isNotEmpty((Object)tableFilter.getTable()) || !ToolUtil.isNotEmpty((Object)tableFilter.getField()) || !ToolUtil.isNotEmpty((Object)tableFilter.getValue())) continue;
                if (DbType.MYSQL.getValue().equalsIgnoreCase(dbType)) {
                    sql.append((CharSequence)this.getQueryByTypeMysql(tableFilter));
                } else if (DbType.ORACLE.getValue().equalsIgnoreCase(dbType)) {
                    sql.append((CharSequence)this.getQueryByTypeOracle(tableFilter));
                } else if (DbType.DM.getValue().equalsIgnoreCase(dbType)) {
                    sql.append((CharSequence)this.getQueryByTypeDM(tableFilter));
                } else {
                    logger.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01");
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff01");
                }
                if (++i != filterList.size()) continue;
                sql.setLength(sql.length() - (tableFilter.getPreCondition().length() + 1));
                continue;
            }
            if (!"child".equals(tableFilter.getType()) || tableFilter.getChildren().size() == 0) continue;
            sql.append("(");
            sql.append((CharSequence)this.convertquery(tableFilter.getChildren(), dbType)).append(")");
        }
        return sql;
    }

    public String fieldType(String fieldType, String fieldValue) {
        switch (fieldType.toUpperCase()) {
            case "CHAR": 
            case "VARCHAR": 
            case "TEXT": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "LONGTEXT": 
            case "ENUM": {
                return "'" + fieldValue + "'";
            }
            case "DATE": 
            case "TIME": 
            case "YEAR": 
            case "DATETIME": 
            case "TIMESTAMP": {
                return "'" + fieldValue + "'";
            }
            case "INT": 
            case "SMALLINT": 
            case "MEDIUMINT": 
            case "INTEGER": 
            case "BIGINT": 
            case "LONG": {
                return fieldValue;
            }
            case "FLOAT": 
            case "DOUBLE": 
            case "DECIMAL": {
                return fieldValue;
            }
            case "BIT": 
            case "TINYINT": {
                return fieldValue;
            }
        }
        return fieldValue;
    }

    public StringBuilder combineField(List<ProjectionField> projectionFields) {
        StringBuilder sql = new StringBuilder();
        for (ProjectionField projectionField : projectionFields) {
            if ("default".equals(projectionField.getType())) {
                sql.append(projectionField.getTable()).append(".").append(projectionField.getField()).append(" ").append(" AS ").append(projectionField.getTable()).append("_").append(projectionField.getField()).append(",").append("\n");
                continue;
            }
            if (!"calc".equals(projectionField.getType())) continue;
            sql.append(projectionField.getExpression());
            sql.append(" AS '").append(projectionField.getRename()).append("'").append(",").append("\n");
        }
        if (!sql.toString().isEmpty()) {
            sql.setLength(sql.length() - 2);
        }
        return sql;
    }

    private static boolean isBelongList(String str) {
        ArrayList<String> calcLists = new ArrayList<String>();
        calcLists.add("count");
        calcLists.add("sum");
        calcLists.add("max");
        calcLists.add("min");
        calcLists.add("avg");
        boolean bResult = false;
        for (String temp : calcLists) {
            if (!str.contains(temp)) continue;
            bResult = true;
        }
        return bResult;
    }

    public List<String[]> exportCsv(TableConfigDto tableConfigDto, String sql) throws LcdpException, IOException {
        List allTableList = this.datasourceDataService.selectDataBySql(tableConfigDto.getDataSourceId(), sql);
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        Map keyMap = (Map)allTableList.get(0);
        String[] keysArray = new String[keyMap.size()];
        int k = 0;
        for (String key : keyMap.keySet()) {
            keysArray[k++] = key;
        }
        dataList.add(keysArray);
        for (Map map : allTableList) {
            String[] keyValueArray = new String[map.size() * 2];
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                keyValueArray[i++] = entry.getValue().toString();
            }
            dataList.add(keyValueArray);
        }
        return dataList;
    }

    public Map<String, Object> viewDataSet(TableConfigDto tableConfigDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SysTableDataSet sysTableDataSet = new SysTableDataSet();
        try {
            sysTableDataSet = (SysTableDataSet)this.tableDataSetService.getById((Serializable)((Object)tableConfigDto.getDataModelId()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        byte[] decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        String decodedMessage = new String(decodedBytes);
        String finalSql = "";
        try {
            finalSql = this.splitSql(decodedMessage, tableConfigDto);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        List allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), finalSql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u67e5\u8be2\u5931\u8d25");
        }
        EchartDto echartDto = new EchartDto();
        ArrayList<String> xAxisData = new ArrayList<String>();
        ArrayList<EchartData> yAxisData = new ArrayList<EchartData>();
        ArrayList dataList = new ArrayList();
        for (Dimension dimension : tableConfigDto.getDim()) {
            for (Object map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (!mapKey.equals(dimension.getFieldName())) continue;
                    xAxisData.addAll(Collections.singleton(map.get(mapKey).toString()));
                }
            }
        }
        echartDto.setxAxisData(xAxisData);
        EchartData datas = new EchartData();
        for (Metrics data : tableConfigDto.getMetric()) {
            datas.setName(data.getLegendName());
            for (Map map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (data.getAggFunc() != null || !data.getAggFunc().isEmpty()) {
                        if (!mapKey.equals(String.format("%s(%s)", data.getAggFunc(), data.getFieldName()))) continue;
                        dataList.add(map.get(mapKey));
                        continue;
                    }
                    if (!mapKey.equals(data.getFieldName())) continue;
                    dataList.add(map.get(mapKey));
                }
            }
            ArrayList newList = new ArrayList(dataList);
            datas.setData(newList);
            yAxisData.add(datas);
            datas = new EchartData();
            dataList = new ArrayList();
        }
        echartDto.setyAxisData(yAxisData);
        resultMap.put("xAxisData", xAxisData);
        resultMap.put("yAxisData", yAxisData);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    public FormDesignResponse publishViewData(ChartApiParamModel chartApiParamModel) {
        SysTableDataSet sysTableDataSet = new SysTableDataSet();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        try {
            sysTableDataSet = (SysTableDataSet)this.tableDataSetService.getById((Serializable)((Object)chartApiParamModel.getDataModelId()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        byte[] decodedBytes = null;
        try {
            decodedBytes = Base64.getDecoder().decode(sysTableDataSet.getSqlContent());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6sql\u89e3\u5bc6\u5931\u8d25");
        }
        String decodedMessage = new String(decodedBytes);
        String sql = this.combinePublishedSql(decodedMessage, chartApiParamModel);
        ArrayList<Map<String, Object>> allTableList = new ArrayList();
        try {
            allTableList = this.datasourceDataService.selectDataBySql(sysTableDataSet.getDataSourceId(), sql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u6570\u636e\u96c6\u914d\u7f6e");
        }
        Map<Object, Object> resultMap = new HashMap();
        resultMap = this.getResult(allTableList, chartApiParamModel);
        formDesignResponse.setData(resultMap);
        return formDesignResponse;
    }

    private String splitSql(String sql, TableConfigDto tableConfigDto) {
        StringBuilder splitSql = new StringBuilder();
        splitSql.append("WITH T AS (").append("\n").append(sql).append(")").append("\n");
        String selectSql = this.combineDatasetSql(tableConfigDto);
        splitSql.append(selectSql);
        return splitSql.toString();
    }

    private String combineDatasetSql(TableConfigDto tableConfigDto) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        stringBuilder.append(((Dimension)tableConfigDto.getDim().get(0)).getFieldName()).append(",");
        ArrayList targetField = new ArrayList(tableConfigDto.getMetric());
        ArrayList dimensions = new ArrayList(tableConfigDto.getDim());
        if (targetField != null && !targetField.isEmpty()) {
            for (Metrics metrics : targetField) {
                if (!metrics.getFieldName().isEmpty() && !metrics.getAggFunc().isEmpty()) {
                    stringBuilder.append(metrics.getAggFunc()).append("(").append(metrics.getFieldName()).append(")").append(",");
                    continue;
                }
                stringBuilder.append(metrics.getFieldName()).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" FROM T");
        stringBuilder.append("\n");
        if (tableConfigDto.getQuery() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getQuery()) && tableConfigDto.getQuery().size() != 0) {
            String dbType;
            try {
                DatasourceConfigDTO configDTO = this.datasourceDataService.getDatasourceNameById(Long.valueOf(tableConfigDto.getDataSourceId()));
                dbType = configDTO.getRealDbType();
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
                throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
            }
            stringBuilder = this.convertquery(tableConfigDto.getQuery(), dbType);
        }
        if (dimensions != null && !dimensions.isEmpty()) {
            stringBuilder.append("GROUP BY").append(" ");
            for (Dimension field : dimensions) {
                stringBuilder.append(" ").append(field.getFieldName()).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        if (tableConfigDto.getSort() != null && ToolUtil.isNotEmpty((Object)tableConfigDto.getSort()) && tableConfigDto.getSort().size() != 0) {
            stringBuilder = this.convertSort(tableConfigDto.getSort());
        }
        return stringBuilder.toString();
    }

    public String combinePublishedSql(String sql, ChartApiParamModel chartApiParamModel) {
        StringBuilder splitSql = new StringBuilder();
        splitSql.append("WITH T AS (").append("\n").append(sql).append(")").append("\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getDim())) {
            for (String s : chartApiParamModel.getDim()) {
                stringBuilder.append(s).append(",");
            }
        }
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getMetrics())) {
            for (String s : chartApiParamModel.getMetrics()) {
                stringBuilder.append(s).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(" FROM T\n");
        if (ToolUtil.isNotEmpty((Object)chartApiParamModel.getDim())) {
            stringBuilder.append("GROUP BY ");
            for (String s : chartApiParamModel.getDim()) {
                stringBuilder.append(s).append(",");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        splitSql.append((CharSequence)stringBuilder);
        return splitSql.toString();
    }

    public Map<String, Object> getResult(List<Map<String, Object>> allTableList, ChartApiParamModel tableConfig) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        EchartDto echartDto = new EchartDto();
        ArrayList<String> xAxisData = new ArrayList<String>();
        ArrayList<EchartData> yAxisData = new ArrayList<EchartData>();
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (String s : tableConfig.getDim()) {
            for (Map<String, Object> map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (!mapKey.equals(s)) continue;
                    xAxisData.addAll(Collections.singleton(map.get(mapKey).toString()));
                }
            }
        }
        echartDto.setxAxisData(xAxisData);
        EchartData datas = new EchartData();
        for (String data : tableConfig.getMetrics()) {
            datas.setName(data);
            for (Map<String, Object> map : allTableList) {
                for (String mapKey : map.keySet()) {
                    if (!mapKey.equals(data)) continue;
                    dataList.add(map.get(mapKey));
                }
            }
            ArrayList arrayList = new ArrayList(dataList);
            datas.setData(arrayList);
            yAxisData.add(datas);
            datas = new EchartData();
            dataList = new ArrayList();
        }
        echartDto.setyAxisData(yAxisData);
        resultMap.put("xAxisData", xAxisData);
        resultMap.put("yAxisData", yAxisData);
        if (ToolUtil.isNotEmpty(resultMap)) {
            return resultMap;
        }
        resultMap.put("code", 10001);
        resultMap.put("msg", "\u6307\u6807\u7ef4\u5ea6\u83b7\u53d6\u5931\u8d25");
        return resultMap;
    }

    public List<Map<String, Object>> getDatasetData(String dataSourceId, String sql) throws Exception {
        byte[] decodedBytes = Base64.getDecoder().decode(sql);
        String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
        return this.datasourceDataService.selectDataBySql(dataSourceId, decodedString);
    }
}

