/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.api.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.api.datasource.config.rule.DbType;
import com.jxdinfo.hussar.formdesign.api.datasource.dto.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.api.datasource.model.TableInfos;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceDataService;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceService;
import com.jxdinfo.hussar.formdesign.api.model.DBConnParams;
import com.jxdinfo.hussar.formdesign.api.model.DataSources;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceDataServiceImpl
implements DataSourceDataService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDataServiceImpl.class);
    private final ResourcePathService resourcePathService;
    private final DataSourceService dataSourceService;
    private final FormDesignProperties formDesignProperties;
    private final StorageService storageService;

    @Autowired
    public DataSourceDataServiceImpl(ResourcePathService resourcePathService, DataSourceService dataSourceService, FormDesignProperties formDesignProperties, StorageService storageService) {
        this.resourcePathService = resourcePathService;
        this.dataSourceService = dataSourceService;
        this.formDesignProperties = formDesignProperties;
        this.storageService = storageService;
    }

    public List<TableInfos> getTableInfoById(Long id, String type) throws LcdpException, IOException {
        List tableInfoList = null;
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            tableInfoList = this.dataSourceService.getDataSourceInfo(configDTO.getName(), dataSourceConfig, type);
        }
        return tableInfoList;
    }

    private DataSourceConfig getDataSourceConfig(DatasourceConfigDTO dataSourceConfigDTO) throws IOException {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        this.configConnParam(dataSourceConfigDTO, dataSourceConfig);
        dataSourceConfig.setUsername(dataSourceConfigDTO.getUsername());
        dataSourceConfig.setPassword(dataSourceConfigDTO.getPassword());
        dataSourceConfig.setDbType(Collections.singletonList(DbType.MYSQL.getValue()));
        dataSourceConfig.setDbName(dataSourceConfigDTO.getDbName());
        dataSourceConfig.setSchemaname(dataSourceConfigDTO.getSchemaname());
        if (dataSourceConfigDTO.getDbType().size() > 1) {
            dataSourceConfig.setDbTypeCustom((String)dataSourceConfigDTO.getDbType().get(1));
        }
        return dataSourceConfig;
    }

    private void configConnParam(DatasourceConfigDTO dataSourceConfigDTO, DataSourceConfig dataSourceConfig) throws IOException {
        String host = dataSourceConfigDTO.getHost();
        String port = dataSourceConfigDTO.getPort();
        String dbType = "";
        if (dataSourceConfigDTO.getDbType().size() > 1) {
            dbType = (String)dataSourceConfigDTO.getDbType().get(1);
        }
        Map dbConnParamMap = this.getConnTypeConfigMap().get("DATABASE").getType();
        DBConnParams dbConnParams = (DBConnParams)dbConnParamMap.get(dbType);
        String urlTemplate = dbConnParams.getUrlTemplate();
        String driverName = dbConnParams.getDriverClassName();
        String url = urlTemplate.replace("${host}", host).replace("${port}", port).replace("${dbName}", dataSourceConfigDTO.getDbName());
        if ("HIGHGO".equals(dbType)) {
            url = url.replace("${schemaname}", dataSourceConfigDTO.getSchemaname());
        }
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setDriverName(driverName);
    }

    public Map<String, DataSources> getConnTypeConfigMap() throws IOException {
        if (this.formDesignProperties.getScenes().isSharedStorage()) {
            return this.getConnTypeConfigMapRemote();
        }
        return this.getConnTypeConfigMapLocal();
    }

    private Map<String, DataSources> getConnTypeConfigMapRemote() {
        return (Map)JSON.parseObject((String)this.dataSourceService.defaultDBTypeConfig(), (TypeReference)new TypeReference<HashMap<String, DataSources>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
    }

    private Map<String, DataSources> getConnTypeConfigMapLocal() throws IOException {
        return (Map)JSON.parseObject((String)this.dataSourceService.defaultDBTypeConfig(), (TypeReference)new TypeReference<HashMap<String, DataSources>>(){}, (Feature[])new Feature[0]);
    }

    private DatasourceConfigDTO getDatasourceNameById(Long id) throws IOException {
        List<DatasourceConfigDTO> datasourceConfigDTOList = this.getList();
        if (null != datasourceConfigDTOList) {
            for (DatasourceConfigDTO configDTO : datasourceConfigDTOList) {
                if (!HussarUtils.equals((Object)configDTO.getId(), (Object)id)) continue;
                return configDTO;
            }
        }
        return null;
    }

    public List<DatasourceConfigDTO> getList() throws IOException {
        Map<Long, DatasourceConfigDTO> dataSourceConfigDTOMap;
        List datasourceConfigDTOList = this.dataSourceService.getDataSourceList();
        if (ToolUtil.isNotEmpty((Object)datasourceConfigDTOList) && null != (dataSourceConfigDTOMap = this.getDataSourceConfigDTOMap())) {
            for (DatasourceConfigDTO configDTO : dataSourceConfigDTOMap.values()) {
                if (this.isDataBaseDataSource(configDTO)) continue;
                datasourceConfigDTOList.add(configDTO);
            }
        }
        return datasourceConfigDTOList;
    }

    private boolean isDataBaseDataSource(DatasourceConfigDTO configDTO) {
        return ToolUtil.isNotEmpty((Object)configDTO.getDbType()) && HussarUtils.equals(configDTO.getDbType().get(0), (Object)"DATABASE");
    }

    public Map<Long, DatasourceConfigDTO> getDataSourceConfigDTOMap() throws IOException {
        if (this.formDesignProperties.getScenes().isSharedStorage()) {
            return this.getDataSourceConfigDTOMapRemote();
        }
        return this.getDataSourceConfigDTOMapLocal();
    }

    private Map<Long, DatasourceConfigDTO> getDataSourceConfigDTOMapRemote() {
        String datasourceStorePath = this.resourcePathService.projectStoreDatasourceFile().getRemotePath();
        StorageResult result = this.storageService.downloadByPath(datasourceStorePath);
        if (result.isSuccess()) {
            String datasourceJSON = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (Map)JSON.parseObject((String)datasourceJSON, (TypeReference)new TypeReference<HashMap<Long, DatasourceConfigDTO>>(){}, (Feature[])new Feature[0]);
        }
        return null;
    }

    private Map<Long, DatasourceConfigDTO> getDataSourceConfigDTOMapLocal() throws IOException {
        File datasourceFile = new File(this.resourcePathService.projectStoreDatasourceFile().getLocalPath());
        if (!datasourceFile.exists()) {
            return null;
        }
        String datasourceJSON = FileUtils.readFileToString((File)datasourceFile, (Charset)StandardCharsets.UTF_8);
        return (Map)JSON.parseObject((String)datasourceJSON, (TypeReference)new TypeReference<HashMap<Long, DatasourceConfigDTO>>(){}, (Feature[])new Feature[0]);
    }

    public List<Map<String, Object>> selectDataBySql(String dataSourceId, String sql) throws IOException, LcdpException {
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(Long.valueOf(dataSourceId));
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
        List mapList = this.dataSourceService.getTableData(configDTO.getName(), dataSourceConfig, sql);
        if (mapList.isEmpty()) {
            return null;
        }
        return mapList;
    }
}

