/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.datasource.controller;

import com.jxdinfo.hussar.formdesign.api.datasource.model.TableInfos;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceDataService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/datasetData"})
public class DataSourcesDataController {
    private Logger logger = LoggerFactory.getLogger(DataSourcesDataController.class);
    @Resource
    private DataSourceDataService datasourceDataService;

    @PostMapping(value={"/getTableInfo"})
    public FormDesignResponse<List<TableInfos>> getTableInfoById(@RequestBody Map<String, Object> params) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        String id = (String)params.get("id");
        String type = (String)params.get("type");
        try {
            speedCodeResponse.setData((Object)this.datasourceDataService.getTableInfoById(Long.valueOf(id), type));
        }
        catch (IOException e) {
            this.logger.error("inputParams:{} and errorMessage:{}", new Object[]{id, e.getMessage(), e});
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_ERROR.getMsg());
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
        }
        catch (LcdpException e) {
            e.printStackTrace();
        }
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }
}

