/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.dataset.controller;

import com.jxdinfo.hussar.formdesign.api.dataset.dto.TableConfigDto;
import com.jxdinfo.hussar.formdesign.api.dataset.model.ChartApiParamModel;
import com.jxdinfo.hussar.formdesign.api.dataset.service.DataSetService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/dataset"})
public class DataSetController {
    @Autowired
    private DataSetService dataSetService;

    @PostMapping(value={"/generateSql"})
    @ApiOperation(value="\u751f\u6210\u6570\u636e\u96c6sql", notes="\u751f\u6210\u6570\u636e\u96c6sql")
    public FormDesignResponse generateSql(@RequestBody TableConfigDto tableConfigDto) {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse = this.dataSetService.generateSql(tableConfigDto);
        return formDesignResponse;
    }

    @PostMapping(value={"/previewData"})
    @ApiOperation(value="\u6570\u636e\u96c6\u6570\u636e\u9884\u89c8", notes="\u6570\u636e\u96c6\u6570\u636e\u9884\u89c8")
    public FormDesignResponse previewData(@RequestBody TableConfigDto tableConfigDto) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        Map map = this.dataSetService.previewData(tableConfigDto);
        formDesignResponse.setData((Object)map);
        return formDesignResponse;
    }

    @PostMapping(value={"/exportCsv"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u96c6\u6570\u636e", notes="\u5bfc\u51fa\u6570\u636e\u96c6\u6570\u636e")
    public FormDesignResponse exportCsv(@RequestBody TableConfigDto tableConfigDto) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        String sql = this.dataSetService.generateSql(tableConfigDto).getData().toString();
        List dataList = this.dataSetService.exportCsv(tableConfigDto, sql);
        formDesignResponse.setData((Object)dataList);
        return formDesignResponse;
    }

    @PostMapping(value={"/viewDataSet"})
    @ApiOperation(value="\u56fe\u8868\u5b9e\u65f6\u9884\u89c8\u6570\u636e", notes="\u56fe\u8868\u5b9e\u65f6\u9884\u89c8\u6570\u636e")
    public FormDesignResponse viewDataSet(@RequestBody TableConfigDto tableConfigDto) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse.setData((Object)this.dataSetService.viewDataSet(tableConfigDto));
        return formDesignResponse;
    }

    @PostMapping(value={"/publishViewData"})
    @ApiOperation(value="\u53d1\u5e03\u540e\u6570\u636e\u5c55\u793a\u67e5\u8be2\u63a5\u53e3", notes="\u53d1\u5e03\u540e\u6570\u636e\u5c55\u793a\u67e5\u8be2\u63a5\u53e3")
    public FormDesignResponse publishViewData(@RequestBody ChartApiParamModel chartApiParamModel) {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        formDesignResponse = this.dataSetService.publishViewData(chartApiParamModel);
        return formDesignResponse;
    }
}

