/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.api.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.api.datasource.config.rule.DbType;
import com.jxdinfo.hussar.formdesign.api.datasource.dto.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.api.datasource.filter.SqlExecuteHandlers;
import com.jxdinfo.hussar.formdesign.api.datasource.model.TableInfos;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataBasesJsonService;
import com.jxdinfo.hussar.formdesign.api.datasource.service.DataSourceService;
import com.jxdinfo.hussar.formdesign.api.util.ModelBeanUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotSharedStorage.class})
public class DataSourcesServiceImpl
implements DataSourceService {
    @Autowired
    private ResourcePathService resourcePathService;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private DataBasesJsonService dataBasesJsonService;
    private static final String HOST_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})";
    private static final String PORT_REG = "(:\\d+)";
    private static final String SQL_SERVER_PORT_REG = "(port=\\d+)";
    private static final String DB_NAME_REG = "(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String SQL_SERVER_DB_NAME_REG = "(databaseName=|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String URL_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern HOST_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})");
    private static final Pattern PORT_PATTERN = Pattern.compile("(:\\d+)");
    private static final Pattern SLQ_SERVER_PORT_PATTERN = Pattern.compile("(port=\\d+)");
    private static final Pattern DB_NAME_PATTERN = Pattern.compile("(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern SQL_SERVER_DB_NAME_PATTERN = Pattern.compile("(databaseName=|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern URL_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+");

    @HussarDs(value="#connName")
    public List<TableInfos> getDataSourceInfo(String connName, DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandlers sqlExecuteHandler = ModelBeanUtil.getDataSourceHandler((String)("database." + dataSourceConfig.getDbTypeCustom().toLowerCase()));
            return sqlExecuteHandler.selectBatch(dataSourceConfig, type);
        }
        return new ArrayList<TableInfos>();
    }

    public List<DatasourceConfigDTO> getDataSourceList() throws IOException {
        String datasourceJSON;
        Map datasourceConfigDTOMap;
        List<DatasourceConfigDTO> configDTOList = this.getTenantList();
        File datasourceFile = new File(this.resourcePathService.projectStoreDatasourceFile().getLocalPath());
        if (datasourceFile.exists() && null != (datasourceConfigDTOMap = (Map)JSON.parseObject((String)(datasourceJSON = FileUtils.readFileToString((File)datasourceFile, (Charset)StandardCharsets.UTF_8)), (TypeReference)new TypeReference<HashMap<String, DatasourceConfigDTO>>(){}, (Feature[])new Feature[0]))) {
            for (DatasourceConfigDTO configDTO : datasourceConfigDTOMap.values()) {
                if (this.isDataBaseDataSource(configDTO)) continue;
                configDTOList.add(configDTO);
            }
        }
        return configDTOList;
    }

    private boolean isDataBaseDataSource(DatasourceConfigDTO configDTO) {
        return ToolUtil.isNotEmpty((Object)configDTO.getDbType()) && HussarUtils.equals(configDTO.getDbType().get(0), (Object)"DATABASE");
    }

    public List<DatasourceConfigDTO> getTenantList() {
        String delFlag = "0";
        ArrayList<DatasourceConfigDTO> configDTOList = new ArrayList<DatasourceConfigDTO>();
        List allTenantDataSource = this.sysDataSourceService.list();
        ((List)Optional.ofNullable(allTenantDataSource).orElse(new ArrayList())).stream().filter(e -> HussarUtils.equals((Object)delFlag, (Object)e.getDelFlag())).collect(Collectors.toList()).forEach(e -> configDTOList.add(this.ofBase((SysDataSource)e)));
        return configDTOList;
    }

    @HussarDs(value="#connName")
    public List<Map<String, Object>> getTableData(String connName, DataSourceConfig dataSourceConfig, String sql) throws LcdpException {
        if (null != dataSourceConfig && null != dataSourceConfig.getDbTypeCustom()) {
            SqlExecuteHandlers sqlExecuteHandler = ModelBeanUtil.getDataSourceHandler((String)("database." + dataSourceConfig.getDbTypeCustom().toLowerCase()));
            try {
                return sqlExecuteHandler.getDataBySql(dataSourceConfig, sql);
            }
            catch (LcdpException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private DatasourceConfigDTO ofBase(SysDataSource formDesignDataSource) {
        if (null == formDesignDataSource) {
            return new DatasourceConfigDTO();
        }
        DatasourceConfigDTO configDTO = new DatasourceConfigDTO();
        configDTO.setId(formDesignDataSource.getId());
        configDTO.setSchemaname(formDesignDataSource.getInstantName());
        configDTO.setUsername(formDesignDataSource.getUserName());
        configDTO.setPassword(formDesignDataSource.getPassword());
        configDTO.setName(formDesignDataSource.getConnName());
        configDTO.setDesc(formDesignDataSource.getRemark());
        List<String> dbType = Arrays.asList("DATABASE", this.getTypeByDriverClass(formDesignDataSource.getDriverClass()));
        configDTO.setDbType(dbType);
        String url = formDesignDataSource.getJdbcUrl();
        if (url.indexOf(63) > -1) {
            url = url.substring(0, url.indexOf(63));
        }
        String host = "";
        String port = "";
        String dbName = "";
        Matcher hostMatcher = HOST_PATTERN.matcher(url);
        if (hostMatcher.find(0)) {
            host = hostMatcher.group(0);
        }
        if (DbType.SQL_SERVER.getDriverClass().equals(formDesignDataSource.getDriverClass())) {
            Matcher urlMatcher;
            Matcher portMatcher = SLQ_SERVER_PORT_PATTERN.matcher(url);
            if (portMatcher.find(0)) {
                port = portMatcher.group(0).substring(5);
            }
            if ((urlMatcher = SQL_SERVER_DB_NAME_PATTERN.matcher(url)).find(0)) {
                dbName = urlMatcher.group(0).substring(13);
            }
        } else {
            Matcher urlMatcher;
            Matcher portMatcher = PORT_PATTERN.matcher(url);
            if (portMatcher.find(0)) {
                port = portMatcher.group(0).substring(1);
            }
            if ((urlMatcher = URL_PATTERN.matcher(url)).find()) {
                String urlName = urlMatcher.group(0);
                if (hostMatcher.find(0)) {
                    urlName = urlName.replace(hostMatcher.group(0), "");
                }
                if (portMatcher.find(0)) {
                    urlName = urlName.replace(portMatcher.group(0), "");
                }
                Matcher dbNameMatcher = DB_NAME_PATTERN.matcher(urlName);
                ArrayList<String> dbNameList = new ArrayList<String>();
                while (dbNameMatcher.find()) {
                    dbNameList.add(dbNameMatcher.group());
                }
                if (ToolUtil.isNotEmpty(dbNameList)) {
                    dbName = ((String)dbNameList.get(dbNameList.size() - 1)).substring(1);
                } else if (DbType.DM.getDriverClass().equalsIgnoreCase(formDesignDataSource.getDriverClass())) {
                    dbName = formDesignDataSource.getUserName();
                }
            }
        }
        configDTO.setDbName(dbName);
        configDTO.setHost(host);
        configDTO.setPort(port);
        return configDTO;
    }

    private String getTypeByDriverClass(String driverClass) {
        for (DbType typeEnum : DbType.values()) {
            if (!typeEnum.getDriverClass().equalsIgnoreCase(driverClass)) continue;
            return typeEnum.getValue().toUpperCase();
        }
        return "";
    }

    public String defaultDBTypeConfig() {
        return this.dataBasesJsonService.getDataSourceType();
    }
}

