/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.server.dataset.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtil.class);

    public static boolean haveNullFiled(Object object) {
        if (Objects.isNull(object)) {
            return true;
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(object) != null && !HussarUtils.isBlank((CharSequence)field.get(object).toString())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5224\u65ad\u5bf9\u8c61\u662f\u5426\u4e3a\u7a7a", (Throwable)e);
        }
        return false;
    }

    public static String replacePlaceholders(String expression, Map<String, String> map) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String id = placeholder.substring(2, placeholder.length() - 1);
            String value = map.getOrDefault(id, "");
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

