/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.refer.PageRefer;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeResultDTO;
import com.jxdinfo.hussar.formdesign.common.service.VueCodeUpgradeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dto.ProcessorConfig;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dto.UpgradeInfoDTO;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dto.UpgradeScopeDTO;
import com.jxdinfo.hussar.formdesign.upgrade.vue.service.IUpgradeVueService;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.UpgradeServiceImpl")
public class UpgradeVueServiceImpl
implements IUpgradeVueService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeVueServiceImpl.class);
    private static final String BACKUP_DIR = "backup";
    private static final String TEMP_SUFFIX = "_temp";
    private static final String HUSSAR_EXTENSION = ".hussar";
    private static final String RECORDS_JSON = "upgrade_records.json";
    private static final String VUE_EXTENSION = ".vue";
    private static final String FILE_TYPE_CURRENT = "currentFile";
    private static final String FILE_TYPE_LAST_PUBLISH = "lastPublish";
    private static final String FILE_TYPE_LAST_FILE = "lastFile";
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final PathStrategyService pathStrategy;
    private final FileMappingService fileMappingService;
    private final FilePublishService filePublishService;
    private final VueCodeUpgradeService vueCodeUpgradeService;
    private final FileTreeService fileTreeService;
    private final VersionManageService versionManageService;
    private final PageInfoService pageInfoService;

    public UpgradeVueServiceImpl(PathStrategyService pathStrategy, FileMappingService fileMappingService, FilePublishService filePublishService, VueCodeUpgradeService vueCodeUpgradeService, FileTreeService fileTreeService, VersionManageService versionManageService, PageInfoService pageInfoService) {
        this.pathStrategy = pathStrategy;
        this.fileMappingService = fileMappingService;
        this.filePublishService = filePublishService;
        this.vueCodeUpgradeService = vueCodeUpgradeService;
        this.fileTreeService = fileTreeService;
        this.versionManageService = versionManageService;
        this.pageInfoService = pageInfoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<String> upgrade(UpgradeInfoDTO upgradeInfo) {
        String upgradeId = upgradeInfo.getUpgradeId();
        if (this.isUpgraded(upgradeId)) {
            return ApiResponse.fail((String)"\u5347\u7ea7\u6807\u8bc6\u91cd\u590d\uff0c\u8be5\u5347\u7ea7\u4efb\u52a1\u5df2\u6267\u884c\u8fc7");
        }
        JSONObject upgradeFile = new JSONObject();
        upgradeFile.put("upgradeId", (Object)upgradeId);
        upgradeFile.put("upgradeTime", (Object)LocalDateTime.now().format(DATE_TIME_FORMATTER));
        JSONArray allUpgradeRecords = new JSONArray();
        String tempBackupDirPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.getProjectStorePath(), BACKUP_DIR, upgradeId + TEMP_SUFFIX}));
        try {
            Files.createDirectories(Paths.get(tempBackupDirPath, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("\u521b\u5efa\u4e34\u65f6\u5907\u4efd\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        File tempBackupDir = new File(tempBackupDirPath);
        try {
            Object wpdFiles;
            if (AppContextUtil.isHTSZMode() && HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
                for (String appId : this.getAppIds()) {
                    AppContextUtil.setAppId((String)appId);
                    wpdFiles = this.getWpdFiles(upgradeInfo.getUpgradeScope());
                    this.processVueFiles((List<JSONObject>)wpdFiles, upgradeInfo.getUpgradeConfigs(), allUpgradeRecords, tempBackupDirPath, appId, upgradeInfo.getProcessorConfig());
                }
                AppContextUtil.setAppId(null);
            } else {
                List<JSONObject> wpdFiles2 = this.getWpdFiles(upgradeInfo.getUpgradeScope());
                this.processVueFiles(wpdFiles2, upgradeInfo.getUpgradeConfigs(), allUpgradeRecords, tempBackupDirPath, AppContextUtil.getAppId(), upgradeInfo.getProcessorConfig());
            }
            if (!allUpgradeRecords.isEmpty()) {
                upgradeFile.put("upgradeRecords", (Object)allUpgradeRecords);
                String upgradeRecordJsonPath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{tempBackupDirPath, RECORDS_JSON}));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(upgradeRecordJsonPath), StandardCharsets.UTF_8));
                wpdFiles = null;
                try {
                    writer.write(JSON.toJSONString((Object)upgradeFile, (boolean)true));
                }
                catch (Throwable throwable) {
                    wpdFiles = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (wpdFiles != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)wpdFiles).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            try (Stream<Path> paths = Files.list(Paths.get(tempBackupDirPath, new String[0]));){
                String hussarFilePath;
                if (paths.findAny().isPresent() && !Files.exists(Paths.get(hussarFilePath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.getProjectStorePath(), BACKUP_DIR, upgradeId, upgradeId + HUSSAR_EXTENSION})), new String[0]), new LinkOption[0])) {
                    this.compressDirectoryToHussar(tempBackupDirPath, hussarFilePath);
                }
            }
        }
        catch (LcdpException | IOException e) {
            logger.error("Upgrade failed for upgradeId: {}", (Object)upgradeId, (Object)e);
        }
        finally {
            if (tempBackupDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tempBackupDir);
                }
                catch (IOException e) {
                    logger.error("Warning: Failed to delete temporary directory (may leave residual files): {}", (Object)tempBackupDirPath);
                }
            } else {
                logger.warn("Temporary directory does not exist, no need to delete: {}", (Object)tempBackupDirPath);
            }
        }
        return ApiResponse.success((String)"\u5347\u7ea7\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<String> rollback(String upgradeId) {
        String hussarFilePath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.getProjectStorePath(), BACKUP_DIR, upgradeId, upgradeId + HUSSAR_EXTENSION}));
        File hussarFile = new File(hussarFilePath);
        if (!hussarFile.exists() || !hussarFile.isFile()) {
            logger.error("Rollback failed: Backup file not found for upgradeId '{}' at {}", (Object)upgradeId, (Object)hussarFilePath);
            return ApiResponse.fail((String)"\u56de\u6eda\u5931\u8d25\uff1a\u5907\u4efd\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        Path tempUnzipDir = null;
        try {
            tempUnzipDir = Files.createTempDirectory("rollback_" + upgradeId, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Failed to create temporary directory for rollback: {}", (Object)e.getMessage());
        }
        try {
            this.unzipHussarFile(hussarFile, tempUnzipDir.toFile());
            Path recordsJsonPath = tempUnzipDir.resolve(RECORDS_JSON);
            if (!Files.exists(recordsJsonPath, new LinkOption[0])) {
                String errorMsg = "Rollback failed: Upgrade records 'upgrade_records.json' not found in backup.";
                logger.error(errorMsg);
                throw new IOException(errorMsg);
            }
            byte[] bytes = Files.readAllBytes(recordsJsonPath);
            String recordsJsonContent = new String(bytes, StandardCharsets.UTF_8);
            JSONObject recordsJson = JSON.parseObject((String)recordsJsonContent);
            JSONArray rollbackRecords = recordsJson.getJSONArray("upgradeRecords");
            if (HussarUtils.isEmpty((Object)rollbackRecords)) {
                logger.error("No files to rollback for upgradeId: {}", (Object)upgradeId);
                ApiResponse apiResponse = ApiResponse.fail((String)"\u6ca1\u6709\u53ef\u56de\u6eda\u7684\u6587\u4ef6\uff01");
                return apiResponse;
            }
            block26: for (Object recordObj : rollbackRecords) {
                JSONObject upgradeRecord = (JSONObject)recordObj;
                String filePath = upgradeRecord.getString("filePath");
                String backupFileName = upgradeRecord.getString("backupFileName");
                String fileType = upgradeRecord.getString("fileType");
                String pageId = upgradeRecord.getString("pageId");
                String originalFileType = upgradeRecord.getString("originalFileType");
                String appId = upgradeRecord.getString("appId");
                if (HussarUtils.isNotEmpty((Object)appId)) {
                    AppContextUtil.setAppId((String)appId);
                }
                if (HussarUtils.isEmpty((Object)originalFileType) || !"VUE".equals(originalFileType)) continue;
                String backupFileContent = this.readBackupFileContent(tempUnzipDir, backupFileName);
                switch (fileType) {
                    case "currentFile": {
                        this.filePublishService.writeStringToFile(backupFileContent, this.webProjectVue(null, filePath).getLocalPath());
                        continue block26;
                    }
                    case "lastPublish": {
                        this.versionManageService.saveLastPublishCode(pageId, backupFileContent);
                        continue block26;
                    }
                    case "lastFile": {
                        this.versionManageService.saveLastFileCode(pageId, backupFileContent);
                        continue block26;
                    }
                }
                logger.warn("Unknown fileType '{}' in rollback upgradeRecord. Skipping.", (Object)fileType);
            }
        }
        catch (IOException e) {
            logger.error("Rollback failed for upgradeId: {}", (Object)upgradeId, (Object)e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempUnzipDir.toFile());
            }
            catch (IOException e) {
                logger.warn("Warning: Failed to delete temporary unzip directory (may leave residual files): {}", (Object)tempUnzipDir.toAbsolutePath());
            }
        }
        return ApiResponse.success((String)"\u56de\u6eda\u6210\u529f\uff01");
    }

    private void processVueFiles(List<JSONObject> wpdFiles, String upgradeConfigs, JSONArray allUpgradeRecords, String tempBackupDirPath, String appId, ProcessorConfig processorConfig) throws LcdpException, IOException {
        for (JSONObject wpdFile : wpdFiles) {
            String id = wpdFile.getString("id");
            String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
            String pageName = wpdFile.getString("name");
            Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
            Optional<String> lastFileContent = Optional.ofNullable(this.versionManageService.getLastFileCode(id));
            String pagePath = this.webProjectVue(null, moduleRelatePath, pageName + VUE_EXTENSION).getLocalPath();
            Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
            if (!currentContent.isPresent()) {
                logger.warn("Current file content is missing for pageId: {}", (Object)id);
                continue;
            }
            String currentFileCode = currentContent.get();
            if (!ancestorContent.isPresent()) {
                logger.warn("LastPublish content is missing for pageId: {}", (Object)id);
                continue;
            }
            String lastPublishCode = ancestorContent.get();
            if (!lastFileContent.isPresent()) {
                logger.warn("Last file content is missing for pageId: {}", (Object)id);
                continue;
            }
            String lastFileCode = lastFileContent.get();
            UpgradeResultDTO upgradeResultDTO = new UpgradeResultDTO();
            upgradeResultDTO.setCurrentFile(currentFileCode);
            upgradeResultDTO.setLastPublish(lastPublishCode);
            upgradeResultDTO.setLastFile(lastFileCode);
            upgradeResultDTO.setUpgradeConfigs(upgradeConfigs);
            upgradeResultDTO.setHasDict(this.hasDict(id));
            upgradeResultDTO.setHasFormLoaded(this.hasFormLoaded(id));
            upgradeResultDTO.setProcessorConfig(JSON.parseObject((String)JSON.toJSONString((Object)processorConfig)));
            this.handleUpgradeByType(upgradeResultDTO);
            if (upgradeResultDTO.isCurrentFileUpgraded()) {
                JSONObject currentBackupRecord = this.backupSingleFile(id, appId, FileUtil.posixPath((String[])new String[]{moduleRelatePath, pageName + VUE_EXTENSION}), FILE_TYPE_CURRENT, currentFileCode, tempBackupDirPath);
                allUpgradeRecords.add((Object)currentBackupRecord);
                this.filePublishService.writeStringToFile(upgradeResultDTO.getCurrentFile(), pagePath);
            }
            if (upgradeResultDTO.isLastPublishUpgraded()) {
                JSONObject lastPublishBackupRecord = this.backupSingleFile(id, appId, "", FILE_TYPE_LAST_PUBLISH, lastPublishCode, tempBackupDirPath);
                allUpgradeRecords.add((Object)lastPublishBackupRecord);
                this.versionManageService.saveLastPublishCode(id, upgradeResultDTO.getLastPublish());
            }
            if (!upgradeResultDTO.isLastFileUpgraded()) continue;
            JSONObject lastFileBackupRecord = this.backupSingleFile(id, appId, "", FILE_TYPE_LAST_FILE, lastFileCode, tempBackupDirPath);
            allUpgradeRecords.add((Object)lastFileBackupRecord);
            this.versionManageService.saveLastFileCode(id, upgradeResultDTO.getLastFile());
        }
    }

    private void handleUpgradeByType(UpgradeResultDTO upgradeResultDTO) throws LcdpException {
        String upgradeConfigs = upgradeResultDTO.getUpgradeConfigs();
        List configs = JSON.parseArray((String)upgradeConfigs, UpgradeConfig.class);
        Map<Integer, List<UpgradeConfig>> configGroups = configs.stream().collect(Collectors.groupingBy(UpgradeConfig::getHandlerType));
        for (Map.Entry<Integer, List<UpgradeConfig>> entry : configGroups.entrySet()) {
            int handlerType = entry.getKey();
            List<UpgradeConfig> typeConfigs = entry.getValue();
            String groupedConfigJson = JSON.toJSONString(typeConfigs);
            upgradeResultDTO.setUpgradeConfigs(groupedConfigJson);
            switch (handlerType) {
                case 0: {
                    this.vueCodeUpgradeService.upgrade(upgradeResultDTO);
                    break;
                }
                case 1: {
                    this.vueCodeUpgradeService.upgradePlus(upgradeResultDTO);
                    break;
                }
            }
        }
        upgradeResultDTO.setCurrentFile(CodeFormatter.formatterHtml((String)upgradeResultDTO.getCurrentFile(), (String)"vue").getCodeFormatCode());
        upgradeResultDTO.setLastPublish(CodeFormatter.formatterHtml((String)upgradeResultDTO.getLastPublish(), (String)"vue").getCodeFormatCode());
        upgradeResultDTO.setLastFile(CodeFormatter.formatterHtml((String)upgradeResultDTO.getLastFile(), (String)"vue").getCodeFormatCode());
    }

    private JSONObject backupSingleFile(String pageId, String appId, String filePath, String fileType, String fileContent, String tempBackupDirPath) throws IOException {
        String backupFileName = pageId + "_" + fileType + VUE_EXTENSION;
        String backupFilePath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{tempBackupDirPath, backupFileName}));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(backupFilePath), StandardCharsets.UTF_8));){
            writer.write(fileContent);
        }
        JSONObject upgradeRecord = new JSONObject();
        upgradeRecord.put("backupFileName", (Object)backupFileName);
        upgradeRecord.put("filePath", (Object)filePath);
        upgradeRecord.put("pageId", (Object)pageId);
        upgradeRecord.put("originalFileType", (Object)"VUE");
        upgradeRecord.put("fileType", (Object)fileType);
        upgradeRecord.put("appId", (Object)appId);
        return upgradeRecord;
    }

    private void compressDirectoryToHussar(String sourceDirPath, String hussarFilePath) throws IOException {
        File sourceDir = new File(sourceDirPath);
        Object[] files = sourceDir.listFiles();
        if (HussarUtils.isEmpty((Object[])files)) {
            return;
        }
        File hussarFile = new File(hussarFilePath);
        File parentDir = hussarFile.getParentFile();
        if (HussarUtils.isNotEmpty((Object)parentDir) && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(hussarFilePath)));){
            for (Object file : files) {
                if (!((File)file).isFile()) continue;
                ZipEntry zipEntry = new ZipEntry(((File)file).getName());
                zos.putNextEntry(zipEntry);
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream((File)file));){
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = bis.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                }
                zos.closeEntry();
            }
        }
    }

    private String readBackupFileContent(Path tempUnzipDir, String backupFileName) throws IOException {
        Path backupFilePath = tempUnzipDir.resolve(backupFileName);
        if (!Files.exists(backupFilePath, new LinkOption[0])) {
            throw new IOException("Backup file not found: " + backupFileName);
        }
        return new String(Files.readAllBytes(backupFilePath), StandardCharsets.UTF_8);
    }

    private void unzipHussarFile(File hussarFile, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipFile zipFile = new ZipFile(hussarFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream fis = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(entryDestination);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = fis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
        }
    }

    private List<JSONObject> getWpdFiles(UpgradeScopeDTO upgradeScopeDTO) {
        String parentId = "#";
        List fileTree = new ArrayList();
        if (!AppContextUtil.isHTSZMode() || !HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            try {
                fileTree = (List)this.fileTreeService.getFileTree(parentId).getData();
            }
            catch (LcdpException | IOException e) {
                logger.error("\u83b7\u53d6\u6587\u4ef6\u6811\u5931\u8d25", e);
            }
        }
        return fileTree.stream().filter(obj -> "WebPage".equals(obj.getString("type"))).collect(Collectors.toList());
    }

    private ResourcePath webProjectVue(Integer strategy, String ... pathSegments) {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{pathStrategy.vuePathService().getVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private boolean isUpgraded(String upgradeId) {
        String hussarFilePath = ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.getProjectStorePath(), BACKUP_DIR, upgradeId, upgradeId + HUSSAR_EXTENSION}));
        File hussarFile = new File(hussarFilePath);
        return hussarFile.exists() && hussarFile.isFile();
    }

    private String getProjectStorePath() {
        if (AppContextUtil.isHTSZMode() && HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            return ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().workSpaces()}));
        }
        return ToolUtil.pathFomatterByOS((String)FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath()}));
    }

    private List<String> getAppIds() {
        ArrayList<String> appIds = new ArrayList<String>();
        String projectStorePath = this.getProjectStorePath();
        if (AppContextUtil.isHTSZMode() && HussarUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            try (Stream<Path> paths = Files.list(Paths.get(projectStorePath, new String[0]));){
                paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !BACKUP_DIR.equals(path.getFileName().toString())).forEach(path -> appIds.add(path.getFileName().toString()));
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u5e94\u7528ID\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
        } else {
            appIds.add(AppContextUtil.getAppId());
        }
        return appIds;
    }

    private boolean hasDict(String pageId) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(pageId);
        String wpdData = pageInfo.getData();
        JSONObject wpdJson = JSONObject.parseObject((String)wpdData);
        Object referencesObj = wpdJson.get((Object)"references");
        List references = new ArrayList();
        if (ObjectUtils.isNotEmpty((Object)referencesObj)) {
            references = JSON.parseArray((String)JSON.toJSONString((Object)referencesObj), PageRefer.class);
        }
        for (PageRefer reference : references) {
            List referValuePathList = reference.getReferValuePath();
            for (String referValue : referValuePathList) {
                String refId = referValue.split("\\.")[0];
                if (!"dict".equalsIgnoreCase(refId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasFormLoaded(String pageId) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(pageId);
        String wpdData = pageInfo.getData();
        JSONObject wpdJson = JSONObject.parseObject((String)wpdData);
        JSONArray events = wpdJson.getJSONArray("events");
        if (HussarUtils.isNotEmpty((Object)events)) {
            for (Object event : events) {
                JSONArray children;
                JSONObject eventJson = (JSONObject)event;
                if (!"onload".equals(eventJson.getString("trigger")) || !HussarUtils.isNotEmpty((Object)(children = eventJson.getJSONArray("children")))) continue;
                for (Object child : children) {
                    JSONObject childJson = (JSONObject)child;
                    JSONObject paramValues = childJson.getJSONObject("paramValues");
                    if (!HussarUtils.isNotEmpty((Object)paramValues) || !HussarUtils.isNotEmpty((Object)paramValues.getJSONObject("formQuery")) || !"formQuery".equals(paramValues.getJSONObject("formQuery").getString("operationName"))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

