/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.back.common.strategy;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.ModelBeanUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.back.processor.ModelStrategy;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelSyncProvider;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import org.springframework.stereotype.Service;

@Service
public class Original
implements ModelStrategy {
    private String dataSourceType;
    private FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);

    public void init(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void codeType() {
        if (!"APP".equals(this.dataSourceType)) {
            switch (this.formDesignProperties.getBackType()) {
                case "python": {
                    this.dataSourceType = "PYTHON_" + this.dataSourceType;
                    break;
                }
                case "php": {
                    this.dataSourceType = "PHP_" + this.dataSourceType;
                    break;
                }
            }
        }
    }

    public String strategyType() {
        return "ORIGINAL";
    }

    public DataModelProcessor<CodeResult> processor() {
        return ModelBeanUtil.getModelProcessorBean((String)this.dataSourceType);
    }

    public DataModelProvider provider() {
        return ModelBeanUtil.getModelProviderBean((String)this.dataSourceType);
    }

    public DataModelSyncProvider<DataModelFieldBase> syncProvider() {
        return ModelBeanUtil.getModelSyncProviderBean((String)this.dataSourceType);
    }

    public void clear() {
        this.dataSourceType = null;
    }
}

