/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.back.common.service.impl;

import com.jxdinfo.hussar.formdesign.back.common.constant.ModelTypeEnum;
import com.jxdinfo.hussar.formdesign.back.service.DataModelService;
import com.jxdinfo.hussar.formdesign.common.annotation.Function;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataModelServiceImpl
implements DataModelService {
    private static final Logger logger = LoggerFactory.getLogger(DataModelServiceImpl.class);
    private FormDesignResponse<Map<String, Map<String, Object>>> formDesignResponse = new FormDesignResponse();

    public FormDesignResponse<Map<String, Map<String, Object>>> getAllMethods() {
        if (HussarUtils.isEmpty((Object)this.formDesignResponse.getData())) {
            this.initAllMethods();
        }
        return this.formDesignResponse;
    }

    private void initAllMethods() {
        logger.debug("DataModelServiceImpl\u5f00\u59cbinit\u52a0\u8f7d\u6240\u6709\u65b9\u6cd5");
        Map beansWithAnnotation = SpringUtil.getBeanWithAnnotation(Function.class);
        HashMap mysqlMap = new HashMap();
        HashMap oracleMap = new HashMap();
        HashMap dmMap = new HashMap();
        HashMap pgMap = new HashMap();
        HashMap oscarMap = new HashMap();
        HashMap kingBaseMap = new HashMap();
        HashMap sqlServerMap = new HashMap();
        HashMap<String, Object> pythonMap = new HashMap<String, Object>();
        HashMap heMap = new HashMap();
        HashMap unknownMap = new HashMap();
        HashMap<String, HashMap<String, Object>> methodMap = new HashMap<String, HashMap<String, Object>>();
        for (Map.Entry objectEntry : beansWithAnnotation.entrySet()) {
            Class<?> category = objectEntry.getValue().getClass();
            String[] tempList = category.getAnnotation(Function.class).type();
            String type = tempList[0];
            String functionName = tempList[1];
            if (ToolUtil.isEmpty((Object)category.getFields())) {
                if ("MYSQL.".equals(type)) {
                    mysqlMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.ORACLE.name())) {
                    oracleMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.DM.name())) {
                    dmMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.POSTGRE_SQL.name())) {
                    pgMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.OSCAR.name())) {
                    oscarMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.KINGBASE.name())) {
                    kingBaseMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.SQL_SERVER.name())) {
                    sqlServerMap.put(functionName, null);
                    continue;
                }
                if (type != null && type.contains(ModelTypeEnum.PYTHON.name())) {
                    pythonMap.put(functionName, null);
                    continue;
                }
                if ("HE.".equals(type)) {
                    heMap.put(functionName, null);
                    continue;
                }
                unknownMap.put(functionName, null);
                continue;
            }
            List methods = Arrays.stream(category.getFields()).map(field -> {
                String method = "";
                try {
                    method = field.get(field.getName()).toString();
                }
                catch (IllegalAccessException e) {
                    this.formDesignResponse.setErrorCode(LcdpExceptionEnum.ERROR.getCode());
                    this.formDesignResponse.setErrorMsg("\u83b7\u53d6" + functionName + "\u6a21\u578b\u65b9\u6cd5\u79cd\u7c7b\u5c5e\u6027\u5931\u8d25");
                    logger.error("\u83b7\u53d6{}\u6a21\u578b\u65b9\u6cd5\u79cd\u7c7b\u5c5e\u6027\u5931\u8d25", (Object)functionName);
                    e.printStackTrace();
                }
                return method;
            }).collect(Collectors.toList());
            if ("MYSQL.".equals(type)) {
                mysqlMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.ORACLE.name())) {
                oracleMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.DM.name())) {
                dmMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.POSTGRE_SQL.name())) {
                pgMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.OSCAR.name())) {
                oscarMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.KINGBASE.name())) {
                kingBaseMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.SQL_SERVER.name())) {
                sqlServerMap.put(functionName, methods);
            } else if (type != null && type.contains(ModelTypeEnum.PYTHON.name())) {
                sqlServerMap.put(functionName, methods);
            } else if ("HE.".equals(type)) {
                heMap.put(functionName, methods);
            } else {
                unknownMap.put(functionName, methods);
            }
            logger.debug("DataModelServiceImpl\u7ed3\u675finit\u52a0\u8f7d\u6240\u6709\u65b9\u6cd5");
        }
        methodMap.put(ModelTypeEnum.MYSQL.name(), mysqlMap);
        methodMap.put(ModelTypeEnum.ORACLE.name(), oracleMap);
        methodMap.put(ModelTypeEnum.DM.name(), dmMap);
        methodMap.put(ModelTypeEnum.POSTGRE_SQL.name(), pgMap);
        methodMap.put(ModelTypeEnum.OSCAR.name(), oscarMap);
        methodMap.put(ModelTypeEnum.KINGBASE.name(), kingBaseMap);
        methodMap.put(ModelTypeEnum.SQL_SERVER.name(), sqlServerMap);
        methodMap.put(ModelTypeEnum.PYTHON.name(), pythonMap);
        methodMap.put(ModelTypeEnum.HE.name(), heMap);
        methodMap.put(ModelTypeEnum.UNKNOWN.name(), unknownMap);
        this.formDesignResponse.setData(methodMap);
    }
}

