/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.onlineimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.CustomComponentGroupInfo;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CustomComponentGroupInfoService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="CustomComponentGroupInfoServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class CustomComponentGroupInfoServiceOnLineImpl
implements CustomComponentGroupInfoService {
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private StorageService storageService;
    @Resource
    private PathStrategyService pathStrategy;

    @Autowired
    public CustomComponentGroupInfoServiceOnLineImpl(FileMappingService fileMappingService, StorageService storageService) {
        this.fileMappingService = fileMappingService;
        this.storageService = storageService;
    }

    @Override
    public void create(CustomComponentGroupInfo customComponentGroupInfo) throws LcdpException, IOException {
        if (customComponentGroupInfo.getReferences() == null) {
            customComponentGroupInfo.setReferences(new JSONObject());
        }
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)customComponentGroupInfo.getFileType()) || ToolUtil.isEmpty((Object)customComponentGroupInfo.getCategory()) || ToolUtil.isEmpty((Object)customComponentGroupInfo.getName()))) {
            String libName = "";
            JSONObject componentObject = this.iterator(customComponentGroupInfo.getCategory());
            if (ToolUtil.isNotEmpty((Object)componentObject)) {
                libName = componentObject.getString("libName");
            }
            String catePath = customComponentGroupInfo.getCategory();
            String metaPath = this.relativeToAbsolute(libName + File.separator + catePath + File.separator + customComponentGroupInfo.getName() + ".meta", rootPath);
            Boolean isExists = Boolean.TRUE.equals(this.storageService.existsByPath(metaPath).getData());
            if (isExists.booleanValue()) {
                throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, metaPath);
            }
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentGroupInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u7ec4\u4ef6\u4fe1\u606f\u9519\u8bef");
        }
    }

    @Override
    public void updateFileMeta(CustomComponentGroupInfo customComponentGroupInfo) throws IOException, LcdpException {
        if (customComponentGroupInfo.getReferences() == null) {
            customComponentGroupInfo.setReferences(new JSONObject());
        }
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        if (!(ToolUtil.isEmpty((Object)customComponentGroupInfo.getFileType()) || ToolUtil.isEmpty((Object)customComponentGroupInfo.getCategory()) || ToolUtil.isEmpty((Object)customComponentGroupInfo.getName()))) {
            String libName = "";
            JSONObject componentObject = this.iterator(customComponentGroupInfo.getCategory());
            if (ToolUtil.isNotEmpty((Object)componentObject)) {
                libName = componentObject.getString("libName");
            }
            String catePath = libName + File.separator + customComponentGroupInfo.getCategory();
            String metaPath = this.relativeToAbsolute(catePath + File.separator + customComponentGroupInfo.getName() + ".meta", rootPath);
            try {
                this.storageService.uploadByPath(metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentGroupInfo).getBytes(StandardCharsets.UTF_8), false);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, metaPath);
            }
        } else {
            throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, "\u7ec4\u4ef6\u4fe1\u606f\u9519\u8bef");
        }
        this.fileMappingService.fileMappingCacheEvict();
    }

    public JSONObject iterator(String name) throws IOException {
        JSONObject jsonObject = null;
        String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
        List storageEntities = (List)this.storageService.list(rootPath, ".meta", true).getData();
        for (StorageEntity storageEntity : storageEntities) {
            JSONObject currFile = JSON.parseObject((String)new String(storageEntity.getContent() != null ? storageEntity.getContent() : "".getBytes(), "UTF-8"));
            String currName = currFile.getString("name");
            if (!name.equals(currName)) continue;
            jsonObject = currFile;
            break;
        }
        return jsonObject;
    }

    @Override
    public void delete(String name) throws LcdpException, IOException {
        try {
            String rootPath = this.pathStrategy.resourcePathService().projectStoreCustomComponents(new String[0]).getRemotePath();
            JSONObject customComInfo = this.iterator(name);
            String category = customComInfo.getString("category");
            String cover = customComInfo.getString("cover");
            JSONObject componentObject = this.iterator(category);
            String libName = componentObject.getString("libName");
            String customComPath = rootPath + File.separator + libName + File.separator + category + File.separator + name + ".meta";
            this.storageService.deleteByPath(customComPath, false);
            this.delCover(cover);
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, "\u81ea\u5b9a\u4e49\u7ec4\u4ef6:" + name);
        }
    }

    @Override
    public FormDesignResponse<String> upload(MultipartFile file) throws LcdpException, IOException {
        FormDesignResponse response = new FormDesignResponse();
        String fileSavePath = this.pathStrategy.resourcePathService().projectStoreCustomComponentsCover(new String[0]).getRemotePath();
        String fileName = file.getOriginalFilename();
        String filePath = fileSavePath + File.separator + fileName;
        byte[] bytes = file.getBytes();
        this.storageService.uploadByPath(filePath, bytes, false);
        response.setData((Object)fileName);
        return response;
    }

    @Override
    public void delCover(String fileName) {
        if (!"".equals(fileName)) {
            String fileSavePath = this.pathStrategy.resourcePathService().projectStoreCustomComponentsCover(new String[0]).getRemotePath();
            String filePath = ToolUtil.pathFomatterByOS((String)fileSavePath) + File.separator + fileName;
            this.storageService.deleteByPath(filePath, false);
        }
    }

    @Override
    public ResponseEntity<byte[]> getFile(String fileName) throws IOException {
        MediaType mime;
        String fileSavePath = this.pathStrategy.resourcePathService().projectStoreCustomComponentsCover(new String[0]).getRemotePath();
        String filePath = fileSavePath + File.separator + fileName;
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (ext.equals("jpg") || ext.equals("JPG")) {
            mime = MediaType.IMAGE_JPEG;
        } else if (ext.equals("png") || ext.equals("PNG")) {
            mime = MediaType.IMAGE_PNG;
        } else {
            System.err.println("bad cover extension: " + ext + ", guess jpeg");
            mime = MediaType.IMAGE_JPEG;
        }
        byte[] bytes = (byte[])this.storageService.downloadByPath(filePath).getData();
        return ResponseEntity.ok().contentType(mime).body((Object)bytes);
    }

    protected String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }
}

