/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.CharacterConversService;
import com.jxdinfo.hussar.formdesign.file.move.util.ConstantUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.stereotype.Service;

@Service
public class CharacterConversServiceImpl
implements CharacterConversService {
    @Override
    public String changeToPinyinFirstLow(String chineseName, HanyuPinyinCaseType caseType) {
        char[] clChars = chineseName.trim().toCharArray();
        StringBuilder hanyupinyin = new StringBuilder();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        try {
            for (char clChar : clChars) {
                if (String.valueOf(clChar).matches("[\u4e00-\u9fa5]+")) {
                    String word = PinyinHelper.toHanyuPinyinStringArray((char)clChar, (HanyuPinyinOutputFormat)defaultFormat)[0];
                    hanyupinyin.append(word.charAt(0));
                    continue;
                }
                if (!String.valueOf(clChar).matches("^[0-9a-zA-Z_]+$")) continue;
                hanyupinyin.append(clChar);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return hanyupinyin.toString();
    }

    @Override
    public String changeToPinyinFirstLowByType(String chineseName, HanyuPinyinCaseType caseType, String type) throws BadHanyuPinyinOutputFormatCombination {
        char[] clChars = chineseName.trim().toCharArray();
        StringBuilder hanyupinyin = new StringBuilder();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        for (char clChar : clChars) {
            if (String.valueOf(clChar).matches("[\u4e00-\u9fa5]+")) {
                String word = PinyinHelper.toHanyuPinyinStringArray((char)clChar, (HanyuPinyinOutputFormat)defaultFormat)[0];
                hanyupinyin.append(word.charAt(0));
                continue;
            }
            String rule = "^[0-9a-zA-Z_]+$";
            if (ToolUtil.isNotEmpty((Object)type) && ConstantUtil.anyMatch(type, "secondScript", "page", "WebPage", "MobilePage", "UniPage", "Module")) {
                rule = "^[0-9a-zA-Z]+$";
            }
            if (!String.valueOf(clChar).matches(rule)) continue;
            hanyupinyin.append(clChar);
        }
        return hanyupinyin.toString();
    }
}

