/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ModuleInfo;
import com.jxdinfo.hussar.formdesign.common.model.OperateFileVO;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendScriptInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.aggregationservice.AggretionModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ModuleInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="AggretionModuleInfoServiceImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class AggretionModuleInfoServiceDBImpl
extends BaseFileServiceImpl<ModuleInfo>
implements AggretionModuleInfoService {
    private static final Logger logger = LoggerFactory.getLogger(AggretionModuleInfoServiceDBImpl.class);
    @Autowired
    ModuleInfoService moduleInfoService;
    @Autowired
    AggretionModuleInfoService aggretionModuleInfoService;
    @Autowired
    IndexStorageLockService indexStorageLockService;
    @Autowired
    FileTreeService fileTreeService;
    @Autowired
    private SysQuoteRelationService sysQuoteRelationService;
    @Autowired
    private PageInfoService pageInfoService;
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private SysMidFileCodeService sysMidFileCodeService;
    @Autowired
    private ExtendScriptInfoService extendScriptInfoService;

    @Override
    public FormDesignResponse<ModuleInfo> deleteDataInfo(String id) throws IOException, LcdpException {
        FormDesignResponse sharedStorage;
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(id)).getErrorCode() != 200) {
            return sharedStorage;
        }
        List<String> idList = this.fileTreeService.getFileTreeId(id);
        for (String referResid : idList) {
            this.sysQuoteRelationService.deleteQuoteRelationByReferResid(referResid);
        }
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeDelete(id);
        return this.moduleInfoService.deleteDirectory(id);
    }

    @Override
    public FormDesignResponse<Map<String, Object>> copyDirectory(OperateFileVO operateFileVO) throws IOException, LcdpException {
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        String uuid = ToolUtil.get36UUID();
        HashMap<String, String> relationMap = new HashMap<String, String>();
        this.aggretionModuleInfoService.copyDirectoryList(operateFileVO.getId(), operateFileVO.getParentId(), uuid, operateFileVO.getNewName(), operateFileVO.getNewDesc(), relationMap);
        for (Map.Entry entry : relationMap.entrySet()) {
            this.sysQuoteRelationService.copyQuoteRelation((String)entry.getKey(), (String)entry.getValue());
        }
        FormDesignResponse<List<JSONObject>> stringFormDesignResponse = this.fileTreeService.getFileTreeNew(uuid);
        if (!this.formDesignProperties.getScenes().isSharedStorage()) {
            JSONObject baseFile = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString(this.moduleInfoService.get(uuid)), JSONObject.class);
            List list = (List)stringFormDesignResponse.getData();
            list.add(baseFile);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("references", relationMap);
            map.put("fileTree", list);
            formDesignResponse.setData(map);
        }
        return formDesignResponse;
    }

    @Override
    public void moveDirectory(OperateFileVO operateFileVO) throws IOException, LcdpException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeMove(operateFileVO.getId(), operateFileVO.getNewName(), operateFileVO.getParentId());
        this.moduleInfoService.moveDirectory(operateFileVO.getId(), operateFileVO.getParentId(), operateFileVO.getNewName(), operateFileVO.getNewDesc());
    }

    @Override
    public void editDirectory(ModuleInfo moduleInfo) throws IOException, LcdpException {
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("Module")).cascadeEdit((BaseFile)moduleInfo);
        this.moduleInfoService.updateDirectory(moduleInfo);
    }

    private void copyCheck(String id, List<String> childIds) throws IOException, LcdpException {
        List sysMidFileCodes = this.sysMidFileCodeService.getChildFileByParentId(id);
        for (SysMidFileCode sysMidFileCode : sysMidFileCodes) {
            childIds.add(sysMidFileCode.getFileId());
            this.copyCheck(sysMidFileCode.getFileId(), childIds);
        }
    }

    private void copyChildFiles(String parentId, String newParentId) throws LcdpException, IOException {
        List sysMidFileCodes = this.sysMidFileCodeService.getChildFileByParentId(parentId);
        for (SysMidFileCode sysMidFileCode : sysMidFileCodes) {
            String uuid = ToolUtil.get36UUID();
            if ("Module".equals(sysMidFileCode.getType())) {
                this.copyDirectoryList(sysMidFileCode.getFileId(), newParentId, uuid, null, null, null);
                continue;
            }
            if (!"1".equals(sysMidFileCode.getMetaFlag())) continue;
            this.extendScriptInfoService.copy(sysMidFileCode.getFileId(), newParentId, uuid, null, null);
        }
    }

    @Override
    public void copyDirectoryList(String id, String parentId, String uuid, String newName, String newDesc, Map<String, String> relationMap) throws LcdpException, IOException {
        ArrayList<String> childIds = new ArrayList<String>();
        this.copyCheck(id, childIds);
        if (childIds.contains(parentId) || id.equals(parentId)) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, parentId);
        }
        SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(id);
        metaFile.setId(null);
        metaFile.setFileId(uuid);
        metaFile.setParentId(parentId);
        JSONObject metaFileData = JSON.parseObject((String)metaFile.getData());
        metaFileData.put("parentId", (Object)parentId);
        metaFileData.put("id", (Object)uuid);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            metaFile.setName(newName);
            metaFileData.put("name", (Object)newName);
        }
        if (HussarUtils.isNotEmpty((Object)newDesc)) {
            metaFileData.put("desc", (Object)newDesc);
        }
        metaFile.setData(JSON.toJSONString((Object)metaFileData));
        this.sysMidFileCodeService.save((Object)metaFile);
        this.copyChildFiles(id, uuid);
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse formDesignResponse = new FormDesignResponse();
        if (ToolUtil.isEmpty((Object)user)) {
            formDesignResponse.setErrorCode(400);
            formDesignResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return formDesignResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && ToolUtil.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!ToolUtil.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !user.getId().equals(userId))) {
            formDesignResponse.setErrorCode(403);
            formDesignResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return formDesignResponse;
        }
        return new FormDesignResponse();
    }

    String getDataPath(String id) throws LcdpException, IOException {
        return this.getMetaPath(id).replace(".meta", "");
    }

    private String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    private void copyFile(File file, File to, List<String> dataModelMetaName) throws IOException {
        if (FileUtils.isDirectory((File)file)) {
            File target = new File(to, file.getName());
            if (!FileUtils.exists((File)target)) {
                FileUtils.forceMkdir((File)target);
            }
            for (File source : FileUtils.listFiles((File)file)) {
                boolean flag = false;
                if (ToolUtil.isNotEmpty(dataModelMetaName)) {
                    for (String metaName : dataModelMetaName) {
                        if (!metaName.contains(source.getName())) continue;
                        flag = true;
                        break;
                    }
                }
                if (FileUtils.isDirectory((File)source)) {
                    this.copyFile(source, target, dataModelMetaName);
                    continue;
                }
                if (flag) continue;
                try {
                    JSONObject parseObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)source, (String)"UTF-8"));
                    String metaType = parseObject.getString("type");
                    if (ToolUtil.isNotEmpty((Object)metaType) && HussarUtils.equals((Object)"Workflow", (Object)metaType) || !source.getName().contains(".")) continue;
                    FileUtils.copyFileToDirectory((File)source, (File)target, (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void iteratorFile(File parentFile, String parentId, Integer workflowCount, Map<String, String> relationMap) throws LcdpException {
        if (FileUtils.exists((File)parentFile)) {
            File[] files;
            File metaFile = new File(this.addMeta(parentFile.getAbsolutePath()));
            if (FileUtils.exists((File)metaFile)) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
                    jsonObject.put("parentId", (Object)parentId);
                    if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)"isMenuSet"))) {
                        jsonObject.put("isMenuSet", (Object)false);
                    }
                    String id = ToolUtil.get36UUID();
                    if (FileUtils.isDirectory((File)parentFile)) {
                        parentId = id;
                    }
                    String oldId = (String)jsonObject.get((Object)"id");
                    relationMap.put(oldId, id);
                    jsonObject.put("id", (Object)id);
                    if ("Workflow".equals(jsonObject.get((Object)"type"))) {
                        jsonObject.put("version", (Object)"0");
                    }
                    FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (String)"UTF-8");
                    if (!parentFile.isDirectory()) {
                        String content = FileUtils.readFileToString((File)parentFile, (String)"UTF-8");
                        content = content.replaceAll(oldId, id);
                        FileUtils.writeStringToFile((File)parentFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSON.parseObject((String)content)), (String)"UTF-8");
                    }
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaFile.getAbsolutePath());
                }
            }
            if (FileUtils.isDirectory((File)parentFile) && ToolUtil.isNotEmpty((Object)(files = FileUtils.listFiles((File)parentFile)))) {
                for (File file : files) {
                    this.iteratorFile(file, parentId, workflowCount, relationMap);
                    Integer n = workflowCount;
                    Integer n2 = workflowCount = Integer.valueOf(workflowCount + 1);
                }
            }
        }
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }
}

