/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pageTemplate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.PageTemplateInfo;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.component.constant.CheckInfoEnum;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.CheckInfo;
import com.jxdinfo.hussar.formdesign.component.model.CheckResult;
import com.jxdinfo.hussar.formdesign.component.model.CompatibleVersions;
import com.jxdinfo.hussar.formdesign.component.model.ComponentDependence;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.pageTemplate.constant.PageTemplateField;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.DefaultPageTemplate;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.PageTemplateInductsInfo;
import com.jxdinfo.hussar.formdesign.pageTemplate.model.TemplateInfo;
import com.jxdinfo.hussar.formdesign.pageTemplate.service.PageTemplateService;
import com.jxdinfo.hussar.formdesign.pageTemplate.util.PageTemplateCheckInfoUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Conditional(value={ConditionNotSharedStorage.class, ConditionNotDataBaseStorage.class})
public class PageTemplateServiceImpl
implements PageTemplateService {
    @Autowired
    private PathStrategyService pathStrategy;
    @Autowired
    private LcdpVersionProperties lcdpVersionProperties;
    @Autowired
    private ComponentService componentService;
    private static final Logger logger = LoggerFactory.getLogger(PageTemplateServiceImpl.class);

    @Override
    public ApiResponse<CheckResult<PageTemplateInductsInfo>> check(MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            return ApiResponse.fail((String)"\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String type = file.getContentType();
        if ("application/x-zip-compressed".equals(type) || "application/zip".equals(type)) {
            return this.zipCheck(file);
        }
        return ApiResponse.fail((String)"\u5f53\u524d\u53ea\u652f\u6301zip\u538b\u7f29\u5305");
    }

    @Override
    public ApiResponse<PageTemplateInfo> inducts(PageTemplateInductsInfo pageTemplateInductsInfo) throws Exception {
        Map<String, PageTemplateInductsInfo> awaitPageTemplateInductsInfos = this.getAwaitPageTemplateInductsInfos();
        PageTemplateInductsInfo awaitPageTemplateInductsInfo = awaitPageTemplateInductsInfos.get(pageTemplateInductsInfo.getId());
        if (HussarUtils.isEmpty((Object)awaitPageTemplateInductsInfo)) {
            return ApiResponse.fail((String)"\u672a\u77e5\u6a21\u677f");
        }
        PageTemplateInfo pageTemplateInfo = this.getPageTemplateJson(pageTemplateInductsInfo);
        pageTemplateInfo.setCategory(pageTemplateInductsInfo.getCategory());
        if (!this.writePageTemplateInfo(pageTemplateInductsInfo, pageTemplateInfo)) {
            return ApiResponse.fail((String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        this.delAwaitPageTemplateInductsInfo(pageTemplateInductsInfo.getId());
        this.delAwaitPageTemplateFile(pageTemplateInductsInfo);
        return ApiResponse.success((Object)pageTemplateInfo);
    }

    @Override
    public boolean export(HttpServletResponse response, PageTemplateInductsInfo inductsInfo) throws Exception {
        if (HussarUtils.isEmpty((Object)inductsInfo)) {
            return false;
        }
        PageTemplateInfo pageTemplateInfo = this.getPageTemplateInfo(inductsInfo);
        if (HussarUtils.isEmpty((Object)pageTemplateInfo)) {
            return false;
        }
        PageTemplateInductsInfo pageTemplateInductsInfo = this.createPageTemplateInductsInfo(pageTemplateInfo);
        if (HussarUtils.isEmpty((Object)pageTemplateInductsInfo)) {
            return false;
        }
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; fileName=" + pageTemplateInfo.getDesc());
        response.setCharacterEncoding("UTF-8");
        ServletOutputStream out = response.getOutputStream();
        HashMap<String, InputStream> inputStreamMap = new HashMap<String, InputStream>();
        this.setInputStream(inputStreamMap, pageTemplateInductsInfo, pageTemplateInfo);
        ZipUtil.zips(inputStreamMap, (OutputStream)out);
        return true;
    }

    public PageTemplateInfo getPageTemplateInfo(PageTemplateInductsInfo pageTemplateInductsInfo) throws IOException {
        String pageType = pageTemplateInductsInfo.getPageType();
        String id = pageTemplateInductsInfo.getId();
        String category = pageTemplateInductsInfo.getCategory();
        if (HussarUtils.isBlank((CharSequence)pageType) || HussarUtils.isBlank((CharSequence)id) || HussarUtils.isBlank((CharSequence)category)) {
            return null;
        }
        String path = FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath(), pageType, category, id + ".meta"});
        File file = new File(path);
        if (!FileUtils.exists((File)file)) {
            return null;
        }
        return (PageTemplateInfo)JSONArray.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), PageTemplateInfo.class);
    }

    @Override
    public synchronized boolean delAwaitPageTemplate(String id) throws IOException {
        Map<String, PageTemplateInductsInfo> awaitPageTemplateInductsInfos = this.getAwaitPageTemplateInductsInfos();
        PageTemplateInductsInfo pageTemplateInductsInfo = awaitPageTemplateInductsInfos.get(id);
        if (HussarUtils.isEmpty((Object)pageTemplateInductsInfo)) {
            return false;
        }
        this.delAwaitPageTemplateFile(pageTemplateInductsInfo);
        this.delAwaitPageTemplateInductsInfo(id);
        return true;
    }

    @Override
    public ApiResponse<DefaultPageTemplate> getPageTemplate() throws IOException {
        DefaultPageTemplate defaultPageTemplate = new DefaultPageTemplate();
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:/template/*/*/*/*Template*.json");
        Resource[] editorTableResources = SpringContextHolder.getApplicationContext().getResources("classpath*:/template/*/*/*/*slave*.json");
        Resource[] bpmResources = SpringContextHolder.getApplicationContext().getResources("classpath*:/template/bpmTemplate.json");
        for (Resource resource : resources) {
            JSONObject jsonObject = JSON.parseObject((String)IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
            this.iterator(defaultPageTemplate, jsonObject, editorTableResources, bpmResources);
        }
        return ApiResponse.success((Object)defaultPageTemplate);
    }

    public void iterator(DefaultPageTemplate defaultPageTemplate, JSONObject jsonObject, Resource[] editorTableResources, Resource[] bpmResources) throws IOException {
        if (jsonObject.get((Object)"pageType") != null) {
            switch (jsonObject.get((Object)"pageType").toString()) {
                case "WebPage": {
                    defaultPageTemplate.setwebPage(this.dealTemplate(jsonObject, defaultPageTemplate.getwebPage(), editorTableResources, bpmResources));
                    break;
                }
                case "UniPage": {
                    defaultPageTemplate.setUniPage(this.dealTemplate(jsonObject, defaultPageTemplate.getUniPage(), editorTableResources, bpmResources));
                    break;
                }
                case "WebAndUni": {
                    defaultPageTemplate.setWebAndUniPage(this.dealTemplate(jsonObject, defaultPageTemplate.getWebAndUniPage(), editorTableResources, bpmResources));
                    break;
                }
            }
        }
    }

    private Map<String, List<TemplateInfo>> dealTemplate(JSONObject jsonObject, Map<String, List<TemplateInfo>> map, Resource[] editorTableResources, Resource[] bpmResources) throws IOException {
        if (jsonObject.get((Object)"functionType") != null) {
            if (map == null) {
                map = new HashMap<String, List<TemplateInfo>>();
            }
            JSONObject bpmjsonObject = null;
            for (Resource resource : bpmResources) {
                bpmjsonObject = JSON.parseObject((String)IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            switch (jsonObject.get((Object)"functionType").toString()) {
                case "BASE": {
                    if (map.get("BASE") != null) {
                        List<TemplateInfo> list = this.dealTemplateInfo(jsonObject, map.get("BASE"));
                        map.put("BASE", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealTemplateInfo(jsonObject, newMap);
                    map.put("BASE", newMap);
                    break;
                }
                case "FLOW": {
                    if (map.get("FLOW") != null) {
                        List<TemplateInfo> list = this.dealFlowAndTaskTemplateInfo(jsonObject, map.get("FLOW"), bpmjsonObject);
                        map.put("FLOW", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealFlowAndTaskTemplateInfo(jsonObject, newMap, bpmjsonObject);
                    map.put("FLOW", newMap);
                    break;
                }
                case "TASK": {
                    if (map.get("TASK") != null) {
                        List<TemplateInfo> list = this.dealFlowAndTaskTemplateInfo(jsonObject, map.get("TASK"), bpmjsonObject);
                        map.put("TASK", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealFlowAndTaskTemplateInfo(jsonObject, newMap, bpmjsonObject);
                    map.put("TASK", newMap);
                    break;
                }
                case "MASTER_SLAVE": {
                    if (map.get("MASTER_SLAVE") != null) {
                        List<TemplateInfo> list = this.dealTemplateInfo(jsonObject, map.get("MASTER_SLAVE"), editorTableResources);
                        map.put("MASTER_SLAVE", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealTemplateInfo(jsonObject, newMap, editorTableResources);
                    map.put("MASTER_SLAVE", newMap);
                    break;
                }
                case "FLOW_MASTER_SLAVE": {
                    if (map.get("FLOW_MASTER_SLAVE") != null) {
                        List<TemplateInfo> list = this.dealFlowAndTaskTemplateInfo(jsonObject, map.get("FLOW_MASTER_SLAVE"), editorTableResources, bpmjsonObject);
                        map.put("FLOW_MASTER_SLAVE", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealFlowAndTaskTemplateInfo(jsonObject, newMap, editorTableResources, bpmjsonObject);
                    map.put("FLOW_MASTER_SLAVE", newMap);
                    break;
                }
                case "TASK_MASTER_SLAVE": {
                    if (map.get("TASK_MASTER_SLAVE") != null) {
                        List<TemplateInfo> list = this.dealFlowAndTaskTemplateInfo(jsonObject, map.get("TASK_MASTER_SLAVE"), editorTableResources, bpmjsonObject);
                        map.put("TASK_MASTER_SLAVE", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealFlowAndTaskTemplateInfo(jsonObject, newMap, editorTableResources, bpmjsonObject);
                    map.put("TASK_MASTER_SLAVE", newMap);
                    break;
                }
                case "VIEW": {
                    if (map.get("VIEW") != null) {
                        List<TemplateInfo> list = this.dealTemplateInfo(jsonObject, map.get("VIEW"));
                        map.put("VIEW", list);
                        break;
                    }
                    List<TemplateInfo> newMap = new ArrayList<TemplateInfo>();
                    newMap = this.dealTemplateInfo(jsonObject, newMap);
                    map.put("VIEW", newMap);
                    break;
                }
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private List<TemplateInfo> dealTemplateInfo(JSONObject jsonObject, List<TemplateInfo> list) {
        if (jsonObject.get((Object)"identity") != null) {
            if (list.isEmpty()) {
                list = new ArrayList<TemplateInfo>();
            }
            for (TemplateInfo templateInfo : list) {
                if (!templateInfo.getIdentity().equals(jsonObject.get((Object)"identity").toString())) continue;
                templateInfo.getAttributes().add(jsonObject);
                return list;
            }
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setIdentity(jsonObject.get((Object)"identity").toString());
            ArrayList<JSONObject> list1 = new ArrayList<JSONObject>();
            list1.add(jsonObject);
            templateInfo.setAttributes(list1);
            list.add(templateInfo);
            return list;
        }
        return Collections.emptyList();
    }

    private List<TemplateInfo> dealTemplateInfo(JSONObject jsonObject, List<TemplateInfo> list, Resource[] editorTableResources) throws IOException {
        if (jsonObject.get((Object)"identity") != null) {
            if (list.isEmpty()) {
                list = new ArrayList<TemplateInfo>();
            }
            for (TemplateInfo templateInfo : list) {
                if (!templateInfo.getIdentity().equals(jsonObject.get((Object)"identity").toString())) continue;
                templateInfo.getAttributes().add(jsonObject);
                return list;
            }
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setIdentity(jsonObject.get((Object)"identity").toString());
            ArrayList<JSONObject> list1 = new ArrayList<JSONObject>();
            list1.add(jsonObject);
            templateInfo.setAttributes(list1);
            templateInfo.setEditTableTemplates(this.dealSlave(jsonObject, editorTableResources));
            list.add(templateInfo);
            return list;
        }
        return Collections.emptyList();
    }

    private List<TemplateInfo> dealFlowAndTaskTemplateInfo(JSONObject jsonObject, List<TemplateInfo> list, JSONObject bpmjsonObject) {
        if (jsonObject.get((Object)"identity") != null) {
            if (list.isEmpty()) {
                list = new ArrayList<TemplateInfo>();
            }
            for (TemplateInfo templateInfo : list) {
                if (!templateInfo.getIdentity().equals(jsonObject.get((Object)"identity").toString())) continue;
                templateInfo.getAttributes().add(jsonObject);
                return list;
            }
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setIdentity(jsonObject.get((Object)"identity").toString());
            ArrayList<JSONObject> list1 = new ArrayList<JSONObject>();
            list1.add(jsonObject);
            templateInfo.setAttributes(list1);
            templateInfo.setBpmTemplates(bpmjsonObject);
            list.add(templateInfo);
            return list;
        }
        return Collections.emptyList();
    }

    private List<TemplateInfo> dealFlowAndTaskTemplateInfo(JSONObject jsonObject, List<TemplateInfo> list, Resource[] editorTableResources, JSONObject bpmjsonObject) throws IOException {
        if (jsonObject.get((Object)"identity") != null) {
            if (list.isEmpty()) {
                list = new ArrayList<TemplateInfo>();
            }
            for (TemplateInfo templateInfo : list) {
                if (!templateInfo.getIdentity().equals(jsonObject.get((Object)"identity").toString())) continue;
                templateInfo.getAttributes().add(jsonObject);
                return list;
            }
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setIdentity(jsonObject.get((Object)"identity").toString());
            ArrayList<JSONObject> list1 = new ArrayList<JSONObject>();
            list1.add(jsonObject);
            templateInfo.setAttributes(list1);
            templateInfo.setBpmTemplates(bpmjsonObject);
            templateInfo.setEditTableTemplates(this.dealSlave(jsonObject, editorTableResources));
            list.add(templateInfo);
            return list;
        }
        return Collections.emptyList();
    }

    private JSONObject dealSlave(JSONObject jsonObject, Resource[] editorTableResources) throws IOException {
        String identity = jsonObject.get((Object)"identity").toString();
        for (Resource resource : editorTableResources) {
            JSONObject editorTableJsonObject = JSON.parseObject((String)IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8));
            if (editorTableJsonObject.get((Object)"identity") == null || !identity.equals(editorTableJsonObject.get((Object)"identity").toString())) continue;
            return editorTableJsonObject;
        }
        return new JSONObject();
    }

    public void setInputStream(Map<String, InputStream> inputStreamMap, PageTemplateInductsInfo pageTemplateInductsInfo, PageTemplateInfo pageTemplateInfo) throws IOException {
        String pageTemplateInductStr = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInductsInfo);
        ByteArrayInputStream is = new ByteArrayInputStream(pageTemplateInductStr.getBytes("UTF-8"));
        inputStreamMap.put("pageTemplateInductsInfo.json", is);
        String pageTemplateStr = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo);
        ByteArrayInputStream jsonIs = new ByteArrayInputStream(pageTemplateStr.getBytes("UTF-8"));
        inputStreamMap.put(pageTemplateInductsInfo.getPageTemplateFileName(), jsonIs);
        if (HussarUtils.isNotEmpty((Object)pageTemplateInductsInfo.getCoverFileName())) {
            File coverFile = new File(FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath(), pageTemplateInductsInfo.getCoverFileName()}));
            FileInputStream coverIs = new FileInputStream(coverFile);
            inputStreamMap.put(pageTemplateInductsInfo.getCoverFileName(), coverIs);
        }
    }

    public PageTemplateInductsInfo createPageTemplateInductsInfo(PageTemplateInfo pageTemplateInfo) throws IOException {
        PageTemplateInductsInfo pageTemplateInductsInfo = new PageTemplateInductsInfo();
        pageTemplateInductsInfo.setPageType(pageTemplateInfo.getPageType());
        if (HussarUtils.isNotBlank((CharSequence)pageTemplateInfo.getCover())) {
            pageTemplateInductsInfo.setCoverFileName(pageTemplateInfo.getCover());
        }
        pageTemplateInductsInfo.setPageTemplateFileName(pageTemplateInfo.getName() + ".meta");
        CompatibleVersions lcdpVersions = new CompatibleVersions();
        lcdpVersions.setRules("scope");
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.lcdpVersionProperties.getLcdpVersion());
        lcdpVersions.setVersions(versions);
        pageTemplateInductsInfo.setLcdpVersions(lcdpVersions);
        if (!"Workflow".equals(pageTemplateInfo.getPageType())) {
            List defaultSlots;
            ArrayList<ComponentDependence> dependences = new ArrayList<ComponentDependence>();
            JSONObject data = pageTemplateInfo.getData();
            if (HussarUtils.isEmpty((Object)data)) {
                return pageTemplateInductsInfo;
            }
            Map slots = (Map)data.get((Object)"slots");
            if (HussarUtils.isEmpty((Object)slots)) {
                return pageTemplateInductsInfo;
            }
            List virtualSlots = (List)slots.get("virtual");
            if (HussarUtils.isNotEmpty((Object)virtualSlots)) {
                this.setDependence(dependences, virtualSlots);
            }
            if (HussarUtils.isNotEmpty((Object)(defaultSlots = (List)slots.get("default")))) {
                this.setDependence(dependences, defaultSlots);
            }
            if (dependences.size() > 0) {
                pageTemplateInductsInfo.setDependencies(dependences);
            }
        }
        return pageTemplateInductsInfo;
    }

    public void setDependence(List<ComponentDependence> dependences, List<Map<String, Object>> slots) throws IOException {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
        HashMap<String, ComponentInfo> componentInfoMap = new HashMap<String, ComponentInfo>();
        for (ComponentInfo componentInfo : componentInfos) {
            componentInfoMap.put(componentInfo.getCode(), componentInfo);
        }
        Iterator<Map<String, Object>> it = slots.iterator();
        while (it.hasNext()) {
            Map<String, Object> object = it.next();
            String code = (String)object.get("name");
            if (HussarUtils.isNotBlank((CharSequence)ClazzFactory.get((String)code))) {
                ComponentDependence dependence;
                ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(code);
                if (HussarUtils.isNotEmpty((Object)componentInfo)) {
                    dependence = new ComponentDependence();
                    dependence.setCode(code);
                    dependence.setName(componentInfo.getName());
                    dependence.setVersion(componentInfo.getVersion());
                    dependence.setCompatibleVersions(componentInfo.getCompatibleVersions());
                    dependences.add(dependence);
                    continue;
                }
                dependence = new ComponentDependence();
                dependence.setCode(code);
                dependences.add(dependence);
                continue;
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePageTemplateInfo(PageTemplateInductsInfo pageTemplateInductsInfo, PageTemplateInfo pageTemplateInfo) throws IOException {
        String rootPath;
        if (HussarUtils.isNotBlank((CharSequence)pageTemplateInfo.getCover())) {
            String coverName = pageTemplateInfo.getCover();
            String[] strs = coverName.split("\\.");
            String suffix = strs[strs.length - 1];
            coverName = pageTemplateInfo.getName() + "." + suffix;
            pageTemplateInfo.setCover(coverName);
            pageTemplateInductsInfo.setCoverFileName(coverName);
            String coverOut = (String)HussarCacheUtil.get((String)"PageTemplateCacheCoverCaChe", (Object)pageTemplateInductsInfo.getId());
            String coverRootPath = this.pathStrategy.resourcePathService().getProjectAndPageTemplateCoverPath();
            File coverRootFile = new File(coverRootPath);
            if (!FileUtils.isDirectory((File)coverRootFile)) {
                FileUtils.forceMkdir((File)coverRootFile);
            }
            String toPath = FileUtil.systemPath((String[])new String[]{coverRootPath, pageTemplateInfo.getCover()});
            File toFile = new File(toPath);
            FileOutputStream fout = null;
            FilterOutputStream bout = null;
            try {
                fout = new FileOutputStream(toFile);
                bout = new BufferedOutputStream(fout);
                if (HussarUtils.isNotEmpty((Object)coverOut)) {
                    byte[] imageBytes = Base64.getDecoder().decode(coverOut);
                    bout.write(imageBytes);
                }
            }
            catch (IOException e) {
                logger.error("\u5199\u5165\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)bout)) {
                    try {
                        bout.close();
                    }
                    catch (IOException e) {
                        logger.error("\u5199\u5165\u56fe\u7247\u5931\u8d25", (Throwable)e);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)fout)) {
                    fout.close();
                }
            }
        }
        if (HussarUtils.isBlank((CharSequence)(rootPath = pageTemplateInductsInfo.getRootPath()))) {
            return false;
        }
        File file = new File(FileUtil.systemPath((String[])new String[]{rootPath, pageTemplateInfo.getName() + ".meta"}));
        FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)pageTemplateInfo), (String)"UTF-8", (boolean)false);
        return true;
    }

    public PageTemplateInfo getPageTemplateJson(PageTemplateInductsInfo pageTemplateInductsInfo) {
        return (PageTemplateInfo)HussarCacheUtil.get((String)"PageTemplateCacheMetaChache", (Object)pageTemplateInductsInfo.getId());
    }

    public ApiResponse<CheckResult<PageTemplateInductsInfo>> zipCheck(MultipartFile file) throws Exception {
        CheckResult<PageTemplateInductsInfo> checkResult = new CheckResult<PageTemplateInductsInfo>();
        CheckInfo completeCheck = new CheckInfo(CheckInfoEnum.COMPLETE.success());
        checkResult.addCheckInfos(completeCheck);
        PageTemplateInductsInfo pageTemplateInductsInfo = this.getPageTemplateInductsInfo(file);
        if (HussarUtils.isEmpty((Object)pageTemplateInductsInfo)) {
            PageTemplateCheckInfoUtil.complete(completeCheck, "pageTemplateInductsInfo.json(\u9875\u9762\u6a21\u677f\u4fe1\u606f)", -3);
            checkResult.setResult(-1);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        pageTemplateInductsInfo.setId("template" + LrEngineUtil.nextId());
        PageTemplateInfo pageTemplateInfo = this.getPageTemplateInfo(file, pageTemplateInductsInfo, completeCheck);
        String coverFileName = this.checkCoverFileName(file, pageTemplateInductsInfo, completeCheck);
        if (1 > completeCheck.getResult()) {
            checkResult.setResult(-1);
        }
        CheckInfo pageTemplateTypeCheck = new CheckInfo();
        checkResult.addCheckInfos(pageTemplateTypeCheck);
        String pageType = pageTemplateInductsInfo.getPageType();
        this.checkPageType(pageType, pageTemplateTypeCheck);
        if (-2 == pageTemplateTypeCheck.getResult()) {
            checkResult.setResult(-1);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        if (-1 == pageTemplateTypeCheck.getResult()) {
            checkResult.setResult(-1);
        }
        if (HussarUtils.isNotEmpty((Object)pageTemplateInfo)) {
            pageTemplateInfo.setName(pageTemplateInductsInfo.getId());
        }
        this.checkInfo(pageTemplateInductsInfo, checkResult);
        if (1 > checkResult.getResult()) {
            if (0 == checkResult.getResult()) {
                this.writeFile(pageTemplateInductsInfo, pageTemplateInfo, coverFileName, file);
                this.addAwaitPageTemplateInductsInfos(pageTemplateInductsInfo);
            }
            checkResult.setData(pageTemplateInductsInfo);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), checkResult, (String)"\u6821\u9a8c\u5931\u8d25");
        }
        this.writeFile(pageTemplateInductsInfo, pageTemplateInfo, coverFileName, file);
        this.addAwaitPageTemplateInductsInfos(pageTemplateInductsInfo);
        checkResult.setData(pageTemplateInductsInfo);
        return ApiResponse.success(checkResult);
    }

    public void checkPageType(String pageType, CheckInfo checkInfo) {
        if ("WebPage".equals(pageType)) {
            PageTemplateCheckInfoUtil.pageType(checkInfo, "web\u9875\u9762", 1);
        } else if ("MobilePage".equals(pageType)) {
            PageTemplateCheckInfoUtil.pageType(checkInfo, "\u79fb\u52a8\u9875\u9762", 1);
        } else if ("Workflow".equals(pageType)) {
            PageTemplateCheckInfoUtil.pageType(checkInfo, "\u5de5\u4f5c\u6d41\u9875\u9762", 1);
        } else if ("UniPage".equals(pageType)) {
            PageTemplateCheckInfoUtil.pageType(checkInfo, "\u79fb\u52a8\u9875\u9762", 1);
        } else {
            PageTemplateCheckInfoUtil.pageType(checkInfo, pageType, -3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checkCoverFileName(MultipartFile file, PageTemplateInductsInfo pageTemplateInductsInfo, CheckInfo completeCheck) {
        String fileName = pageTemplateInductsInfo.getCoverFileName();
        if (HussarUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        try (ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String zipFileName = zipEntry.getName();
                if (!fileName.equals(zipFileName)) continue;
                String string = fileName;
                return string;
            }
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u677f\u5c01\u9762\u5931\u8d25", (Throwable)e);
        }
        PageTemplateCheckInfoUtil.complete(completeCheck, PageTemplateField.COVERFILENAME.getLabel(), -2);
        completeCheck.setResultAndMsg(-1, CheckInfoEnum.COMPLETE.fail());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageTemplateInductsInfo getPageTemplateInductsInfo(MultipartFile file) {
        try (ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));){
            ZipEntry zipEntry;
            String fileName;
            do {
                if ((zipEntry = zis.getNextEntry()) == null) return null;
            } while (!"pageTemplateInductsInfo.json".equals(fileName = zipEntry.getName()));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zis));
            StringBuilder sb = new StringBuilder("");
            while (true) {
                String line;
                if ((line = bufferedReader.readLine()) == null) {
                    PageTemplateInductsInfo pageTemplateInductsInfo = (PageTemplateInductsInfo)JSONObject.parseObject((String)sb.toString(), PageTemplateInductsInfo.class);
                    return pageTemplateInductsInfo;
                }
                sb.append(line);
            }
        }
        catch (JSONException | IOException e) {
            logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u677f\u5931\u8d25", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageTemplateInfo getPageTemplateInfo(MultipartFile file, PageTemplateInductsInfo pageTemplateInductsInfo, CheckInfo completeCheck) {
        if (!HussarUtils.isNotEmpty((Object)pageTemplateInductsInfo.getPageTemplateFileName())) {
            PageTemplateCheckInfoUtil.complete(completeCheck, PageTemplateField.PAGETEMPLATEFILENAME.getLabel(), -1);
            return null;
        }
        String fileName = pageTemplateInductsInfo.getPageTemplateFileName();
        try (ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String zipFileName = zipEntry.getName();
                if (!fileName.equals(zipFileName)) continue;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zis));
                StringBuilder sb = new StringBuilder("");
                while (true) {
                    String line;
                    if ((line = bufferedReader.readLine()) == null) {
                        PageTemplateInfo pageTemplateInfo = (PageTemplateInfo)JSONObject.parseObject((String)sb.toString(), PageTemplateInfo.class);
                        return pageTemplateInfo;
                    }
                    sb.append(line);
                }
            }
        }
        catch (IOException e) {
            logger.error("\u9875\u9762\u6a21\u677fmeta\u6587\u4ef6\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        PageTemplateCheckInfoUtil.complete(completeCheck, PageTemplateField.PAGETEMPLATEFILENAME.getLabel(), -2);
        return null;
    }

    public void checkInfo(PageTemplateInductsInfo pageTemplateInductsInfo, CheckResult<PageTemplateInductsInfo> checkResult) throws IOException {
        CheckInfo lcdpCheck = new CheckInfo(CheckInfoEnum.LCDPVERSION.success());
        checkResult.addCheckInfos(lcdpCheck);
        CompatibleVersions lcdpVersions = pageTemplateInductsInfo.getLcdpVersions();
        if (HussarUtils.isEmpty((Object)lcdpVersions)) {
            PageTemplateCheckInfoUtil.lcdpVersion(lcdpCheck, null, null, false);
            checkResult.setResult(-1);
        } else {
            String lcdpVersion = this.lcdpVersionProperties.getLcdpVersion();
            if (!lcdpVersions.check(lcdpVersion)) {
                PageTemplateCheckInfoUtil.lcdpVersion(lcdpCheck, lcdpVersion, lcdpVersions, false);
                checkResult.setResult(-1);
            }
        }
        CheckInfo dependenceCheck = new CheckInfo(CheckInfoEnum.PAGEDEPENDENCIES.success());
        checkResult.addCheckInfos(dependenceCheck);
        List<ComponentDependence> componentDependences = pageTemplateInductsInfo.getDependencies();
        if (HussarUtils.isEmpty(componentDependences)) {
            return;
        }
        HashMap<String, String> componentVersions = new HashMap<String, String>();
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
        for (ComponentInfo component : componentInfos) {
            componentVersions.put(component.getCode(), component.getVersion());
        }
        for (ComponentDependence componentDependence : pageTemplateInductsInfo.getDependencies()) {
            boolean flag = false;
            String code = componentDependence.getCode();
            String name = componentDependence.getName();
            String version = componentDependence.getVersion();
            if (HussarUtils.isEmpty((Object)componentDependence.getVersion())) continue;
            String localVersion = (String)componentVersions.get(componentDependence.getCode());
            if (HussarUtils.isEmpty((Object)localVersion)) {
                PageTemplateCheckInfoUtil.dependencies(dependenceCheck, name, -2);
                checkResult.setResult(-1);
                continue;
            }
            if (localVersion.equals(componentDependence.getVersion())) continue;
            CompatibleVersions versions = componentDependence.getCompatibleVersions();
            if (HussarUtils.isNotEmpty((Object)versions)) {
                flag = versions.check(localVersion);
            }
            if (flag) continue;
            String msg = PageTemplateCheckInfoUtil.version(PageTemplateField.DEPENDENCIES.getLabel() + "\u4e2d\u7684\u7ec4\u4ef6" + name, "\u5df2\u5b58\u5728\u7684" + name + "\u7ec4\u4ef6\u7684\u7248\u672c\u53f7", "\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u5e94\u7528\u7684" + name + "\u7ec4\u4ef6\u7248\u672c\u53f7\u4e3a\uff1a" + version + "\uff0c\u517c\u5bb9", localVersion, versions);
            PageTemplateCheckInfoUtil.dependencies(dependenceCheck, msg, 0);
            checkResult.setResult(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(PageTemplateInductsInfo pageTemplateInductsInfo, PageTemplateInfo pageTemplateInfo, String fileName, MultipartFile file) throws IOException {
        ZipInputStream zis = new ZipInputStream(file.getInputStream(), ZipUtil.getFileCharset(file.getInputStream()));
        if (HussarUtils.isNotBlank((CharSequence)fileName)) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    int count;
                    String name = zipEntry.getName();
                    if (!name.equals(fileName)) continue;
                    byte[] dataByte = new byte[1024];
                    while ((count = zis.read(dataByte)) != -1) {
                        byteOut.write(dataByte, 0, count);
                    }
                    HussarCacheUtil.put((String)"PageTemplateCacheCoverCaChe", (Object)pageTemplateInductsInfo.getId(), (Object)Base64.getEncoder().encodeToString(byteOut.toByteArray()));
                }
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u6a21\u677f\u5c01\u9762\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (HussarUtils.isNotEmpty((Object)zis)) {
                    zis.close();
                }
            }
        }
        HussarCacheUtil.put((String)"PageTemplateCacheMetaChache", (Object)pageTemplateInductsInfo.getId(), (Object)pageTemplateInfo);
        logger.info("\u5199\u5165\u6a21\u677f\u7f13\u5b58" + pageTemplateInductsInfo.getId());
    }

    public synchronized void addAwaitPageTemplateInductsInfos(PageTemplateInductsInfo pageTemplateInductsInfo) throws IOException {
        Map<String, PageTemplateInductsInfo> componentInfos = this.getAwaitPageTemplateInductsInfos();
        componentInfos.put(pageTemplateInductsInfo.getId(), pageTemplateInductsInfo);
        this.writeAwaitPageTemplateInductsInfos(componentInfos);
        logger.info("\u5199\u5165\u5f85\u5904\u7406" + pageTemplateInductsInfo.getId());
    }

    public synchronized void delAwaitPageTemplateInductsInfo(String id) throws IOException {
        Map<String, PageTemplateInductsInfo> awaitPageTemplateInductsInfos = this.getAwaitPageTemplateInductsInfos();
        awaitPageTemplateInductsInfos.remove(id);
        this.writeAwaitPageTemplateInductsInfos(awaitPageTemplateInductsInfos);
        logger.info("\u5220\u9664\u5f85\u5904\u7406\u4fe1\u606f" + id);
    }

    public Map<String, PageTemplateInductsInfo> getAwaitPageTemplateInductsInfos() throws IOException {
        Map<String, PageTemplateInductsInfo> awaitPageTemplateInductsInfos = new HashMap<String, PageTemplateInductsInfo>();
        String path2 = FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath(), "awaitPageTemplateInductsInfos"});
        File file2 = new File(path2);
        if (!FileUtils.exists((File)file2)) {
            return awaitPageTemplateInductsInfos;
        }
        String jsonStr = FileUtils.readFileToString((File)file2, (String)"UTF-8");
        awaitPageTemplateInductsInfos = (Map)JSONArray.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<String, PageTemplateInductsInfo>>(){}, (Feature[])new Feature[0]);
        return awaitPageTemplateInductsInfos;
    }

    public void writeAwaitPageTemplateInductsInfos(Map<String, PageTemplateInductsInfo> awaitPageTemplateInductsInfos) throws IOException {
        String path1 = this.pathStrategy.resourcePathService().projectStorePageTemplate(new String[0]).getLocalPath();
        File file1 = new File(path1);
        if (!FileUtils.exists((File)file1)) {
            FileUtils.forceMkdir((File)file1);
        }
        String path2 = FileUtil.systemPath((String[])new String[]{path1, "awaitPageTemplateInductsInfos"});
        File file = new File(path2);
        FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(awaitPageTemplateInductsInfos), (String)"UTF-8", (boolean)false);
    }

    public void delAwaitPageTemplateFile(PageTemplateInductsInfo pageTemplateInductsInfo) {
        HussarCacheUtil.evict((String)"PageTemplateCacheMetaChache", (Object)pageTemplateInductsInfo.getId());
        if (HussarUtils.isNotBlank((CharSequence)pageTemplateInductsInfo.getCoverFileName())) {
            HussarCacheUtil.evict((String)"PageTemplateCacheCoverCaChe", (Object)pageTemplateInductsInfo.getId());
        }
    }
}

