/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.modeltoexcel.utils;

import com.jxdinfo.hussar.formdesign.modeltoexcel.utils.Share;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static void export(LinkedHashMap<String, String> kvMap, List<?> list, OutputStream out, String dateFormat) {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            dateFormat = !Share.isEmpty(dateFormat) ? dateFormat : "yyyy-MM-dd";
            XSSFCellStyle titleStyle = wb.createCellStyle();
            titleStyle.setBorderTop(BorderStyle.THIN);
            titleStyle.setBorderLeft(BorderStyle.THIN);
            titleStyle.setBorderBottom(BorderStyle.THIN);
            titleStyle.setBorderRight(BorderStyle.THIN);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setWrapText(true);
            XSSFFont titleFont = wb.createFont();
            titleFont.setBold(true);
            titleFont.setFontHeightInPoints((short)15);
            titleStyle.setFont((Font)titleFont);
            XSSFCellStyle contentStyle = wb.createCellStyle();
            contentStyle.setBorderTop(BorderStyle.THIN);
            contentStyle.setBorderLeft(BorderStyle.THIN);
            contentStyle.setBorderBottom(BorderStyle.THIN);
            contentStyle.setBorderRight(BorderStyle.THIN);
            contentStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            contentStyle.setAlignment(HorizontalAlignment.CENTER);
            contentStyle.setWrapText(true);
            XSSFSheet sheet = wb.createSheet("\u6a21\u578b\u5bfc\u5165_\u7528\u6237\u4fe1\u606f\u8868");
            XSSFRow oneRow = sheet.createRow(0);
            oneRow.setHeightInPoints(33.0f);
            Set<String> keySet = kvMap.keySet();
            int setIndex = 0;
            for (String key : keySet) {
                sheet.setColumnWidth(setIndex, 4800);
                XSSFCell oneRowCell = oneRow.createCell(setIndex);
                oneRowCell.setCellValue(key);
                oneRowCell.setCellStyle((CellStyle)titleStyle);
                ++setIndex;
            }
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                XSSFRow row = sheet.createRow(i + 1);
                row.setHeightInPoints(33.0f);
                String[] values = new String[kvMap.size()];
                Field[] fields = obj.getClass().getDeclaredFields();
                int count = 0;
                for (String key : keySet) {
                    String value = kvMap.get(key);
                    if ("\u5e8f\u53f7".equals(value)) {
                        values[count] = i + 1 + "";
                        ++count;
                        continue;
                    }
                    for (int j = 0; j < fields.length; ++j) {
                        String dataValue;
                        Field field = fields[j];
                        field.setAccessible(true);
                        String name = field.getName();
                        Object valueObj = field.get(obj);
                        if (!name.equals(value)) continue;
                        if (valueObj instanceof Date) {
                            valueObj = new SimpleDateFormat(dateFormat).format(valueObj);
                        }
                        values[count] = dataValue = !Share.isEmpty(valueObj) ? valueObj.toString() : "";
                    }
                    ++count;
                }
                for (int c = 0; c < keySet.size(); ++c) {
                    XSSFCell cell = row.createCell(c);
                    cell.setCellValue(!Share.isEmpty(values[c]) ? values[c] : "");
                    cell.setCellStyle((CellStyle)contentStyle);
                }
            }
            try {
                wb.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LinkedHashMap<String, String> getExcelDemoAttribute() {
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put("jobNumber", "jobNumber");
        hashMap.put("name", "name");
        hashMap.put("sex", "sex");
        hashMap.put("age", "age");
        hashMap.put("birthday", "birthday");
        hashMap.put("selfIntroduction", "selfIntroduction");
        return hashMap;
    }
}

